$flag::Xpos = "369";
$flag::Ypos = "707";

function Ftime() {

	if($FlagHUD::EnemyCarrier == "DROPPED") {
	  $Ftimer--;
	  Schedule::Add("Ftime();", 1);
	  FlagHUD::Update();
	}
	else
	  $Ftimer = 48;
}

function Etime() {

	if($FlagHUD::FriendlyCarrier == "DROPPED") {
	  $Etimer--;
	  Schedule::Add("Etime();", 1);
	  FlagHUD::Update();
	}
	else
	  $Etimer = 48;
}

function FlagHUD::Init() {

	if($FlagHUD::Loaded)
	  return;

	$FlagHUD::Loaded = 1;

	$FlagHUD::EnemyStatus = "<f2>  Home";
	$FlagHUD::FriendlyStatus = "<f2>  Home";
	$Escore = 0;
	$Fscore = 0;
	$Ftimer = 48;
	$Etimer = 48;

	$FlagHUD::Container = newObject("FlagHUD::Container", SimGui::Control, $flag::Xpos, $flag::Ypos, 184, 61);
	$FlagHUD[0] = newObject("FlagHUD_Frame", FearGui::FearGuiMenu, 0, 0, 184, 61);
	$FlagHUD[1] = newObject("FlagHUD_Icons", FearGuiFormattedText, 4, -4, 0, 0);
	$FlagHUD[2] = newObject("FlagHUD_EnemyFlag", FearGuiFormattedText, 50, 3, 0, 0);
	$FlagHUD[3] = newObject("FlagHUD_FriendlyFlag", FearGuiFormattedText, 50, 21, 0, 0);
	$FlagHUD[4] = newObject("FlagHUD_EnemyScore", FearGuiFormattedText, 35, 3, 0, 0);
	$FlagHUD[5] = newObject("FlagHUD_FriendlyScore", FearGuiFormattedText, 35, 21, 0, 0);

	for(%i=0; $FlagHUD[%i]!=""; %i++)
	  addToSet($FlagHUD::Container, $FlagHUD[%i]); 

	$IconPlacement = "<b5,9:bmp\\eflag.bmp>\n<b-20,16:bmp\\fflag.bmp>";
	$FriendlyScore = "<f2>" @ $Fscore;
	$EnemyScore = "<f2>" @ $Escore;

        Control::setValue("FlagHUD_Icons",         $IconPlacement);
        Control::setValue("FlagHUD_EnemyFlag",     $FlagHUD::FriendlyStatus);
        Control::setValue("FlagHUD_FriendlyFlag",  $FlagHUD::EnemyStatus);
        Control::setValue("FlagHUD_EnemyScore",    $EnemyScore);
        Control::setValue("FlagHUD_FriendlyScore", $FriendlyScore);
}

function FlagHUD::Update() {

	if ($FlagHUD::FriendlyCarrier == "")
		$FlagHUD::FriendlyStatus = "<f2>  Home";
	else if ($FlagHUD::FriendlyCarrier == "DROPPED")
		$FlagHUD::FriendlyStatus = "<f2>  Dropped " @ $Etimer;
	else
                $FlagHUD::FriendlyStatus = "<f2>  " @ $FlagHUD::FriendlyCarrier;

	if ($FlagHUD::EnemyCarrier == "")
		$FlagHUD::EnemyStatus = "<f2>  Home";
	else if ($FlagHUD::EnemyCarrier == "DROPPED")
		$FlagHUD::EnemyStatus = "<f2>  Dropped " @ $Ftimer;

	else
                $FlagHUD::EnemyStatus = "<f2>  " @ $FlagHUD::EnemyCarrier;

		$FriendlyScore = "<f2>" @ $Fscore;
		$EnemyScore = "<f2>" @ $Escore;

        Control::setValue("FlagHUD_EnemyFlag",     $FlagHUD::FriendlyStatus);
        Control::setValue("FlagHUD_FriendlyFlag",  $FlagHUD::EnemyStatus);
        Control::setValue("FlagHUD_EnemyScore",    $EnemyScore);
        Control::setValue("FlagHUD_FriendlyScore", $FriendlyScore);
}

function FlagHUD::Reset() {

	$FlagHUD::EnemyCarrier = "";
	$FlagHUD::FriendlyCarrier = "";
	$Escore = 0;
	$Fscore = 0;
	FlagHUD::Update();
}

function FlagHUD::GuiOpen(%gui) {

	if(%gui != playGui)
	  return;

	addToSet(playGui, $FlagHUD::Container);
}

function FlagHUD::GuiClose(%gui) {

	if(%gui != playGui)
	  return;

	removeFromSet(playGui, $FlagHUD::Container);
}

function FlagHUD::Destroy() {

        removeFromSet(playGui, $FlagHUD::Container);
        deleteObject($FlagHUD::Container);
}

function TeamScore(%team, %score) {

	if(%team == client::getTeam(getManagerID())) {
	  $Fscore = %score;
	  FlagHUD::Update();
	}
	else {
	  $Escore = %score;
	  FlagHUD::Update();
	}
}

function FlagTaken(%team, %player) {

	if(%team == client::getTeam(getManagerID())) {
	  $FlagHUD::EnemyCarrier = %player;
	  FlagHUD::Update();
	}
	else {
	  $FlagHUD::FriendlyCarrier = %player;
	  FlagHUD::Update();
	}
}

function FlagDropped(%team, %player) {

	if(%team != client::getTeam(getManagerID())) {
	  $FlagHUD::FriendlyCarrier = "DROPPED";
	  Schedule::Cancel("Etime();");
	  $Etimer = 48;
	  Etime();
	}
	else {
	  $FlagHUD::EnemyCarrier = "DROPPED";
	  Schedule::Cancel("Ftime();");
	  $Ftimer = 48;
	  Ftime();
	}
}

function FlagReturned(%team, %player) {

	if(%team == client::getTeam(getManagerID())) {
	  $FlagHUD::EnemyCarrier = "Home";
	  FlagHUD::Update();
	}
	else {
	  $FlagHUD::FriendlyCarrier = "Home";
	  FlagHUD::Update();
	}
}

function FlagCaptured(%team, %player) {

	if(!$zAdmin::ActiveMode) {

		if(%team == client::getTeam(getManagerID())) {
	  	  $Escore++;
	  	  FlagHUD::Update();
		}
		else {
	  	  $Fscore++;
	  	  FlagHUD::Update();
		}
	}

	$FlagHUD::FriendlyCarrier = "Home";
	$FlagHUD::EnemyCarrier = "Home";
	FlagHUD::Update();
}

Event::Attach(eventGuiOpen, FlagHUD::GuiOpen);
Event::Attach(eventGuiClose, FlagHUD::GuiClose);
Event::Attach(eventExit, FlagHUD::Destroy);
Event::Attach(eventChangeMission, FlagHUD::Reset);
Event::Attach(eventDisconnected, FlagHUD::Reset);
Event::Attach(eventTeamScore, TeamScore);
Event::Attach(eventFlagTaken, FlagTaken);
Event::Attach(eventFlagDropped, FlagDropped);
Event::Attach(eventFlagReturned, FlagReturned);
Event::Attach(eventFlagTimeoutReturn, FlagReturned);
Event::Attach(eventFlagCaptured, FlagCaptured);

FlagHUD::Init();

