// docks to bottom of flaghud
$pack::xPos = $flag::xPos+145;
$pack::yPos = $flag::yPos+37;

function Pack::Init() {

	if($Pack::Loaded)
	  return;

	$Pack::Loaded = true;

	$Pack::Container = newObject("Pack_Container", SimGui::Control, $pack::xPos, $pack::yPos, 30, 25);
	$PackHUD[0] = newObject("PackHUD_BG", FearGui::FearGuiMenu, 0, 0, 30, 25);
	$PackHUD[1] = newObject("PackHUD_BMP", FearGuiFormattedText, 0, 0, 30, 25);

	control::setVisible("PackHUD_BG", false);

	for(%i = 0; $PackHUD[%i] != ""; %i++)
	  addToSet($Pack::Container, $PackHUD[%i]); 

	Pack::Update();
}

function Pack::Update() {

	if(!$Mode::PlayMode)
	  return;

	%pack = "";

	if(getItemCount("Energy Pack") == 1)
	  %pack = "<B1,2:bmp\\packs.bmp>";

	else if(getItemCount("Repair Pack") == 1)
	  %pack = "<B1,-26:bmp\\packs.bmp>";

	else if(getItemCount("Ammo Pack") == 1)
	  %pack = "<B1,-86:bmp\\packs.bmp>";

	else if(getItemCount("Shield Pack") == 1)
	  %pack = "<B1,-114:bmp\\packs.bmp>";

	else if(getItemCount("Sensor Jammer Pack") == 1)
	  %pack = "<B1,-142:bmp\\packs.bmp>";

	else if(getItemCount("Inventory Station") == 1)	
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else if(getItemCount("Ammo Station") == 1)
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else if(getItemCount("Motion Sensor") == 1)
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else if(getItemCount("Pulse Sensor") == 1)
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else if(getItemCount("Sensor Jammer") == 1)
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else if(getItemCount("Camera") == 1)
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else if(getItemCount("Turret") == 1)
	  %pack = "<B1,-56:bmp\\packs.bmp>";

	else
	  %pack = "<B1,-174:bmp\\packs.bmp>";	

	control::setValue("PackHud_BMP", %pack);

	schedule("Pack::Update();", 1);
}

function Pack::GuiOpen(%gui) {

	if(%gui != playGui)
	  return;

	addToSet(playGui, $Pack::Container);
	
	Pack::Update();
}

function Pack::GuiClose(%gui) {

	if(%gui != playGui)
	  return;

	removeFromSet(playGui, $Pack::Container);
}

function Pack::Destroy() {

        removeFromSet(playGui, $Pack::Container);
        deleteObject($Pack::Container);
}

Event::Attach(eventGuiOpen, Pack::GuiOpen);
Event::Attach(eventGuiClose, Pack::GuiClose);
Event::Attach(eventExitGame, Pack::Destroy);

Pack::Init();
