$RetryAttempts = 0;
$RetryTime = 0;
$RetryDelay = 2;

function Retry::Connect(%ip) {

	GuiPopDialog(MainWindow, "gui\\retry.gui");

	if(!$RetryOn)
	  return;

	if(!$ConnectedToServer)
	  connect(%ip);
}

function Retry::Schedule() {

	$RetryAttempts++;
	$RetryTime = $RetryTime + $RetryDelay;
	$RetryOn = true;

	$RetryMessage = "<jc>Server IP: " @ $Server::Address @ "\n\nConnecting in " @ $RetryDelay @ " second(s)\nPress OK to stop\n\nServer Attempts: "
			@ $RetryAttempts @ "\nTime Elapsed: " @ $RetryTime @ " seconds";

	GuiPushDialog(MainWindow, "gui\\retry.gui");
	schedule("Control::setValue(RetryText, $RetryMessage);", 0);
	schedule("Retry::Connect($Server::Address);", $RetryDelay);
}

function Retry::Cancel() {

	$RetryOn = false;
	$RetryAttempts = 0;
	$RetryTime = 0;
}

Event::Attach(eventConnectionRejected, Retry::Schedule);
Event::Attach(eventConnected, Retry::Cancel);