//
//  MoreString 1.51
//  Written by Tim "Zear" Hammock
//
//
//  The functions supplied here are as follows:
//
// String::left(%string, %len)
// Returns the leftmost %len characters from %string. For example
// 	    String::left("What is at the left?", 7)
// will return the string
// 	    "What is"
// 
// String::right(%string, %len)
// Returns the rightmost %len characters from %string. For example
// 	    String::right("What is at the right?", 7)
// will return the string
// 	    " right?"
// 
// String::starts(%string, %search)
// Returns true if the beginning of %string exactly (including case)
// matches %search, character for character, otherwise returns false. For
// example
//      String::starts("What is at the left?", "What")
// will return true, but
//      String::starts("What is at the left?", "what")
// will return false.
// 
// String::ends(%string, %search)
// Returns true if the end of %string exactly (including case) matches
// %search, character for character, otherwise returns false. For example
// 	    String::starts("What is at the right?", "right?")
// will return true, but
// 	    String::starts("What is at the right?", "right")
// will return false (no '?').
// 
// String::insert(%string, %insert, %idx)
// Returns a string where %insert has been inserted into %string and
// position %idx. For example
// 	    String::insert("Insert into this", "Tribes ", 7)
// will return the string
// 	    "Insert Tribes into this"
// 
// String::replace(%string, %search, %replace)
// Returns a string where all instances of %search in %string have been
// replaced with an instance of %replace. For example
// 	    String::replace("Insert into this", "Insert into", "Replace")
// will return the string
// 	    "Replace this"
// 
// String::setString(%chars, %num)
// Returns a string consiting of %num repititions of %chars. For example
// 	    String::setString("Four", 4)
// will return the string
// 	    "FourFourFourFour"
// 
// String::doubleSlashes(%string)
// Replaces all instances of "\" in %string with "\\" and returns the
// result. For example
// 	    String::doubleSlashes("config\autoexec.cs")
// will return the string
// 	    "config\\autoexec.cs"
// 
// String::halveSlashes(%string)
// Replaces all instances of "\\" in %string with "\" and returns the
// result. For example
// 	    String::halveSlashes("config\\autoexec.cs")
// will return the string
// 	    "config\autoexec.cs"
// 
// String::trim(%string)
// Returns %string after stripping off any leading or trailing spaces. For
// example
//      String::trim("  too many spaces   ")
// will return the string
//      "too many spaces"
// 
// String::pad(%string, %char, %width, %justify)
// Returns %string after padding it with enough %char's to give it a
// length of %width. If %char is more than one character in length, or if
// %width is less than the initial length of %string, then %string will be
// returned unmodified. Justify can be "left", "right", or "center"
// (actually only the first character of %justify is significant and case
// doesn't matter). For example
// 	    String::pad("XXX", "o", 10, "center")
// will return the string
// 	    "oooXXXoooo"
// The most common use will likely be one where %char is passed as " "
// (single space) to allow text to be lined up in columns.
// 
// String::indexOf(%string, %search, %idx)
// Returns an index indicating the position of %search in %string, much
// like the Dynamix function String::findSubStr(). The difference here is
// that indexOf() begins searching %string after %idx characters, allowing
// you to skip over instances of %search already found earlier in %string.
// For example
// 	    String::indexOf("A string that repeats. String repeats.", "repeats", 24)
// will return 30.
// 
// String::len(%string)
// Returns the length of %string in chars. For example
// 	    String::len("A string with length.")
// will return 21.
// 
// String::getWordCount(%string)
// Returns the number of words in %string, using spaces as delimiters. For
// example
// 	    String::getWordCount("A string of words to count.")
// will return 6. Note that the period at the end is considered a part of
// the word 'count' as there is no space between them.
// 
// String::ascii(%string, %idx)
// Returns the ascii value of the %idx'th character of %string. For example:
//      String::ascii("ABC", 0)
// will return 65. %idx is zero-based, so the first character is at %idx == 0.
// Only ascii numbers 32 through 126 are returned. If the character falls
// outside that range, if %idx < 0, or if %idx >= String::len(%string), a -1
// will be returned.
//
// String::char(%ascii)
// Returns the character having the ascii value %ascii. For example:
//      String::char(65)
// will return "A". Only ascii numbers 32 through 126 are returned. If the
// value falls outside that range a "" will be returned.
//
// String::pixels(%string)
// Returns the width of %string in pixels. Only ascii numbers 32 through 126 are
// considered. If the value falls outside that range its width will not be added.
//
// -------------------------------------------------
// 
// The Tribes-default string functions are:
//
// String::findSubStr(%string, %search)
// String::getSubStr(%string, %idx, %len)
// String::ICompare(%string, %search)
// String::NCompare(%string1, %string2, %len)
// String::empty(%string)
// getWord(%string, %idx)

function String::left(%string, %len)    
{
    if(%len >= String::len(%string))
        return %string;
    
    %left = String::getSubStr(%string, 0, %len);
    return %left;
}

function String::right(%string, %len)    
{
    if(%len >= String::len(%string))
        return %string;

    %idx = String::len(%string) - %len;
    %right = String::getSubStr(%string, %idx, %len);
    return %right;
}

function String::starts(%string, %search)    
{
    %idx = String::len(%search);
    if(%idx > String::len(%string))
        return false;
    
    if(String::left(%string, %idx) == %search)
        return true;
    else
        return false;
}

function String::ends(%string, %search)    
{
    %idx = String::len(%search);
    if(%idx > String::len(%string))
        return false;
    
    if(String::right(%string, %idx) == %search)
        return true;
    else
        return false;
}

function String::insert(%string, %insert, %idx)    
{
    %front = String::left(%string, %idx);
    %back = String::right(%string, String::len(%string) - %idx);
    %result = %front @ %insert @ %back;
    return %result;
}

function String::replace(%string, %search, %replace)    
{
    if(%search == %replace || String::findSubStr(%replace, %search) != -1) // prevent infinite loops
        return %string;
        
    while((%idx = String::findSubStr(%string, %search)) != -1)             
    {   
        %len = String::len(%string);
        %front = String::getSubStr(%string, 0, %idx);
        %idx += String::len(%search);
        %back = String::getSubStr(%string, %idx, %len - %idx);
        %string = %front @ %replace @ %back;
    }
    return %string; 
}

function String::doubleSlashes(%string)    
{
    %newstring = "";
    for(%i = 0; %i < String::len(%string); %i++)
    {
        %char = String::getSubStr(%string, %i, 1);
        if(%char == "\\")
            %newstring = %newstring@"\\\\";
        else
            %newstring = %newstring@%char;
    }
    return %newstring; 
}

function String::halveSlashes(%string)    
{
    %newstring = "";
    for(%i = 0; %i < String::len(%string); %i++)
    {
        %chars = String::getSubStr(%string, %i, 2);
        if(%chars == "\\\\")
        {
            %newstring = %newstring@"\\";
            %i++;
        }
        else
            %newstring = %newstring@String::getSubStr(%chars, 0, 1);
    }
    return %newstring; 
}

function String::setString(%chars, %num)
{
    for(%i = 0; %i < %num; %i++)
        %string = %string @ %chars;
        
    return %string;
}

function String::pad(%string, %char, %width, %justify)
{
    %len = String::len(%string);
    if(%len < %width && String::len(%char) == 1)
    {    
        %justify = String::getSubStr(%justify, 0, 1);
        if(%justify == "l" || %justify == "L")
        {
            %string = %string @ String::setString(%char, %width - %len);
            return %string;
        }
        if(%justify == "r" || %justify == "R")
        {
            %string = String::setString(%char, %width - %len) @ %string;
            return %string;
        }
        if(%justify == "c" || %justify == "C")
        {
            %right = (%width - %len) / 2;
            %string = %string @ String::setString(%char, %right);
            %left = %width - String::len(%string);
            %string = String::setString(%char, %left) @ %string;
            return %string;
        }
    }
    return %string;
}

function String::trim(%string)
{
    while(String::starts(%string, " "))
    {
        %string = String::right(%string, String::len(%string) - 1);
    }
    while(String::ends(%string, " "))
    {
        %string = String::left(%string, String::len(%string) - 1);
    }
    return %string;
}

function String::indexOf(%string, %search, %idx)
{
    %newString = String::getSubStr(%string, %idx, String::len(%string) - %idx);
    %newIdx = %idx + String::findSubStr(%newString, %search);
    return %newIdx;
}

function String::len(%string) 
{
    for(%length=0; String::getSubStr(%string, %length, 1) != ""; %length++)
    {} // it's all done above!
    return %length;
}
           
function String::getWordCount(%string)
{
    for(%num = 0; getWord(%string, %num) != -1; %num++)
    {} // it's all done above!
    return %num;
}

function String::ascii(%string, %idx)
{
	if(String::len(%string) <= %idx || %idx < 0)
	    return -1;
	%char = String::getSubStr(%string, %idx, 1);
	%idx = String::findSubStr($String::asciiString, %char);
	if(%idx < 0)
		return -1;

	if(String::Compare(%char, String::getSubStr($String::asciiString, %idx, 1)) == 0)
		return %idx + 32;
    else
        return %idx + 64;
}

function String::char(%ascii)
{
	if(%ascii < 32 || %ascii > 126)
		return "";
	else
		return String::getSubStr($String::asciiString, %ascii-32, 1);
}

function String::pixels(%string)
{
    %pixels = 0;
    for(%i = 0; %i < String::len(%string); %i++)
    {
        %val = String::ascii(%string, %i);
        if(%val != -1)
            %pixels += $String::asciipixels[%val];
    }
    return %pixels;
}
    
$String::asciiString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

$String::asciipixels[32] = 6;
$String::asciipixels[33] = 3;
$String::asciipixels[34] = 5;
$String::asciipixels[35] = 8;
$String::asciipixels[36] = 7;
$String::asciipixels[37] = 11;
$String::asciipixels[38] = 8;
$String::asciipixels[39] = 4;
$String::asciipixels[40] = 5;
$String::asciipixels[41] = 5;
$String::asciipixels[42] = 7;
$String::asciipixels[43] = 9;
$String::asciipixels[44] = 4;
$String::asciipixels[45] = 5;
$String::asciipixels[46] = 3;
$String::asciipixels[47] = 6;
$String::asciipixels[48] = 7;
$String::asciipixels[49] = 7;
$String::asciipixels[50] = 7;
$String::asciipixels[51] = 7;
$String::asciipixels[52] = 7;
$String::asciipixels[53] = 7;
$String::asciipixels[54] = 7;
$String::asciipixels[55] = 7;
$String::asciipixels[56] = 7;
$String::asciipixels[57] = 7;
$String::asciipixels[58] = 3;
$String::asciipixels[59] = 4;
$String::asciipixels[60] = 8;
$String::asciipixels[61] = 8;
$String::asciipixels[62] = 8;
$String::asciipixels[63] = 6;
$String::asciipixels[64] = 7;
$String::asciipixels[65] = 9;
$String::asciipixels[66] = 7;
$String::asciipixels[67] = 8;
$String::asciipixels[68] = 8;
$String::asciipixels[69] = 6;
$String::asciipixels[70] = 7;
$String::asciipixels[71] = 8;
$String::asciipixels[72] = 8;
$String::asciipixels[73] = 3;
$String::asciipixels[74] = 6;
$String::asciipixels[75] = 8;
$String::asciipixels[76] = 7;
$String::asciipixels[77] = 9;
$String::asciipixels[78] = 7;
$String::asciipixels[79] = 9;
$String::asciipixels[80] = 7;
$String::asciipixels[81] = 9;
$String::asciipixels[82] = 8;
$String::asciipixels[83] = 7;
$String::asciipixels[84] = 9;
$String::asciipixels[85] = 8;
$String::asciipixels[86] = 9;
$String::asciipixels[87] = 11;
$String::asciipixels[88] = 7;
$String::asciipixels[89] = 9;
$String::asciipixels[90] = 7;
$String::asciipixels[91] = 5;
$String::asciipixels[92] = 6;
$String::asciipixels[93] = 5;
$String::asciipixels[94] = 8;
$String::asciipixels[95] = 8;
$String::asciipixels[96] = 4;
$String::asciipixels[97] = 7;
$String::asciipixels[98] = 7;
$String::asciipixels[99] = 6;
$String::asciipixels[100] = 7;
$String::asciipixels[101] = 7;
$String::asciipixels[102] = 6;
$String::asciipixels[103] = 7;
$String::asciipixels[104] = 7;
$String::asciipixels[105] = 3;
$String::asciipixels[106] = 5;
$String::asciipixels[107] = 7;
$String::asciipixels[108] = 3;
$String::asciipixels[109] = 11;
$String::asciipixels[110] = 7;
$String::asciipixels[111] = 7;
$String::asciipixels[112] = 7;
$String::asciipixels[113] = 7;
$String::asciipixels[114] = 5;
$String::asciipixels[115] = 6;
$String::asciipixels[116] = 6;
$String::asciipixels[117] = 7;
$String::asciipixels[118] = 6;
$String::asciipixels[119] = 7;
$String::asciipixels[120] = 7;
$String::asciipixels[121] = 6;
$String::asciipixels[122] = 6;
$String::asciipixels[123] = 7;
$String::asciipixels[124] = 3;
$String::asciipixels[125] = 7;
$String::asciipixels[126] = 8;
$String::asciipixels[127] = 8;
$String::asciipixels[128] = 8;
$String::asciipixels[129] = 8;
$String::asciipixels[130] = 3;
$String::asciipixels[131] = 7;
$String::asciipixels[132] = 5;
$String::asciipixels[133] = 11;
$String::asciipixels[134] = 7;
$String::asciipixels[135] = 7;
$String::asciipixels[136] = 5;
$String::asciipixels[137] = 17;
$String::asciipixels[138] = 6;
$String::asciipixels[139] = 4;
$String::asciipixels[140] = 12;
$String::asciipixels[141] = 8;
$String::asciipixels[142] = 8;
$String::asciipixels[143] = 8;
$String::asciipixels[144] = 8;
$String::asciipixels[145] = 3;
$String::asciipixels[146] = 3;
$String::asciipixels[147] = 5;
$String::asciipixels[148] = 5;
$String::asciipixels[149] = 5;
$String::asciipixels[150] = 8;
$String::asciipixels[151] = 13;
$String::asciipixels[152] = 5;
$String::asciipixels[153] = 8;
$String::asciipixels[154] = 6;
$String::asciipixels[155] = 4;
$String::asciipixels[156] = 11;
$String::asciipixels[157] = 8;
$String::asciipixels[158] = 8;
$String::asciipixels[159] = 9;
$String::asciipixels[160] = 7;
$String::asciipixels[161] = 3;
$String::asciipixels[162] = 6;
$String::asciipixels[163] = 7;
$String::asciipixels[164] = 9;
$String::asciipixels[165] = 9;
$String::asciipixels[166] = 3;
$String::asciipixels[167] = 7;
$String::asciipixels[168] = 5;
$String::asciipixels[169] = 10;
$String::asciipixels[170] = 6;
$String::asciipixels[171] = 6;
$String::asciipixels[172] = 8;
$String::asciipixels[173] = 5;
$String::asciipixels[174] = 10;
$String::asciipixels[175] = 5;
$String::asciipixels[176] = 5;
$String::asciipixels[177] = 9;
$String::asciipixels[178] = 5;
$String::asciipixels[179] = 5;
$String::asciipixels[180] = 4;
$String::asciipixels[181] = 8;
$String::asciipixels[182] = 8;
$String::asciipixels[183] = 3;
$String::asciipixels[184] = 5;
$String::asciipixels[185] = 3;
$String::asciipixels[186] = 6;
$String::asciipixels[187] = 6;
$String::asciipixels[188] = 10;
$String::asciipixels[189] = 9;
$String::asciipixels[190] = 11;
$String::asciipixels[191] = 5;
$String::asciipixels[192] = 9;
$String::asciipixels[193] = 9;
$String::asciipixels[194] = 9;
$String::asciipixels[195] = 9;
$String::asciipixels[196] = 9;
$String::asciipixels[197] = 9;
$String::asciipixels[198] = 12;
$String::asciipixels[199] = 9;
$String::asciipixels[200] = 7;
$String::asciipixels[201] = 7;
$String::asciipixels[202] = 7;
$String::asciipixels[203] = 7;
$String::asciipixels[204] = 4;
$String::asciipixels[205] = 4;
$String::asciipixels[206] = 5;
$String::asciipixels[207] = 5;
$String::asciipixels[208] = 10;
$String::asciipixels[209] = 9;
$String::asciipixels[210] = 10;
$String::asciipixels[211] = 10;
$String::asciipixels[212] = 10;
$String::asciipixels[213] = 10;
$String::asciipixels[214] = 10;
$String::asciipixels[215] = 8;
$String::asciipixels[216] = 10;
$String::asciipixels[217] = 8;
$String::asciipixels[218] = 8;
$String::asciipixels[219] = 8;
$String::asciipixels[220] = 8;
$String::asciipixels[221] = 9;
$String::asciipixels[222] = 7;
$String::asciipixels[223] = 7;
$String::asciipixels[224] = 7;
$String::asciipixels[225] = 7;
$String::asciipixels[226] = 7;
$String::asciipixels[227] = 7;
$String::asciipixels[228] = 7;
$String::asciipixels[229] = 7;
$String::asciipixels[230] = 10;
$String::asciipixels[231] = 6;
$String::asciipixels[232] = 7;
$String::asciipixels[233] = 7;
$String::asciipixels[234] = 7;
$String::asciipixels[235] = 7;
$String::asciipixels[236] = 5;
$String::asciipixels[237] = 4;
$String::asciipixels[238] = 5;
$String::asciipixels[239] = 5;
$String::asciipixels[240] = 7;
$String::asciipixels[241] = 6;
$String::asciipixels[242] = 7;
$String::asciipixels[243] = 7;
$String::asciipixels[244] = 7;
$String::asciipixels[245] = 7;
$String::asciipixels[246] = 7;
$String::asciipixels[247] = 9;
$String::asciipixels[248] = 7;
$String::asciipixels[249] = 6;
$String::asciipixels[250] = 6;
$String::asciipixels[251] = 6;
$String::asciipixels[252] = 6;
$String::asciipixels[253] = 7;
$String::asciipixels[254] = 7;
$String::asciipixels[255] = 7;

