$ammo::Xoffset = "55";
$ammo::Yoffset = "35";

function Ammo::Init() {

	if($Ammo::Loaded)
	  return;

	$Ammo::Loaded = true;

	$Ammo::Type[13] = "Bullet";
	$Ammo::Type[15] = "Plasma Bolt";
	$Ammo::Type[17] = "Grenade Ammo";
	$Ammo::Type[19] = "Mortar Ammo";
	$Ammo::Type[21] = "Disc";

	$Ammo::Container = newObject("Ammo_Container", SimGui::Control, 0, 0, 30, 30);
	$Ammo::HUD = newObject("Ammo_Text", FearGuiFormattedText, 0, 0, 30, 30);

	addToSet($Ammo::Container, $Ammo::HUD);
}

function Ammo::Update() {

	if(!$Mode::PlayMode)
	  return;

	%weaponID = getMountedItem(0);
	%ammo = getItemCount($Ammo::Type[%weaponID]);

	if(%ammo)
	  control::setValue("Ammo_Text", "<F2>" @ %ammo);
	else
	  control::setValue("Ammo_Text", "<F1>~");

	schedule("Ammo::Update();", 1);
}

function Ammo::GuiOpen(%gui) {

	if(%gui != playGui)
	  return;

	addToSet(playGui, $Ammo::Container);
	
	Ammo::Update();

    	$ammo::PosX = ($ScreenX-$ammo::Xoffset)/2;
    	$ammo::PosY = ($ScreenY+$ammo::Yoffset)/2;

	control::setPosition("Ammo_Container", $ammo::PosX, $ammo::PosY);
}

function Ammo::GuiClose(%gui) {

	if(%gui != playGui)
	  return;

	removeFromSet(playGui, $Ammo::Container);
}

function Ammo::Destroy() {

        removeFromSet(playGui, $Ammo::Container);
	deleteObject($Ammo::Container);
}

Event::Attach(eventGuiOpen, Ammo::GuiOpen);
Event::Attach(eventGuiClose, Ammo::GuiClose);
Event::Attach(eventExitGame, Ammo::Destroy);

Ammo::Init();

