// By default set to friendly
$Target::Auto = "Friendly";

function Target::Grabbed(%team, %player) {

	$MyTeam = Client::GetTeam(getManagerID());

	if(%player == $PCFG::Name) { 
	  return; 
	}

	if(%team == $MyTeam) { 
	  %team = "Enemy"; 
	  %action = "Attack"; 
	  %wav = "attway";
	}
	else { 
	  %team = "Friendly"; 
	  %action = "Escort"; 
	  %wav = "escfr";
	}

	if($Target::Auto == %team) {
	  targetFlaggerByName(%player, %action@" "@%team@": "@%player@".~w"@%wav);
	}
}

function Target::Dropped(%team, %player) {

	$MyTeam = Client::GetTeam(getManagerID());

	if(%team != $MyTeam) { 
	  %team = "Friendly"; 
	}
	else { 
	  %team = "Enemy"; 
	}

	if($Target::Auto == %team) {
	  Target::Off();
	}
}

function targetFlaggerByName(%player, %msg) {
	%clientId = getClientByName(%player);
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
}

function Target::Off() {
	remoteEval(2048, CStatus, 0, "p0|nt3r 044");
}

function Target::Friendly() {

	Target::Off();
	$Target::Auto = "Friendly";
	remoteTP(2048, "<f2><jc>Flag Auto Target set to:  FRIENDLY", 2);

	if(($FlagHUD::FriendlyCarrier != "")  && ($FlagHUD::FriendlyCarrier != "DROPPED"))
	  targetFlaggerByName($FlagHUD::FriendlyCarrier, "Escort Friendly: " @ $FlagHUD::FriendlyCarrier @".~wescfr");
}

function Target::Enemy() {

	Target::Off();
	$Target::Auto = "Enemy";
	remoteTP(2048, "<f2><jc>Flag Auto Target set to:  ENEMY", 2);

	if(($FlagHUD::EnemyCarrier != "")  && ($FlagHUD::EnemyCarrier != "DROPPED"))
	  targetFlaggerByName($FlagHUD::EnemyCarrier, "Attack Enemy: " @ $FlagHUD::EnemyCarrier @".~attway");
}

Event::Attach(EventFlagTaken, Target::Grabbed);
Event::Attach(EventFlagDropped, Target::Dropped);
Event::Attach(EventFlagCaptured, Target::Off);