// docks to bottom of flaghud
$Item::xPos = $flag::xPos+9;
$Item::yPos = $flag::yPos+42;

function ItemHUD::Init() {

	if($ItemHUD::Loaded)
	  return;

	$ItemHUD::Loaded = true;

	$ItemHUD::Container = newObject("ItemHUD::Container", SimGui::Control, $Item::xPos, $Item::yPos, 140, 12);
	$ItemHUD::Data = newObject("ItemHUD::Data", FearGuiFormattedText, 0, 0, 140, 12);

	addToSet($ItemHUD::Container, $ItemHUD::Data);
}

function ItemHUD::Wake(%gui) {

	if(%gui != playGui)
	  return;

	addToSet(playGui, $ItemHUD::Container);

	ItemHUD::Update();
}

function ItemHUD::Sleep(%gui) {

	if(%gui != playGui)
	  return;

	removeFromSet(playGui, $ItemHUD::Container);

	schedule::cancel("ItemHUD::Update();");
}

function ItemHUD::Destroy() {

        removeFromSet(playGui, $ItemHUD::Container);
        deleteObject($ItemHUD::Container);
}

function ItemHUD::Update() {

	if(!$Mode::PlayMode)
	  return;

	schedule::add("ItemHUD::Update();", 1);

	%data  = "";
	%kits  = getItemCount("Repair Kit");
	%mines = getItemCount("Mine");
	%nades = getItemCount("Grenade");
 
	if(%kits)
	  %kits_bmp = "kiticon.bmp";
	else
	  %kits_bmp = "blankicon.bmp";
	
	%data = "<B0,0:bmp\\" @ %kits_bmp @ ">";
	
	for (%i = 0; %i < %mines; %i++) {

		%data = %data @ "<B0,0:bmp\\mineicon.bmp>";
	}

	for (%i = 0; %i < %nades; %i++) {

		%data = %data @ "<B0,0:bmp\\nadeicon.bmp>";
	}
	
	Control::SetValue("ItemHUD::Data", %data);
}

ItemHUD::Init();

Event::Attach(eventItemReceived, ItemHUD::Update);
Event::Attach(eventGuiOpen, ItemHUD::Wake);
Event::Attach(eventGuiClose, ItemHUD::Sleep);
Event::Attach(eventExit, ItemHUD::Destroy);