$zAdmin::ActiveMode = false;

function Active::Disconnect() {

	$zAdmin::ActiveMode = false;
}

// Function is called by server IF server is running zadmin.
function remotezAdminActiveMode(%client, %state) {

	$zAdmin::ActiveMode = true;
}

function zAdmin::InitActiveMode() {

	if(String::FindSubStr($Server::Address, "LOOPBACK") != -1)
	  return;
	
	$zAdmin::ActiveMode = false;

	RemoteEval(2048, zAdminActiveMode);
}

function remoteItemReceived(%client, %item, %count) {

	Event::Trigger(eventItemReceived, %item, %count);
}

function remoteKillTrak(%client, %killer, %victim, %weapon) {

	%killer = Client::GetName(%killer);
	%victim = Client::GetName(%victim);

	if((%killer == $PCFG::Name) || (%victim == $PCFG::Name))
	  Event::Trigger(eventKillTrak, %killer, %victim, %weapon);
}

function remoteMatchStarted(%client) {

	Event::Trigger(eventMatchStarted);
}

function remoteEnterStation(%client, %station) {

	Event::Trigger(eventEnterStation);
}

function remoteExitStation(%client, %station) {

	Event::Trigger(eventExitStation);
}

function remoteTeamScore(%client, %team, %score) {

	Event::Trigger(eventTeamScore, %team, %score);
}

function remoteFlagTaken(%client, %team, %player) {
	
	%player = client::getName(%player);
	Event::Trigger(eventFlagTaken, %team, %player);
}

function remoteFlagDropped(%client, %team, %player) {

	%player = client::getName(%player);
	Event::Trigger(eventFlagDropped, %team, %player);
}

function remoteFlagReturned(%client, %team, %player) {

	%player = client::getName(%player);
	Event::Trigger(eventFlagReturned, %team, %player);
}

function remoteFlagCaptured(%client, %team, %player) {

	%player = client::getName(%player);
	Event::Trigger(eventFlagCaptured, %team, %player);
}

Event::Attach(eventConnectionAccepted, zAdmin::InitActiveMode);
Event::Attach(eventDisconnected, Active::Disconnect);