// eventClientMessage(%client, %msg)
// eventServerMessage(%msg)
// eventExtendedClientMessage(%client, %long, %msg)
// eventClientTagMessage(%client, %tag, %value)
// eventChangeMission(%nextMission)
// eventMissionInfo(%server, %missionName, %missionType)
// eventServerInfo(%server, %version, %hostname, %mod, %info, %favKey)
// eventServerMod(%modname)
// eventMod_<modname>
// eventClientTeamAdd(%team, %name)
// eventClientJoin(%client)
// eventClientDrop(%client)
// eventClientChangeTeam(%client, %team)
// eventConnectionAccepted
// eventConnectionRejected(%reason)
// eventConnectionLost(%reason)
// eventConnectionTimeout
// eventConnected
// eventDisconnected
// eventGuiOpen(%gui)
// eventGuiClose(%gui)
// eventInventoryMode
// eventCommandMode
// eventPlayMode
// eventScreenModeChanged
// eventFullScreenMode
// eventSoftwareMode
// eventScreenSizeChanged
// eventObjectivesMode
// eventOptionsScreenOpened
// eventOptionsScreenClosed
// eventExit
// eventQuit
// eventSaveConfig
// eventSavePlayGui
// eventExportPrefs
// eventUpdateTime(%min, %sec)
// eventItemReceived(%item, %count)
// eventMatchStarted
// eventEnterStation
// eventExitStation
// eventUseItem(%desc)
// eventChangeTribesMusic($cdTrack, $cdPlayMode)
// eventFlagTaken(%team, %player)
// eventFlagDropped(%team, %player)
// eventFlagReturned(%team, %player)
// eventFlagTimeoutReturn(%team)
// eventFlagCaptured(%team, %player)
// eventRemoteITXT(%msg)

function Event::Attach(%event, %returnFunction) {

	if(%event != "" && %returnfunction != "") {

		for(%i = 1; %i <= $Event::[%event@"Num"]; %i++) {

			if($Event::[%event@%i] == %returnFunction) {

				return;
			}
		}

		$Event::[%event@"Num"]++;
		$Event::[%event@%i] = %returnfunction;
		$Event::[%event@%i, isstatement] = (String::FindSubStr(%returnFunction, ";") != -1);
	}
}

function Event::Detach(%event, %function) {

	if(%event != "" && %returnfunction != "") {

		for(%i = 1; %i <= $Event::[%event@"Num"]; %i++) {

			if($Event::[%event@%i] == %returnFunction) {

				$Event::[%event@%i] = "$null='';";
				$Event::[%event@%i, isstatement] = true;
			}
		}
	}
}

function Event::Trigger(%event, %p1, %p2, %p3, %p4, %p5, %p6, %p7, %p8, %p9, %p10) {

	for(%i = 1; %i <= $Event::[%event@"Num"]; %i++) {

		if ($Event::[%event@%i, isstatement]) {

		  %tmp = "";
		  eval($Event::[%event@%i]);
		}

		else
		  %tmp = eval($Event::[%event@%i]@"(%p1,%p2,%p3,%p4,%p5,%p6,%p7,%p8,%p9,%p10);" );

		if(%return != "FALSE") {

			if(%tmp != "")
			  %return = %tmp;
		}
	}

	return %return;
}

function onClientMessage(%client, %msg) {

    	if(%client)
     	  $lastClientMessage = %client;

    	%muted = false;

    	if((%index = String::findSubStr(%msg, "~")) != -1) {

		%long = %msg;
		%msg = String::getSubStr(%msg, 0, %index);
    	}

    	else %long = %msg;

	if(%client) {

	    %muted = %muted || (Event::Trigger(eventClientMessage, %client, %msg) == mute);
	}

	else {

		%handled = false;

		if(!$zAdmin::ActiveMode) {

			if (String::FindSubStr(%msg, "Station ") != -1) {

				if (%msg == "Station Access On") {

				  %muted = %muted || (Event::Trigger(eventEnterStation) == mute);
				  %handled = true;
				}

				else if (%msg == "Station Access Off") {

				  %muted = %muted || (Event::Trigger(eventExitStation) == mute);
				  $Event::Station = "";
				  %handled = true;
				}
			}

			if((String::FindSubStr(%msg, "flag") != -1) && (!handled)) {
			
				if(String::FindSubStr(%msg, "Your") != -1) { 
				  return; 
				}
		
				if(String::FindSubStr(%msg, " took the") != -1) {

					if(GetWord(%msg, 0) == "You") {
					 %player = $PCFG::Name; 
					}
					else { 
					  %idx = String::FindSubStr(%msg, " took the");
					  %player = String::GetSubStr(%msg, 0, %idx);
					}

					%tmp = Client::GetTeam(GetClientByName(%player));

					if(%tmp == 0) { 
					  %team = 1; 
					}
					else { 
					  %team = 0; 
					}

					%returns = Event::Trigger(eventFlagTaken, %team, %player);
			  		%handled = (%returns);
			  		%muted = %muted || (%returns == mute);
				}

				else if(String::FindSubStr(%msg, "dropped the") != -1) {

					if(GetWord(%msg, 0) == "You") { 
				  	  %player = $PCFG::Name; 
					}
					else { 
				  	  %idx = String::FindSubStr(%msg, " dropped the");
				  	  %player = String::GetSubStr(%msg, 0, %idx);
					}

					%tmp = Client::GetTeam(GetClientByName(%player));

					if(%tmp == 0) {
					  %team = 1; 
					}
					else { 
					  %team = 0; 
					}

					%returns = Event::Trigger(eventFlagDropped, %team, %player);
			  		%handled = (%returns);
			  		%muted = %muted || (%returns == mute);
				}

				else if(String::FindSubStr(%msg, "returned the") != -1) {

					if(GetWord(%msg, 0) == "You") {
					  %player = $PCFG::Name;
					}
					else { 
					  %idx = String::FindSubStr(%msg, " returned the");
					  %player = String::GetSubStr(%msg, 0, %idx);
					}

					%team = Client::GetTeam(GetClientByName(%player));

					%returns = Event::Trigger(eventFlagReturned, %team, %player);
			  		%handled = (%returns);
			  		%muted = %muted || (%returns == mute);
				}

				else if(String::FindSubStr(%msg, "returned to") != -1) {

					%returns = Event::Trigger(eventFlagTimeoutReturn, %team);
			  		%handled = (%returns);
			  		%muted = %muted || (%returns == mute);
				}

				else if(String::FindSubStr(%msg, "captured the") != -1) {

					if(GetWord(%msg, 0) == "You") { 
				  	  %player = $PCFG::Name;
					}
					else { 
				  	  %idx = String::FindSubStr(%msg, " captured the");
				  	  %player = String::GetSubStr(%msg, 0, %idx);
					}

					%tmp = Client::GetTeam(GetClientByName(%player));

					if(%tmp == 0) { 
				  	  %team = 1; 
					}
					else { 
				  	  %team = 0; 
					}

					%returns = Event::Trigger(eventFlagCaptured, %team, %player);
			  		%handled = (%returns);
			  		%muted = %muted || (%returns == mute);
				}
			}

			if ((String::findSubStr(%msg, "You received ") != -1) && (!%handled)) {

			  %substr = String::getSubStr(%msg, 13, 1024);
			  %space = String::findSubStr(%substr, " ");
			  %count = String::getSubStr(%substr, 0, %space);
			  %item = String::getSubStr(%substr, %space+1, 1024);

			  %muted = %muted || (Event::Trigger(eventItemReceived, %item, %count) == mute);
			  %handled = true;
			}
		
			if ((%msg == "Match started.") && (!%handled)) {

			  Event::Trigger(eventMatchStarted);
			  %handled = true;
			}
		}

		if(!%handled) {

		    %muted = %muted || (Event::Trigger(eventServerMessage, %msg) == mute);
		    %handled = true;
		}
	}
    
    return !%muted;
}

function remoteMissionChangeNotify(%serverManagerId, %nextMission) {

    	if(%serverManagerId == 2048) {

        	Event::Trigger(eventChangeMission, %nextMission);

       		echo("Server mission complete - changing to mission: ", %nextMission);
        	echo("Flushing Texture Cache");
        	flushTextureCache();
        	schedule("purgeResources(true);", 3);
    	}
}

function remoteMInfo(%server, %missionName) {

	if(%server == 2048) {

		$MDESC::Type = "";
		$MDESC::Text = "";

		%file = "missions\\" @ %missionName @ ".dsc";
		if(File::findFirst(%file) != "")
			exec(%file);

		$ServerMission = %missionName;
		$ServerText = $MDESC::Text;
		$ServerMissionType = $MDESC::Type;

		if(isObject(LobbyGui))
		  LobbyGui::onOpen();
	}

	Event::Trigger(eventMissionInfo, %server, %missionName, $ServerMissionType);
}

function remoteSVInfo(%server, %version, %hostname, %mod, %info, %favKey) {

    	if(%server == 2048) {

        	$ServerVersion = %version;
        	$ServerName = %hostname;
        	$modList = %mod;
        	$ServerMod = $modList;
        	$ServerInfo = %info;
        	$ServerFavoritesKey = %favKey;

        	Event::Trigger(eventServerInfo, %server, %version, %hostname, %mod, %info, %favKey);

        	%i = 0;

        	while((%modname = getWord(%mod, %i)) != -1) {

            	  Event::Trigger(eventServerMod, %modname);
            	  Event::Trigger(eventMod_ @ %modname);
            	  %i++;
        	}

        	EvalSearchPath();
    	}
}

function onTeamAdd(%team, %name) {

	$Team::Name[%team-1] = %name;
    	Event::Trigger(eventClientTeamAdd, %team, %name);
}

function onClientJoin(%client) {

    	Event::Trigger(eventClientJoin, %client);
}

function onClientDrop(%client) {

    	Event::Trigger(eventClientDrop, %client);
}

function onClientChangeTeam(%client, %team) {

    	Event::Trigger(eventClientChangeTeam, %client, %team);
}

function onQuit() {

	%returned = Event::Trigger(eventQuit);

    	if(%returned == mute)
          return;

    	if($pref::ConfirmQuit && !(%returned != noconfirm))
	  GuiPushDialog(MainWindow, "gui\\Exit.gui");
    	else
          quit();
}

function onExit() {

    	%returned = Event::trigger(eventExit);

    	if(isObject(playGui)) {

          RemoveClickFix(playGui);
          storeObject(playGui, "config\\play.gui");
    	}

    	saveActionMap("config\\config.cs", "actionMap.sae", "playMap.sae", "pdaMap.sae");

    	$pref::VideoFullScreen = isFullScreenMode(MainWindow);

    	if($pref::StartAlwaysFullScreen)
          $pref::VideoFullScreen = true; // set fullscreenmode to true for next start
    	else
          $pref::VideoFullScreen = isFullScreenMode(MainWindow); //update the video mode - since it can be changed with alt-enter

    	checkMasterTranslation();

    	echo("exporting pref::* to prefs.cs");
    	export("pref::*", "config\\ClientPrefs.cs", False);
    	export("Server::*", "config\\ServerPrefs.cs", False);
    	export("pref::lastMission", "config\\ServerPrefs.cs", True);
}

function onConnectionError(%client, %manager, %errorString) {

	return;
}

function onConnection(%message) {

    	echo("Connection ", %message);
    	$dataFinished = false;

    	if(%message == "Accepted") {

        	resetSimTime();

        	if($PCFG::Script != "")
            	  exec($PCFG::Script);

        	resetPlayDelegate();
        	remoteEval(2048, "SetCLInfo", $PCFG::SkinBase, $PCFG::RealName, $PCFG::EMail, $PCFG::Tribe, $PCFG::URL, $PCFG::Info, $pref::autoWaypoint, $pref::noEnterInvStation, $pref::messageMask);

        	if ($Pref::PlayGameMode == "JOIN") {

            	  cursorOn(MainWindow);
            	  GuiLoadContentCtrl(MainWindow, "gui\\Loading.gui");
            	  renderCanvas(MainWindow);
        	}

		Event::Trigger(eventConnectionAccepted);
    	}

    	else if(%message == "Rejected") {

          $errorString = "Connection to server rejected:\n" @ $errorString;
          Event::Trigger(eventConnectionRejected, $errorString);
    	}

    	else {

          Quickstart();

        	if(%message == "Dropped") {

            		if($errorString == "")
                	  $errorString = "Connection to server lost:\nServer went down.";
            		else
                	  $errorString = "Connection to server lost:\n" @ $errorString;

            		Event::Trigger(eventConnectionLost, $errorString);

            		GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
            		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
        	}

       		else if(%message == "TimedOut") {

            		$errorString = "Connection to server timed out.";
            		GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
            		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
            		Event::Trigger(eventConnectionTimeout);
        	}
    	}
}

function dataFinished() {

    	if ($cdMusic && !$pref::userCDOverride) {

          rbSetPlayMode(CD, 0);
          rbStop(CD);
    	}

    	Control::setValue(ProgressText, "<jc><f0>Get ready to rock n' roll!");
    	Control::setValue(ProgressSlider, 0.9);

    	$dataFinished = true;
    	remoteEval(2048, dataFinished);

    	Event::Trigger(eventConnected);

    	echo("Flushing Texture Cache");
    	flushTextureCache();
}

function EndGame() {

	$ConnectedToServer = FALSE;
	$recordDemo = FALSE;

	setCursor(MainWindow, "Cur_Arrow.bmp");
	disconnect();

	if($SinglePlayer)
	  TrainingEndGameCallback();

	if ($pref::userCDOverride == False) {

	  rbSetPlayMode (CD, 0);
	  rbStop (CD);
	  $cdTrack = "";
	}

	startMainMenuScreen();

	deleteServer();
	QuickStart();

	Event::Trigger(eventDisconnected);

	deleteObject(ConsoleScheduler);
	newObject(ConsoleScheduler, SimConsoleScheduler);
	
	if($quitOnDisconnect)
	  schedule("quit();", 0);
}

function remoteSetMusic (%player, %track, %mode) {

    	if(%player == 2048) {

          $cdPlayMode = %mode;
          $cdTrack = %track;

        	if(!$pref::userCDOverride) {

            		if($cdTrack == 0) {

			  rbSetPlayMode (CD, 0);
			  rbStop (CD);
            		}

            		else if($cdTrack != "") {

                	  Event::Trigger(eventChangeTribesMusic, $cdTrack, $cdPlayMode);

                    	  rbSetPlayMode (CD, 0);
                   	  rbStop (CD);
                    	  rbSetPlayMode (CD, $cdPlayMode);

                    		if($pref::cdMusic)
                        	  rbPlay(CD, $cdTrack);
            		}
        	}
    	}
}

function OpenAGui(%gui) {

	Event::Trigger(eventGuiOpen, %gui);

    	if($needsClickFix)
          ClickFix(%gui);
}

function CmdInventoryGui::onOpen() {

    	if($curFavorites == -1) {

          CmdInventoryGui::favoritesSel(1);
          Control::performClick("FavButton1");
    	}

    	$Mode::InventoryMode = true;
    	$Mode::CommandMode =
    	$Mode::ObjectivesMode =
    	$Mode::OptionsMode =
    	$Mode::PlayMode = false;

    	OpenAGui(CmdInventoryGui);

    	Event::Trigger(eventInventoryMode);

    	if($Mode::ExitInventory) {

          $Mode::ExitInventory = false;
          remoteEval(2048, PlayMode);
    	}
}

function CmdInventoryGui::onClose() {

    	$Mode::InventoryMode = false;
    	Event::Trigger(eventGuiClose, CmdInventoryGui);
}

function PlayGui::onOpen() {

    	$Mode::CommandMode = false;
    	$Mode::InventoryMode = false;
    	$Mode::ObjectivesMode = false;
    	$Mode::OptionsMode = false;
    	$Mode::PlayMode = true;

    	OpenAGui(PlayGui);

    	Event::Trigger(eventPlayMode);

    	if($pref::VideoFullScreen != $Events::VideoFullScreen) {

        	Event::Trigger(eventScreenModeChanged);

        	if($pref::VideoFullScreen)
            	  Event::Trigger(eventFullScreenMode);
        	else
            	  Event::Trigger(eventSoftwareMode);
    	}

    	else if($pref::VideoFullScreen && ($pref::VideoFullScreenRes != $Events::VideoFullScreenRes)) {

        	Event::Trigger(eventScreenSizeChanged, $pref::VideoFullScreenRes);
    	}

    	$Events::VideoFullScreen = $pref::VideoFullScreen;
    	$Events::VideoFullScreenRes = $pref::VideoFullScreenRes;
}

function PlayGui::onClose() {

    	Event::Trigger(eventGuiClose, PlayGui);
    	$Mode::PlayMode = false;
}

function CommandGui::onOpen() {

    	if ($pref::mapFilter & 0x0001) Control::setValue(IDCTG_CMDO_PLAYERS, "TRUE");
    	else Control::setValue(IDCTG_CMDO_PLAYERS, "FALSE");

    	if ($pref::mapFilter & 0x0002) Control::setValue(IDCTG_CMDO_TURRETS, "TRUE");
    	else Control::setValue(IDCTG_CMDO_TURRETS, "FALSE");

    	if ($pref::mapFilter & 0x0004) Control::setValue(IDCTG_CMDO_ITEMS, "TRUE");
    	else Control::setValue(IDCTG_CMDO_ITEMS, "FALSE");

    	if ($pref::mapFilter & 0x0008) Control::setValue(IDCTG_CMDO_OBJECTS, "TRUE");
    	else Control::setValue(IDCTG_CMDO_OBJECTS, "FALSE");

    	if (String::ICompare($pref::mapSensorRange, "TRUE") == 0) Control::setValue(IDCTG_CMDO_RADAR, "TRUE");
    	else Control::setValue(IDCTG_CMDO_RADAR, "FALSE");

    	if (String::ICompare($pref::mapNames, "TRUE") == 0) Control::setValue(IDCTG_CMDO_EXTRA, "TRUE");
    	else Control::setValue(IDCTG_CMDO_EXTRA, "FALSE");

    	Control::setValue("TVButton", false);

    	$Mode::CommandMode = true;
    	$Mode::InventoryMode =
    	$Mode::ObjectivesMode =
    	$Mode::OptionsMode =
    	$Mode::PlayMode = false;

    	OpenAGui(CommandGui);

    	Event::Trigger(eventCommandMode);

    	if($Mode::ExitCommand) {

          $Mode::ExitCommand = false;
          remoteEval(2048, PlayMode);
    	}
}

function CommandGui::onClose() {

    	Event::Trigger(eventGuiClose, CommandGui);
    	$Mode::CommandMode = false;
}

function OptionsGui::onOpen() {

    	$Events::VideoFullScreen = $pref::VideoFullScreen;

    	IRCOptions::init();

    	OptionsMovement::init();
    	OptionsVideo::init();
    	OptionsGraphics::init();
    	OptionsNetwork::init();
    	OptionsSound::init();

    	if(!$Mode::OptionsMode) {

          $Mode::OptionsMode = true;
          $Mode::CommandMode =
          $Mode::InventoryMode =
          $Mode::ObjectivesMode =
          $Mode::PlayMode = false;

          Event::Trigger(eventOptionsScreenOpened);
    	}

    	OpenAGui(OptionsGui);
}

function OptionsGui::onClose() {

    	Event::Trigger(eventGuiClose, OptionsGui);

    	IRCOptions::Shutdown();

    	OptionsNetwork::shutdown();

    	$Mode::OptionsMode = false;

    	Event::Trigger(eventOptionsScreenClosed);
}

function CmdObjectivesGui::onOpen() {

    	$Mode::ObjectivesMode = true;
    	$Mode::CommandMode = false;
    	$Mode::InventoryMode = false;
    	$Mode::ObjectivesMode = false;
    	$Mode::OptionsMode = false;
    	$Mode::PlayMode = false;

    	OpenAGui(CmdObjectivesGui);

    	Event::Trigger(eventObjectivesMode);
}

function CmdObjectivesGui::onClose() {

    	Event::Trigger(eventGuiClose, CmdObjectivesGui);
    	$Mode::ObjectivesMode = false;
}

function remoteINV(%msg)  { 

	if(String::findSubStr(%msg, "STATION ENERGY") != -1) 
	  $Event::Station = "RemoteInventory";
	else 
	  $Event::Station = "Inventory";
}

function remoteITXT(%manager, %msg) {

	if(%manager == 2048) { 

	  Control::setValue(EnergyDisplayText, %msg); 
	  remoteINV(%msg);

	  Event::Trigger(eventRemoteITXT, %msg);
	} 
}

function use(%desc) {

	%type = getItemType(%desc);

	if(%type != -1) {

	  useItem(%type);
	  Event::Trigger(eventUseItem, %desc);
	}
}

function throw(%desc) {

	%type = getItemType(%desc);

	if(%type != -1) {

	  remoteEval(2048, throwItem, %type, 1000);
	  Event::Trigger(eventUseItem, %desc);
	}
}

function remoteSetTime(%server, %time) {

    	if(%server == 2048)
          setHudTimer(%time);

    	%time = (-%time + $tweakTime);
    	%min = Time::getMinutes(%time);
    	%sec = Time::getSeconds(%time);
	
    	if(%min > 59)
      	  return;

    	Event::Trigger(eventUpdateTime, %min, %sec);
}
