// ===============================================================================================
//  HyperHUD V3.2a
//  August 8, 1999
//
//  DarkNinja
//  http://www.zianet.com/mjaecks/hyperhud/
// ===============================================================================================
//  This is another HUD script file for Starsiege TRIBES.  It is a variant of DynHUD by Presto,
//  which in turn is a modification of the original DynHUD by KillerBunny.
//
//  So what?  Well, I've tried to venture down a different path by making the HUD totally
//  configurable.  There are many separate HUDs available.  I've also designed some custom icons
//  for the General HUDs.
//
//	NOTE: These can be placed on any four sides of the screen.
//
//	- CTF HUDs for your team's flag status and the enemy's flag status.
//	  Optional display of time until a dropped flag returns home.
//	- Flag Capture HUD shows how many times your team, the enemy team and you personally have captured the flag.
//	  Optional display of your personal lifetime captures.
//	- Kills HUD shows how many kills you've made so far.
//	  Optional display of your lifetime kills.
//	- Deaths HUD shows how many times you've died.
//	  Optional display of your lifetime deaths.
//	- Mines HUD shows how many mines you have.
//	- Grenades HUD shows how many grenades you have.
//	- Repair Kit HUD shows if you have a repair kit.
//	- Beacon HUD shows how many beacons you have.
//	- Player Count HUD for showing how many players are on each team.
//	  Optional display of how many observers there are too.
//	- Play time HUD shows how long you have been playing the current session of TRIBES.
//	  Optional display of your lifetime play time.
//	- Backpack HUD shows you what you are carrying on your back.
//
//	Extras (non-HUD):
//
//	- Show who you have killed along with the weapon you used.
//	- Show who killed you along with the weapon they used.
//	- Notify all players when there is team unbalance.
//
//	Other beneficial scripts:
//
//	- Objective HUD by |HH|Crunchy.  (Link is on my links page.)
//	  This cool HUD shows the objectives currently being held by your team or the enemy.  It
//	  shows objectives for Find & Retrieve, Defend & Destroy, Capture & Hold, etc.  And it
//	  touts the ability to learn objectives on NEW maps. :)
//
//  There are now three styles of HUD screens available.  Hitting "Control-H" will cycle through
//  these accordingly.
//
//	1) Capture the Flag - Shows your team and enemy team flag status HUDs.  Also, shows your
//	   general HUDs.
//	2) Multiple Team CTF - Shows your team's flag status along with the general HUDs.  Right
//	   now HyperHUD can only handle two teams at most in CTF, so there is no sense in
//	   showing the enemy's flag status if there are three or more teams playing.
//	3) General Gameplay - Shows only the general HUDs.  This option is useful for other
//	   gameplay, such as Defend & Destroy, Deathmatch, etc.
//
//  NOTE: For more detailed information, please read the descriptions for each function in the
//  script.  The HUD update function descriptions will tell you what the HUDs look like and how
//  they work.
// ===============================================================================================
//  History:
//	- 3.2a, August 8, 1999
//	  Added dynamic calculation of flag return time for use with flag return time display in
//	  the CTF HUDs.  Time is calculated only once upon a server connection.  The initial
//	  default is still 48 seconds.  Calculation is done by counting how many seconds a flag
//	  stays dropped in the field before returning on its own.  NOTE:  If you suddenly get
//	  lag during a flag return event and first-time calculation of the flag return time, you
//	  could end up with a new inaccurate default flag return time.  You check this by seeing
//	  if the CTF HUD displays "Flag returns in 1" when the flag actually is returned.  If
//	  you see a value less than 1 or greater than 1, then you'll know.  If this happens, you
//	  can bring down the console (~) and enter:
//
//		$Hyper::FlagTimerDefault = 48;
//		$Hyper::NewReturnTime = "";
//
//	  Fixed a bug where play time HUD would not update upon initial connection to a server.
//
//	  Fixed a bug where beacon icon wasn't being highlighted, even though you did have
//	  beacons in your inventory.
//
//	- 3.2, August 1, 1999
//	  There is an annoying bug where the Play Time HUD doesn't show anything upon startup.
//	  I still need to track this down, but wanted to get this release out now.  Once a
//	  minute has been reached or you manually toggle HyperHUD, the time will be shown.
//
//	  HyperHUD is now stored in "Tribes\config\HyperHUD" along with the icons in a volume
//	  file.  Therefore, you may delete all the "Tribes\base\HyperHUD_..." files and the
//	  "Tribes\config\HyperHUD.cs" file if you want.  The Prefs/Stats/DEBUG files are still
//	  kept in "Tribes\config\".  NOTE:  Change your call to HyperHUD in your
//	  "Tribes\config\autoexec.cs" file to:
//
//		Include("HyperHUD\\HyperHUD.cs");
//
//	  Changed the flag capture general HUD a little.  Now when you personally capture a
//	  flag, the flag capture icon will blink, alternately showing your personal captures for
//	  this current game being played.  What's different from previous versions is that the
//	  capture totals to the left and right of the icon remain visible, instead of
//	  disappearing.
//
//	  Player count HUD now keeps track of up to four teams in Multiple Team play.  I use
//	  colored arrows to represent each team.  The arrows also have the number (1-4) of which
//	  team is what color (green/red/lt. blue/yellow).  Your team's player count will appear
//	  in white and all enemies' in orange.  NOTE:  If you are playing a map that allows up
//	  to four teams, but there are currently only two teams playing, then the HUD will only
//	  show the two teams (as green and red arrows).  There is no sense wasting screen space
//	  displaying the extra two teams if no one is on them. :)
//
//	  Reworked the appearance of the HUDs.  They are now a bit smaller.  Not much, but you
//	  might notice the difference.  If you have manually repositioned the HUD locations from
//	  previous versions, you might have to reposition them again due to the size change.
//
//	  Removed the "bottom" option from the general HUD location choices.  It was too much
//	  trouble to figure out how far up from the bottom to start displaying them.  Instead,
//	  choose the "top" choice and reposition them manually with the x/y position menu.
//
//	  Fixed a bug pertaining to the display of general HUDs during the manual positioning
//	  and change of the HUDs per line (e.g. General HUD Location at "top" and HUDs Per Line
//	  equal to 2).  This shows the general HUDs in two columns, instead of one.  At least
//	  one user had requested this option, but it was unknowingly already included.  To try
//	  it, choose Prefs at the gameplay screen (ALT-k).  Choose the general HUD config menu.
//	  Choose "o" to change the HUDs per line to 2.  Hit ESCAPE (don't need to save prefs for
//	  this example, unless you want 2 columns permanently).  Choose Prefs again.  Choose
//	  general HUD location.  Change them to the "top" position.  Now you can manually move
//	  them around using the x/y position menu.
//
//	  Added the option to display the time remaining before a flag is returned home.  This
//	  is shown in the CTF HUDs, where you normally would see the "ATTACK..." or "ESCORT..."
//	  messages.  Default return time is 48 seconds.  You can change this manually during
//	  gameplay by opening the console (~) and typing "$Hyper::FlagTimerDefault = ##", where
//	  ## equals the total seconds it takes this server to return flags on their own.  I will
//	  work on a dynamic calculation for this in the next release.  NOTE:  Remember, all new
//	  options that can be toggled on/off are off with the new version of HyperHUD.  You must
//	  go into Preferences (ALT-k at gameplay screen) and turn them on if you want to use
//	  them.  So the flag timer option is off by default.  It's located in the
//	  "Miscellaneous" menu.  Thanks Razor!
//
//	  Added option to call HyperHUD from another script with the ability to toggle HyperHUD
//	  into a specific mode.  Valid modes are "CTF" (Capture the Flag), "MT" (Multiple Team),
//	  "Gen" (General) and "" (No visible HUDs).  So if you wanted to call HyperHUD in
//	  General mode, you would use the line "Hyper::Toggle("Gen");" in your code.  Thanks
//	  Patrick!
//
//  For previous version history, check out my news web page:
//  http://www.zianet.com/mjaecks/hyperhud/news.html
// ===============================================================================================
//  Requirements:
//	- Presto's ScriptPak V0.93 or higher.
//	  (http://www.planetstarsiege.com/presto/)
//	- "MoreString.cs" by Zear (included in NewOpts, also by Zear).
//	  (http://www.cetisp.com/~thammock/scripts/script/NewOpts.html)
//	- Backpack HUD works best with latest "inventory_table.cs" script by Writer.
//	  (http://www.planetstarsiege.com/lorne/scripts/inventory_table.cs)
//	- "autoexec.cs" in your "Tribes\config" directory.  If you don't have this file, just
//	  copy the one supplied with Presto's ScriptPak.
//	- A screen width of at least 512 works best.  Anything smaller isn't worthwhile.
// ===============================================================================================
//  Installation:
//	- After installing Presto's ScriptPak, you should have in your
//	  "Tribes\config\autoexec.cs" file the following, if you don't already have it:
//
//		exec("Presto\\install.cs");
//
//	- If you followed the installation instructions from Presto, then add this next:
//
//		Include("HyperHUD\\HyperHUD.cs");
//
//	- HyperHUD's Preference Menus can be accessed via "ALT-k" on the gameplay screen.  You
//	  can change this by editing the "Tribes\config\HHPrefs-{Your Nickname}.cs" file.  If
//	  you don't have one yet, one will be created after running Tribes at least once.
//
//	- HyperHUD's default control is currently set to "Control-h".  You can change this by
//	  editing the "Tribes\config\HHPrefs-{Your Nickname}.cs" file.  If you don't have one
//	  yet, one will be created after running Tribes at least once.
//
//	- If you're not using Presto's DynHUD, edit "Tribes\config\Presto\PrestoPrefs.cs" and
//	  change the line:
//
//	  $PrestoPref::DynHud = "control h";
//
//	  to
//
//	  $PrestoPref::DynHud = false;
//
//	- Make sure you have the following line in your "Tribes\config\Presto\PrestoPrefs.cs"
//	  file somewhere:
//
//	  $PrestoPref::KillTrak = true;
//
//	  If this is set to false, then the kills/deaths HUDs won't operate properly.
// ===============================================================================================
//  Help:
//	- After you've installed everything correctly and have run TRIBES, HyperHUD may not
//	  activate when you press "Control-H".
//
//	  Solution:
//		- Edit your "Tribes\config\config.cs" file and make sure that there are only
//		  two references to the "Control-H" bind.  The first line is the "make" bind
//		  referring to "Hyper::Toggle();".  The second line will be the "break" bind
//		  referring to "".  If you see any other lines with something like
//		  "control, "h"", then delete them.
//
//	- Player names will wrap in the flag status HUDs if they are very long. This has to do
//	  with Presto's ScriptPak, but I really don't think it's that bad.  I've left three
//	  lines for a player's name, in case there are some out there who insist on long names
//	  with meaningless symbols in them. :)
//
//	- For more help, check out:
//
//	  http://www.zianet.com/mjaecks/hyperhud/help.html
// ===============================================================================================
//  Future:
//	- Add team score tracking perhaps.
//	- Clean up the code some.
// ===============================================================================================
//  Thanks to:
//	- Presto: Without his ScriptPak, life would be a little bit harder. :)
//	- KillerBunny: For starting a revolution with the release of the original DynHUD.
//	- Starsiege Team: Great game!
//	- Scripters: Keep up the good work.
// ===============================================================================================
//  Contact:
//	- Comments and suggestions are welcome.
//	- Permission is granted to use parts of my HyperHUD.cs script in helping you develop a
//	  cool HUD of your own. All I ask is for some mention/credit of my script name and/or
//	  nickname.  References to DynHUD, Presto and KillerBunny would be welcome too.
//	- Permission is granted to use my custom icons in your HUD development as long as some
//	  mention/credit of my script name and/or nickname is given.
//	- PLEASE do not contact me about any problems installing or using Presto's ScriptPak.
//
//  DarkNinja
//  mjaecks@zianet.com
// ===============================================================================================

// Script functions needed.
Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\TeamTrak.cs");
Include("presto\\KillTrak.cs");
Include("NewOpts\\MoreString.cs");
newObject(HyperHUD, SimVolume, "HyperHUD\\hyperhud.vol");

// Lets add a banner on the main screen.
Presto::AddScriptBanner(HyperHUD,
	"<f2><jc>HyperHUD\n" @
	"<f1>Version 3.2a\n" @
	"<f0><jc>August 8, 1999\n\n" @
	"<f0>Written by: <f2>DarkNinja<f0>\n\n" @
	"<f0>The HUD of champions!\n\n" @
	"<f2>ALT-k <f1>for Preferences");

$Hyper::DefaultUser = $PCFG::Name;

$Hyper::c = -1;	// DO NOT MODIFY THIS LINE!!!

function Hyper::DefaultPrefs(%type)
{
if ($HHDEBUG)
	Hyper::DEBUG("\nHyper::DefaultPrefs(" @ %type @ ")", 3);

if ((%type == "keys") || (%type == "all"))
{
$HyperPref::Toggle = "control h";
$HyperPref::PrefToggle = "alt k";
}

if ((%type == "flagloc") || (%type == "all"))
{
// Where do you want the flag status HUDs to appear?  Options are:
//
//	   "left" - Appear vertically on the left side of the screen, between the power/health
//		  meters and the weapon icons.  If you have the general HUDs below set to
//		  "left" also, then the flag status HUDs will appear to the right of the
//		  general HUDs.
//	  "right" - Appear vertically on the right side of the screen, just under the compass.
//		  If you have the general HUDs below set to "right" also, then the flag status
//		  HUDs will appear to the left of the general HUDs.
//	    "top" - Appear horizontally at the top center of the screen.  Use this option only
//		  if you have turned off the chat window.  You can do this during gameplay
//		  via the prefs menu, default key is "k".
//	 "bottom" - Appear horizontally at the bottom of the screen.  If you choose this option,
//		  your team's flag status HUD will appear in bottom left corner and the
//		  enemy's will appear in the bottom right corner.
$HyperPref::FlagHUDLoc = "left";

// Starting Y position of our flag HUDs.  This is how many pixels from top of screen the flag HUDs
// will be displayed.  Good values are 65 for 512x384, 70 for 640x480, 80 for 800x600 and 90 for
// 1024x768.  This value only applies if $HyperPref::FlagHUDLoc equals "left", "right" or "topchat".
// You can modify this to your own liking.
$HyperPref::FlagPos = "0% 25%";
}

if ((%type == "genloc") || (%type == "all"))
{
// Where do you want the general HUDs to appear?  Options are:
//
//	   "left" - Appear vertically on the left side of the screen, between the power/health
//		  meters and the weapon icons.
//	  "right" - Appear vertically on the right side of the screen, just under the compass.
//	    "top" - Appear horizontally at the top center of the screen.  Use this only if you
//		  do not like having the chat message window open.  You can turn the chat
//		  window on/off via prefs menu during gameplay, default key is "k".
$HyperPref::GenHUDLoc = "right";

// Starting Y position of our general HUDs (caps/kills/deaths/etc.).  This is how many pixels from
// top of screen the HUDs will be displayed.  This value only applies if $HyperPref::GenHUDLoc equals
// "left", "right" or "topchat".  Good values are the same as for $HyperPref::FlagPos.  Modify to
// your liking.
$HyperPref::GenPos = "100% 25%";
}

if ((%type == "perline") || (%type == "all"))
{
// This is how many general HUDs to display per line ONLY IF $HyperPref::GenHUDLoc equals "top".
// Good values are 4 for a screen width of 512, 6 for 640 and 9 for 800+.
$HyperPref::HUDsPerLine = 6;
}

// For the following, true = uncommented line and false = commented line.  Commented lines
// begin with "//", so '//$HyperPref::Gen[%c++] = "Caps";' would turn off the flag capture HUD.
//
// Also, you can reorder the General HUDs to your liking.  All you have to do is CUT & PASTE the
// lines below in the order you want the HUDs to appear.

if ((%type == "gencfg") || (%type == "all"))
{
// General HUDs.
$HyperPref::Gen[$Hyper::c++] = "Caps";		// Show how many times you and/or your team have captured the enemy flag?
$HyperPref::Gen[$Hyper::c++] = "Kills";		// Show how many kills you've made?
$HyperPref::Gen[$Hyper::c++] = "Deaths";	// Show how many times you have been killed?
$HyperPref::Gen[$Hyper::c++] = "Mines";		// Show how many mines you have?
$HyperPref::Gen[$Hyper::c++] = "Grenades";	// Show how many grenades you have?
$HyperPref::Gen[$Hyper::c++] = "Repair";	// Show if you have a repair kit?
$HyperPref::Gen[$Hyper::c++] = "Beacon";	// Show beacons if you have them?
$HyperPref::Gen[$Hyper::c++] = "Players";	// Show how many players are on each team?
$HyperPref::Gen[$Hyper::c++] = "PlayTime";	// Show how long you've been playing?

// For the following, true = on and false = off.

$HyperPref::ShowTC = true;
$HyperPref::ShowTK = true;
$HyperPref::ShowTD = true;
$HyperPref::ShowObserver = true;
$HyperPref::ShowTT = true;

$HyperPref::NumGenHUDs = $Hyper::c + 1;	// How many General HUDs do we have?
}

if ((%type == "misc") || (%type == "all"))
{
// For the following, true = on and false = off.

$HyperPref::ShowVictim = true;	// Upon a kill, do you want the victim and weapon used shown
				// temporarily onscreen?
$HyperPref::ShowKiller = true;	// Upon your death, do you want to view the killer and weapon used
				// temporarily onscreen?

$HyperPref::AutoStart = true;		// Do you want HyperHUD to automatically run on startup?

$HyperPref::GenStart = false;		// Do you want HyperHUD to start up in the General Gameplay screen?  (No flag status HUDs.)

$HyperPref::DEBUG = false;

$HyperPref::BalanceNotify = true;	// Notify everyone when teams are unbalanced?  NOTE: You must have
				// the player count HUD active above ("Players"), otherwise this
				// is useless.
$HyperPref::FlagReturnTime = true;
}


if ((%type == "outnumber") || (%type == "all"))
$HyperPref::Outnumber = 5;		// By how many players do you consider a team outnumbered?

if ((%type == "pack") || (%type == "all"))
{
$HyperPref::ShowPack = true;
$HyperPref::PackPos = "100% 100%";
}

if ($HHDEBUG)
	Hyper::DEBUG("Exiting Hyper::DefaultPrefs\n", -3);
}

function Hyper::DEBUG(%txt, %indent)
{
	if (%indent == "")
		%indent = 0;
	if ($HHIndent < 0)
		$HHIndent = 0;
	if (%indent != 3)
		$HHIndent += %indent;
	else
	{
		$hh = " ";
		echo($hh);
		export("$hh", "config\\HH-DEBUG.cs", true);
	}

	for (%i = 0; %i < $HHIndent; %i++)
		%txt = " " @ %txt;
	$hh = %txt;
	export("$hh", "config\\HH-DEBUG.cs", true);
	%txt = "DEBUG: " @ %txt;
	echo(%txt);
	if (%indent == 3)
		$HHIndent += %indent;
}

function Hyper::ProcessDebug()
{
	$hh = "HyperHUD V3.2a DEBUG File";
	export("$hh", "config\\HH-DEBUG.cs", false);
	$hh = " ";
	export("$hh", "config\\HH-DEBUG.cs", true);
	$hh = "HyperHUD Preferences:";
	export("$hh", "config\\HH-DEBUG.cs", true);
	export("$HyperPref::*", "config\\HH-DEBUG.cs", true);
	$hh = " ";
	export("$hh", "config\\HH-DEBUG.cs", true);
	$hh = "HyperHUD Stats:";
	export("$hh", "config\\HH-DEBUG.cs", true);
	export("$HyperStat::*", "config\\HH-DEBUG.cs", true);
	$hh = " ";
	export("$hh", "config\\HH-DEBUG.cs", true);
	$hh = "HyperHUD Program Execution:";
	export("$hh", "config\\HH-DEBUG.cs", true);
}

function Hyper::ProcessArray(%value)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::ProcessArray(" @ %value @ ")", 3);

	$HyperPref::Gen[$Hyper::c++] = %value;

	if ($HHDEBUG)
	{
		Hyper::DEBUG("$HyperPref::Gen[" @ $Hyper::c @ "]: " @ %value);
		Hyper::DEBUG("Exiting Hyper::ProcessArray", -3);
	}
}

function Hyper::ProcessName(%in)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::ProcessName(" @ %in @ ")", 3);

	%strlen = String::len(%in);
	%name = "";

	for (%i = 0; %i < %strlen; %i++)
	{
		%ascii = String::ascii($PCFG::Name, %i);
		if ((%ascii == 32) || (%ascii == 45) || ((%ascii > 47) && (%ascii < 58)) ||
		    ((%ascii > 64) && (%ascii < 91)) || ((%ascii > 96) && (%ascii < 123)))
			%name = %name @ String::char(%ascii);
	}

	%name = %name @ "";

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%name: " @ %name);
		Hyper::DEBUG("Exiting Hyper::ProcessName", -3);
	}

	return %name;
}

function Hyper::UpdatePrefs(%type)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdatePrefs(" @ %type @ ")", 3);

	if ($PCFG::Name != $Hyper::DefaultUser)
	{
		Client::centerPrint("<jc><f1>Starting User Nickname is not the same as current Nickname.\nPlease quit Tribes and run again.\nPrefs file will not be updated until then.", 1); 
    		schedule("Client::centerPrint(\"\", 1);", 30);
		if ($HHDEBUG)
		{
			Hyper::DEBUG("Exiting Hyper::UpdatePrefs", -3);
		}
		return;
	}

	%filename = "config\\HHPrefs-" @ Hyper::ProcessName($PCFG::Name);

	if (%type == "normal")
		%filename = %filename @ ".cs";
	else
		%filename = %filename @ ".bak";

	export("$HyperPref::*", %filename, false);

	%txt = "HyperHUD Preferences ";

	if (%type == "normal")
		%txt = %txt @ "Updated!";
	else
		%txt = %txt @ "Backup Made!";

	echo(%txt);

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%filename: " @ %filename);
		Hyper::DEBUG("export($HyperPref::*, " @ %filename @ ", false)");
		Hyper::DEBUG("Exiting Hyper::UpdatePrefs", -3);
	}
}

function Hyper::LoadPrefs()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::LoadPrefs()", 3);

	%filename = "HHPrefs-" @ Hyper::ProcessName($PCFG::Name) @ ".cs";

	if ($HHDEBUG)
		Hyper::DEBUG("%filename: " @ %filename);

	if (isFile("config\\" @ %filename))
	{
		if ($HHDEBUG)
		{
			Hyper::DEBUG(%filename @ " exists!");
			Hyper::DEBUG("exec(" @ %filename @ ")");
		}

		exec(%filename);

		for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		{
			%txt = "Hyper::ProcessArray($HyperPref::Gen" @ %i @ ");";
			eval(%txt);
		}

		echo("HyperHUD Preferences Loaded!");

		Hyper::UpdatePrefs("backup");
	}
	else
	{
		if ($HHDEBUG)
			Hyper::DEBUG(%filename @ " does not exist!");

		Hyper::DefaultPrefs("all");
		Hyper::UpdatePrefs("normal");
		echo("HyperHUD Defaults Saved!");
	}
	$HHDEBUG = $HyperPref::DEBUG;
	$HHIndent = 0;

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::LoadPrefs", -3);
}

Hyper::LoadPrefs();

function Hyper::UpdateStats(%type)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateStats(" @ %type @ ")", 3);

	if ($PCFG::Name != $Hyper::DefaultUser)
	{
		Client::centerPrint("<jc><f1>Starting User Nickname is not the same as current Nickname.\nPlease quit Tribes and run again.\nStats file will not be updated until then.", 1); 
    		schedule("Client::centerPrint(\"\", 1);", 30);
		if ($HHDEBUG)
		{
			Hyper::DEBUG("Exiting Hyper::UpdateStats", -3);
		}
		return;
	}

	%filename = "config\\HHStats-" @ Hyper::ProcessName($PCFG::Name);

	if (%type == "normal")
		%filename = %filename @ ".cs";
	else
		%filename = %filename @ ".bak";

	export("$HyperStat::*", %filename, false);

	%txt = "HyperHUD Statistics ";

	if (%type == "normal")
		%txt = %txt @ "Updated!";
	else
		%txt = %txt @ "Backup Made!";

	echo(%txt);

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%filename: " @ %filename);
		Hyper::DEBUG("export(\"$HyperStat::*\", " @ %filename @ ", false)");
		Hyper::DEBUG("Exiting Hyper::UpdateStats", -3);
	}
}

function Hyper::LoadStats()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::LoadStats()", 3);

	%filename = "HHStats-" @ Hyper::ProcessName($PCFG::Name) @ ".cs";

	if ($HHDEBUG)
		Hyper::DEBUG("%filename: " @ %filename);

	if (isFile("config\\" @ %filename))
	{
		if ($HHDEBUG)
		{
			Hyper::DEBUG(%filename @ " exists!");
			Hyper::DEBUG("Include(" @ %filename @ ")");
		}

		Include(%filename);

		echo("HyperHUD Statistics Loaded!");
		Hyper::UpdateStats("backup");
	}
	else if ($HHDEBUG)
		Hyper::DEBUG(%filename @ " does not exist!");

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::LoadStats", -3);
}

$HyperStat::TotalTime = "0 0 0";
Hyper::LoadStats();
$Hyper::StatDay = getWord($HyperStat::TotalTime, 0);
$Hyper::StatHour = getWord($HyperStat::TotalTime, 1);
$Hyper::StatMin = getWord($HyperStat::TotalTime, 2);

if ($HHDEBUG)
	Hyper::ProcessDebug();

function Hyper::AddObject(%hud, %tag, %x, %y, %width, %height)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::AddObject(" @ %hud @ ", " @ %tag @ ", " @ %x @ ", " @ %y @ ", " @ %width @ ", " @ %height @ ")", 3);
	%frame = eval("HUD::AddObject(" @ %hud @ ", SimGui::Control, " @ %x @ ", " @ %y @ ", " @ %width @ ", " @ %height @ ");");
	%line = newobject(%tag, FearGuiFormattedText, 0, 0, %width, %height);
	addToSet(%frame, Object::GetName(%line));
	if ($HHDEBUG)
	{
		Hyper::DEBUG("%frame: " @ %frame);
		Hyper::DEBUG("%line: " @ %line);
		Hyper::DEBUG("Exiting Hyper::AddObject", -3);
	}
	return %line;
}

function Hyper::GetReturnTime(%team, %client)
{
	if ((%client == 0) && ($Hyper::LastReturnClient == 0))
	{
		$Hyper::FlagTimerDefault = $Hyper::FlagTimerDefault - $Hyper::ReturnTime[%team] + 1;
		Event::Detach(eventFlagReturned, Hyper::GetReturnTime);
	}

	$Hyper::LastReturnClient = %client;
}

// ===============================================================================================
//  Function: UpdateHomeHUD
//
//  Purpose: Update our team's flag status.
//
//	Flag status updates:
//
//	- Green flag indicates our team's flag is safe at home.
//	- Grey flag with a eagle (bird) symbol indicates that the flag is currently being
//	  carried by an enemy player.  If so, a message will appear next to the flag symbol
//	  informing you who currently holds the flag.
//	- A flag with a question mark can indicate two possibilities:
//
//	  1) When you CONNECT for the first time to a server, the flag status will be unknown.
//	     Therefore, we will initially start with the ? flag.
//	  2) After a capture, the flag status will be correct.  From this point, a ? flag will
//	     indicate that the team's flag has been dropped in the field.  This is usually due
//	     to the carrier's death.
// ===============================================================================================
function Hyper::UpdateHomeHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateHomeHUD()", 3);

	if ($Hyper::homeobj != "set")
	{
		$Hyper::homeiconobj = Hyper::AddObject("hudHHCTFHome", "hhhomeicon", 2, 1, 40, 14);
		$Hyper::ctfhiconobj = Hyper::AddObject("hudHHCTFHome", "hhctfhicon", 2, 15, 40, 40);
		$Hyper::hometxtobj = Hyper::AddObject("hudHHCTFHome", "hhhometxt", 44, -2, 71, 56);
		Control::SetValue(Object::GetName($Hyper::homeiconobj), "<B0,0:HH_home.bmp>");
		$Hyper::homesmiconobj = Hyper::AddObject("hudHHCTFHomeSm", "hhhomesmicon", 2, 1, 40, 14);
		$Hyper::ctfhsmiconobj = Hyper::AddObject("hudHHCTFHomeSm", "hhctfhsmicon", 2, 15, 40, 40);
		Control::SetValue(Object::GetName($Hyper::homesmiconobj), "<B0,0:HH_home.bmp>");
		$Hyper::homeobj = "set";
	}

	%friendlyTeam = Team::Friendly();
	%teamFlag = Team::GetFlagLocation(%friendlyTeam);	// Status of our flag.

	if (%teamFlag == $Trak::locationHome)
	{
		if ($Hyper::homeicon != "safe")
		{
			Control::SetValue(Object::GetName($Hyper::ctfhsmiconobj), "<B0,0:flag_atbase.bmp>");		// Our flag is safe at home.
			$Hyper::homeicon = "safe";
		}
	}
	else if (%teamFlag == $Trak::locationField)
	{
		if ($Hyper::homeicon != "dropped")
		{
			Control::SetValue(Object::GetName($Hyper::ctfhiconobj), "<B0,0:flag_notatbase.bmp>");		// Our flag was dropped in the field.
			$Hyper::homeicon = "dropped";
		}

		if ($HyperPref::FlagReturnTime)
		{
			if ($Hyper::NewReturnTime != "set")
			{
				Event::Attach(eventFlagReturned, Hyper::GetReturnTime, hhreturntime);
				$Hyper::NewReturnTime = "set";
			}

			$Hyper::ReturnTime[%friendlyTeam] = $Hyper::FlagTimerDefault - (floor(getSimTime()) - $Hyper::FlagTimer[%friendlyTeam]);
			Control::SetValue(Object::GetName($Hyper::hometxtobj), "<f1><jc>Flag\nreturns\nin\n<f2>" @ $Hyper::ReturnTime[%friendlyTeam]);

			if ($HHDEBUG)
			{
				Hyper::DEBUG("Your flag status (%teamFlag): " @ %teamFlag);
				Hyper::DEBUG("$Hyper::FlagTimerDefault: " @ $Hyper::FlagTimerDefault);
				Hyper::DEBUG("$Hyper::FlagTimer[%friendlyTeam]: " @ $Hyper::FlagTimer[%friendlyTeam]);
				Hyper::DEBUG("Exiting Hyper::UpdateHomeHUD", -3);
			}
			return 1;
		}
		else
			Control::SetValue(Object::GetName($Hyper::hometxtobj), "<f2>" @ $Hyper::LastFlagCarrier[1 - %friendlyTeam] @ "<f1> dropped our flag!");

	}
	else if (%teamFlag == "")
	{
		if ($Hyper::homeicon != "unknown")
		{
			Control::SetValue(Object::GetName($Hyper::ctfhsmiconobj), "<B0,0:flag_notatbase.bmp>");		// Our flag was dropped in the field.
			$Hyper::homeicon = "unknown";
		}
	}
	else
	{
		if ($Hyper::homeicon != "taken")
		{
			Control::SetValue(Object::GetName($Hyper::ctfhiconobj), "<B0,0:flag_neutral.bmp>");
			$Hyper::homeicon = "taken";
		}
		Control::SetValue(Object::GetName($Hyper::hometxtobj), "<f1>ATTACK:\n<f2>" @ %teamFlag);	// Enemy has our flag!
		$Hyper::LastFlagCarrier[1 - %friendlyTeam] = %teamFlag;
	}

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Your flag status (%teamFlag): " @ %teamFlag);
		Hyper::DEBUG("$Hyper::FlagTimerDefault: " @ $Hyper::FlagTimerDefault);
		Hyper::DEBUG("$Hyper::FlagTimer[%friendlyTeam]: " @ $Hyper::FlagTimer[%friendlyTeam]);
		Hyper::DEBUG("Exiting Hyper::UpdateHomeHUD", -3);
	}

	$Hyper::FlagTimerSet[%friendlyTeam] = false;

	return 0;
}

// ===============================================================================================
//  Function: UpdateEnemyHUD
//
//  Purpose: Update enemy team's flag status.
//
//	Flag status updates:
//
//	- Red flag indicates enemy team's flag is safe at home.
//	- Grey flag with a eagle (bird) symbol indicates that the flag is currently being
//	  carried by a teammate.  If so, a message will appear next to the flag symbol informing
//	  you who currently holds the flag.  If you are carrying the flag, the text will blink
//	  in the HUD to notify you.
//	- A flag with a question mark can indicate two possibilities:
//
//	  1) When you CONNECT for the first time to a server, the flag status will be unknown.
//	     Therefore, we will initially start with the ? flag.
//	  2) After a capture, the flag status will be correct.  From this point, a ? flag will
//	     indicate that the team's flag has been dropped in the field.  This is usually due
//	     to the carrier's death.
// ===============================================================================================
function Hyper::UpdateEnemyHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateEnemyHUD()", 3);

	if ($Hyper::enemyobj != "set")
	{
		$Hyper::enemyiconobj = Hyper::AddObject("hudHHCTFEnemy", "hhenemyicon", 2, 1, 40, 14);
		$Hyper::ctfeiconobj = Hyper::AddObject("hudHHCTFEnemy", "hhctfeicon", 2, 15, 40, 40);
		$Hyper::enemytxtobj = Hyper::AddObject("hudHHCTFEnemy", "hhenemytxt", 44, -2, 71, 56);
		Control::SetValue(Object::GetName($Hyper::enemyiconobj), "<B0,0:HH_enemy.bmp>");
		$Hyper::enemysmiconobj = Hyper::AddObject("hudHHCTFEnemySm", "hhenemysmicon", 2, 1, 40, 14);
		$Hyper::ctfesmiconobj = Hyper::AddObject("hudHHCTFEnemySm", "hhctfesmicon", 2, 15, 40, 40);
		Control::SetValue(Object::GetName($Hyper::enemysmiconobj), "<B0,0:HH_enemy.bmp>");
		$Hyper::enemyobj = "set";
	}

	%enemyTeam = Team::Enemy();
	%enemyFlag = Team::GetFlagLocation(%enemyTeam);	// Status of the enemy's flag.

	if ($HHDEBUG)
		Hyper::DEBUG("Enemy's flag status (%enemyFlag): " @ enemyFlag);

	if (%enemyFlag == $Trak::locationHome)
	{
		if ($Hyper::enemyicon != "safe")
		{
			Control::SetValue(Object::GetName($Hyper::ctfesmiconobj), "<B0,0:flag_enemycaptured.bmp>");	// Enemy flag is safe at home.
			$Hyper::enemyicon = "safe";
		}
	}
	else if (%enemyFlag == $Trak::locationField)
	{
		if ($Hyper::enemyicon != "dropped")
		{
			Control::SetValue(Object::GetName($Hyper::ctfeiconobj), "<B0,0:flag_notatbase.bmp>");	// Enemy flag was dropped in the field.
			$Hyper::enemyicon = "dropped";
		}

		if ($HyperPref::FlagReturnTime)
		{
			if ($Hyper::NewReturnTime != "set")
			{
				Event::Attach(eventFlagReturned, Hyper::GetReturnTime, hhreturntime);
				$Hyper::NewReturnTime = "set";
			}

			$Hyper::ReturnTime[%enemyTeam] = $Hyper::FlagTimerDefault - (floor(getSimTime()) - $Hyper::FlagTimer[%enemyTeam]);
			Control::SetValue(Object::GetName($Hyper::enemytxtobj), "<f1><jc>Flag\nreturns\nin\n<f2>" @ $Hyper::ReturnTime[%enemyTeam]);

			if ($HHDEBUG)
			{
				Hyper::DEBUG("Enemy flag status (%enemyFlag): " @ %enemyFlag);
				Hyper::DEBUG("$Hyper::FlagTimerDefault: " @ $Hyper::FlagTimerDefault);
				Hyper::DEBUG("$Hyper::FlagTimer[%enemyTeam]: " @ $Hyper::FlagTimer[%enemyTeam]);
				Hyper::DEBUG("Exiting Hyper::UpdateEnemyHUD", -3);
			}
			return 1;
		}
		else
			Control::SetValue(Object::GetName($Hyper::enemytxtobj), "<f2>" @ $Hyper::LastFlagCarrier[1 - %enemyTeam] @ "<f1> dropped the flag!");
	}
	else if (%enemyFlag == "")
	{
		if ($Hyper::enemyicon != "unknown")
		{
			Control::SetValue(Object::GetName($Hyper::ctfesmiconobj), "<B0,0:flag_notatbase.bmp>");	// Enemy flag was dropped in the field.
			$Hyper::enemyicon = "unknown";
		}
	}
	else
	{
		$Hyper::FlagTimerSet[%enemyTeam] = false;
		if ($Hyper::enemyicon != "taken")
		{
			Control::SetValue(Object::GetName($Hyper::ctfeiconobj), "<B0,0:flag_neutral.bmp>");
			$Hyper::enemyicon = "taken";
		}
		$Hyper::LastFlagCarrier[1 - %enemyTeam] = %enemyFlag;

		if (%enemyFlag == client::getname(getManagerId()))
		{
			if ($Hyper::BlinkToggle == 0)
			{
				Control::SetValue(Object::GetName($Hyper::enemytxtobj), "<f2>YOU <f1>have\nthe enemy\nflag!");	// YOU are carrying the enemy flag.
				$Hyper::BlinkToggle++;
			}
			else
			{
				Control::SetValue(Object::GetName($Hyper::enemytxtobj), "");	// Blink the text off in the HUD.
				$Hyper::BlinkToggle = 0;
			}

			if ($HHDEBUG)
			{
				Hyper::DEBUG("Enemy flag status (%enemyFlag): " @ %enemyFlag);
				Hyper::DEBUG("$Hyper::FlagTimerDefault: " @ $Hyper::FlagTimerDefault);
				Hyper::DEBUG("$Hyper::FlagTimer[%enemyTeam]: " @ $Hyper::FlagTimer[%enemyTeam]);
				Hyper::DEBUG("Exiting Hyper::UpdateEnemyHUD", -3);
			}
			return 1;	// If you are carrying the flag, schedule an update in one second so we can blink the text.
		}
		else
			Control::SetValue(Object::GetName($Hyper::enemytxtobj), "<f1>ESCORT:\n<f2>" @ %enemyFlag);	// A teammate has the enemy flag.
	}

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Enemy flag status (%enemyFlag): " @ %enemyFlag);
		Hyper::DEBUG("$Hyper::FlagTimerDefault: " @ $Hyper::FlagTimerDefault);
		Hyper::DEBUG("$Hyper::FlagTimer[%enemyTeam]: " @ $Hyper::FlagTimer[%enemyTeam]);
		Hyper::DEBUG("Exiting Hyper::UpdateEnemyHUD", -3);
	}

	$Hyper::FlagTimerSet[%enemyTeam] = false;

	return 0;
}

// ===============================================================================================
//  Function: UpdateCapsHUD
//
//  Purpose: Update how many times your team, the enemy team and you personally have captured the
//	   flag.  The HUD will have a small TRIBES-like flag with a "C" in it.  There are two
//	   different displays available, depending on which HUD screen you have chosen by
//	   hitting "Control-H".
//
//	   CTF HUD screen - Your team's flag capture total will be displayed to the left of the
//	   icon and the enemy flag capture total will be on the right of the icon.  If your team
//	   has no captures yet, then the icon will be left justified.  If there are no enemy
//	   captures yet, the right will be left blank.  Upon a flag capture by YOU, the HUD will
//	   blink (alternate) between the normal display and a display just showing how many
//	   times you have captured the enemy flag personally so far.
//
//	   Multiple Team HUD screen - Your personal flag capture count will be displayed on the
//	   left side of the icon and your team's total flag capture amount is on the right side.
//	   If you have no personal captures, the icon will be left justified.  If your team has
//	   no captures, it will be left blank to the right of the icon.
//
//	   NOTE: The flag capture HUD display will be turned off automatically if you choose the
//	   General Gameplay HUD screen.  If you're not going to show the flag status, no sense
//	   in showing your captures. :)
// ===============================================================================================
function Hyper::UpdateCapsHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateCapsHUD()", 3);

	%myteam = Client::getTeam(getManagerId());	// Get which team I'm on.
	%mycaps = $Hyper::MyCaps[%myteam];		// Get how many captures I have so far.
	%teamcaps = $Hyper::caps[%myteam];		// Get how many captures my team has.
	%enemycaps = $Hyper::caps[1 - %myteam];		// Get how many captures the enemy team has.

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Your team (%myteam): " @ %myteam);
		Hyper::DEBUG("Your flag captures (%mycaps): " @ %mycaps);
		Hyper::DEBUG("Team flag captures (%teamcaps): " @ %teamcaps);
		Hyper::DEBUG("Enemy flag captures (%enemycaps): " @ %enemycaps);
	}

	if ($Hyper::capobj != "set")
	{
		$Hyper::capiconobj = Hyper::AddObject("hudHHCaps", "hhcapicon", 21, 1, 18, 18);
		$Hyper::captxtobj_0 = Hyper::AddObject("hudHHCaps", "hhcaptxt_0", 5, 1, 13, 18);
		$Hyper::captxtobj_1 = Hyper::AddObject("hudHHCaps", "hhcaptxt_1", 42, 1, 13, 18);
		$Hyper::captxtobj_2 = Hyper::AddObject("hudHHCaps", "hhcaptxt_2", 24, 1, 13, 18);
		$Hyper::capobj = "set";
	}

	if ($Hyper::YouCapped)	// If you captured the flag, then let's blink the flag capture HUD.
	{
		if ($HHDEBUG)
			Hyper::DEBUG("You captured the enemy flag!");

		if ($Hyper::capBlinkCnt++ > 11)
		{
			$Hyper::capBlinkCnt = 0;
			$Hyper::capBlink = 0;
			$Hyper::YouCapped = false;
		}

		if ($Hyper::capBlink == 1)	// Show your capture count every other second.
		{
			Control::SetValue(Object::GetName($Hyper::capiconobj), "");
			$Hyper::capicon = "";
			Control::SetValue(Object::GetName($Hyper::captxtobj_2), "<f1><jc>" @ %mycaps);

			$Hyper::capBlink = 0;

			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::UpdateCapsHUD", -3);

			return 1;
		}
	}

	if ($HHDEBUG)
		Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);

	for (%i = 0; %i < 3; %i++)
		eval("Control::SetValue(Object::GetName($Hyper::captxtobj_" @ %i @ "), \"\");");

	if (($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen"))
	{
		if (%teamcaps > 0)
			Control::SetValue(Object::GetName($Hyper::captxtobj_0), "<f2><jc>" @ %teamcaps);
	}
	else if (%mycaps > 0)
			Control::SetValue(Object::GetName($Hyper::captxtobj_0), "<f1><jc>" @ %mycaps);

	if (((($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen")) && ((%teamcaps > 0) || (%enemycaps > 0))) ||
	    (($Hyper::Mode == "MT") && ((%mycaps >0) || (%teamcaps > 0))))
	{
		if ($Hyper::capicon != "caps")
		{
			Control::SetValue(Object::GetName($Hyper::capiconobj), "<B0,0:HH_cap.bmp>");
			$Hyper::capicon = "caps";
		}
	}
	else
	{
		if ($Hyper::capicon != "nocaps")
		{
			Control::SetValue(Object::GetName($Hyper::capiconobj), "<B0,0:HH_nocap.bmp>");
			$Hyper::capicon = "nocaps";
		}
	}

	if (($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen"))
	{
		if (%enemycaps > 0)
			Control::SetValue(Object::GetName($Hyper::captxtobj_1), "<f0><jc>" @ %enemycaps);
	}
	else if (%teamcaps > 0)
			Control::SetValue(Object::GetName($Hyper::captxtobj_1), "<f2><jc>" @ %teamcaps);

	if ($HyperPref::ShowTC)
	{
		if ($HHDEBUG)
			Hyper::DEBUG("TOTAL flag captures so far ($HyperStat::TotalCaps): " @ $HyperStat::TotalCaps);

		if ($Hyper::tcobj != "set")
		{
			$Hyper::tciconobj = Hyper::AddObject("hudHHCaps", "hhtcicon", 2, 21, 15, 15);
			$Hyper::tctxtobj = Hyper::AddObject("hudHHCaps", "hhtctxt", 20, 19, 34, 15);
			$Hyper::tcobj = "set";
		}

		if ($HyperStat::TotalCaps > 0)
		{
			if ($Hyper::tcicon != "totcaps")
			{
				Control::SetValue(Object::GetName($Hyper::tciconobj), "<B0,0:HH_totcaps.bmp>");
				$Hyper::tcicon = "totcaps";
			}
			Control::SetValue(Object::GetName($Hyper::tctxtobj), "<f1><jc>" @ $HyperStat::TotalCaps);
		}
		else if ($Hyper::tcicon != "nototcaps")
		{
			Control::SetValue(Object::GetName($Hyper::tciconobj), "<B0,0:HH_nototcaps.bmp>");
			Control::SetValue(Object::GetName($Hyper::tctxtobj), "");
			$Hyper::tcicon = "nototcaps";
		}
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateCapsHUD", -3);

	if ($Hyper::YouCapped)	// Set our blink toggle for our next call to this function.
	{
		$Hyper::capBlink = 1;
		return 1;
	}
	else
		return 0;
}

// ===============================================================================================
//  Function: UpdateKillsHUD
//
//  Purpose: Update our verified kills.  This HUD will show a SKULL & CROSSBONES icon.  To the
//	   right will be shown the amount of kills you have so far.  If you don't have any, then
//	   the number will be left blank.
// ===============================================================================================
function Hyper::UpdateKillsHUD()
{
	if ($HHDEBUG)
	{
		Hyper::DEBUG("Hyper::UpdateKillsHUD()", 3);
		Hyper::DEBUG("Kills for this game ($Hyper::Kills): " @ $Hyper::Kills);
	}

	if ($Hyper::killobj != "set")
	{
		$Hyper::killiconobj = Hyper::AddObject("hudHHKills", "hhkillicon", 2, 1, 24, 18);
		$Hyper::killtxtobj = Hyper::AddObject("hudHHKills", "hhkilltxt", 31, 1, 20, 18);
		$Hyper::killobj = "set";
	}

	if ($Hyper::Kills > 0)
	{
		if ($Hyper::killicon != "kills")
		{
			Control::SetValue(Object::GetName($Hyper::killiconobj), "<B0,0:HH_kills.bmp>");
			$Hyper::killicon = "kills";
		}
		Control::SetValue(Object::GetName($Hyper::killtxtobj), "<f2><jc>" @ $Hyper::Kills);
	}
	else if ($Hyper::killicon != "nokills")
	{
		Control::SetValue(Object::GetName($Hyper::killiconobj), "<B0,0:HH_nokills.bmp>");
		Control::SetValue(Object::GetName($Hyper::killtxtobj), "");
		$Hyper::killicon = "nokills";
	}

	if ($HyperPref::ShowTK)
	{
		if ($HHDEBUG)
			Hyper::DEBUG("TOTAL kills so far ($HyperStat::TotalKills): " @ $HyperStat::TotalKills);

		if ($Hyper::tkobj != "set")
		{
			$Hyper::tkiconobj = Hyper::AddObject("hudHHKills", "hhtkicon", 2, 21, 15, 15);
			$Hyper::tktxtobj = Hyper::AddObject("hudHHKills", "hhtktxt", 20, 19, 34, 15);
			$Hyper::tkobj = "set";
		}

		if ($HyperStat::TotalKills > 0)
		{
			if ($Hyper::tkicon != "totkills")
			{
				Control::SetValue(Object::GetName($Hyper::tkiconobj), "<B0,0:HH_totkills.bmp>");
				$Hyper::tkicon = "totkills";
			}
			Control::SetValue(Object::GetName($Hyper::tktxtobj), "<f1><jc>" @ $HyperStat::TotalKills);
		}
		else if ($Hyper::tkicon != "nototkills")
		{
			Control::SetValue(Object::GetName($Hyper::tkiconobj), "<B0,0:HH_nototkills.bmp>");
			Control::SetValue(Object::GetName($Hyper::tktxtobj), "");
			$Hyper::tkicon = "nototkills";
		}
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateKillsHUD", -3);

	return 0;
}

// ===============================================================================================
//  Function: UpdateDeathsHUD
//
//  Purpose: Update how many times we have been killed. :(  This HUD will have a CROSS icon along
//	   with how many times you have been killed.  If there are no deaths, then the number
//	   will be left blank.
// ===============================================================================================
function Hyper::UpdateDeathsHUD()
{
	if ($HHDEBUG)
	{
		Hyper::DEBUG("Hyper::UpdateDeathsHUD()", 3);
		Hyper::DEBUG("Deaths for this game ($Hyper::Deaths): " @ $Hyper::Deaths);
	}

	if ($Hyper::deathobj != "set")
	{
		$Hyper::deathiconobj = Hyper::AddObject("hudHHDeaths", "hhdeathicon", 2, 1, 24, 18);
		$Hyper::deathtxtobj = Hyper::AddObject("hudHHDeaths", "hhdeathtxt", 31, 1, 20, 18);
		$Hyper::deathobj = "set";
	}

	if ($Hyper::Deaths > 0)
	{
		if ($Hyper::deathicon != "deaths")
		{
			Control::SetValue(Object::GetName($Hyper::deathiconobj), "<B0,0:HH_deaths.bmp>");
			$Hyper::deathicon = "deaths";
		}
		Control::SetValue(Object::GetName($Hyper::deathtxtobj), "<f2><jc>" @ $Hyper::Deaths);
	}
	else if ($Hyper::deathicon != "nodeaths")
	{
		Control::SetValue(Object::GetName($Hyper::deathiconobj), "<B0,0:HH_nodeaths.bmp>");
		Control::SetValue(Object::GetName($Hyper::deathtxtobj), "");
		$Hyper::deathicon = "nodeaths";
	}

	if ($HyperPref::ShowTD)
	{
		if ($HHDEBUG)
			Hyper::DEBUG("TOTAL deaths so far ($HyperStat::TotalDeaths): " @ $HyperStat::TotalDeaths);

		if ($Hyper::tdobj != "set")
		{
			$Hyper::tdiconobj = Hyper::AddObject("hudHHDeaths", "hhtdicon", 2, 21, 15, 15);
			$Hyper::tdtxtobj = Hyper::AddObject("hudHHDeaths", "hhtdtxt", 20, 19, 34, 15);
			$Hyper::tdobj = "set";
		}

		if ($HyperStat::TotalDeaths > 0)
		{
			if ($Hyper::tdicon != "totdeaths")
			{
				Control::SetValue(Object::GetName($Hyper::tdiconobj), "<B0,0:HH_totdeaths.bmp>");
				$Hyper::tdicon = "totdeaths";
			}
			Control::SetValue(Object::GetName($Hyper::tdtxtobj), "<f1><jc>" @ $HyperStat::TotalDeaths);
		}
		else if ($Hyper::tdicon != "nototdeaths")
		{
			Control::SetValue(Object::GetName($Hyper::tdiconobj), "<B0,0:HH_nototdeaths.bmp>");
			Control::SetValue(Object::GetName($Hyper::tdtxtobj), "");
			$Hyper::tdicon = "nototdeaths";
		}
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateDeathsHUD", -3);

	return 0;
}

// ===============================================================================================
//  Function: UpdateMinesHUD
//
//  Purpose: Update how many mines we have.  This HUD will have a MINE icon along with how many
//	   mines we have.  If there are no mines, then the number will be left blank.
// ===============================================================================================
function Hyper::UpdateMinesHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateMinesHUD()", 3);

	%mines = getItemCount("Mine");

	if ($HHDEBUG)
		Hyper::DEBUG("You have " @ %mines @ " (%mines) mines.");

	if ($Hyper::mineobj != "set")
	{
		$Hyper::mineiconobj = Hyper::AddObject("hudHHMines", "hhmineicon", 2, 1, 24, 18);
		$Hyper::minetxtobj = Hyper::AddObject("hudHHMines", "hhminetxt", 31, 1, 20, 18);
		$Hyper::mineobj = "set";
	}

	if (%mines > 0)
	{
		if ($Hyper::mineicon != "mines")
		{
			Control::SetValue(Object::GetName($Hyper::mineiconobj), "<B0,0:HH_mine.bmp>");
			$Hyper::mineicon = "mines";
		}
		Control::SetValue(Object::GetName($Hyper::minetxtobj), "<f2><jc>" @ %mines);
	}
	else if ($Hyper::mineicon != "nomines")
	{
		Control::SetValue(Object::GetName($Hyper::mineiconobj), "<B0,0:HH_nomine.bmp>");
		Control::SetValue(Object::GetName($Hyper::minetxtobj), "");
		$Hyper::mineicon = "nomines";
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateMinesHUD", -3);

	return 0;
}

// ===============================================================================================
//  Function: UpdateGrenadesHUD
//
//  Purpose: Update how many grenades we have.  This HUD will have a GRENADE icon along with how
//	   many grenades we have.  If there are no mines, then the number will be left blank.
// ===============================================================================================
function Hyper::UpdateGrenadesHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateGrenadesHUD()", 3);

	%grenades = getItemCount("Grenade");

	if ($HHDEBUG)
		Hyper::DEBUG("You have " @ %grenades @ " (%grenades) grenades.");

	if ($Hyper::grenobj != "set")
	{
		$Hyper::greniconobj = Hyper::AddObject("hudHHGrenades", "hhgrenicon", 2, 1, 24, 18);
		$Hyper::grentxtobj = Hyper::AddObject("hudHHGrenades", "hhgrentxt", 31, 1, 20, 18);
		$Hyper::grenobj = "set";
	}

	if (%grenades > 0)
	{
		if ($Hyper::grenicon != "grenades")
		{
			Control::SetValue(Object::GetName($Hyper::greniconobj), "<B0,0:HH_grenade.bmp>");
			$Hyper::grenicon = "grenades";
		}
		Control::SetValue(Object::GetName($Hyper::grentxtobj), "<f2><jc>" @ %grenades);
	}
	else if ($Hyper::grenicon != "nogrenades")
	{
		Control::SetValue(Object::GetName($Hyper::greniconobj), "<B0,0:HH_nogrenade.bmp>");
		Control::SetValue(Object::GetName($Hyper::grentxtobj), "");
		$Hyper::grenicon = "nogrenades";
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateGrenadesHUD", -3);

	return 0;
}

// ===============================================================================================
//  Function: UpdateRepairHUD
//
//  Purpose: Update inventory of a repair kit and beacons.  This HUD will show a REPAIR icon if
//	   you currently have a repair kit.  A BEACON icon will be shown if you have a beacon.
//	   If you do not have the item, then the HUD will be blank.
// ===============================================================================================
function Hyper::UpdateRepairHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateRepairHUD()", 3);

	if ($Hyper::repairobj != "set")
	{
		$Hyper::repairiconobj = Hyper::AddObject("hudHHRepair", "hhrepairicon", 18, 1, 24, 18);
		$Hyper::repairobj = "set";
	}

	if (getItemCount("Repair Kit") > 0)
	{
		if ($Hyper::repairicon != "repair")
		{
			Control::SetValue(Object::GetName($Hyper::repairiconobj), "<B0,0:HH_repair.bmp>");
			$Hyper::repairicon = "repair";
		}
		if ($HHDEBUG)
			Hyper::DEBUG("You have a Repair Kit.");
	}
	else
	{
		if ($Hyper::repairicon != "norepair")
		{
			Control::SetValue(Object::GetName($Hyper::repairiconobj), "<B0,0:HH_norepair.bmp>");
			$Hyper::repairicon = "norepair";
		}
		if ($HHDEBUG)
			Hyper::DEBUG("You do not have a Repair Kit.");
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateRepairHUD", -3);

	return 0;
}

function Hyper::UpdateBeaconHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateBeaconHUD()", 3);

	%beacons = getItemCount("Beacon");

	if ($HHDEBUG)
		Hyper::DEBUG("You have " @ %beacons @ " (%beacons) beacons.");

	if ($Hyper::beaconobj != "set")
	{
		$Hyper::beaconiconobj = Hyper::AddObject("hudHHBeacon", "hhbeaconicon", 2, 1, 24, 18);
		$Hyper::beacontxtobj = Hyper::AddObject("hudHHBeacon", "hhbeacontxt", 31, 1, 20, 18);
		$Hyper::beaconobj = "set";
	}

	if (%beacons > 0)
	{
		if ($Hyper::beaconicon != "beacons")
		{
			Control::SetValue(Object::GetName($Hyper::beaconiconobj), "<B0,0:HH_beacon.bmp>");
			$Hyper::beaconicon = "beacons";
		}
		Control::SetValue(Object::GetName($Hyper::beacontxtobj), "<f2><jc>" @ %beacons);
	}
	else if ($Hyper::beaconicon != "nobeacons")
	{
		Control::SetValue(Object::GetName($Hyper::beaconiconobj), "<B0,0:HH_nobeacon.bmp>");
		Control::SetValue(Object::GetName($Hyper::beacontxtobj), "");
		$Hyper::beaconicon = "nobeacons";
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateBeaconHUD", -3);

	return 0;
}

function Hyper::GetHUDInfo(%hudtype, %retrieve)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::GetHUDInfo(" @ %hudtype @ ", " @ %retrieve @ ")", 3);

	if (%retrieve == "label")
		%return = "hudHH" @ %hudtype;
	else if (%retrieve == "func")
		%return = "Hyper::Update" @ %hudtype @ "HUD";
	else
		%return = "";

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Function Return (%return): " @ %return);
		Hyper::DEBUG("Exiting Hyper::GetHUDInfo", -3);
	}

	return %return;
}

// DO NOT MODIFY THESE THREE LINES!!!
// They are used in the UpdatePlayersHUD function below for team unbalance notification.
$Hyper::comSay[0] = "color2";	// Yell Shazbot!
$Hyper::comSay[1] = "color6";	// Yell Dammit!
$Hyper::comSay[2] = "color7";	// Yell Ahhh crap!

// ===============================================================================================
//  Function: UpdatePlayersHUD
//
//  Purpose: Check how many players are on each team.  In the center of the HUD, you will see an
//	   icon with a green arrow on the left and a red arrow on the right.  The number of
//	   players on your team will appear on the left (green arrow pointing to your team) and
//	   the enemy player count will appear on the right (red arrow pointing to enemy team).
//	   If there are no players on a team, then it will be left blank.  Also added a team
//	   unbalance notification routine.  Everyone will be sent the phrase "Teams are
//	   unbalanced!!!" when a team is outnumbered along with a random colorful verbal remark.
//	   Also, upon switching to observer mode, the number of currect observers will be shown
//	   to the left of the green arrow and the number of ACTIVE players will be shown to the
//	   right of the red arrow.
// ===============================================================================================
function Hyper::UpdatePlayersHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdatePlayersHUD()", 3);

	%clientteam = Client::getTeam(getManagerId());	// Find out which team you are on.

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Your team: " @ %clientteam);
		Hyper::DEBUG("Last Client ($Hyper::LastClient): " @ $Hyper::LastClient);
	}

	for (%i = -1; %i < 4; %i++)
		%players[%i] = 0;

	for (%i = $Hyper::LastClient; %i > 2048; %i--)	// Check all valid players up to the last known client.
	{
		%team = Client::getTeam(%i);		// Find out which team this player is on.

		if (Client::getName(%i) != "")	// Is it a valid player?
		{
			%players[%team]++;	// Increment our player count for each team.
			if ($HHDEBUG)
				Hyper::DEBUG("Client " @ %i @ " (%i) is on team " @ %team @ " (%team).");
		}
	}

	%teams = 0;
	for (%i = 0; %i < 4; %i++)
		if (%players[%i] > 0)
			%teams++;

	if (%teams > 2)
		$Hyper::mt = true;
	else
		$Hyper::mt = false;

	if (($HyperPref::ShowObserver && $Hyper::mt && (HUD::Height(hudHHPlayers) != 58)) ||
	    (!$HyperPref::ShowObserver && $Hyper::mt && (HUD::Height(hudHHPlayers) != 38)) ||
	    ($HyperPref::ShowObserver && !$Hyper::mt && (HUD::Height(hudHHPlayers) != 40)) ||
	    (!$HyperPref::ShowObserver && !$Hyper::mt && (HUD::Height(hudHHPlayers) != 20)))
		eval("Hyper::MakeNewHUDs(false, \"gen\", HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 0), HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 1));");

	if ($Hyper::playobj != "set")
	{
		$Hyper::playiconobj = Hyper::AddObject("hudHHPlayers", "hhplayicon", 21, 1, 18, 18);
		$Hyper::playtxtobj_0 = Hyper::AddObject("hudHHPlayers", "hhplaytxt_0", 5, 1, 13, 18);
		$Hyper::playtxtobj_1 = Hyper::AddObject("hudHHPlayers", "hhplaytxt_1", 42, 1, 13, 18);
		$Hyper::playobj = "set";
	}

	if ($Hyper::mt)
	{
		if ($Hyper::mtobj != "set")
		{
			$Hyper::mticonobj = Hyper::AddObject("hudHHPlayers", "hhmticon", 21, 19, 18, 18);
			$Hyper::mttxtobj_0 = Hyper::AddObject("hudHHPlayers", "hhmttxt_0", 5, 19, 13, 18);
			$Hyper::mttxtobj_1 = Hyper::AddObject("hudHHPlayers", "hhmttxt_1", 42, 19, 13, 18);
			$Hyper::mtobj = "set";
		}
	}

	if ($HHDEBUG)
	{
		for (%i = 0; %i < 4; %i++)
			if (%players[%i] > 0)
				Hyper::DEBUG("Team " @ %i @ " (%i) has " @ %players[%i] @ " (%players[%i]) players.");

		Hyper::DEBUG("Team players (%teamplayers): " @ %teamplayers);
		Hyper::DEBUG("Enemy players (%enemyplayers): " @ %enemyplayers);
	}

	if (!$Hyper::mt)
	{
		$Hyper::mticon = "";
		Control::SetValue(Object::GetName($Hyper::mticonobj), "");
		Control::SetValue(Object::GetName($Hyper::mttxtobj_0), "");
		Control::SetValue(Object::GetName($Hyper::mttxtobj_1), "");
		if (%clientteam != -1)
		{
			if ($Hyper::playicon != "players")
			{
				Control::SetValue(Object::GetName($Hyper::playiconobj), "<B0,0:HH_players.bmp>");
				$Hyper::playicon = "players";
			}
			%teamplayers = %players[%clientteam];
			for (%i = 0; %i < 4; %i++)
			{
				if ((%players[%i] > 0) && (%i != %clientteam))
				{
					%enemyplayers = %players[%i];
					%i = 4;
				}
			}
		}
		else
		{
			if ($Hyper::playicon != "noteam")
			{
				Control::SetValue(Object::GetName($Hyper::playiconobj), "<B0,0:HH_noteam.bmp>");
				$Hyper::playicon = "noteam";
			}
			%j = 0;
			for (%i = 0; %i < 4; %i++)
			{
				if (%players[%i] > 0)
					if (%j == 0)
					{
						%teamplayers = %players[%i];
						%j++;
					}
					else
						%enemyplayers = %players[%i];
			}
		}

		%txt = "";
		if (%teamplayers > 0)
		{
			if (%clientteam != -1)
				%txt = "<f2>";
			else
				%txt = "<f0>";
			%txt = "<jc>" @ %txt @ %teamplayers;
		}
		Control::SetValue(Object::GetName($Hyper::playtxtobj_0), %txt);
		%txt = "";
		if (%enemyplayers > 0)
			%txt = "<f0><jc>" @ %enemyplayers;
		Control::SetValue(Object::GetName($Hyper::playtxtobj_1), %txt);
	}
	else
	{
		$Hyper::playicon = "";
		if (%clientteam != -1)
		{
			if ($Hyper::mticon != "players")
			{
				Control::SetValue(Object::GetName($Hyper::playiconobj), "<B0,0:HH_players1-2.bmp>");
				Control::SetValue(Object::GetName($Hyper::mticonobj), "<B0,0:HH_players3-4.bmp>");
				$Hyper::mticon = "players";
			}
		}
		else
		{
			if ($Hyper::mticon != "noteam")
			{
				Control::SetValue(Object::GetName($Hyper::playiconobj), "<B0,0:HH_noteam1-2.bmp>");
				Control::SetValue(Object::GetName($Hyper::mticonobj), "<B0,0:HH_noteam3-4.bmp>");
				$Hyper::mticon = "noteam";
			}
		}

		for (%i = 0; %i < 4; %i++)
		{
			%txt = "";
			if (%players[%i] > 0)
			{
				if (%i == %clientteam)
					%txt = "<f2>";
				else
					%txt = "<f0>";
				%txt = "<jc>" @ %txt @ %players[%i];
			}
			if (%i < 2)
				%tag = "$Hyper::playtxtobj_" @ %i;
			else
				%tag = "$Hyper::mttxtobj_" @ (%i - 2);
			eval("Control::SetValue(Object::GetName(" @ %tag @ "), %txt);");
		}
	}

	if (($HyperPref::BalanceNotify) && !$Hyper::mt)	// Do you want to notify everyone when there is team unbalance?
	{
		%balance = %teamplayers - %enemyplayers;	// Determine by how many players teams are unbalanced.

		if ($HHDEBUG)
			Hyper::DEBUG("Team balance difference (%balance): " @ %balance);

		if ((%balance != 0) && (%clientteam != -1))
		{
			if (%balance < 0)
				%balance = -(%balance);	// If it is a negative number, let's make it positive.

			if ((%balance >= $HyperPref::Outnumber) && ($Hyper::BalanceToggle == 0) &&
			    ($Hyper::LastMsg != "Teams are unbalanced!!!") &&
			    ($Hyper::Next2LastMsg != "Teams are unbalanced!!!"))
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("$HyperPref::Outnumber: " @ $HyperPref::Outnumber);
					Hyper::DEBUG("Teams are unbalanced!");
				}
				remoteEval(2048, say, 0, "Teams are unbalanced!!!~w" @ $Hyper::comSay[floor(getRandom() * 3)]);	// Tell everyone about team unbalance and yell a random remark.
				$Hyper::BalanceToggle = 1;	// Toggle our team balance variable so we don't say this repeatedly.
			}
			else if (%balance < 3)
				$Hyper::BalanceToggle = 0;	// If team unbalance drops below three, then reset our variable, so we can say it the next time there is team unbalance.
		}
	}

	if ($HyperPref::ShowObserver)
	{
		if ($HHDEBUG)
			Hyper::DEBUG("There are " @ %players[-1] @ " (%players[-1]) observers.");

		if ($Hyper::obsvobj != "set")
		{
			$Hyper::obsviconobj[0] = Hyper::AddObject("hudHHPlayers", "hhobsvicon_0", 2, 21, 24, 18);
			$Hyper::obsvtxtobj[0] = Hyper::AddObject("hudHHPlayers", "hhobsvtxt_0", 31, 21, 20, 18);
			$Hyper::obsviconobj[1] = Hyper::AddObject("hudHHPlayers", "hhobsvicon_1", 2, 39, 24, 18);
			$Hyper::obsvtxtobj[1] = Hyper::AddObject("hudHHPlayers", "hhobsvtxt_1", 31, 39, 20, 18);
			$Hyper::obsvobj = "set";
		}

		if ($Hyper::mt)
			%i = 1;
		else
			%i = 0;

		Control::SetValue(Object::GetName($Hyper::obsviconobj[1 - %i]), "");
		Control::SetValue(Object::GetName($Hyper::obsvtxtobj[1 - %i]), "");

		if (%players[-1] > 0)
		{
			Control::SetValue(Object::GetName($Hyper::obsviconobj[%i]), "<B0,0:HH_observer.bmp>");
			Control::SetValue(Object::GetName($Hyper::obsvtxtobj[%i]), "<f1><jc>" @ %players[-1]);
		}
		else
		{
			Control::SetValue(Object::GetName($Hyper::obsviconobj[%i]), "<B0,0:HH_noobserver.bmp>");
			Control::SetValue(Object::GetName($Hyper::obsvtxtobj[%i]), "");
		}
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdatePlayersHUD", -3);

	return 0;
}

// ===============================================================================================
//  Function: UpdatePlayTimeHUD
//
//  Purpose: Update how long you have been playing online so far for this session.  
// ===============================================================================================
function Hyper::UpdatePlayTimeHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdatePlayTimeHUD()", 3);

	if ($Hyper::timeobj != "set")
	{
		$Hyper::timetxtobj_0 = Hyper::AddObject("hudHHPlayTime", "hhtimetxt_0", 2, -4, 57, 14);
		$Hyper::timetxtobj_1 = Hyper::AddObject("hudHHPlayTime", "hhtimetxt_1", 2, 7, 57, 14);
		$Hyper::timetxtobj_2 = Hyper::AddObject("hudHHPlayTime", "hhtimetxt_2", 2, 18, 57, 14);
		$Hyper::timeobj = "set";
	}

	%time = "";
	if ($Hyper::TimeHour > 0)
		%time = $Hyper::TimeHour;
	%time = %time @ ":";
	if ($Hyper::TimeMin < 10)
		%time = %time @ "0";
	%time = %time @ $Hyper::TimeMin;

	Control::SetValue(Object::GetName($Hyper::timetxtobj_0), "<f2><jc>" @ %time);

	if ($HHDEBUG)
		Hyper::DEBUG("Current play time - Hours ($Hyper::TimeHour): " @ $Hyper::TimeHour @ "  Minutes ($Hyper::TimeMin): " @ $Hyper::TimeMin);

	if ($HyperPref::ShowTT)
	{
		%time = "";
		if ($Hyper::StatDay > 0)
		{
			%time = $Hyper::StatDay;
			if (String::len($Hyper::StatDay) < 6)
				%time = %time @ " <f0>D";
			Control::SetValue(Object::GetName($Hyper::timetxtobj_1), "<f1><jc>" @ %time);
			%tag = "2";
		}
		else
		{
			%tag = "1";
		}
		%height = HUD::Height(hudHHPlayTime);
		if ((($Hyper::StatDay > 0) && (%height != 34)) ||
		    (($Hyper::StatDay == 0) && (%height != 23)))
			eval("Hyper::MakeNewHUDs(false, \"gen\", HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 0), HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 1));");
		%time = "";
		if ($Hyper::StatHour > 0)
			%time = $Hyper::StatHour;
		%time = %time @ ":";
		if ($Hyper::StatMin < 10)
			%time = %time @ "0";
		%time = %time @ $Hyper::StatMin;
		eval("Control::SetValue(Object::GetName($Hyper::timetxtobj_" @ %tag @ "), \"<f1><jc>\" @ %time);");

		if ($HHDEBUG)
			Hyper::DEBUG("TOTAL Time - Days ($Hyper::StatDay): " @ $Hyper::StatDay @ "  Hours ($Hyper::StatHour): " @ $Hyper::StatHour @ "  Minutes ($Hyper::StatMin): " @ $Hyper::StatMin);
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdatePlayTimeHUD", -3);

	return 0;
}

function Hyper::UpdatePackHUD()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdatePackHUD()", 3);

	HUD::AddText(hudPack, "<B0,1:HH_pack.bmp> " @ $Inv::Name[getMountedItem(1)] @ "<jr><B7,1:HH_pack.bmp>");

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Backpack Item #: " @ getMountedItem(1) @ "  Backpack Name ($Inv::Name[getMountedItem(1)]): " @ $Inv::Name[getMountedItem(1)]);
		Hyper::DEBUG("Exiting Hyper::UpdatePackHUD", -3);
	}

	return 0;
}

function Hyper::UpdateBackpack()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateBackpack()", 3);

	%pack = getMountedItem(1);
	%item = $Inv::Name[%pack];

	if ($HHDEBUG)
		Hyper::DEBUG("Backpack Item # (%pack): " @ %pack @ "  Backpack Name (%item): " @ %item);

	if ((%pack != -1) && (%item != ""))
	{
		if ($Hyper::NewPackPos != "")
		{
			%x = getWord($Hyper::NewPackPos, 0);
			%y = getWord($Hyper::NewPackPos, 1);
		}
		else
		{
			%x = getWord($HyperPref::PackPos, 0);
			%y = getWord($HyperPref::PackPos, 1);
		}

		HUD::Move(hudPack, %x, %y, String::pixels(%item) + 67, 18);

		if ($HHDEBUG)
			Hyper::DEBUG("HUD::Move(hudPack, " @ %x @ ", " @ %y @ ", " @ (String::pixels(%item) + 67) @ ", 18)");

		if (!(HUD::GetDisplayed(hudPack)))
			HUD::Display(hudPack);
		HUD::Update(hudPack);
	}
	else if (HUD::GetDisplayed(hudPack))
		HUD::Display(hudPack, false);

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateBackpack", -3);
}

// ===============================================================================================
//  Function: UpdateItemHUDs
//
//  Purpose: Here we update our mines, grenades and repair kit/beacon HUDs when certain events
//	   have occurred, such as throwing of an item or the use of an item.
// ===============================================================================================
function Hyper::UpdateItemHUDs()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateItemHUDs()", 3);

	if ($Hyper::ItemToggle == 0)
	{
		schedule("Hyper::UpdateItemHUDs();", 1);
		$Hyper::ItemToggle++;

		if ($HHDEBUG)
			Hyper::DEBUG("Exiting Hyper::UpdateItemHUDs", -3);

		return;
	}

	if (HUD::GetDisplayed(hudHHMines))
		HUD::Update(hudHHMines);	// Update our mines HUD.
	if (HUD::GetDisplayed(hudHHGrenades))
		HUD::Update(hudHHGrenades);	// Update our grenades HUD.
	if (HUD::GetDisplayed(hudHHRepair))
		HUD::Update(hudHHRepair);	// Update our repair kit HUD.
	if (HUD::GetDisplayed(hudHHBeacon))
		HUD::Update(hudHHBeacon);	// Update our beacon HUD.

	if ($HyperPref::ShowPack && ($Hyper::Mode != ""))
		Hyper::UpdateBackpack();

	$Hyper::ItemToggle = 0;		// Reset our timer toggle.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateItemHUDs", -3);
}

// ===============================================================================================
//  Function: UpdateCTF
//
//  Purpose: Update our flag status HUDs from this one function instead of having to monitor two
//	   separate flag events, one for our flag and one for the enemy's.
// ===============================================================================================
function Hyper::UpdateCTF()
{
	if ($HHDEBUG)
	{
		Hyper::DEBUG("Hyper::UpdateCTF()", 3);
		Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);
	}

	if (($Hyper::Mode == "Gen") || ($Hyper::Mode == "") || ($HyperPref::GenStart))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Exiting Hyper::UpdateCTF", -3);
		return;
	}

	%friendlyTeam = Team::Friendly();
	%teamFlag = Team::GetFlagLocation(%friendlyTeam);	// Status of our flag.

	if ($HHDEBUG)
		Hyper::DEBUG("Your Flag Status (%teamFlag): " @ %teamFlag);

	if ((%teamFlag == $Trak::locationHome) || (%teamFlag == ""))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Displaying small flag status HUD for your team's flag.");

		HUD::Display(hudHHCTFHome, false);
		HUD::Display(hudHHCTFHomeSm);
		HUD::Update(hudHHCTFHomeSm);	// Upon a flag event, update our team's flag HUD.
	}
	else
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Displaying large flag status HUD for your team's flag.");

		if ((%teamFlag == $Trak::locationField) && !$Hyper::FlagTimerSet[%friendlyTeam] && $HyperPref::FlagReturnTime)
		{
			$Hyper::FlagTimer[%friendlyTeam] = floor(getSimTime());
			$Hyper::FlagTimerSet[%friendlyTeam] = true;
		}

		HUD::Display(hudHHCTFHomeSm, false);
		HUD::Display(hudHHCTFHome);
		HUD::Update(hudHHCTFHome);	// Upon a flag event, update our team's flag HUD.
	}

	if ($Hyper::Mode != "CTF")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Exiting Hyper::UpdateCTF", -3);
		return;
	}

	%enemyTeam = Team::Enemy();
	%enemyFlag = Team::GetFlagLocation(%enemyTeam);	// Status of the enemy's flag.

	if ($HHDEBUG)
		Hyper::DEBUG("Enemy Flag Status (%enemyFlag): " @ %enemyFlag);

	if ((%enemyFlag == $Trak::locationHome) || (%enemyFlag == ""))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Displaying small flag status HUD for enemy flag.");
		HUD::Display(hudHHCTFEnemy, false);
		HUD::Display(hudHHCTFEnemySm);
		HUD::Update(hudHHCTFEnemySm);	// Upon a flag event, update our team's flag HUD.
	}
	else
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Displaying large flag status HUD for enemy flag.");

		if ((%enemyFlag == $Trak::locationField) && !$Hyper::FlagTimerSet[%enemyTeam] && $HyperPref::FlagReturnTime)
		{
			$Hyper::FlagTimer[%enemyTeam] = floor(getSimTime());
			$Hyper::FlagTimerSet[%enemyTeam] = true;
		}

		HUD::Display(hudHHCTFEnemySm, false);
		HUD::Display(hudHHCTFEnemy);
		HUD::Update(hudHHCTFEnemy);	// Upon a flag event, update our team's flag HUD.
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateCTF", -3);
}

// ===============================================================================================
//  Function: UpdatePlayers
//
//  Purpose: Update our team player count HUD using a short delay.
// ===============================================================================================
function Hyper::UpdatePlayers()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdatePlayers()", 3);

	if ($Hyper::PlayerToggle == 0)
	{
		schedule("Hyper::UpdatePlayers();", 1);		// Update our player HUD in one second if someone has
		$Hyper::PlayerToggle++;			// joined or dropped.  This allows time for the player
		if ($HHDEBUG)
			Hyper::DEBUG("Exiting Hyper::UpdatePlayers", -3);
		return;					// count to catch up after event has ended.
	}

	HUD::Update(hudHHPlayers);	// Update the HUD.

	$Hyper::PlayerToggle = 0;	// Reset our timer toggle.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdatePlayers", -3);
}

// ===============================================================================================
//  Function: UpdateMinutes
//
//  Purpose: Increment our minutes counter every 60 seconds, then update our play time HUD.
// ===============================================================================================
function Hyper::UpdateMinutes()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::UpdateMinutes()", 3);

	schedule("Hyper::UpdateMinutes();", 60);	// Call back in a minute.

	$Hyper::TimeMin++;				// Increment our minutes counter.
	$Hyper::StatMin++;

	if ($HHDEBUG)
		Hyper::DEBUG("$Hyper::TimeMin: " @ $Hyper::TimeMin @ "  $Hyper::StatMin: " @ $Hyper::StatMin);

	if ($Hyper::TimeMin > 59)			// Are our minutes over an hour?
	{
		$Hyper::TimeMin = 0;		// If so, reset our minutes and
		$Hyper::TimeHour++;			// increment our hour counter.
	}

	if ($Hyper::TimeHour > 23)
	{
		$Hyper::TimeHour = 0;
		$Hyper::TimeDay++;
	}

	if ($Hyper::StatMin > 59)
	{
		$Hyper::StatMin = 0;
		$Hyper::StatHour++;
	}

	if ($Hyper::StatHour > 23)
	{
		$Hyper::StatHour = 0;
		$Hyper::StatDay++;
	}

	if ($HHDEBUG)
	{
		Hyper::DEBUG("$Hyper::TimeMin: " @ $Hyper::TimeMin @ "  $Hyper::StatMin: " @ $Hyper::StatMin);
		Hyper::DEBUG("$Hyper::TimeHour: " @ $Hyper::TimeHour @ "  $Hyper::StatHour: " @ $Hyper::StatHour);
		Hyper::DEBUG("$Hyper::StatDay: " @ $Hyper::StatDay);
	}

	HUD::Update(hudHHPlayTime);			// Update our play time HUD.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::UpdateMinutes", -3);
}

function Hyper::ProcessTotalTime()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::ProcessTotalTime()", 3);

	if ($Hyper::StatDay < 0)
		$Hyper::StatDay = 0;
	if ($Hyper::StatHour < 0)
		$Hyper::StatHour = 0;
	if ($Hyper::StatMin < 0)
		$Hyper::StatMin = 0;
	$HyperStat::TotalTime = $Hyper::StatDay @ " " @ $Hyper::StatHour @ " " @ $Hyper::StatMin;

	if ($HHDEBUG)
		Hyper::DEBUG("TOTAL Time ($HyperStat::TotalTime): " @ $HyperStat::TotalTime);

	Hyper::UpdateStats("normal");

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::ProcessTotalTime", -3);
}

// ===============================================================================================
//  Function: MakeNewHUDs
//
//  Purpose: This is where we initially create our various HUDs.  This function is only called
//	   once during a server connection.  Depending on your selected preferences, the flag
//	   status HUDs and general HUDs will be created.
// ===============================================================================================
function Hyper::MakeNewHUDs(%make, %type, %newx, %newy)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::MakeNewHUDs(" @ %make @ ", " @ %type @ ", " @ %newx @ ", " @ %newy @ ")", 3);

	%ScreenDim = Presto::ScreenSize();
	%ScreenWidth = getWord(%ScreenDim, 0);
	%ScreenHeight = getWord(%ScreenDim, 1);

	if ($HHDEBUG)
		Hyper::DEBUG("Screen Dimension (%ScreenDim): " @ %ScreenDim);

	if ((%type == "pack") && !make)
	{
		HUD::Move(hudPack, %newx, %newy, HUD::Width(hudPack), 18);
		if ($HHDEBUG)
		{
			Hyper::DEBUG("HUD::Move(hudPack, " @ %newx @ ", " @ %newy @ ", " @ HUD::Width(hudPack) @ ", 18)");
			Hyper::DEBUG("Exiting Hyper::MakeNewHUDs", -3);
		}
		return;
	}
	else if (($HyperPref::ShowPack) && !(HUD::Exists(hudPack)) && %make)
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::New(hudPack, Hyper::UpdatePackHUD, " @ getWord($HyperPref::PackPos, 0) @ ", " @ getWord($HyperPref::PackPos, 1) @ ", 25%, 18)");
		HUD::New(hudPack, Hyper::UpdatePackHUD, getWord($HyperPref::PackPos, 0), getWord($HyperPref::PackPos, 1), "25%", 18);
	}

	if (%make)
	{
		%FlagXPos = getWord($HyperPref::FlagPos, 0);	// By default, flag status HUDs are placed on the left side of the screen.
		%FlagYPos = getWord($HyperPref::FlagPos, 1);	// Initialize how far down we want them displayed from the top of the screen.
	}
	else if (%type == "ctf")
	{
		%FlagXPos = %newx;
		%FlagYPos = %newy;
	}

	$Hyper::FlagXPos = %FlagXPos;
	$Hyper::FlagYPos = %FlagYPos;

	if (($HyperPref::FlagHUDLoc == "top") && (%FlagXPos == "50%"))
		%FlagXPos = floor((%ScreenWidth - 232) / 2);

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%FlagXPos: " @ %FlagXPos @ "  %FlagYPos: " @ %FlagYPos);
		Hyper::DEBUG("$HyperPref::FlagHUDLoc: " @ $HyperPref::FlagHUDLoc);
	}

	if (%make && !(HUD::Exists(hudHHCTFHome)))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::New(hudHHCTFHome, Hyper::UpdateHomeHUD, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 116, 56)");
		HUD::New(hudHHCTFHome, Hyper::UpdateHomeHUD, %FlagXPos, %FlagYPos, 116, 56);						// Our flag HUD.
	}
	else if (%type == "ctf")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::Move(hudHHCTFHome, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 116, 56)");
		HUD::Move(hudHHCTFHome, %FlagXPos, %FlagYPos, 116, 56);						// Our flag HUD.
	}

	if (($HyperPref::FlagHUDLoc == "right") || ($HyperPref::FlagHUDLoc == "top"))
		%FlagXPos = "right(hudHHCTFHome)-44";

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%FlagXPos: " @ %FlagXPos @ "  %FlagYPos: " @ %FlagYPos);
	}

	if (%make && !HUD::Exists(hudHHCTFHomeSm))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::New(hudHHCTFHomeSm, Hyper::UpdateHomeHUD, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 44, 56)");
		HUD::New(hudHHCTFHomeSm, Hyper::UpdateHomeHUD, %FlagXPos, %FlagYPos, 44, 56);						// Our small flag HUD.
	}
	else if (%type == "ctf")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::Move(hudHHCTFHomeSm, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 44, 56)");
		HUD::Move(hudHHCTFHomeSm, %FlagXPos, %FlagYPos, 44, 56);						// Our small flag HUD.
	}

	%FlagXPos = "left(hudHHCTFHome)";
	%FlagYPos = "bottom(hudHHCTFHome)";

	if (($HyperPref::FlagHUDLoc == "top") || ($HyperPref::FlagHUDLoc == "bottom"))
	{
		%FlagYPos = getWord(HUD::GetPosition(hudHHCTFHome), 1);
		if ($HyperPref::FlagHUDLoc == "top")
			%FlagXPos = "right(hudHHCTFHome)-1";
		else if ($HyperPref::FlagHUDLoc == "bottom")
			%FlagXPos = "100%";
	}

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%FlagXPos: " @ %FlagXPos @ "  %FlagYPos: " @ %FlagYPos);
	}

	if (%make && !HUD::Exists(hudHHCTFEnemy))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::New(hudHHCTFEnemy, Hyper::UpdateEnemyHUD, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 116, 56)");
		HUD::New(hudHHCTFEnemy, Hyper::UpdateEnemyHUD, %FlagXPos, %FlagYPos, 116, 56);		// Enemy flag HUD.
	}
	else  if (%type == "ctf")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::Move(hudHHCTFEnemy, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 116, 56)");
		HUD::Move(hudHHCTFEnemy, %FlagXPos, %FlagYPos, 116, 56);		// Enemy flag HUD.
	}

	if ($HyperPref::FlagHUDLoc == "right")
		%FlagXPos = "right(hudHHCTFEnemy)-44";

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%FlagXPos: " @ %FlagXPos @ "  %FlagYPos: " @ %FlagYPos);
	}

	if (%make && !HUD::Exists(hudHHCTFEnemySm))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::New(hudHHCTFEnemySm, Hyper::UpdateEnemyHUD, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 44, 56)");
		HUD::New(hudHHCTFEnemySm, Hyper::UpdateEnemyHUD, %FlagXPos, %FlagYPos, 44, 56);	// Small enemy flag HUD.
	}
	else  if (%type == "ctf")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("HUD::Move(hudHHCTFEnemySm, " @ %FlagXPos @ ", " @ %FlagYPos @ ", 44, 56)");
		HUD::Move(hudHHCTFEnemySm, %FlagXPos, %FlagYPos, 44, 56);	// Small enemy flag HUD.
	}

	if ((!make && (%type == "ctf")) || ($HyperPref::NumGenHUDs == 0))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Exiting Hyper::MakeNewHUDs", -3);
		return;
	}

	if (%make)
	{
		%GenXPos = getWord($HyperPref::GenPos, 0);	// By default, our general HUDs are placed on the right side of the screen.
		%GenYPos = getWord($HyperPref::GenPos, 1);	// Initialize our general HUD position from top of screen.
	}
	else if (%type == "gen")
	{
		%GenXPos = %newx;
		%GenYPos = %newy;
	}

	$Hyper::GenXPos = %GenXPos;
	$Hyper::GenYPos = %GenYPos;

	if (($HyperPref::GenHUDLoc == "top") && (%GenXPos == "50%"))	// Or are they to be centered?
		if ($HyperPref::NumGenHUDs < $HyperPref::HUDsPerLine)
			%GenXPos = floor((%ScreenWidth - ($HyperPref::NumGenHUDs * 60)) / 2);	// Calculate the center starting point.
		else
			%GenXPos = floor((%ScreenWidth - ($HyperPref::HUDsPerLine * 60)) / 2);

	if ($HHDEBUG)
	{
		Hyper::DEBUG("%GenXPos: " @ %GenXPos @ "  %GenYPos: " @ %GenYPos);
		Hyper::DEBUG("$HyperPref::GenHUDLoc: " @ $HyperPref::GenHUDLoc);
		Hyper::DEBUG("$HyperPref::NumGenHUDs: " @ $HyperPref::NumGenHUDs);
		Hyper::DEBUG("$HyperPref::HUDsPerLine: " @ $HyperPref::HUDsPerLine);
	}

	if (!$Hyper::ItemUse)
		$Hyper::ItemUse = false;

	for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
	{
		%h = eval("HUD::Height(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");");

		if ($HHDEBUG)
			Hyper::DEBUG("$Hyper::ItemUse: " @ $Hyper::ItemUse);

		if (((%i - $HyperPref::HUDsPerLine) >= 0) && ($HyperPref::GenHUDLoc != "left") && ($HyperPref::GenHUDLoc != "right"))
		{
			%GenYPos = "bottom(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i - $HyperPref::HUDsPerLine], "label") @ ")";
			%GenXPos = "left(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i - $HyperPref::HUDsPerLine], "label") @ ")";
		}

		%hudheight = 20;

		if ((($HyperPref::Gen[%i] == "Caps") && ($HyperPref::ShowTC)) ||
		    (($HyperPref::Gen[%i] == "Kills") && ($HyperPref::ShowTK)) ||
		    (($HyperPref::Gen[%i] == "Deaths") && ($HyperPref::ShowTD)))
			%hudheight = 37;
		else if ($HyperPref::Gen[%i] == "Players")
		{
			if ($HyperPref::ShowObserver && $Hyper::mt)
				%hudheight = 58;
			else if ($Hyper::mt)
				%hudheight = 38;
			else if ($HyperPref::ShowObserver)
				%hudheight = 40;
		}
		else if ($HyperPref::Gen[%i] == "PlayTime")
		{
			if ($HyperPref::ShowTT)
			{
				if ($Hyper::StatDay > 0)
					%hudheight = 34;
				else
					%hudheight = 23;
			}
			else
				%hudheight = 12;
		}
		if ($HHDEBUG)
		{
			Hyper::DEBUG("%GenXPos: " @ %GenXPos @ "  %GenYPos: " @ %GenYPos);
			Hyper::DEBUG("%hudheight: " @ %hudheight);
		}

		if (%make && !(eval("HUD::Exists(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");")))
		{
			if ($HHDEBUG)
				Hyper::DEBUG("HUD::New(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", " @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "func") @ ", " @ %GenXPos @ ", " @ %GenYPos @ ", 60, " @ %hudheight @ ")");
			eval("HUD::New(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", " @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "func") @ ", %GenXPos, %GenYPos, 60, %hudheight);");	// Create a HUD.
		}
		else if (%type == "gen")
		{
			if ($HHDEBUG)
				Hyper::DEBUG("HUD::Move(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", " @ %GenXPos @ ", " @ %GenYPos @ ", 60, " @ %hudheight @ ")");
			eval("HUD::Move(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", %GenXPos, %GenYPos, 60, %hudheight);");	// Create a HUD.
		}

		if (!$Hyper::ItemUse)
			if ((($HyperPref::Gen[%i] == "Mines") || ($HyperPref::Gen[%i] == "Grenades") ||
			    ($HyperPref::Gen[%i] == "Repair") || ($HyperPref::Gen[%i] == "Beacon") ||
			     ($HyperPref::ShowPack)) && (%make))
				$Hyper::ItemUse = true;

		if (($HyperPref::GenHUDLoc == "left") || ($HyperPref::GenHUDLoc == "right"))
			%GenYPos = "bottom(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ")";	// Skip down for next HUD display.
		else
			%GenXPos = "right(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ")-1";	// Skip over to the right for next HUD display.
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::MakeNewHUDs", -3);
}

// ===============================================================================================
//  Function: Toggle
//
//  Purpose: Since we have designed three different HUD screens, we must offer the ability to
//	   switch between them.  As a default, Control-H is our toggle switch.  NOTE:  By HUD
//	   screens, I mean we work with TRIBES' default HUD display and add to that.  The three
//	   screens are:
//
//	   1) Our first HUD screen consists of the CTF flag status HUDs for each team.  These
//	      are located on the left, right, top or bottom of the screen, depending on your
//	      preferences.  Our general HUDs are located on one of the four sides of the screen
//	      also.
//
//	   2) The second HUD screen is basically just for Multiple Team CTF.  Your team's flag
//	      status HUD and the general HUDs are displayed.
//
//	   3) Our last HUD screen is for any other type of game (i.e. Defend & Destroy,
//	      Deathmatch, etc.).  This screen will only show your general HUDs.
// ===============================================================================================
function Hyper::Toggle(%mode)
{
	if ($HHDEBUG)
	{
		Hyper::DEBUG("Hyper::Toggle()", 3);
		Hyper::DEBUG("$Hyper::HUDTypeToggle: " @ $Hyper::HUDTypeToggle);
	}

	if ($Hyper::HUDTypeToggle == 0)	// Setup our HUDs.  Done on first call to HyperHUD only.
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Initializing HyperHUD.");

		$Hyper::NewFlagPos = "";
		$Hyper::NewGenPos = "";
		$Hyper::NewPackPos = "";

		Hyper::MakeNewHUDs(true);		// Call our HUD creation function.

		Hyper::MakeMenus();

		$Hyper::HUDTypeToggle++;		// Point our toggle counter to the CTF HUD screen layout.
	}

	if ($Hyper::HUDTypeToggle == 1)	// Capture the Flag HUD screen.
	{
		$Hyper::Mode = "CTF";

		if ($HHDEBUG)
		{
			Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);
			Hyper::DEBUG("Capture the Flag HUD Screen.");
		}

		Hyper::UpdateCTF();

		if ($HyperPref::ShowPack)
		{
			Hyper::UpdateBackpack();
			if ($HHDEBUG)
			{
				Hyper::DEBUG("Event::Attach(eventUse, Hyper::UpdateItemHUDs)");
				Hyper::DEBUG("Event::Attach(eventDrop, Hyper::UpdateItemHUDs)");
			}
			Event::Attach(eventUse, Hyper::UpdateItemHUDs);	// Upon the use of an item (repair kit, beacon, etc.), update our
			Event::Attach(eventDrop, Hyper::UpdateItemHUDs);
		}

		if ($HHDEBUG)
		{
			Hyper::DEBUG("Event::Attach(eventFlagsUpdated, Hyper::UpdateCTF)");
			Hyper::DEBUG("Event::Attach(eventClientMessage, Hyper::onClientMessage)");
		}

		Event::Attach(eventFlagsUpdated, Hyper::UpdateCTF);	// Update our flag Status HUDs upon a flag event.
		Event::Attach(eventClientMessage, Hyper::onClientMessage);	// Check if we have accessed a station for supplies, picked up an item
									// or server went through a mission change.
		for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		{
			if ($HHDEBUG)
				Hyper::DEBUG("HUD::Display("@ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ")");
			eval("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");");

			if ($HyperPref::Gen[%i] == "Caps")
			{
				if ($HHDEBUG)
					Hyper::DEBUG("Event::Attach(eventFlagCaptured, Hyper::Capture)");
				Event::Attach(eventFlagCaptured, Hyper::Capture);	// If a flag is captured, check to see if it was you.
			}
			else if (($HyperPref::Gen[%i] == "Kills") || ($HyperPref::Gen[%i] == "Deaths"))
			{
				if ($HHDEBUG)
					Hyper::DEBUG("Event::Attach(eventKillTrak, Hyper::VerifiedKill)");
				Event::Attach(eventKillTrak, Hyper::VerifiedKill);	// Execute our VerifiedKill function upon a kill event.
			}
			else if (($HyperPref::Gen[%i] == "Mines") || ($HyperPref::Gen[%i] == "Grenades"))
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("Event::Attach(eventThrowRelease, Hyper::UpdateItemHUDs)");
					Hyper::DEBUG("Event::Attach(eventDrop, Hyper::UpdateItemHUDs)");
				}
				Event::Attach(eventThrowRelease, Hyper::UpdateItemHUDs);	// Upon the throwing of an object (grenade, mine, etc.), update our HUDs.
				Event::Attach(eventDrop, Hyper::UpdateItemHUDs);		// Upon dropping an object (grenade, mine, etc.), update our HUDs.
			}
			else if (($HyperPref::Gen[%i] == "Repair") || ($HyperPref::Gen[%i] == "Beacon"))
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("Event::Attach(eventUse, Hyper::UpdateItemHUDs)");
					Hyper::DEBUG("Event::Attach(eventDrop, Hyper::UpdateItemHUDs)");
				}
				Event::Attach(eventUse, Hyper::UpdateItemHUDs);	// Upon the use of an item (repair kit, beacon, etc.), update our
				Event::Attach(eventDrop, Hyper::UpdateItemHUDs);		// Upon dropping an object (grenade, mine, etc.), update our HUDs.
			}
			else if ($HyperPref::Gen[%i] == "Players")
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("Event::Attach(eventClientJoin, Hyper::onClientJoin)");
					Hyper::DEBUG("Event::Attach(eventClientDrop, Hyper::onClientDrop)");
				}
				Event::Attach(eventClientJoin, Hyper::onClientJoin);			// Update the HUD upon a player joining a team.
				Event::Attach(eventClientDrop, Hyper::onClientDrop);			// Update the HUD upon a player leaving the game.
			}
		}

		$Hyper::HUDTypeToggle++;	// Increment our toggle counter to point to Multiple Team CTF HUD next.
		if ($HyperPref::GenStart || (%mode == "MT") || (%mode == "Gen") || (%mode == ""))
		{
			if ($HHDEBUG)
				Hyper::DEBUG("$HyperPref::GenStart: " @ $HyperPref::GenStart);
			Hyper::Toggle(%mode);	// If user wants to start in General Gameplay HUD screen, advance our HyperHUD toggle.
		}
	}
	else if ($Hyper::HUDTypeToggle == 2)	// Multiple Team CTF HUD screen.
	{
		$Hyper::Mode = "MT";
		if ($HHDEBUG)
		{
			Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);
			Hyper::DEBUG("Multiple Team CTF HUD Screen.");
			Hyper::DEBUG("HUD::Display(hudHHCTFEnemy, false)");
			Hyper::DEBUG("HUD::Display(hudHHCTFEnemySm, false)");
		}
		HUD::Display(hudHHCTFEnemy, false);	// Turn off enemy flag HUD.
		HUD::Display(hudHHCTFEnemySm, false);
		if (Hyper::CheckGenHUDs("Caps"))
			HUD::Update(hudHHCaps);
		$Hyper::HUDTypeToggle++;		// Increment our toggle counter to point to the General Gameplay HUD.
		if ($HyperPref::GenStart || (%mode == "CTF") || (%mode == "Gen") || (%mode == ""))
		{
			if ($HHDEBUG)
				Hyper::DEBUG("$HyperPref::GenStart: " @ $HyperPref::GenStart);
			Hyper::Toggle(%mode);	// If user wants to start in General Gameplay HUD screen, advance our HyperHUD toggle.
		}
	}
	else if ($Hyper::HUDTypeToggle == 3)	// General Gameplay HUD screen.
	{
		$Hyper::Mode = "Gen";
		if ($HHDEBUG)
		{
			Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);
			Hyper::DEBUG("General Gameplay Screen.");
			Hyper::DEBUG("HUD::Display(hudHHCTFHome, false)");
			Hyper::DEBUG("HUD::Display(hudHHCTFHomeSm, false)");
			Hyper::DEBUG("Event::Detach(eventFlagsUpdated, Hyper::UpdateCTF)");
		}
		HUD::Display(hudHHCTFHome, false);	// Turn off our team's flag HUD.
		HUD::Display(hudHHCTFHomeSm, false);
		Event::Detach(eventFlagsUpdated, Hyper::UpdateCTF);	// Disable flag status HUD updates on a flag event.
		if (Hyper::CheckGenHUDs("Caps"))
			HUD::Update(hudHHCaps);
		$Hyper::HUDTypeToggle++;	// Increment our toggle counter to point to our last choice of no HUDs at all.
		if ((%mode == "CTF") || (%mode == "MT") || (%mode == ""))
			Hyper::Toggle(%mode);
	}
	else	// No HUDs at all.
	{
		$Hyper::Mode = "";
		if ($HHDEBUG)
		{
			Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);
			Hyper::DEBUG("No HUDs.");
			Hyper::DEBUG("Event::Detach(eventClientMessage, Hyper::onClientMessage)");
		}

		Event::Detach(eventClientMessage, Hyper::onClientMessage);	// Disable event check for station access, pickups and mission changes.

		if ($HyperPref::ShowPack && HUD::GetDisplayed(hudPack))
		{
			if ($HHDEBUG)
			{
				Hyper::DEBUG("HUD::Display(hudPack, false)");
				Hyper::DEBUG("Event::Detach(eventUse, Hyper::UpdateItemHUDs)");
				Hyper::DEBUG("Event::Detach(eventDrop, Hyper::UpdateItemHUDs)");
			}
			HUD::Display(hudPack, false);
			Event::Detach(eventUse, Hyper::UpdateItemHUDs);
			Event::Detach(eventDrop, Hyper::UpdateItemHUDs);
		}

		for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		{
			if ($HHDEBUG)
				Hyper::DEBUG("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", false)");

			eval("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", false);");

			if ($HyperPref::Gen[%i] == "Caps")
			{
				if ($HHDEBUG)
					Hyper::DEBUG("Event::Detach(eventFlagCaptured, Hyper::Capture)");
				Event::Detach(eventFlagCaptured, Hyper::Capture);	// Disable detection for the flag capture HUD.
			}
			else if (($HyperPref::Gen[%i] == "Kills") || ($HyperPref::Gen[%i] == "Deaths"))
			{
				if ($HHDEBUG)
					Hyper::DEBUG("Event::Detach(eventKillTrak, Hyper::VerifiedKill)");
				Event::Detach(eventKillTrak, Hyper::VerifiedKill);	// Disable our VerifiedKill function upon a kill event.
			}
			else if (($HyperPref::Gen[%i] == "Mines") || ($HyperPref::Gen[%i] == "Grenades"))
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("Event::Detach(eventThrowRelease, Hyper::UpdateItemHUDs)");
					Hyper::DEBUG("Event::Detach(eventDrop, Hyper::UpdateItemHUDs)");
				}
				Event::Detach(eventThrowRelease, Hyper::UpdateItemHUDs);	// Disable checking of the throwing of an object.
				Event::Detach(eventDrop, Hyper::UpdateItemHUDs);
			}
			else if (($HyperPref::Gen[%i] == "Repair") || ($HyperPref::Gen[%i] == "Beacon"))
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("Event::Detach(eventUse, Hyper::UpdateItemHUDs)");
					Hyper::DEBUG("Event::Detach(eventDrop, Hyper::UpdateItemHUDs)");
				}
				Event::Detach(eventUse, Hyper::UpdateItemHUDs);	// Disable the USE event up an item's use.
				Event::Detach(eventDrop, Hyper::UpdateItemHUDs);
			}
			else if ($HyperPref::Gen[%i] == "Players")
			{
				if ($HHDEBUG)
				{
					Hyper::DEBUG("Event::Detach(eventClientJoin, Hyper::onClientJoin)");
					Hyper::DEBUG("Event::Detach(eventClientDrop, Hyper::onClientDrop)");
				}
				Event::Detach(eventClientJoin, Hyper::onClientJoin);		// Disable client joining event.
				Event::Detach(eventClientDrop, Hyper::onClientDrop);		// Disable client dropping event.
			}
		}

		$Hyper::HUDTypeToggle = 1;	// Reset our toggle counter to point to the CTF HUD again.

		$HyperPref::GenStart = false;	// Turn off our General Gameplay screen startup preference, so we can toggle HyperHUD normally again.
		if ((%mode == "CTF") || (%mode == "MT") || (%mode == "Gen"))
			Hyper::Toggle(%mode);
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::Toggle", -3);
}

// ===============================================================================================
//  Function: ResetHUDs
//
//  Purpose: Call our update functions for each HUD.
// ===============================================================================================
function Hyper::ResetHUDs()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::ResetHUDs()", 3);

	Hyper::UpdateCTF();		// Update
	HUD::Update(hudHHCaps);
	HUD::Update(hudHHKills);	// our
	HUD::Update(hudHHDeaths);
	Hyper::UpdateItemHUDs();	// HUDs.
	Hyper::UpdatePlayers();
	Hyper::UpdatePlayTimeHUD();
	Hyper::UpdateBackpack();

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::ResetHUDs", -3);
}

// ===============================================================================================
//  Function: Reset
//
//  Purpose: Reset variables and update flag HUDs.
// ===============================================================================================
function Hyper::Reset()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::Reset()", 3);

	for (%i = 0; %i < 4; %i++)
	{
		$Hyper::caps[%i] = 0;	// Reset all teams capture totals.
		$Hyper::MyCaps[%i] = 0;	// Reset your personal captures.
	}

	$Hyper::Kills = 0;		// Reset how many kills we have made.
	$Hyper::Deaths = 0;		// Reset how times we have been killed.
	$Hyper::ItemToggle = 0;	// Reset our timer toggle for use with UpdateItemHUDs.
	$Hyper::PlayerToggle = 0;	// Reset our timer toggle for use with UpdatePlayers.
	$Hyper::BlinkToggle = 0;	// Reset our flag toggle to blink enemy flag status when you have the flag.
	$Hyper::YouCapped = false;	// Reset our capture toggle.
	$Hyper::capBlink = 0;	// Reset our blink toggle for personal captures displayed in the flag capture HUD.
	$Hyper::capBlinkCnt = 0;	// Reset our blink counter.
	$Hyper::BalanceToggle = 0;	// Reset our team balance toggle.
	$Hyper::FlagTimerSet[0] = false;
	$Hyper::FlagTimerSet[1] = false;

	Hyper::ResetHUDs();		// Update our HUDs.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::Reset", -3);

}

$Hyper::TimeMin = -1;	// DO NOT MODIFY THIS LINE!

function Hyper::ResetAll()
{
	$Hyper::FlagTimerDefault = 48;
	$Hyper::NewReturnTime = "";

	if (Hyper::CheckGenHUDs("PlayTime") && ($Hyper::TimeMin < 0))
	{
		$Hyper::TimeMin = 0;

		if ($HHDEBUG)
			Hyper::DEBUG("$Hyper::StatDay: " @ $Hyper::StatDay @ "  $Hyper::StatHour: " @ $Hyper::StatHour @ "  $Hyper::StatMin: " @ $Hyper::StatMin);

		schedule("Hyper::UpdateMinutes();", 60);	// Start our play timer in a minute.
	}

	Hyper::Reset();
}

// ===============================================================================================
//  Function: Capture
//
//  Purpose: Keep track of which team has captured the flag along with your personal captures for
//	   the each team you are a member of during a mission.
// ===============================================================================================
function Hyper::Capture(%team, %client)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::Capture(" @ %team @ ", " @ %client @ ")", 3);

	%whichteam = Client::getTeam(%client);

	$Hyper::caps[%whichteam]++;			// Increment the team that captured the flag counter.

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Your team (%whichteam): " @ %whichteam);
		Hyper::DEBUG("Team capture total ($Hyper::caps[%whichteam]): " @ $Hyper::caps[%whichteam]);
	}

	if (%client == getManagerId())		// Did you capture?
	{
		$Hyper::MyCaps[%whichteam]++;	// Increment your capture total.
		$HyperStat::TotalCaps++;

		if ($HHDEBUG)
		{
			Hyper::DEBUG("You captured the flag!");
			Hyper::DEBUG("Your capture total ($Hyper::MyCaps[%whichteam]): " @ $Hyper::MyCaps[%whichteam]);
			Hyper::DEBUG("Your TOTAL captures ($HyperStat::TotalCaps): " @ $HyperStat::TotalCaps);
			Hyper::DEBUG("$Hyper::Mode: " @ $Hyper::Mode);
		}

		Hyper::UpdateStats("normal");

		if (($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen"))
			$Hyper::YouCapped = true;	// If in CTF mode, blink our flag capture HUD.
	}

	HUD::Update(hudHHCaps);			// Update our flag capture HUD.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::Capture", -3);
}

// ===============================================================================================
//  Function: VerifiedKill
//
//  Purpose: Determine if we have killed someone or if we have been killed.
// ===============================================================================================
function Hyper::VerifiedKill(%killer, %victim, %weapon)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::VerifiedKill(" @ %killer @ ", " @ %victim @ ", " @ %weapon @ ")", 3);

	%me = getManagerId();	// Get our client ID.

	if ($HHDEBUG)
		Hyper::DEBUG("Your Client ID (%me): " @ %me);

	if (%victim == %me)	// I've been killed. :(
	{
		if ($HHDEBUG)
			Hyper::DEBUG("You have been killed by Client ID: " @ %killer @ "  Client Name: " @ Client::getName(%killer) @ ".");
		if ($HyperPref::ShowKiller)
		{
			if (%killer != %victim)
			{
				if ($HHDEBUG)
					Hyper::DEBUG("Showing who killed you.");
				Client::centerPrint("<jc><f1>You died!\n<f0>Killed by: <f2>" @ Client::getName(%killer) @"\n <f0>Weapon: <f2>" @ %weapon, 1); 
		    		schedule("Client::centerPrint(\"\", 1);", 5);
			}
		}

		$Hyper::Deaths++;		// Increment our deaths counter.
		$HyperStat::TotalDeaths++;
		if ($HHDEBUG)
		{
			Hyper::DEBUG("Deaths for this game ($Hyper::Deaths): " @ $Hyper::Deaths);
			Hyper::DEBUG("TOTAL deaths so far ($HyperStat::TotalDeaths): " @ $HyperStat::TotalDeaths);
		}
		Hyper::UpdateStats("normal");
		HUD::Update(hudHHDeaths);	// Update our Deaths HUD.
		if ($HHDEBUG)
			Hyper::DEBUG("Scheduling Hyper::UpdateItemHUDs() every 5 seconds for up to 30 seconds.");
		for (%i = 1; %i < 7; %i++)				// If we die, update our item HUDs every five seconds for 30 seconds.
			schedule("Hyper::UpdateItemHUDs();", 5 * %i);	// If you respawn after that, HUDs won't be updated correctly and you
								// will still be shown item count from before death.  Remember, the
								// item count is not reset until you respawn alive.
	}
	else if (%killer == %me)	// I've killed someone. :)
	{
		if ($HHDEBUG)
			Hyper::DEBUG("You have killed Client ID: " @ %victim @ "  Client Name: " @ Client::getName(%victim) @ ".");
		if ($HyperPref::ShowVictim)
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Showing who you killed.");
			Client::centerPrint("<jc><f1>Kill Added\n<f0>Killed: <f2>" @ Client::getName(%victim) @"\n <f0>Weapon: <f2>" @ %weapon, 1); 
		    	schedule("Client::centerPrint(\"\", 1);", 5);
		}

		$Hyper::Kills++;		// Increment our kills counter.
		$HyperStat::TotalKills++;
		if ($HHDEBUG)
		{
			Hyper::DEBUG("Kills for this game ($Hyper::Kills): " @ $Hyper::Kills);
			Hyper::DEBUG("TOTAL kills so far ($HyperStat::TotalKills): " @ $HyperStat::TotalKills);
		}
		Hyper::UpdateStats("normal");
		HUD::Update(hudHHKills);	// Update our Kills HUD.
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::VerifiedKill", -3);
}

// ===============================================================================================
//  Function: onClientMessage
//
//  Purpose: Determine if we have accessed a station for supplies, picked up an item, went through
//	   a server mission change.  If so, we will update our HUDs.
// ===============================================================================================
function Hyper::onClientMessage(%client, %msg)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::onClientMessage(" @ %client @ ", " @ %msg @ ")", 3);

	$Hyper::Next2LastMsg = $Hyper::LastMsg;
	$Hyper::LastMsg = %msg;

	if ($HHDEBUG)
	{
		Hyper::DEBUG("$Hyper::Next2LastMsg: " @ $Hyper::Next2LastMsg);
		Hyper::DEBUG("$Hyper::LastMsg: " @ $Hyper::LastMsg);
	}

	if (%client != 0)
	{
		if ($HHDEBUG)
		{
			Hyper::DEBUG("Message is not for our Client.");
			Hyper::DEBUG("Exiting Hyper::onClientMessage", -3);
		}
		return;
	}

	if ($Hyper::ItemUse)
		if ((%msg == "Station Access Off") || (%msg == "Resupply Complete") ||
		    (String::starts(%msg, "You received")) || (%msg == "Match started."))
			Hyper::UpdateItemHUDs();	// Update our mines, grenades and repair kit/beacon HUDs.  NOTE: If you use an ammo
						// station, you must wait until "Resupply Complete", otherwise the HUDs will not be
						// updated correctly.

	if (%msg == "Match started.")
		Hyper::UpdateCTF();

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::onClientMessage", -3);
}

// ===============================================================================================
//  Function: onClientJoin
//
//  Purpose: Update our team player count HUD when someone joins.
// ===============================================================================================
function Hyper::onClientJoin(%client)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::onClientJoin(" @ %client @ ")", 3);

	if (%client > $Hyper::LastClient)	// If the new client that joined is greater than our last known client,
		$Hyper::LastClient = %client;	// then set our last known client equal to the newly joined client.

	if ($HHDEBUG)
		Hyper::DEBUG("$Hyper::LastClient: " @ $Hyper::LastClient);

	Hyper::UpdatePlayers();		// Update the team player count HUD.

	if (%client == getManagerId())
	{
		if ($HHDEBUG)
			Hyper::DEBUG("You have joined a team.");
		Hyper::UpdateItemHUDs();	// Update our item HUDs.
	}
	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::onClientJoin", -3);
}

// ===============================================================================================
//  Function: onClientDrop
//
//  Purpose: Update our team player count HUD when someone drops.
// ===============================================================================================
function Hyper::onClientDrop(%client)
{
	if ($HHDEBUG)
	{
		Hyper::DEBUG("Hyper::onClientDrop(" @ %client @ ")", 3);
		Hyper::DEBUG("$Hyper::LastClient: " @ $Hyper::LastClient);
	}

	if (%client == $Hyper::LastClient)	// If our last known client dropped,
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Last known client dropped.");
		Hyper::GetLastClient();	// then find a new last known client.
	}
	else if (%client == getManagerID())
		$Hyper::FlagTimerDefault = 40;

	Hyper::UpdatePlayers();		// Update the team player count HUD.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::onClientDrop", -3);
}

// ===============================================================================================
//  Function: onClientChangeTeam
//
//  Purpose: Update ALL HUDs if you changed teams.  Otherwise, just update the team player count
//	   HUD.
// ===============================================================================================
function Hyper::onClientChangeTeam(%client, %team)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::onClientChangeTeam(" @ %client @ ", " @ %team @ ")", 3);

	if (%client == getManagerId())	// Did you change teams?
	{
		if ($HHDEBUG)
			Hyper::DEBUG("You have switched teams.");
		Hyper::ResetHUDs();		// update ALL the HUDs.
	}
	else if (Hyper::CheckGenHUDs("Players"))
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Client ID: " @ %client @ "  Client Name: " @ Client::getName(%client) @ " has switched teams.");
		Hyper::UpdatePlayers();	// Otherwise, update the team player count HUD.
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::onClientChangeTeam", -3);
}

// ===============================================================================================
//  Function: GetLastClient
//
//  Purpose: Determine who is the last known client currently on the server.  This helps in the
//	   scanning phase for our team player count HUD.
// ===============================================================================================
function Hyper::GetLastClient()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::GetLastClient()", 3);

	for (%i = $Hyper::LastClient; %i > 2048; %i--)	// Check all valid players up to the last known client.
		if (Client::getName(%i) != "")	// Is it a valid player?
		{
			$Hyper::LastClient = %i;	// If so, this is our new last known client.
			if ($HHDEBUG)
			{
				Hyper::DEBUG("$Hyper::LastClient: " @ $Hyper::LastClient);
				Hyper::DEBUG("Exiting Hyper::GetLastClient", -3);
			}
			return;
		}

	if ($HHDEBUG)
		Hyper::DEBUG("$Hyper::LastClient: " @ $Hyper::LastClient);

	if ($Hyper::LastClient == 2176)
		schedule("Hyper::GetLastClient();", 3);	// Execute GetLastClient until we find the last known client.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::GetLastClient", -3);
}

// ===============================================================================================
//  Function: FindClient
//
//  Purpose: Simple function to initialize our last known client variable and to call the function
//	   for determining the last known client.  This is the function to be called upon on a
//	   accepted server connection.
// ===============================================================================================
function Hyper::FindClient()
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::FindClient()", 3);

	$Hyper::LastClient = 2176;	// Initialize our last client to the 128th player (2048 + 128).

	if ($HHDEBUG)
		Hyper::DEBUG("$Hyper::LastClient: " @ $Hyper::LastClient);

	Hyper::GetLastClient();	// Find the last known client.

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::FindClient", -3);
}

// ===============================================================================================
//  Function: CheckGenHUDs
//
//  Purpose: Check to see if our preference (%pref) is turned on according to the user.  Return
//	   "true" if it is, otherwise return "false".
// ===============================================================================================
function Hyper::CheckGenHUDs(%pref)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::CheckGenHUDs(" @ %pref @ ")", 3);

	%result = false;

	for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		if ($HyperPref::Gen[%i] == %pref)
		{
			%result = true;
			$Hyper::index = %i;
			%i = $Hyper::c;
		}

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Function Return (%result): " @ %result);
		Hyper::DEBUG("Exiting Hyper::CheckGenHUDs", -3);
	}

	return %result;
}

function Hyper::GetMode(%value)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::GetMode(" @ %value @ ")", 3);

	if (%value)
		%return = "ON";
	else
		%return = "OFF";

	if ($HHDEBUG)
	{
		Hyper::DEBUG("Function Return (%return): " @ %return);
		Hyper::DEBUG("Exiting Hyper::GetMode", -3);
	}

	return %return;
}

function Hyper::ProcessMenu(%type, %value, %choice, %txt)
{
	if ($HHDEBUG)
		Hyper::DEBUG("Hyper::ProcessMenu(" @ %type @ ", " @ %value @ ", " @ %choice @ ", " @ %txt @ ")", 3);

	%ScreenDim = Presto::ScreenSize();
	%ScreenWidth = getWord(%ScreenDim, 0);
	%ScreenHeight = getWord(%ScreenDim, 1);

	if ($HHDEBUG)
		Hyper::DEBUG("Screen Dimension (%ScreenDim): " @ %ScreenDim);

	if (%value == "exit")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Exiting and saving Preferences.");

		if ((%type == "ctfloc") || (%type == "ctfxy"))
		{
			$HyperPref::FlagPos = $Hyper::NewFlagPos;
			if ($HHDEBUG)
				Hyper::DEBUG("$HyperPref::FlagPos: " @ $HyperPref::FlagPos);
			$Hyper::NewFlagPos = "";
		}
		else if ((%type == "genloc") || (%type == "genxy"))
		{
			$HyperPref::GenPos = $Hyper::NewGenPos;
			if ($HHDEBUG)
				Hyper::DEBUG("$HyperPref::GenPos: " @ $HyperPref::GenPos);
			$Hyper::NewGenPos = "";
		}
		else if (%type == "pack")
		{
			$HyperPref::PackPos = $Hyper::NewPackPos;
			if ($HHDEBUG)
				Hyper::DEBUG("$HyperPref::PackPos: " @ $HyperPref::PackPos);
			$Hyper::NewPackPos = "";
		}

		Hyper::UpdatePrefs("normal");

		if ($HHDEBUG)
			Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);

		return;
	}
	else if (%type == "ctfxy")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing x/y position of CTF HUDs.");

		if (getWord(%value, 0) == "x")
			%FlagXPos = getWord(%value, 1);
		else if (getWord(%value, 0) == "y")
			%FlagYPos = getWord(%value, 1);
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("flagloc");
			%FlagXPos = getWord($HyperPref::FlagPos, 0);
			%FlagYPos = getWord($HyperPref::FlagPos, 1);
		}
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		if (%value != "default")
		{
			%HUD1x = HUD::GetCoordValue(hudHHCTFHome, 0);
			%HUD1y = HUD::GetCoordValue(hudHHCTFHome, 1);
			%HUD2x = HUD::GetCoordValue(hudHHCTFEnemy, 0);
			%HUD2y = HUD::GetCoordValue(hudHHCTFEnemy, 1);

			if (((%FlagXPos + %HUD1x) < 0) || ((%FlagXPos + %HUD2x) > (%ScreenWidth - HUD::Width(hudHHCTFEnemy))))
				%FlagXPos = 0;

			%FlagXPos += %HUD1x;

			if (((%FlagYPos + %HUD1y) < 0) || ((%FlagYPos + %HUD2y) > (%ScreenHeight - HUD::Height(hudHHCTFEnemy))))
				%FlagYPos = 0;

			%FlagYPos += %HUD1y;
		}

		$Hyper::NewFlagPos = %FlagXPos @ " " @ %FlagYPos;

		Hyper::MakeNewHUDs(false, "ctf", %FlagXPos, %FlagYPos);
		Menu::SetTitle(menuHHCTFxy, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
		Menu::Display(menuHHCTFxy);
	}
	else if (%type == "ctfloc")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing location of CTF HUDs.");

		$HyperPref::FlagHUDLoc = %value;

		if (%value == "left")
		{
			%FlagXPos = 0;
			%FlagYPos = "25%";
		}
		else if (%value == "right")
		{
			%FlagXPos = "100%";
			%FlagYPos = "25%";
		}
		else if (%value == "top")
		{
			%FlagXPos = "50%";
			%FlagYPos = "0";
		}
		else if (%value == "bottom")
		{
			%FlagXPos = "0";
			%FlagYPos = "100%";
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("flagloc");
			%FlagXPos = getWord($HyperPref::FlagPos, 0);
			%FlagYPos = getWord($HyperPref::FlagPos, 1);
		}
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}
		$Hyper::NewFlagPos = %FlagXPos @ " " @ %FlagYPos;

		Hyper::MakeNewHUDs(false, "ctf", %FlagXPos, %FlagYPos);
		Menu::SetTitle(menuHHCTFLoc, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
		Menu::Display(menuHHCTFLoc);
	}
	else if (%type == "genxy")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing x/y position of general HUDs.");

		if (getWord(%value, 0) == "x")
			%GenXPos = getWord(%value, 1);
		else if (getWord(%value, 0) == "y")
			%GenYPos = getWord(%value, 1);
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("genloc");
			%GenXPos = getWord($HyperPref::GenPos, 0);
			%GenYPos = getWord($HyperPref::GenPos, 1);
		}
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		if (%value != "default")
		{
			%HUD1x = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 0);");
			%HUD1y = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 1);");
			if ($HyperPref::NumGenHUDs < $HyperPref::HUDsPerLine)
				%HUD2x = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::NumGenHUDs - 1], "label") @ ", 0);");
			else
				%HUD2x = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::HUDsPerLine - 1], "label") @ ", 0);");
			%HUD2y = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::NumGenHUDs - 1], "label") @ ", 1);");

			if (((%GenXPos + %HUD1x) < 0) || ((%GenXPos + %HUD2x) > (%ScreenWidth - HUD::Width(Hyper::GetHUDInfo($HyperPref::Gen[0], "label")))))
				%GenXPos = 0;

			%GenXPos += %HUD1x;

			if (((%GenYPos + %HUD1y) < 0) || ((%GenYPos + %HUD2y) > (%ScreenHeight - HUD::Height(Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::NumGenHUDs - 1], "label")))))
				%GenYPos = 0;

			%GenYPos += %HUD1y;
		}

		$Hyper::NewGenPos = %GenXPos @ " " @ %GenYPos;

		Hyper::MakeNewHUDs(false, "gen", %GenXPos, %GenYPos);
		Menu::SetTitle(menuHHGenxy, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
		Menu::Display(menuHHGenxy);
	}
	else if (%type == "genloc")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing location of general HUDs.");

		$HyperPref::GenHUDLoc = %value;

		if (%value == "left")
		{
			%GenXPos = 0;
			%GenYPos = "25%";
		}
		else if (%value == "right")
		{
			%GenXPos = "100%";
			%GenYPos = "25%";
		}
		else if (%value == "top")
		{
			%GenXPos = "50%";
			%GenYPos = "0";
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("genloc");
			%GenXPos = getWord($HyperPref::GenPos, 0);
			%GenYPos = getWord($HyperPref::GenPos, 1);
		}
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		$Hyper::NewGenPos = %GenXPos @ " " @ %GenYPos;

		Hyper::MakeNewHUDs(false, "gen", %GenXPos, %GenYPos);
		Menu::SetTitle(menuHHGenLoc, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
		Menu::Display(menuHHGenLoc);
	}
	else if (%type == "perline")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing general HUDs per line.");

		if ((%value == -1) || (%value == 1))
		{
			$HyperPref::HUDsPerLine += %value;
			if ($HyperPref::HUDsPerLine < 1)
				$HyperPref::HUDsPerLine = 1;
		}
		else if (%value == "default")
			Hyper::DefaultPrefs("perline");
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		if ($HyperPref::GenHUDLoc == "top")
		{
			if ($Hyper::NewGenPos != "")
			{
				%GenXPos = getWord($Hyper::NewGenPos, 0);
				%GenYPos = getWord($Hyper::NewGenPos, 1);
			}
			else
			{
				%GenXPos = getWord($HyperPref::GenPos, 0);
				%GenYPos = getWord($HyperPref::GenPos, 1);
			}
			Hyper::MakeNewHUDs(false, "gen", %GenXPos, %GenYPos);
		}
		Menu::SetTitle(menuHHPerLine, "Gen. HUDs Per Line:  " @ $HyperPref::HUDsPerLine);
		Menu::SetText(menuHHGenCfg, 12, "dHUDs Per Line:  " @ $HyperPref::HUDsPerLine);
		Menu::Display(menuHHPerLine);
	}
	else if (%type == "gencfg")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing general HUD configuration.");

		%new = false;

		if (%value == "TC")
		{
			$HyperPref::ShowTC = !$HyperPref::ShowTC;
			%tmp = $HyperPref::ShowTC;
		}
		else if (%value == "TK")
		{
			$HyperPref::ShowTK = !$HyperPref::ShowTK;
			%tmp = $HyperPref::ShowTK;
		}
		else if (%value == "TD")
		{
			$HyperPref::ShowTD = !$HyperPref::ShowTD;
			%tmp = $HyperPref::ShowTD;
		}
		else if (%value == "TT")
		{
			$HyperPref::ShowTT = !$HyperPref::ShowTT;
			%tmp = $HyperPref::ShowTT;
		}
		else if (%value == "observer")
		{
			$HyperPref::ShowObserver = !$HyperPref::ShowObserver;
			%tmp = $HyperPref::ShowObserver;
		}
		else if (%value != "default")
		{
			if (Hyper::CheckGenHUDs(%value))
			{
				eval("HUD::Display(" @ Hyper::GetHUDInfo(%value, "label") @ ", false);");
				for (%j = $Hyper::index; %j < $Hyper::c; %j++)
					$HyperPref::Gen[%j] = $HyperPref::Gen[%j + 1];
				$HyperPref::Gen[%j] = "";
				$HyperPref::NumGenHUDs--;
				$Hyper::c--;
				%tmp = Hyper::CheckGenHUDs(%value);
			}
			else
			{
				$HyperPref::Gen[$Hyper::c++] = %value;
				$HyperPref::NumGenHUDs++;
				%new = true;
				%tmp = Hyper::CheckGenHUDs(%value);
			}
		}
		else
		{
			$Hyper::c = -1;
			Hyper::DefaultPrefs("gencfg");
			Hyper::DefaultPrefs("perline");
			for (%i = 0; %i < $Hyper::GenNum; %i++)
			{
				if (%i < ($Hyper::GenNum - 1))
					%tmp = "Show " @ $Hyper::GenCfgMsg[%i] @ ":  " @ eval("Hyper::GetMode(" @ $Hyper::GenCfgVal[%i] @ ");");
				else
					%tmp = $Hyper::GenCfgMsg[%i] @ ":  " @ $HyperPref::HUDsPerLine;
				Menu::SetText(menuHHGenCfg, %i, %tmp);
			}
		}

		Hyper::MakeNewHUDs(%new, "gen", getWord($HyperPref::GenPos, 0), getWord($HyperPref::GenPos, 1));
		if (%new)
			eval("HUD::Display(" @ Hyper::GetHUDInfo(%value, "label") @ ");");
		else if (%value == "default")
			for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
				eval("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");");
		Hyper::ResetHUDs();
		if (%value != "default")
			Menu::SetText(menuHHGenCfg, %choice, "Show " @ $Hyper::GenCfgMsg[%choice] @ ":  " @ Hyper::GetMode(%tmp));
		Menu::Display(menuHHGenCfg);
	}
	else if (%type == "pack")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing backpack HUD configuration.");

		if ($Hyper::NewPackPos != "")
		{
			%PackXPos = getWord($Hyper::NewPackPos, 0);
			%PackYPos = getWord($Hyper::NewPackPos, 1);
		}
		else
		{
			%PackXPos = getWord($HyperPref::PackPos, 0);
			%PackYPos = getWord($HyperPref::PackPos, 1);
		}

		%new = false;

		if (%value == "show")
		{
			$HyperPref::ShowPack = !$HyperPref::ShowPack;
			if (!HUD::Exists(hudPack) && $HyperPref::ShowPack)
				%new = true;
			else if (HUD::GetDisplayed(hudPack) && !$HyperPref::ShowPack)
				HUD::Display(hudPack, false);
		}
		else if (getWord(%value, 0) == "y")
		{
			%YPos = getWord(%value, 1);
			if (((%YPos + %PackYPos) < 0) || ((%YPos + %PackYPos) > (%ScreenHeight - HUD::Height(hudPack))))
				%YPos = 0;
			%PackYPos += %YPos;
		}
		else if (%value == "center")
		{
			%PackXPos = "50%";
		}
		else if (%value == "left")
		{
			%PackXPos = 0;
		}
		else if (%value == "right")
		{
			%PackXPos = "100%";
		}
		else if (%value == "top")
		{
			%PackYPos = 0;
		}
		else if (%value == "bottom")
		{
			%PackYPos = "100%";
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("pack");
			%PackXPos = getWord($HyperPref::PackPos, 0);
			%PackYPos = getWord($HyperPref::PackPos, 1);
		}
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		$Hyper::NewPackPos = %PackXPos @ " " @ %PackYPos;

		if ($HyperPref::ShowPack)
		{
			Hyper::MakeNewHUDs(%new, "pack", %PackXPos, %PackYPos);
			Hyper::UpdateBackpack();
		}
		Menu::SetText(menuHHPackCfg, 0, "Show Backpack:  " @ Hyper::GetMode($HyperPref::ShowPack));
		Menu::Display(menuHHPackCfg);
	}
	else if (%type == "outnumber")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing player outnumber value.");

		if ((%value == -1) || (%value == 1))
		{
			$HyperPref::Outnumber += %value;
			if ($HyperPref::Outnumber < 1)
				$HyperPref::Outnumber = 1;
		}
		else if (%value == "default")
			Hyper::DefaultPrefs("outnumber");
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		Menu::SetTitle(menuHHOutnumber, "Outnumbered by:  " @ $HyperPref::Outnumber);
		Menu::SetText(menuHHMisc, 6, "Outnumbered by:  " @ $HyperPref::Outnumber);
		Menu::Display(menuHHOutnumber);
	}
	else if (%type == "misc")
	{
		if ($HHDEBUG)
			Hyper::DEBUG("Changing miscellaneous item configurations.");

		if (%value == "victim")
		{
			$HyperPref::ShowVictim = !$HyperPref::ShowVictim;
			%value = $HyperPref::ShowVictim;
		}
		else if (%value == "killer")
		{
			$HyperPref::ShowKiller = !$HyperPref::ShowKiller;
			%value = $HyperPref::ShowKiller;
		}
		else if (%value == "autostart")
		{
			$HyperPref::AutoStart = !$HyperPref::AutoStart;
			%value = $HyperPref::AutoStart;
		}
		else if (%value == "genstart")
		{
			$HyperPref::GenStart = !$HyperPref::GenStart;
			%value = $HyperPref::GenStart;
		}
		else if (%value == "debug")
		{
			$HyperPref::DEBUG = !$HyperPref::DEBUG;
			$HHDEBUG = $HyperPref::DEBUG;
			$HHIndent = 0;
			if ($HHDEBUG)
				Hyper::ProcessDebug();
			%value = $HyperPref::DEBUG;
		}
		else if (%value == "balance")
		{
			$HyperPref::BalanceNotify = !$HyperPref::BalanceNotify;
			%value = $HyperPref::BalanceNotify;
		}
		else if (%value == "return")
		{
			$HyperPref::FlagReturnTime = !$HyperPref::FlagReturnTime;
			%value = $HyperPref::FlagReturnTime;
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("misc");
			$HHDEBUG = $HyperPref::DEBUG;
			$HHIndent = 0;
			Hyper::DefaultPrefs("outnumber");
			for (%i = 0; %i < $Hyper::MiscNum; %i++)
			{
				%tmp = $Hyper::MiscMsg[%i];
				if (%i < ($Hyper::MiscNum - 1))
					%tmp = %tmp @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");");
				else
					%tmp = %tmp @ $HyperPref::Outnumber;
				Menu::SetText(menuHHMisc, %i, %tmp);
			}
		}
		else
		{
			if ($HHDEBUG)
				Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
			return;
		}

		if (%value != "default")
			Menu::SetText(menuHHMisc, %choice, $Hyper::MiscMsg[%choice] @ ":  " @ Hyper::GetMode(%value));
		Menu::Display(menuHHMisc);
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::ProcessMenu", -3);
}

function Hyper::MakeMenus()
{
	if ($HHDEBUG)
	{
		Hyper::DEBUG("Hyper::MakeMenus()", 3);
		Hyper::DEBUG("Menu::New(menuHHCTFxy, CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos @ ")");
	}

	Menu::New(menuHHCTFxy, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
	Menu::AddChoice(menuHHCTFxy, "1Increase x Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"x 1\");");
	Menu::AddChoice(menuHHCTFxy, "2Increase x Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"x 10\");");
	Menu::AddChoice(menuHHCTFxy, "3Decrease x Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"x -1\");");
	Menu::AddChoice(menuHHCTFxy, "4Decrease x Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"x -10\");");
	Menu::AddChoice(menuHHCTFxy, "5Increase y Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"y 1\");");
	Menu::AddChoice(menuHHCTFxy, "6Increase y Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"y 10\");");
	Menu::AddChoice(menuHHCTFxy, "7Decrease y Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"y -1\");");
	Menu::AddChoice(menuHHCTFxy, "8Decrease y Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"y -10\");");
	Menu::AddChoice(menuHHCTFxy, "xDEFAULTS", "Hyper::ProcessMenu(\"ctfxy\", \"default\");");
	Menu::AddChoice(menuHHCTFxy, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"ctfxy\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHCTFLoc, CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos @ ")");

	Menu::New(menuHHCTFLoc, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
	Menu::AddChoice(menuHHCTFLoc, "1Left Side of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"left\");");
	Menu::AddChoice(menuHHCTFLoc, "2Right Side of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"right\");");
	Menu::AddChoice(menuHHCTFLoc, "3Top of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"top\");");
	Menu::AddChoice(menuHHCTFLoc, "4Bottom of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"bottom\");");
	Menu::AddMenu(menuHHCTFLoc, "5Move by X/Y Position", menuHHCTFxy);
	Menu::AddChoice(menuHHCTFLoc, "xDEFAULTS", "Hyper::ProcessMenu(\"ctfloc\", \"default\");");
	Menu::AddChoice(menuHHCTFLoc, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"ctfloc\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHGenxy, Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos @ ")");

	Menu::New(menuHHGenxy, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
	Menu::AddChoice(menuHHGenxy, "1Increase x Position 1", "Hyper::ProcessMenu(\"genxy\", \"x 1\");");
	Menu::AddChoice(menuHHGenxy, "2Increase x Position 10", "Hyper::ProcessMenu(\"genxy\", \"x 10\");");
	Menu::AddChoice(menuHHGenxy, "3Decrease x Position 1", "Hyper::ProcessMenu(\"genxy\", \"x -1\");");
	Menu::AddChoice(menuHHGenxy, "4Decrease x Position 10", "Hyper::ProcessMenu(\"genxy\", \"x -10\");");
	Menu::AddChoice(menuHHGenxy, "5Increase y Position 1", "Hyper::ProcessMenu(\"genxy\", \"y 1\");");
	Menu::AddChoice(menuHHGenxy, "6Increase y Position 10", "Hyper::ProcessMenu(\"genxy\", \"y 10\");");
	Menu::AddChoice(menuHHGenxy, "7Decrease y Position 1", "Hyper::ProcessMenu(\"genxy\", \"y -1\");");
	Menu::AddChoice(menuHHGenxy, "8Decrease y Position 10", "Hyper::ProcessMenu(\"genxy\", \"y -10\");");
	Menu::AddChoice(menuHHGenxy, "xDEFAULTS", "Hyper::ProcessMenu(\"genxy\", \"default\");");
	Menu::AddChoice(menuHHGenxy, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"genxy\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHGenLoc, Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos @ ")");

	Menu::New(menuHHGenLoc, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
	Menu::AddChoice(menuHHGenLoc, "1Left Side of Screen", "Hyper::ProcessMenu(\"genloc\", \"left\");");
	Menu::AddChoice(menuHHGenLoc, "2Right Side of Screen", "Hyper::ProcessMenu(\"genloc\", \"right\");");
	Menu::AddChoice(menuHHGenLoc, "3Top of Screen", "Hyper::ProcessMenu(\"genloc\", \"top\");");
	Menu::AddMenu(menuHHGenLoc, "4Move by X/Y Position", menuHHGenxy);
	Menu::AddChoice(menuHHGenLoc, "xDEFAULTS", "Hyper::ProcessMenu(\"genloc\", \"default\");");
	Menu::AddChoice(menuHHGenLoc, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"genloc\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHPerLine, Gen. HUDs Per Line:  " @ $HyperPref::HUDsPerLine @ ")");

	Menu::New(menuHHPerLine, "Gen. HUDs Per Line:  " @ $HyperPref::HUDsPerLine);
	Menu::AddChoice(menuHHPerLine, "1Increase", "Hyper::ProcessMenu(\"perline\", 1);");
	Menu::AddChoice(menuHHPerLine, "2Decrease", "Hyper::ProcessMenu(\"perline\", -1);");
	Menu::AddChoice(menuHHPerLine, "xDEFAULT", "Hyper::ProcessMenu(\"perline\", \"default\");");
	Menu::AddChoice(menuHHPerLine, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"perline\", \"exit\");");

	%i = -1;

	$Hyper::GenCfgMsg[%i++] = "Flag Captures";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Caps\")";
	$Hyper::GenCfgMsg[%i++] = "Kills";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Kills\")";
	$Hyper::GenCfgMsg[%i++] = "Deaths";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Deaths\")";
	$Hyper::GenCfgMsg[%i++] = "Mines";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Mines\")";
	$Hyper::GenCfgMsg[%i++] = "Grenades";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Grenades\")";
	$Hyper::GenCfgMsg[%i++] = "Repair Kit";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Repair\")";
	$Hyper::GenCfgMsg[%i++] = "Beacons";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Beacon\")";
	$Hyper::GenCfgMsg[%i++] = "Player Count";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Players\")";
	$Hyper::GenCfgMsg[%i++] = "Play Time";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"PlayTime\")";
	$Hyper::GenCfgMsg[%i++] = "Total Caps";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTC";
	$Hyper::GenCfgMsg[%i++] = "Total Kills";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTK";
	$Hyper::GenCfgMsg[%i++] = "Total Deaths";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTD";
	$Hyper::GenCfgMsg[%i++] = "Observers";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowObserver";
	$Hyper::GenCfgMsg[%i++] = "Total Time";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTT";
	$Hyper::GenCfgMsg[%i++] = "Gen. HUDs Per Line:";
	$Hyper::GenCfgKey = "a b c d e f g h i j k l m n o";
	$Hyper::GenCfgType = "Caps Kills Deaths Mines Grenades Repair Beacon Players PlayTime TC TK TD observer TT";
	$Hyper::GenNum = %i + 1;

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHGenCfg, General HUD Config)");

	Menu::New(menuHHGenCfg, "General HUD Config");
	for (%j = 0; %j < ($Hyper::GenNum - 1); %j++)
		Menu::AddChoice(menuHHGenCfg, getWord($Hyper::GenCfgKey, %j) @ "Show " @ $Hyper::GenCfgMsg[%j] @ ":  " @ eval("Hyper::GetMode(" @ $Hyper::GenCfgVal[%j] @ ");"), "Hyper::ProcessMenu(\"gencfg\", \"" @ getWord($Hyper::GenCfgType, %j) @ "\", " @ %j @ ");");
	Menu::AddMenu(menuHHGenCfg, getWord($Hyper::GenCfgKey, %j) @ $Hyper::GenCfgMsg[%j] @ ":  " @ $HyperPref::HUDsPerLine, menuHHPerLine);
	Menu::AddChoice(menuHHGenCfg, "xDEFAULTS", "Hyper::ProcessMenu(\"gencfg\", \"default\");");
	Menu::AddChoice(menuHHGenCfg, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"gencfg\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHPackCfg, BackPack Configuration)");

	Menu::New(menuHHPackCfg, "BackPack Configuration");
	Menu::AddChoice(menuHHPackCfg, "1Show Backpack:  " @ Hyper::GetMode($HyperPref::ShowPack), "Hyper::ProcessMenu(\"pack\", \"show\");");
	Menu::AddChoice(menuHHPackCfg, "2Center", "Hyper::ProcessMenu(\"pack\", \"center\");");
	Menu::AddChoice(menuHHPackCfg, "3Left Side", "Hyper::ProcessMenu(\"pack\", \"left\");");
	Menu::AddChoice(menuHHPackCfg, "4Right Side", "Hyper::ProcessMenu(\"pack\", \"right\");");
	Menu::AddChoice(menuHHPackCfg, "5Top Side", "Hyper::ProcessMenu(\"pack\", \"top\");");
	Menu::AddChoice(menuHHPackCfg, "6Bottom Side", "Hyper::ProcessMenu(\"pack\", \"bottom\");");
	Menu::AddChoice(menuHHPackCfg, "7Increase y Position 1", "Hyper::ProcessMenu(\"pack\", \"y 1\");");
	Menu::AddChoice(menuHHPackCfg, "8Increase y Position 10", "Hyper::ProcessMenu(\"pack\", \"y 10\");");
	Menu::AddChoice(menuHHPackCfg, "9Decrease y Position 1", "Hyper::ProcessMenu(\"pack\", \"y -1\");");
	Menu::AddChoice(menuHHPackCfg, "0Decrease y Position 10", "Hyper::ProcessMenu(\"pack\", \"y -10\");");
	Menu::AddChoice(menuHHPackCfg, "xDEFAULTS", "Hyper::ProcessMenu(\"pack\", \"default\");");
	Menu::AddChoice(menuHHPackCfg, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"pack\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHOutnumber, Outnumbered by:  " @ $HyperPref::Outnumber @ ")");

	Menu::New(menuHHOutnumber, "Outnumbered by:  " @ $HyperPref::Outnumber);
	Menu::AddChoice(menuHHOutnumber, "1Increase", "Hyper::ProcessMenu(\"outnumber\", 1);");
	Menu::AddChoice(menuHHOutnumber, "2Decrease", "Hyper::ProcessMenu(\"outnumber\", -1);");
	Menu::AddChoice(menuHHOutnumber, "xDEFAULT", "Hyper::ProcessMenu(\"outnumber\", \"default\");");
	Menu::AddChoice(menuHHOutnumber, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"outnumber\", \"exit\");");

	%i = -1;

	$Hyper::MiscMsg[%i++] = "Show Victim";
	$Hyper::MiscVal[%i] = "$HyperPref::ShowVictim";
	$Hyper::MiscMsg[%i++] = "Show Killer";
	$Hyper::MiscVal[%i] = "$HyperPref::ShowKiller";
	$Hyper::MiscMsg[%i++] = "HyperHUD AutoStart";
	$Hyper::MiscVal[%i] = "$HyperPref::AutoStart";
	$Hyper::MiscMsg[%i++] = "General AutoStart";
	$Hyper::MiscVal[%i] = "$HyperPref::GenStart";
	$Hyper::MiscMsg[%i++] = "DEBUG";
	$Hyper::MiscVal[%i] = "$HyperPref::DEBUG";
	$Hyper::MiscMsg[%i++] = "Team Balance Notify";
	$Hyper::MiscVal[%i] = "$HyperPref::BalanceNotify";
	$Hyper::MiscMsg[%i++] = "Flag Return Time";
	$Hyper::MiscVal[%i] = "$HyperPref::FlagReturnTime";
	$Hyper::MiscMsg[%i++] = "Outnumbered by";
	$Hyper::MiscCfgType = "victim killer autostart genstart debug balance return";
	$Hyper::MiscNum = %i + 1;

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHMisc, Miscellaneous Config)");

	Menu::New(menuHHMisc, "Miscellaneous Config");
	for (%j = 0; %j < ($Hyper::MiscNum - 1); %j++)
		Menu::AddChoice(menuHHMisc, (%j + 1) @ $Hyper::MiscMsg[%j] @ ":  " @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%j] @ ");"), "Hyper::ProcessMenu(\"misc\", \"" @ getWord($Hyper::MiscCfgType, %j) @ "\", " @ %j @ ");");
	Menu::AddMenu(menuHHMisc, (%j + 1) @ $Hyper::MiscMsg[%j] @ ":  " @ $HyperPref::Outnumber, menuHHOutnumber);
	Menu::AddChoice(menuHHMisc, "xDEFAULTS", "Hyper::ProcessMenu(\"misc\", \"default\");");
	Menu::AddChoice(menuHHMisc, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"misc\", \"exit\");");

	if ($HHDEBUG)
		Hyper::DEBUG("Menu::New(menuHHMain, HyperHUD Preferences)");

	Menu::New(menuHHMain, "HyperHUD Preferences");
	Menu::AddMenu(menuHHMain, "1CTF HUD Location", menuHHCTFLoc);
	Menu::AddMenu(menuHHMain, "2General HUD Location", menuHHGenLoc);
	Menu::AddMenu(menuHHMain, "3General HUD Config", menuHHGenCfg);
	Menu::AddMenu(menuHHMain, "4Backpack HUD Config", menuHHPackCfg);
	Menu::AddMenu(menuHHMain, "5Miscellaneous Config", menuHHMisc);
	Menu::AddChoice(menuHHMain, "xEXIT", "");

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting Hyper::MakeMenus", -3);
}


// Below are our NEW event triggered client functions.

// ===============================================================================================
//  Function: throwRelease
//
//  Purpose: Determine if we have thrown an object.
// ===============================================================================================
function throwRelease(%desc)
{
	if ($HHDEBUG)
		Hyper::DEBUG("throwRelease(" @ %desc @ ")", 3);

	%type = getItemType(%desc);
	if (%type != -1) {
		%delta = getSimTime() - $throwStartTime;
		if (%delta > 1)
			%delta = 100;
		else
			%delta = floor(%delta * 100);
		remoteEval(2048,throwItem,%type,%delta);

		Event::Trigger(eventThrowRelease, %desc);	// Added this trigger for event use.

	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting throwRelease", -3);
}

// ===============================================================================================
//  Function: use
//
//  Purpose: Determine if we have used an item.
// ===============================================================================================
function use(%desc)
{
	if ($HHDEBUG)
		Hyper::DEBUG("use(" @ %desc @ ")", 3);

	%type = getItemType(%desc);
	if (%type != -1) {
		useItem(%type);
		Event::Trigger(eventUse, %desc);	// Added this trigger for event use.
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting use", -3);
}

function drop(%desc)
{
	if ($HHDEBUG)
		Hyper::DEBUG("drop(" @ %desc @ ")", 3);

	%type = getItemType(%desc);
	if (%type != -1) {
		remoteEval(2048,dropItem,%type);
		Event::Trigger(eventDrop, %desc);	// Added this trigger for event use.
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}

	if ($HHDEBUG)
		Hyper::DEBUG("Exiting drop", -3);
}

// Events
if (Hyper::CheckGenHUDs("Players"))
{
	if ($HHDEBUG)
		Hyper::DEBUG("Event::Attach(eventConnectionAccepted, Hyper::FindClient)");
	Event::Attach(eventConnectionAccepted, Hyper::FindClient);	// Initialize and find the last known client.
}

if ($HHDEBUG)
{
	Hyper::DEBUG("Event::Attach(eventConnectionAccepted, Hyper::Reset)");
	Hyper::DEBUG("Event::Attach(eventChangeMission, Hyper::Reset)");
	Hyper::DEBUG("Event::Attach(eventClientChangeTeam, Hyper::onClientChangeTeam)");
	Hyper::DEBUG("Event::Attach(eventExit, Hyper::ProcessTotalTime)");
}
Event::Attach(eventConnectionAccepted, Hyper::ResetAll);		// Execute our Reset function upon a first-time connection to a server.
Event::Attach(eventChangeMission, Hyper::Reset);			// Also execute the Reset function upon a server-side mission change.
Event::Attach(eventClientChangeTeam, Hyper::onClientChangeTeam);	// See if we have switched teams during gameplay.
Event::Attach(eventExit, Hyper::ProcessTotalTime);

if ($HHDEBUG)
{
	Hyper::DEBUG("bindkey(play, " @ $HyperPref::Toggle @ ", Hyper::Toggle(\"default\");)");
	Hyper::DEBUG("bindkey(play, " @ $HyperPref::PrefToggle @ ", Menu::Display(menuHHMain);)");
}
bindkey(play, $HyperPref::Toggle, "Hyper::Toggle(\"default\");");
bindkey(play, $HyperPref::PrefToggle, "Menu::Display(menuHHMain);");

if ($HHDEBUG)
	Hyper::DEBUG("$HyperPref::AutoStart: " @ $HyperPref::AutoStart);
if ($HyperPref::AutoStart)
	Hyper::Toggle("default");					// Automatically start HyperHUD according to user preference.
