// ============================================================================
// File:				daeHUD.cs
// Author:			Bryan "daerid" Ross
// Date:				2/1/2001
// Version:			1.02
// Description: My CTF style hud from my personal config, ported over to work
//              with MrPoop's Stripped.
// 
// Credits:  =V=z0dd, for his amazing z0dd_hud.cs, which is what got me into scripting.
//                  MrPoop, for his awesome Stripped Pack, which is by far the best all-around script
//                  pack I have ever seen.
// 
// Installation: 
// 
// Just plop this file right into your Tribes\Config directory, and add this line to your autoexec.cs
// after the line 'exec("Stripped.cs");':
// 
// exec("daeHUD.cs");
// 
// That's all there is to it.
// ============================================================================

// ============================================================================
// VERSION HISTORY:
// 
//  1.02  Added the Enemy and Friendly Home locations to the User Config section, and (hopefully) fixed the bug 
//            where the hud wouldn't show some characters.
// 
//  1.01  Fixed a bug that was causing the dropped flag timer to stay at 1 when the flag was returned by timeout.
// 
// ============================================================================

// ============================================================================
// USER CONFIG SECTION
// ============================================================================
// Set this to 1 to have the hud displayed by default
$daeHUD::AutoStart = 1;

//Set the location of the hud here.
$daeHUD::Left = 0;
$daeHUD::Top = 0;

// Key to toggle hud on/off
$daehud::ToggleHud = "control d";

// Key to manually reset hud 
$daeHUD::ResetKey = "control r";

// Set this to 1 if you want transparent huds
$daeHUD::Transparent = 0;

// Set this to the key you want to toggle transparency on/off with.
$daeHUD::ToggleTrans = "control t";

// Set this to what you want to display when the flag is at the base.
$daeHUD::FriendlyHome = "Home";
$daeHUD::EnemyHome = "Home";

// These are used when you join a server
// in the middle of a game to get the 
// hud up to date

// Key to add friendly point
$daeHUD::AddFriendlyPoint = "control numpad+";
// Key to subtract a friendly point
$daeHUD::SubFriendlyPoint = "control numpad-";

// Key to add enemy point
$daeHUD::AddEnemyPoint = "alt numpad+";
// Key to sub enemy point
$daeHUD::SubEnemyPoint = "alt numpad-";
// ============================================================================
// SCRIPTING SECTION
// ============================================================================


// ============================================================================
// bind user keys
keybind($daeHUD::ToggleHud,"daeHUD::ToggleHud();");
keybind($daeHUD::ResetKey,"daeHUD::reset();");
keybind($daeHUD::AddFriendlyPoint,"daeHUD::AddScore(\"friendly\",1);");
keybind($daeHUD::SubFriendlyPoint,"daeHUD::AddScore(\"friendly\",-1);");
keybind($daeHUD::AddEnemyPoint,"daeHUD::AddScore(\"enemy\",1);");
keybind($daeHUD::SubEnemyPoint,"daeHUD::AddScore(\"enemy\",-1);");
keybind($daeHUD::ToggleTrans,"daeHUD::ToggleTrans();");
// ============================================================================

// %1 = $daeHUD::OurScore;
// %2 = $daeHUD::EnemyScore;
// %3 = $daeHUD::OurFlagCarrier;
// %4 = $daeHUD::EnemyFlagCarrier;
// %5 = OurFlagIcon
// %6 = TheirFlagIcon


function daeHUD::GetText()
{
  %text = "<F2><B0,0:daerid\\F%5.bmp><L4>\t%3\n\t%1\n\n<B-20,0:daerid\\E%6.bmp><L4>\t%4\n\t%2";
  if ($daeHUD::OurFlagCarrier == $daeHUD::FriendlyHome)
    %FIcon = "home";
  else
    %FIcon = "away";
  if ($daeHUD::EnemyFlagCarrier == $daeHUD::EnemyHome)
    %EIcon = "home";
  else
    %EIcon = "away";
  return sprintf(%text,$daeHUD::OurScore+0,$daeHUD::EnemyScore+0,daeHUD::MakeLegal($daeHUD::OurFlagCarrier),daeHUD::MakeLegal($daeHUD::EnemyFlagCarrier),%FIcon,%EIcon);
}

// This function just replaces all the <'s and >'s with _'s so that the tribes
// engine doesn't think they're markup tags and make the hud look all weird.
function daeHUD::MakeLegal(%text)
{
  %text = daeHUD::Replace(%text,"<","<<");
  %text = daeHUD::Replace(%text,"\\","\\\\");
  return escapestring(%text);
}

function daeHUD::replace(%string, %search, %replace)    
{
  while ((%idx=String::FindSubStr(%string,%search))!=-1)
  {
    %left = %left @ String::GetSubStr(%string,0,%idx) @ %replace;
    %string = String::GetSubStr(%string,%idx+String::Len(%search),String::Len(%string));
  }
  %left = %left @ %string;
  return %left;
}

function daeHUD::Init()
{
	// Let's create some gui objects, shall we?
  $daeHUD::Cont = newObject(daeHUD,SimGui::Control,$daeHUD::Top, $daeHUD::Left,140,70);
  $daeHUD::BG = newObject(daeHUD_BG,FearGui::FearGuiMenu,0,0,140,70);
  $daeHUD::TextObj = newObject(daeHUD_Text,FearGuiFormattedText,3,-1,1000,72);

  // OK, add the BG and Text Objects to the Container.
  addToSet($daeHUD::Cont,$daeHUD::BG);
  addToSet($daeHUD::Cont,$daeHUD::TextObj);
  
	// If the hud is off by default, set the whole group's visibility to "FALSE"
  if (!$daeHUD::AutoStart)
		Control::SetVisible(daeHUD,"FALSE");
  // If the hud is transparent, then set the background object's visibility to "FALSE"
  if ($daeHUD::Transparent)
    Control::SetVisible(daeHUD_BG,"FALSE");

	$daeHUD::Loaded = "TRUE";
}
if ($daeHUD::Loaded!="TRUE")
	daeHUD::Init();

function daeHUD::Attach()
{
  // Set the initial text.
  daeHUD::Update();
  // Add the hud to the playscreen.
  addToSet(playGui,$daeHUD::Cont);
}
Event::Attach(eventPlayGuiCreated,daeHUD::Attach);

function daeHUD::Destroy()
{
  // Clean up the hud so it doesn't stick to our playGui
  removeFromSet(PlayGui,$daeHUD::Cont);
  deleteObject($daeHUD::Cont);
}
Event::Attach(eventExit,daeHUD::Destroy);

// The ever-popular Update() function :)
function daeHUD::Update()
{
	Control::SetValue(daeHUD_Text,daeHUD::GetText());
}

// The not-quite-as-popular-as-the-Update-function Reset() function
function daeHUD::reset()
{
	$daeHUD::OurScore = 0;
	$daeHUD::EnemyScore = 0;	
	$daeHUD::OurFlagCarrier = $daeHUD::FriendlyHome;
	$daeHUD::EnemyFlagCarrier = $daeHUD::EnemyHome;
	daeHUD::Update();
}
Event::Attach(eventConnectionAccepted, daeHUD::reset);
Event::Attach(eventChangeMission, daeHUD::reset);

// Flag has been grabbed, so set the appropriate variables, and Update the hud
function daeHUD::FlagGrab(%name, %team)
{
		if(%team == $MyTeam)
			$daeHUD::OurFlagCarrier = %name;
		else
			$daeHUD::EnemyFlagCarrier = %name;
		daeHUD::Update();
}
Event::Attach(eventFlagGrabbed,daeHUD::FlagGrab);


// Flag dropped, so do the countdown thingy.
function daeHUD::FlagTimer(%team, %status)
{
  if (%team == $MyTeam)
    $daeHUD::OurFlagCarrier = "DROPPED "@%status;
  else
    $daeHUD::EnemyFlagCarrier = "DROPPED "@%status;
  daeHUD::Update();
}
Event::Attach(EventFlagTimerUpdate,daeHUD::FlagTimer);

// Flag returned, so clear the Carrier for that flag.
function daeHUD::FlagReturn(%name,%team)
{
	if (%team == $MyTeam) 
		$daeHUD::OurFlagCarrier = $daeHUD::FriendlyHome;
	else 
		$daeHUD::EnemyFlagCarrier = $daeHUD::EnemyHome;
	daeHUD::Update();
}
Event::Attach(EventFlagTimeoutReturn, daeHUD::FlagReturn);
Event::Attach(eventFlagReturned,daeHUD::FlagReturn);
Event::Attach(eventFlagOOBReturn,daeHUD::FlagReturn);

// Captured flag. Woohoo!
function daeHUD::FlagCap(%name,%team)
{
	daeHUD::FlagReturn(%name,%team);
	if (%team == $MyTeam)
		daeHUD::AddScore("Enemy",1);
	else 
		daeHUD::AddScore("Friendly",1);
	daeHUD::Update();
}
Event::Attach(eventFlagCaptured,daeHUD::FlagCap);

// Generic function for adding points to a team
function daeHUD::AddScore(%who,%points)
{
	if (%who == "Friendly")
	{
		$daeHUD::OurScore+=%points;
		if($daeHUD::OurScore<0) $daeHUD::OurScore=0;
	}
	else
	{
		$daeHUD::EnemyScore+=%points;
		if ($daeHUD::EnemyScore<0) $daeHUD::EnemyScore=0;
	}
	daeHUD::Update();
}

// for changing teams
// Gotta switch around the variables.
function daeHUD::changeteam(%client,%team)
{
	if (%client != getManagerID())
		return;
	
	%hold = $daeHUD::OurScore;
	$daeHUD::OurScore = $daeHUD::EnemyScore;
	$daeHUD::EnemyScore = %hold;

	%hold = $daeHUD::EnemyFlagCarrier;
	$daeHUD::EnemyFlagCarrier = $daeHUD::OurFlagCarrier;
	$daeHUD::OurFlagCarrier = %hold;

  daeHUD::Update();
}
Event::Attach(eventClientChangeTeam,daeHUD::changeteam);

// Toggle the hud visibility on/off
function daeHUD::ToggleHud()
{
	if (Control::GetVisible(daeHUD) == "TRUE")
    Control::SetVisible(daeHUD,"FALSE");
  else
    Control::SetVisible(daeHUD,"TRUE");
}

// Toggle the hud transparency on/off
function daeHUD::ToggleTrans()
{
	if (Control::GetVisible(daeHUD_BG) == "TRUE")
    Control::SetVisible(daeHUD_BG,"FALSE");
  else
    Control::SetVisible(daeHUD_BG,"TRUE");
}