// QuietGame script, stand alone version
// http://www.crushedfrogs.org/files/quietgame/
//
// [cF]CeD
// L33t muting script.
//
// Thanks to orox, Fang, StoneCraft for testing, ruWank for testing and 
// writing the description info.
//
// Fed up of clients spamming messages with sounds attached? This script is
// for j00!  The main aim is any sound within a message that is NOT below in 
// the default list (i.e. $QG::sound[attack] = 1; for "Attack") won't be displayed 
// in the ChatHud.  With the default list, you won't have any messages from soundpacks, 
// nor those of the tribes default taunts - uncomment these if you would like them enabled.
// For example, remove the "//" in "//$QG::sound[color6] = 1;" so messages with the sound 
// "Dammit" will be displayed.
// It's also possible to ignore whole messages, such as "!AP Off" like so - 
// $QG::garbage["!AP Off"] = 1; (these must be exact).
// No more annoying sound pack spamming :-)
// Note: You will see your own messages regardless of the list.
//
// This is the stand alone version, it requires you to edit your onClientMessage
// function so it will return QG::Filter(%client, %msg) if the %client is set - look
// at the UltraLite and VikingPack versions for examples.
//
// To install, place this file in your config directory and add the following line at 
// the end of your autoexec.cs : exec("QuietGame.cs");
// The filter is enabled by default, F9 to enable/disable it, F10 to display a report.
//

editActionmap("playmap.sae");
bindCommand(keyboard0, make, "f9", TO, "QG::Toggle();"); // Enable/Disable the spam filter
bindCommand(keyboard0, make, "f10", TO, "QG::Report();"); // Report the number of messages filtered displayed so far

function QG::Filter(%client, %msg) {

	if (!%client || %client == getManagerID() || !$QG::Status) // We don't want our own messages to be filtered.
		return Mute::Process(%client, %msg);

	%soundpos = String::findSubStr(%msg, "~") + 2;

	if (%soundpos != 1) { // (-1 + 2), yeah!
		%sound = String::getSubStr(%msg, %soundpos, %soundpos + 15); // If one of your sounds name is longer than 15 chars, increase the value.
		if (%sound != "" && !$QG::sound[%sound]) {
			$QG::filtered++; // Filtered messages counter
			return mute;
		}
		else
			return Mute::Process(%client, %msg);
	} else if ($QG::garbage[%msg] != "") {
		$QG::filtered++;
		return mute;
	} else
		return true;
}

function QG::Report() {
	if ($QG::filtered < 1)
		remoteBP(2048, "<f1>No messages have been filtered!", 2);
	else if ($QG::filtered == 1)
		remoteBP(2048, "<f1>Only 1 message has been filtered!", 2);
	else
		remoteBP(2048, "<f1>A total of " @ $QG::filtered @ " messages have been filtered!", 2);
}

function QG::Enable() {
	$QG::Status = true;
}

function QG::Disable() {
	$QG::Status = false;
}

function QG::Status() {
	if(!$QG::Status)
		remoteBP(2048, "<f1>Filter disabled", 2);
	else
		remoteBP(2048, "<f1>Filter enabled", 2);
}

function QG::Reset() {
	$QG::filtered = 0;
}

function QG::Toggle() {
	$QG::Status = !$QG::Status;
	QG::Status();
}

QG::Enable();

// These are the messages you DON'T WANT to be displayed :
$QG::garbage[""] = 1;
$QG::garbage[" "] = 1;
$QG::garbage["!AP Off"] = 1;
$QG::garbage["Transmitting..."] = 1;


// These are the sounds you WANT to have played :
$QG::sound[attack] = 1;			// Attack
$QG::sound[attac2] = 1;			// Attack
$QG::sound[attenem] = 1;		// Attack the enemy
$QG::sound[attbase] = 1;		// Attack the enemy base
$QG::sound[gooff] = 1;			// Go on the offensive
$QG::sound[waitsig] = 1;		// Wait for my signal to attack
$QG::sound[cease] = 1;			// Cease fire
$QG::sound[moveout] = 1;		// Move out
$QG::sound[takcovr] = 1;		// Take cover
$QG::sound[retreat] = 1;		// Retreat
$QG::sound[hitdeck] = 1;		// Hit the deck
$QG::sound[regroup] = 1;		// Regroup
$QG::sound[coverme] = 1;		// Cover me
$QG::sound[ono] = 1;			// Going offense
$QG::sound[waitpas] = 1;		// APC ready to go... waiting for passengers

$QG::sound[belay] = 1;			// Belay order
$QG::sound[ordcan] = 1;			// Order cancelled

$QG::sound[tgtacq] = 1;			// Target Acquired
$QG::sound[firetgt] = 1;		// Fire on my target
$QG::sound[needtgt] = 1;		// I need a target
$QG::sound[tgtobj] = 1;			// Target location
$QG::sound[tgtout] = 1;			// Target out of range
$QG::sound[desgen] = 1;			// Destroy the enemy generator
$QG::sound[gendes] = 1;			// Enemy generator destroyed
$QG::sound[destur] = 1;			// Destroy enemy turret
$QG::sound[turdes] = 1;			// Enemy Turret Destroyed

$QG::sound[incom2] = 1;			// Incoming enemies
$QG::sound[basatt] = 1;			// We are being attacked
$QG::sound[basundr] = 1;		// The enemy is attacking our base
$QG::sound[needdef] = 1;		// We need more defense
$QG::sound[defbase] = 1;		// Defend our base
$QG::sound[godef] = 1;			// Go on the defensive
$QG::sound[defend] = 1;			// Defending our base
$QG::sound[basetkn] = 1;		// Base is taken
$QG::sound[bsclr2] = 1;			// Base is secured
$QG::sound[isbsclr] = 1;		// Is our base clear ?

$QG::sound[flgtkn1] = 1;		// Our flag is not in the base
//$QG::sound[flgtkm2] = 1;		// The enemy has our flag
$QG::sound[haveflg] = 1;		// I have the enemy flag
$QG::sound[flaghm] = 1;			// Our flag is secure
$QG::sound[retflag] = 1;		// Return our flag to base
$QG::sound[geteflg] = 1;		// Get the enemy flag
$QG::sound[mineflg] = 1;		// Mine the flag
$QG::sound[flgmine] = 1;		// Our flag is mined
$QG::sound[clrflg] = 1;			// Clear the mines from our flag
$QG::sound[mineclr] = 1;		// Mines have been cleared

$QG::sound[needrep] = 1;		// Need repairs
$QG::sound[needpku] = 1;		// I need an APC pickup
$QG::sound[needesc] = 1;		// I need an escort back to base
$QG::sound[needamo] = 1;		// Can anyone bring me some ammo ?
//$QG::sound[shoot3] = 1;		// Watch where your shooting
//$QG::sound[hurystn] = 1;		// Hurry station

$QG::sound[yes] = 1;			// Yes
$QG::sound[no] = 1;			// No
$QG::sound[help] = 1;			// Help
$QG::sound[thanks] = 1;			// Thanks
$QG::sound[ready] = 1;			// Ready
$QG::sound[sorry] = 1;			// Sorry
$QG::sound[wait1] = 1;			// Wait
$QG::sound[wait2] = 1;			// Waiting
$QG::sound[noprob] = 1;			// No Problem
$QG::sound[dontkno] = 1;		// I don't know
$QG::sound[hello] = 1;			// Hi
$QG::sound[bye] = 1;			// Bye
//$QG::sound[oops] = 1;			// Oops				-> Uncomment from here
//$QG::sound[watchsh] = 1;		// Eh
//$QG::sound[doh] = 1;			// D'oh
//$QG::sound[shoot1] = 1;		// Eh
//$QG::sound[oops1] = 1;		// Doh
//$QG::sound[oops2] = 1;		// Oops
//$QG::sound[color2] = 1;		// Shazbot
//$QG::sound[color3] = 1;		// Hmm
//$QG::sound[color6] = 1;		// Damnit
//$QG::sound[color7] = 1;		// Ah Crap
//$QG::sound[cheer1] = 1;		// Yeah
//$QG::sound[cheer2] = 1;		// Woohoo
//$QG::sound[cheer3] = 1;		// All right
//$QG::sound[dsgst1] = 1;		// Duh
//$QG::sound[dsgst2] = 1;		// You Idiot
//$QG::sound[dsgst4] = 1;		// Argh
//$QG::sound[dsgst5] = 1;		// Sigh
//$QG::sound[taunt1] = 1;		// Yoohoo
//$QG::sound[taunt2] = 1;		// Missed me
//$QG::sound[taunt3] = 1;		// Dance
//$QG::sound[taunt4] = 1;		// Come get some
//$QG::sound[taunt10] = 1;		// How'd that feel ?
//$QG::sound[taunt11] = 1;		// I've had worse
//$QG::sound[death] = 1;		// Aaarrrggg			<- To here, if you want the default taunts back.

$QG::sound[ovrhere] = 1;		// Over here
//$QG::sound[outway] = 1;		// Move out of the way
$QG::sound[retreat] = 1;		// Retreat

$QG::sound[acknow] = 1;			// Command acknowledged
$QG::sound[objcomp] = 1;		// Objective complete
$QG::sound[objxcmp] = 1;		// Unable to complete objective

$QG::sound[attobj] = 1;			// Attack objective
$QG::sound[attway] = 1;			// Attack enemy at waypoint
$QG::sound[defobj] = 1;			// Defend objective
$QG::sound[mineobj] = 1;		// Our objective is mined
$QG::sound[capobj] = 1;			// Capture the objective
$QG::sound[getobj] = 1;			// Get objective
$QG::sound[clrobj] = 1;			// Clear the mine from our objective
$QG::sound[goway] = 1;			// Proceed to waypoint
$QG::sound[escfr] = 1;			// Escort friendly at waypoint
$QG::sound[pilot] = 1;			// Pilot APC to waypoint
$QG::sound[boarda] = 1;			// Board APC
$QG::sound[defway] = 1;			// Defend waypoint

$QG::sound[repobj] = 1;			// Repair objective
$QG::sound[repplyr] = 1;		// Repair friendly at waypoint

$QG::sound[deppuls] = 1;		// Deploy pulse sensor at waypoint
$QG::sound[depjamr] = 1;		// Deploy sensor jammer at waypoint
$QG::sound[depmot] = 1;			// Deploy motion sensor at waypoint
$QG::sound[depcam] = 1;			// Deploy camera at waypoint
$QG::sound[depamo] = 1;			// Deploy Ammo Station at waypoint
$QG::sound[depinv] = 1;			// Deploy Inventory Station at waypoint
$QG::sound[deptur] = 1;			// Deploy Turret at waypoint
$QG::sound[depbecn] = 1;		// Deploy beacon at waypoint

$QG::sound[repeqp] = 1;			// Repair equipement at waypoint
$QG::sound[repitem] = 1;		// Repair item at waypoint
$QG::sound[repobj] = 1;			// Repair objective
$QG::sound[repplyr] = 1;		// Repair friendly at waypoint

//$QG::sound[depapad] = 1;		// Deploy remote ammo pad at waypoint
//$QG::sound[depobj] = 1;		// Deploy objective at waypoint
//$QG::sound[deseqip] = 1;		// Destroy the objective at waypoint
//$QG::sound[flgtkn2] = 1;		// The enemy has our flag
//$QG::sound[goto] = 1;			// Proceed to waypoint
$QG::sound[isbclr] = 1;			// Is our base clear ?
$QG::sound[offflg] = 1;			// I have the flag


