// Script:
// -------
// MuteLocal.cs <stripped/presto version>
//
// Available at http://www.crushedfrogs.org/MuteLocal/
// Versions for VikingPack, UltraLite, Stripped and Presto
// can be found on the site.
//
//
// Info:
// -----
// Brought to you by your beloved ced & ruWank
//
// Thanks to haze, we made him work on something which 
// ended up being useless (for the script, that is) :}
//
// The script mutes the local sounds.
// It's quite simple, we set the $pref::playVoices
// variable to false, and then to true when we receive 
// a message with a sound attached (it's set back to
// false immediately so you will still here the messages in 
// the chathud -- but not the local ones) :)
//
//
// "Bugs":
// ------
// It will also mute the sounds attached to the waypoints 
// command, because those ones do not go through the 
// onClientMessage function so we don't catch them.
//
// You might hear, rarely, a local sound. It will happen if
// someone around you makes a taunt while at the exact same
// time you get a message with a sound in the chathud (tho
// the sound of the message in the hud should cover the local
// taunt noise :])
//
//
// Install:
// --------
// To install, place this file in your config directory and 
// add the following line at the end of your autoexec.cs: 
// exec("MuteLocal_Stripped_Presto.cs");
// 
// You can use F8 to enable or disable the script ingame
//

$Mute::Mute = 1; // The script is enabled

editActionmap("playmap.sae");
bindCommand(keyboard0, make, "F8", TO, "Mute::Toggle();"); // Our toggle bind

Event::Attach(eventExtendedClientMessage, Mute::Process);

$Mute::AdvancedCheck = 0; // Hmm

function Mute::Enable() { // Enabling the script

	function Mute::Process(%client, %msg) {
		if (String::findSubStr(%msg, "~") != -1) // If there is a sound attached
			Mute::Mute(); // We launch our unmute/mute process
		return true;
	}

	$Mute::Mute = 1;
	$pref::playVoices = false;
	schedule("$pref::playVoices = false;", 0.01); // We make it 2 times... not sure it's needed, but it's costless
}

function Mute::Disable() { // Disabling the script

	function Mute::Process(%client, %msg) { // We override our function by a really simple one :)
		return true;
	}
	
	$Mute::Mute = 0;
	$pref::playVoices = true;
	schedule("$pref::playVoices = true;", 0.01); // Same as above

}

function Mute::Toggle() { // Enable/Disable the script
	$Mute::Mute = !$Mute::Mute;
	if ($Mute::Mute)
		Mute::Enable();
	else
		Mute::Disable();
		
	remoteBP(2048, "<f1>Local Muting : " @ $Mute::Print[$Mute::Mute], 3); // Display a message with the script status
}

function Mute::AdvancedCheck() {

	function Mute::Mute() {
		$pref::playVoices = true; // Unmuted
		if (!$Mute::Muting) { // If we are not already muting, we proceed
			$Mute::Muting = 1; // We are muting
			schedule("Mute::MuteNow();", 0.001); // We set our schedule
		}
	}
	
	function Mute::MuteNow() {
		if ($Mute::Muting) { // We still want to mute, right ?
			$pref::playVoices = false; // Muted
			$Mute::Muting = 0; // We are not muting anymore
		}
	}

}

function Mute::NoCheck() {

	function Mute::Mute() {
		$pref::playVoices = true; // Unmuted
		schedule("$pref::playVoices = false;", 0.001); // We set our schedule
	}

}

function Mute::Init() {
	$Mute::Print[0] = "Off";
	$Mute::Print[1] = "On";

	if ($Mute::Mute) {
		if ($Mute::AdvancedCheck)
			Mute::AdvancedCheck();
		else
			Mute::NoCheck();
		Mute::Enable();
	} else
		Mute::Disable();
}

Mute::Init(); // Let's go
