//***********************************************************
//OrdersHUD
//***********************************************************
//OrdersHUD allows you to give commands to your teammates who assigned themselves to a "Fire Team"
//This is a very simple script to use, however, for it to be effective, every member of your team
//should be using it.  I only recommend this script to those who play competitively and can actually
//get their whole team to use it.  Anyhow, let's get on with the definable stuff, shall we?

//This key is for selecting your fireteam.  It toggles through the list of teams in its database.
$Orders::ToggleTeamsKey = "9";
	
//This key activates the command menu.
$Orders::CommandKey = "8";

//This is the key you press to see who is on what team and what each team's current orders are.
$Orders::SortTeamsKey = "7";

//This sets where you want the hud to appear. Your choice is "Top" or "Bottom"
$Orders::Location = "Bottom";

//Populate the FireTeam Database
$Order::Team[0] = "Off";
$Order::Team[1] = "Red";
$Order::Team[2] = "Blue";
$Order::Team[3] = "Yellow";
$Order::Team[4] = "Green";
$Order::Team[5] = "Black";

//Populate the Command Database
$Order::Command[1] = "Defend our base!";
$Order::Command[2] = "Repair our Gens!";
$Order::Command[3] = "Capture the enemy flag!";
$Order::Command[4] = "Go on the offensive!";
$Order::Command[5] = "Return our flag to our base!";
$Order::Command[6] = "Defend our flag!";
$Order::Command[7] = "Tell Poop how sexy he is.";
//***********************************************************



//***********************************************************
//Here lies the GUTS of the script.  Don't mess unless you know what you are doing.

//Check to see if stripped is installed so we dont execute the next two functions.
if($Presto::Version) {
	echo("Presto Pack detected... installing support functions...");
	function Stripped::getScreenSizeX() {
		$pref::VideoFullScreen = isFullScreenMode(MainWindow);
		%screen = "640x480";
		if($pref::VideoFullScreen)
			%screen = $pref::VideoFullScreenRes;
		%xPos = String::findSubStr(%screen, "x");
		return String::getSubStr(%screen, 0, %xPos);
	}

	function Stripped::getScreenSizeY() {
		$pref::VideoFullScreen = isFullScreenMode(MainWindow);
		%screen = "640x480";
		if($pref::VideoFullScreen)
			%screen = $pref::VideoFullScreenRes;
		%xPos = String::findSubStr(%screen, "x");
		return String::getSubStr(%screen, %xPos + 1, 1024);
	}
	Event::Attach(eventExtendedClientMessage, Order::Parse);
}
	
Event::Attach(eventExit, Order::Remove);
Event::Attach(EventClientChangeTeam, Order::CheckTeamChange);
if($Stripped::Version) { Event::Attach(EventClientMessage, Order::Parse); }


$Order::MyTeam = $Order::Team[1];

function Order::Init(%gui) {
	if(!$Orders::HUD) {
		//Create our HUD and custom keymaps
		while($Order::Team[$Order::TotTeams++] != "") {
			%tmp = $Order::Team[$Order::TotTeams];
			$Order::TeamOrder[%tmp] = "None";
		}
		$Order::TotTeams--;
		while($Order::Command[$Order::TotCommands++] != "") { }
		$Order::TotCommands--;
		if(!$Orders::HUD) {
			$Orders::HUD = newObject("OrdersHUD", FearGui::FearGuiMenu, Stripped::getScreenSizeX()/2, Stripped::getScreenSizey()-25, 100, 20);
			$Orders::String = newObject("OrdersString", FearGuiFormattedText, 1, 1, 0, 0);
			AddToSet(OrdersHUD, "OrdersString");
			AddToSet(playGui, "OrdersHUD");
			Control::SetValue("OrdersString", "<JC><F2>WOOO");
			Control::SetVisible("OrdersHUD", FALSE);
			//Throw the fireteam keymap in here
			%chars = " 1234567890abcdefghijklmnopqrstuvwxyz";
			NewActionMap("FireTeamMap.sae");
			EditActionMap("FireTeamMap.sae");
			for(%i = 1; %i <= $Order::TotTeams; %i++){
				bindCOmmand(Keyboard0, make, String::GetSubStr(%chars, %i, 1), TO, "Order::CommandTeam("@%i@");");
			}
			NewActionMap("OrdersMap.sae");
			EditActionMap("OrdersMap.sae");
			for(%i = 1; %i <= $Order::TotCommands; %i++) {
				bindCOmmand(keyboard0, make, String::GetSubStr(%chars, %i, 1), TO, "Order::GiveCommand("@%i@");");
			}
		}
	}
}

//Remove the HUD
function Order::Remove() {
	removeFromSet("playgui", $Orders::HUD);
	deleteObject($Orders::HUD);
	removeFromSet("playgui", $Orders::String);
	deleteObject($Orders::String);
}

//Toggle through the Fireteams
function Order::SelectTeam() {
	$Order::TeamNum++;
	if($Order::Team[$Order::TeamNum] != "") {
		$Order::MyTeam = $Order::Team[$Order::TeamNum];
	}
	else {
		$Order::TeamNum = 0;
		$Order::MyTeam = $Order::Team[$Order::TeamNum];
	}
	%num = $Order::TeamSwitchNum++;
	schedule("Order::UpdateTeams("@%num@");", 3);
	Order::Init();
	Order::Update();
	remoteBP(2048, "<JC><F1>Your current fire team is <F2>"@$Order::MyTeam, 3);
}

function Order::GetTeams() {
	schedule("Say(1, \"Requesting...~request\");", 5);
}

function Order::CheckTeamChange(%cl, %team) {
	if(%cl == GetManagerID()) {
		schedule("Order::GetTeams();", 3);
	}
}

function Order::UpdateTeams(%num) {
	if(%num == $Order::TeamSwitchNum) {
		say(1, "Fireteam...~team*"@$Order::MyTeam);
	}
}

//Check the client messages for FireTeam orders.
function Order::Parse(%cl, %msg) {
	if(Client::GetTeam(%cl) == Client::GetTeam(GetManagerID())) {
		//Parse the order message
		if(String::FindSubStr(%msg, "~Order") != -1) {
			%msg = String::Replace(%msg, "*", " ");
			%team = GetWord(%msg, 1);
			%idx = String::FindSubStr(%msg, GetWord(%msg, 2));
			$Order::TeamOrder[%team] = String::GetSubStr(%msg, %idx, 1000);
			if($Order::MyTeam == %team) { 
				localmessage(message);
				Order::Blink();
			}
			Order::Update();
			if($Presto::Version) { return Mute; }
			else { return false; }
		}
		//Parse to see who is on what team
		else if(String::FindSubStr(%msg, "~team") != -1) {
			%msg = String::Replace(%msg, "*", " ");
			%team = GetWord(%msg, 1);
			%player = Client::GetName(%cl);
			$Orders::Player[%player] = %team;
			%idx = String::FindSubStr(%msg, GetWord(%msg, 2));
			if(%idx != -1) {
				$Order::TeamOrder[%team] = String::GetSubStr(%msg, %idx, 1000);
			}
			if($Presto::Version) { return Mute; }
			else { return false; }
		}
		//Notify Team what fireteam you are on by request.
		else if(String::FindSubStr(%msg, "~request") != -1) {//&& %cl != GetManagerID()) {
			say(1, "Fireteam...~team*"@$Order::MyTeam@"*"@String::Replace($Order::TeamOrder[$Order::MyTeam], " ", "*"));
			if($Presto::Version) { return Mute; }
			else { return false; }
		}
	}
	return true;
}

function Order::SortTeams() {
	//this seems processor intensive, but i needed this to sort players by team.
	for(%i = 1; %i <= $Order::TotTeams; %i++) {
		%tmp = $Order::Team[%i];
		%text = %text@"<JL><F0>\t"@$Order::Team[%i]@": <F1>"@$Order::TeamOrder[%tmp]@"\n";
		for (%cl = 2200; %cl > 2048; %cl--) {
			if(Client::GetName(%cl) != "") {
				%team = Client::GetTeam(%cl);
				if(%team == Client::GetTeam(GetManagerID())) {
					%name = Client::GetName(%cl);
					if($Orders::Player[%name] == $Order::Team[%i]) {
						%text = %text@"\t\t<F2>"@%name@"\n";
					}
				}
				
			}
		}
	}
	remoteBP(2048, %text, 5);
}

function Order::Blink() {
	for(%i=1; %i <= 12; %i++) {
		schedule("Control::SetVisible(\"OrdersHUD\", False);", 0.25*%i);
		schedule("Control::SetVisible(\"OrdersHUD\", True);", 0.25*%i++);
	}
}

//Update the OrdersHUD
function Order::Update() {
	Control::SetValue("OrdersString", "<JC><F1>"@$Order::MyTeam@": <F2>"@$Order::TeamOrder[$Order::MyTeam]);
	Control::SetExtent("OrdersHUD", (String::Pixels($Order::TeamOrder[$Order::MyTeam])+100), 20);
	if($Orders::Location == "Top") {
		Control::SetPosition("OrdersHUD", (Stripped::getScreenSizeX()/2)-((String::pixels($Order::TeamOrder[$Order::MyTeam])+100)/2), 0);
	}
	else {
		Control::SetPosition("OrdersHUD", (Stripped::getScreenSizeX()/2)-((String::pixels($Order::TeamOrder[$Order::MyTeam])+100)/2), (Stripped::getScreenSizeY()-20));
	}
	if($Order::MyTeam == "Off") { Control::SetVisible("OrdersHUD", False); }
	else { Control::SetVisible("OrdersHUD", TRUE); }
}

function Order::GiveOrders() {
	%chars = " 1234567890abcdefghijklmnopqrstuvwxyz";
	for(%i = 1; %i <= $Order::TotTeams; %i++) {
		%text = %text@"\t<JL><F1>"@String::GetSubStr(%chars, %i, 1)@": <F2>"@$Order::Team[%i]@"\n";
	}
	PushActionMap("FireTeamMap.sae");
	remoteBP(2048, %text);
}

function Order::CommandTeam(%team) {
	PopActionMap("FireTeamMap.sae");
	$Order::CurrentTeamOrdered = $Order::Team[%team];
	PushActionMap("OrdersMap.sae");
	Order::ShowCommands();
}

function Order::ShowCommands() { 
	%chars = " 1234567890abcdefghijklmnopqrstuvwxyz";
	for(%i = 1; %i <= $Order::TotCommands; %i++) {
		%text = %text@"\t<JL><F1>"@String::GetSubStr(%chars, %i, 1)@": <F2>"@$Order::Command[%i]@"\n";
	}
	remoteBP(2048, %text);
}

function Order::GiveCommand(%orderNum) {
	PopActionMap("OrdersMap.sae");
	remoteBP(2048, "");
	say(1, "Ordering...~order*"@$Order::CurrentTeamOrdered@"*"@String::Replace($Order::Command[%orderNum], " ", "*"));
}
		
	

editActionMap("Playmap.sae");

bindCommand(Keyboard0, make, $Orders::ToggleTeamsKey, TO, "Order::SelectTeam();");
bindCommand(Keyboard0, make, $Orders::CommandKey, TO, "Order::GiveOrders();");
bindCommand(Keyboard0, make, $Orders::SortTeamsKey, TO, "Order::SortTeams();");