// PiNGHUD v1.0
// 6.14.00
// by Rayn 
// rayn@tribalwar.com
// Idea by: [FTM] Tequila
// Ping Code by: VeKToR
// --------------------------------------------------------------------------
// 		              VISIT WWW.TRIBALWAR.COM
// 			 The Premier Tribes Resource On The Web
// --------------------------------------------------------------------------
// Tequila requested a small HUD that would display your current ping so I
// whipped this up.  It updates every 3 seconds, if it were any more it would
// interfere with your ping.  The ping shown is not exact but very close.
// Send me your feedback or feel free to modify as needed, drop me a line if you
// do I'd like to see.  
//
//	 * Feedback/Bug Reports/Love Letters to: rayn@tribalwar.com *
//
//
// INSTALL NOTES
// Requires:
//		Presto Pack v0.93 or better
// Add this line to your AUTOEXEC.CS somewhere after Include("Presto\\Install.cs"); :
//	Include("rayn\\pingHUD.cs");
//	
// ---------------------------------------------------------------------------
// PING HUD PREFERENCES 
// Set to customize and configure HUD
// HUD Location X in percentage of the screen (i.e 100 = all the way right): 

   $phud::X = 100;

//  HUD Location Y in percentage of the screen (i.e 15 = 15% from top);

   $phud::Y = 15;

// Display  icons with ping to indicate good/med/bad.  Set to true, no reason not to!

   $phud::showIcons = "true";

// How often do you want to check your ping? Default is every 3 seconds, I don't recommend
// setting any lower, higher is fine.

   $phud::updateInterval = "3.0";

// ---------------------------------------------------------------------------
//
// ----------------------------- BEWARE OF CODE -------------------------------

$phud::debugMode = false;
$phud::initialized = false;

Event::Attach(eventConnected,"phud::init",initPHUD);

function phud::init() 
{
     $phud::check = true;
     $phud::pingText = "0";
	%ic = 0;
	if ($phud::showIcons)
		%ic = 15;
     if (!HUD::Exists(pingdhud)) 
     HUD::New("pingdhud","phud::updatePingHUD", $phud::X @"% "@ $phud::Y@"% 30+"@%ic@" 18");
     HUD::Display("pingdhud");
     phud::checkPing();     
}

function phud::toggle()
{
    $phud::check = !phud::check;    
    HUD::ToggleDisplay(pingdhud);	
}

function phud::updatePingHUD()
{
    HUD::SetText("pingdhud",$phud::pingText);
    HUD::Display("pingdhud");
}

function phud::ping() {
	
	remoteeval(2048, eval, PingHUDResponse, getsimtime());
}

function remotePingHUDResponse(%client, %origtime) {
	
        $phud::currentPing = ((getsimtime() - %origtime) * 500);
}

function phud::computePing()
{
  
  %p = phud::ping();
  $phud::currentPing = floor($phud::currentPing);
  if ($phud::debugmode)
	ECHO ($phud::currentPing);     
}

function phud::checkPing()
{
   
  if ($phud::debugmode)
	ECHO ("CHECKING PING");
  phud::computePing();
  $phud::pingText = phud::pickGfx();	
  $phud::pingText = $phud::pingText @ $phud::currentPing;
  HUD::Update(pingdhud); 
  Schedule::Add("phud::checkPing();",$phud::updateInterval);
}

function phud::pickGfx()
{
  %txt = "<f2>";

  if (!$phud::showIcons)
     return %txt;

  if ($phud::currentPing <= $Pref::ConnectionGoodPing)
     %txt = "<jl><f2><B0,6:LR_HH_End_Green.bmp><l3>";
  else if ($phud::currentPing < $Pref::ConnectionPoorPing)
     %txt = "<jl><f2><B0,6:LR_HH_End_Yellow.bmp><l3>";
  else 
     %txt = "<jl><f2><B0,6:LR_HH_End_Red.bmp><l3>";

  return %txt;
}

