//////////////////////////////////////////////////////////////////
//								//
// File Name:	notifypowerdown.cs				//
// Config Name:	Notify On Power Down (Version 2.20)		//
// Author: 	>:-< Plague! 					//
// Description: Notifies your team when the power is down 	//
//						 		//
//////////////////////////////////////////////////////////////////

// uses presto's Event::Attach function & Include

Include("Presto\\Event.cs");

$ResetTime = 180;	// time before power down flag resets
$PowerDown = false;	// flag used to determine if power is down
$ResetStarted = false;	// flag used to determine if reset countdown has started

function PowerDown::Msg(%client, %msg)
{
	if (%client != 0)
		return;
	
	// gives team message and sets powerdown to true
	if((String::findSubStr(%msg, "Unit is not powered") != -1) &&
		($PowerDown == false))
	{		
		say(1, "Our Power is Down!~job:can-rep-gen~wneedrep");
		$PowerDown = true;
		PowerDown::ResetStarted();
	}

	// gives team message and sets powerdown to false
	if(((String::findSubStr(%msg, "Station Access On") != -1) ||
		(String::findSubStr(%msg, "Resupply Complete") != -1) ||
		(String::findSubStr(%msg, "Command Access On") != -1)) && 
		($PowerDown == true))	
	{	
		say(1, "Our Power is Back Up!~wobjcomp");
		$PowerDown = false;
		$ResetStarted = false;
	}
}

function PowerDown::CheckPower(%client, %msg)
{
	// set powerdown to true if someone else says the power is down
	if(String::findSubStr(%msg, "Our Power Is Down!") != -1)
	{
		$PowerDown = true;	
		PowerDown::ResetStarted();
	}
	
	// set powerdown to false if someone else says the power is restored
	if(String::findSubStr(%msg, "Our Power is Back Up!") != -1)
	{
		$PowerDown = false;
		$ResetStarted = false;
	}
}

// Resets PowerDown flag after Time seconds after initial power down message
function PowerDown::ResetStarted()
{
	if (($PowerDown == true) && ($ResetStarted == false))
	{
		schedule("PowerDown::Reset();", $ResetTime);
		$ResetStarted = true;
	}
}

// Resets vars (Assumes Power is back up)
function PowerDown::Reset()
{
	$PowerDown = false;
	$ResetStarted = false;
}

Event::Attach(eventClientMessage, PowerDown::CheckPower);
Event::Attach(eventClientMessage, PowerDown::Msg);
Event::Attach(eventConnected, PowerDown::Reset);
Event::Attach(eventChangeMission, PowerDown::Reset);
EditActionMap("playMap.sae");
bindCommand(keyboard0, make, "r", TO, "say(1, \"Our Power is Back Up!~wobjcomp\");");

