// this is a version modified by powdahound to work with PowPoints.cs. i left all his code here incase you wanted to use it however.
// powdahound - 11/11/02

// FILE:		z0dd_waypoints.cs
// VERSION:		1.1
// DATE:		1/15/2001
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
// DESCRIPTION:
//
//	This script allows you to cycle through predfine WPs with a single
//	key bind. There's a key bind that allows you change which WPs are
//      included in the cycling. The three settings are "friendly", "enemy"
//      and all "friendly and enemy and neutral" waypoints.
//
//	Each map has a different set of WPs. The "Cycle Key" is used to
//	change your current WP. Pressing the Cycle Key while at the last WP
//	will bring you back to the first WP. Thus, the name "Cycle" key.
//
//	The default WPs for this script are the ones I use. You may want to
//	change which WPs are used on each map. The defaults are EXTREMELY
//	limited and are what I feel are the important WPs on each map. 
//
// 	This script is configured by editing the areas labeled:
//	USER CONFIGURATION SECTION and WP CONFIGURATION SECTION. Please
//	read through the entire INSTALLATION and USER CONFIGURATION
//	sections before running this script. Editing the WP CONFIGURATION
//	SECTION is optional.
//
//	At the bottom of this is data for almost all of the WPs you would
//	to set on every OGL CTF map. By default, Most of these aren't used.
//	You can edit the WP CONFIGURATION SECTION to set which WPs are used.
//	Refer to the WP CONFIGURATION SECTION at the bottom of this script
//	for instructions on how this is done.
//
//
// Version history:
//	1.1	- I learned how to spell Obfuscation!!!  Obfuscation will
//		  now be recognized as a valid map and the waypoint data
//		  has been corrected.
//
//
//
// INSTALLATION:
//	This script doesn't require and won't conflict with presto pack.
//
//	Put z0dd_waypoints.cs into your:
//		...\tribes\config
// 	directory.
//
//	Insert this line into your autoexec.cs:
//	exec("z0dd_waypoints.cs");
//
//	Edit the key binds in the USER CONFIGURATION SECTION before
//	running this script. 
//
//
// CREDITS
// 	Thanks to Rayn for letting me use the WP data from his script.
//	He saved me much work.
//


////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION ////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// ------------------------ waypoints config area -------------------------
//
// CYCLE WPS FORWARD KEY
// The key to cycle FORWARD through the waypoints.
// The default key is "g"
//bindCommand(keyboard0, make, "g", TO, "z0ddWPs::nextWP(1);");
//bindCommand(keyboard0, break, "g", TO, "");

// CYCLE WPS BACKWARDS KEY
// The key to cycle BACKWARDS through the waypoints.
// The default key is "j"
//bindCommand(keyboard0, make, "q", TO, "z0ddWPs::nextWP(-1);");
//bindCommand(keyboard0, break, "q", TO, "");

// WP SELECTION KEY
// This key selects which waypoints are cycled through when pressing the WP
// CYCLE KEY
// The default key is "control g"
//bindCommand(keyboard0, make, control, "g", TO, "z0ddWPs::cycleFilter();");
//bindCommand(keyboard0, break, control, "g", TO, "");
//
////////////////////////////////////////////////////////////////////////////
////////////////////// END USER CONFIGURATION SECTION //////////////////////
////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////
///////////////////////////// START CODE AREA //////////////////////////////
////////// DON'T EDIT THIS AREA IF YOU DON'T KNOW WHAT YOU'RE DOING ////////
////////////////////////////////////////////////////////////////////////////
//
// index into array of WPs within a mapname.
$z0ddWPs::WPindex = 0;
$z0ddWPs::WPfilter = 1;  // 1=ALL, 2=OURS, 3=ENEMY


/////////////////////////////////////////////////////////////////////////////////////////
// Add a WP to the data set
/////////////////////////////////////////////////////////////////////////////////////////                         
//   mapName: This is the value of the server global $servermission
//   x: the x coordinate of map WP
//   y: the x coordinate of map WP
//   side: 0=BE, 1=DS, 2=niether
//   msgStr: A item type string. Use the "$z0ddWPs::???Str" variables
function z0ddWPs::addWP(%mapName, %x, %y, %side, %msgStr)
{
	%n = $z0ddWPs::data[%mapName, n]++;
	$z0ddWPs::data[%mapName, %n, side] = %side;
	$z0ddWPs::data[%mapName, %n, x] = %x;
	$z0ddWPs::data[%mapName, %n, y] = %y;
	$z0ddWPs::data[%mapName, %n, str] = %msgStr;
}

/////////////////////////////////////////////////////////////////////////////////////////
// controls how long msgs are displayed
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddWPs::TurnOffCP()
{
	$z0dd::CenterPrintCounter--;
	if(!$z0dd::CenterPrintCounter)
		Client::centerPrint("", 1);
}


function z0ddWPs::cycleIndex(%current_index, %cycle_val)
{
	%i = %current_index + %cycle_val;
	
	if(%i < 1) 
		%i = $z0ddWPs::data[$servermission, n];
	else if (%i > $z0ddWPs::data[$servermission, n])
		%i = 1;		
	
	return %i;
}

/////////////////////////////////////////////////////////////////////////////////////////
// Find the next WP to target depending on which WP filter option is on
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddWPs::getNextFilteredWPIndex(%cycle_val)
{
	// cycle to next WP within this map
	// %newIndex = (($z0ddWPs::WPindex % $z0ddWPs::data[$servermission, n]) + 1);

	%newIndex = z0ddWPs::cycleIndex($z0ddWPs::WPindex, %cycle_val);

	// if filter isnt set to display ALL WPs find the next, filtered, WP index
	if($z0ddWPs::WPfilter != 1)
	{		
		// if we're only looking for friendly WPs
		if($z0ddWPs::WPfilter == 2)
			%nextTargetSideNum = Client::getTeam(getManagerId());
		else  // else we're only looking for enemy WPs
			%nextTargetSideNum = !(Client::getTeam(getManagerId()));

		while (%nextTargetSideNum != $z0ddWPs::data[$servermission, %newIndex, side])
			%newIndex = z0ddWPs::cycleIndex(%newindex, %cycle_val);
	}
	
	return %newIndex;
}

function z0ddWPs::mapNotInDataSet()
{
	// map is in the data set
	if($z0ddWPs::data[$servermission, n])
		return 0;	

	Client::centerPrint("<jc>\"" @ $servermission @ "\" not in data set.\nWPs not set.", 1);
	$z0dd::CenterPrintCounter++;
	schedule("z0ddWPs::TurnOffCP();", 3);
	return 1;
}	

/////////////////////////////////////////////////////////////////////////////////////////
// A key bind calls this function. Cycles to the next valid WP
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddWPs::nextWP(%cycle_val)
{		
	// if this map isn't in the data set
	if(z0ddWPs::mapNotInDataSet())
		return;

	$z0ddWPs::WPindex = z0ddWPs::getNextFilteredWPIndex(%cycle_val);

//	echo("=== z0ddWPs::WPindex=" @ z0ddWPs::WPindex);  // debug
//	echo("=== z0ddWPs::data[servermission, z0ddWPs::WPindex, side]=" @ $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, side]);  // debug
//	echo("=== z0ddWPs::data[servermission, z0ddWPs::WPindex, str]=" @ $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, str]);  // debug
	
	// 2 represents item isn't bound to a side; it's neutral
	if(2 == $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, side])
		%teamStr = "";	
	else if(Client::getTeam(getManagerId()) == $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, side])
		%teamStr = "Our ";
	else
		%teamStr = "Enemy ";

	remoteEval(2048, "issueCommand", 1, "WP = " @ %teamStr @ $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, str],
	           $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, x],
	           $z0ddWPs::data[$servermission, $z0ddWPs::WPindex, y],
	           getManagerId());
}

/////////////////////////////////////////////////////////////////////////////////////////
// A key bind calls this function. Cycles the 3 filter modes: ALL, OURS, ENEMY
// 1="ALL" 2="OURS" 3="ENEMY"
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddWPs::cycleFilter()
{
	if($z0ddWPs::WPfilter == 1)
	{
		$z0ddWPs::WPfilter = 2;
		Client::centerPrint("<jc>WPs Displayed:\nOURS", 1);
	}
	else if($z0ddWPs::WPfilter == 2)
	{
		$z0ddWPs::WPfilter = 3;
		Client::centerPrint("<jc>WPs Displayed:\nENEMY", 1);
	}
	else
	{
		$z0ddWPs::WPfilter = 1;
		Client::centerPrint("<jc>WPs Displayed:\nALL", 1);
	}
		
	$z0dd::CenterPrintCounter++;
	schedule("z0ddWPs::TurnOffCP();", 2);	
}

// Display strings
$z0ddWPs::BaseStr 	= "base";
$z0ddWPs::FlagStandStr	= "flag stand";
$z0ddWPs::RTStr		= "rocket turret";
$z0ddWPs::ELFTurStr	= "ELF turret";
$z0ddWPs::PlasmaTurStr	= "plasma turret";
$z0ddWPs::MortarTurStr	= "mortar turret";
$z0ddWPs::PulseSenStr	= "pulse sensor";
$z0ddWPs::RepPackStr	= "repair pack";
$z0ddWPs::EPackStr	= "energy pack";
$z0ddWPs::ELFGunStr	= "ELF gun";
$z0ddWPs::PlasmaGunStr	= "plasma gun";
$z0ddWPs::LaserRifleStr	= "laser rifle";
$z0ddWPs::GenStr	= "generator";
$z0ddWPs::SolarStr	= "solar panel";
$z0ddWPs::InvStr	= "inventory station";
$z0ddWPs::VehPadStr	= "vehicle pad";
$z0ddWPs::TowerStr	= "tower";
$z0ddWPs::SwitchStr	= "switch";
// Number strings to identify multiple items of same type
$z0ddWPs::OneStr	= " 1";
$z0ddWPs::TwoStr	= " 2";
$z0ddWPs::ThreeStr	= " 3";
// Compass direction strings to identify multiple items of same type
$z0ddWPs::NorthStr	= "north";
$z0ddWPs::SouthStr	= "south";
$z0ddWPs::EastStr	= "east";
$z0ddWPs::WestStr	= "west";


// WP data. Order is:
//   Map String: This is the value of the server global $servermission
//   x coord: the x coordinate of map WP
//   y coord: the x coordinate of map WP
//   side #: 0=BE, 1=DS, 2=niether
//   target discription string: A item type string. Use the "$z0ddWPs::???Str" variables
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////// END CODE AREA ///////////////////////////////
////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////
///////////////////////// WP CONFIGURATION SECTION /////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// How to edit this section:
//
// Each line is a WP. By looking at the last or second last variable it should
// be obvious what item the WP is (flag stand, RT, base, ELF turret, etc..)
// Lines that have // in front of them are NOT included in the WP cycling.
//
// Remove the // at the begingin of a line to include that WP for that map.
// Add a // to the begining of a line to exclude that WP for that map.
// 
// Remember, by default most of these WPs aren't included because I prefer
// to only cycle the WPs I feel are essential for that map.
//
// If you feel really ambitious, you can add your own WP lines. You'll have
// to figure out how on your own.
//


////////////////////////////////////////////////////////////////////////////
// Acrophobia
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Acrophobia", 698, 800, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Acrophobia", 597, 692, 0, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Acrophobia", 699, 801, 0, $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("Acrophobia", 691, 793, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Acrophobia", 701, 807, 0, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("Acrophobia", 686, 797, 0, $z0ddWPs::GenStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("Acrophobia", 703, 814, 0, $z0ddWPs::GenStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("Acrophobia", 475, 756, 0, $z0ddWPs::InvStr);
//z0ddWPs::addWP("Acrophobia", 678, 779, 0, $z0ddWPs::VehPadStr);
//z0ddWPs::addWP("Acrophobia", 327, 225, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Acrophobia", 428, 332, 1, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Acrophobia", 324, 222, 1, $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("Acrophobia", 333, 231, 1, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Acrophobia", 323, 217, 1, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("Acrophobia", 338, 227, 1, $z0ddWPs::GenStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("Acrophobia", 321, 210, 1, $z0ddWPs::GenStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("Acrophobia", 292, 388, 1, $z0ddWPs::InvStr);
//z0ddWPs::addWP("Acrophobia", 346, 244, 1, $z0ddWPs::VehPadStr);


////////////////////////////////////////////////////////////////////////////
// AvalancheMkII
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("AvalancheMkII", 885, 664, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("AvalancheMkII", 879, 728, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("AvalancheMkII", 884, 684, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("AvalancheMkII", 886, 638, 0, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("AvalancheMkII", 887, 660, 0, $z0ddWPs::GenStr);
//z0ddWPs::addWP("AvalancheMkII", 141, 361, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("AvalancheMkII", 145, 297, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("AvalancheMkII", 140, 339, 1, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("AvalancheMkII", 138, 386, 1, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("AvalancheMkII", 139, 361, 1, $z0ddWPs::GenStr);


////////////////////////////////////////////////////////////////////////////
// CanyonCrusade_deluxe
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("CanyonCrusade_deluxe", 736, 464, 0, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe", 893, 672, 0, $z0ddWPs::TowerStr @ " " @ $z0ddWPs::BaseStr);
z0ddWPs::addWP("CanyonCrusade_deluxe", 806, 592, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe", 810, 640, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe", 267, 464, 1, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe", 106, 657, 1, $z0ddWPs::TowerStr @ " " @ $z0ddWPs::BaseStr);
z0ddWPs::addWP("CanyonCrusade_deluxe", 205, 572, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe", 197, 613, 1, $z0ddWPs::RepPackStr);


////////////////////////////////////////////////////////////////////////////
// CanyonCrusade_deluxe
// This entry is for 5150 servers. 5150 servers have 2 CC-dlx entries. The
// 2nd one has a space at the end of the $servermission name.
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("CanyonCrusade_deluxe ", 736, 464, 0, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe ", 893, 672, 0, $z0ddWPs::TowerStr @ " " @ $z0ddWPs::BaseStr);
z0ddWPs::addWP("CanyonCrusade_deluxe ", 806, 592, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe ", 810, 640, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe ", 267, 464, 1, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe ", 106, 657, 1, $z0ddWPs::TowerStr @ " " @ $z0ddWPs::BaseStr);
z0ddWPs::addWP("CanyonCrusade_deluxe ", 205, 572, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("CanyonCrusade_deluxe ", 197, 613, 1, $z0ddWPs::RepPackStr);


////////////////////////////////////////////////////////////////////////////
// Cloak Of Night
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("CloakOfNight", 829, 825, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("CloakOfNight", 840, 836, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("CloakOfNight", 916, 702, 0, $z0ddWPs::RTStr);
//z0ddWPs::addWP("CloakOfNight", 836, 841, 0, $z0ddWPs::ELFTurStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("CloakOfNight", 845, 832, 0, $z0ddWPs::ELFTurStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("CloakOfNight", 827, 822, 0, $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("CloakOfNight", 824, 817, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("CloakOfNight", 831, 817, 0, $z0ddWPs::GenStr);
//z0ddWPs::addWP("CloakOfNight", 194, 198, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("CloakOfNight", 184, 188, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("CloakOfNight", 109, 322, 1, $z0ddWPs::RTStr);
//z0ddWPs::addWP("CloakOfNight", 189, 183, 1, $z0ddWPs::ELFTurStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("CloakOfNight", 179, 193, 1, $z0ddWPs::ELFTurStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("CloakOfNight", 198, 203, 1, $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("CloakOfNight", 200, 206, 1, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("CloakOfNight", 193, 207, 1, $z0ddWPs::GenStr);


////////////////////////////////////////////////////////////////////////////
// Dangerous Crossing
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("DangerousCrossing", 800, 750, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("DangerousCrossing", 860, 863, 0, $z0ddWPs::InvStr);
z0ddWPs::addWP("DangerousCrossing", 421, 288, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("DangerousCrossing", 471, 159, 1, $z0ddWPs::InvStr);


////////////////////////////////////////////////////////////////////////////
// Desert Of Death
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Desert_Of_Death", 389, 196, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Desert_Of_Death", 359, 405, 0, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("Desert_Of_Death", 537, 327, 0, $z0ddWPs::EastStr @ " " @ $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("Desert_Of_Death", 319, 245, 0, $z0ddWPs::WestStr @ " " @ $z0ddWPs::PulseSenStr);
z0ddWPs::addWP("Desert_Of_Death", 371, 883, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Desert_Of_Death", 392, 699, 1, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("Desert_Of_Death", 492, 775, 1, $z0ddWPs::EastStr @ " " @ $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("Desert_Of_Death", 142, 773, 1, $z0ddWPs::WestStr @ " " @ $z0ddWPs::PulseSenStr);
z0ddWPs::addWP("Desert_Of_Death", 195, 433, 2, $z0ddWPs::ELFGunStr);
//z0ddWPs::addWP("Desert_Of_Death", 449, 517, 2, $z0ddWPs::PlasmaGunStr);
//z0ddWPs::addWP("Desert_Of_Death", 441, 511, 2, $z0ddWPs::LaserRifleStr);
//z0ddWPs::addWP("Desert_Of_Death", 589, 591, 2, $z0ddWPs::RepPackStr);


////////////////////////////////////////////////////////////////////////////
// Domino
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("Domino", 295, 735, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Domino", 256, 226, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Domino", 291, 715, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Domino", 726, 287, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Domino", 768, 797, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Domino", 732, 309, 1, $z0ddWPs::RepPackStr);


////////////////////////////////////////////////////////////////////////////
// IceRidge
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("IceRidge", 599, 212, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("IceRidge", 437, 430, 0, $z0ddWPs::PlasmaTurStr);
z0ddWPs::addWP("IceRidge", 345, 787, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("IceRidge", 533, 719, 1, $z0ddWPs::PlasmaTurStr);


////////////////////////////////////////////////////////////////////////////
// Jagged Claw
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("JaggedClaw", 635, 250, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("JaggedClaw", 413, 255, 0, $z0ddWPs::RTStr);
z0ddWPs::addWP("JaggedClaw", 297, 756, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("JaggedClaw", 520, 754, 1, $z0ddWPs::RTStr);


////////////////////////////////////////////////////////////////////////////
// Northern Lights
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("NorthernLights", 483, 260, 0, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("NorthernLights", 492, 253, 0, $z0ddWPs::RepPackStr);
z0ddWPs::addWP("NorthernLights", 540, 764, 1, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("NorthernLights", 532, 771, 1, $z0ddWPs::RepPackStr);


////////////////////////////////////////////////////////////////////////////
// Obfuscation
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("Obfuscation", 202, 876, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Obfuscation", 283, 836, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Obfuscation", 283, 836, 0, $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("Obfuscation", 300, 908, 0, $z0ddWPs::PlasmaTurStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("Obfuscation", 203, 786, 0, $z0ddWPs::PlasmaTurStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("Obfuscation", 208, 883, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Obfuscation", 834, 201, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Obfuscation", 752, 241, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Obfuscation", 752, 241, 1, $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("Obfuscation", 734, 172, 1, $z0ddWPs::PlasmaTurStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("Obfuscation", 821, 284, 1, $z0ddWPs::PlasmaTurStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("Obfuscation", 827, 196, 1, $z0ddWPs::RepPackStr);


////////////////////////////////////////////////////////////////////////////
// IceDagger
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("IceDagger", 222, 233, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("IceDagger", 222, 267, 0, $z0ddWPs::NorthStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("IceDagger", 222, 200, 0, $z0ddWPs::SouthStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("IceDagger", 218, 231, 0, $z0ddWPs::PulseSenStr);
z0ddWPs::addWP("IceDagger", 808, 786, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("IceDagger", 808, 820, 1, $z0ddWPs::NorthStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("IceDagger", 808, 753, 1, $z0ddWPs::SouthStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("IceDagger", 813, 789, 1, $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("IceDagger", 584, 487, 2, $z0ddWPs::SwitchStr);


////////////////////////////////////////////////////////////////////////////
// MidnightMayhem_deluxe
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("MidnightMayhem_deluxe", 124, 510, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("MidnightMayhem_deluxe", 217, 374, 0, $z0ddWPs::RTStr);
z0ddWPs::addWP("MidnightMayhem_deluxe", 886, 491, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("MidnightMayhem_deluxe", 798, 619, 1, $z0ddWPs::RTStr);


////////////////////////////////////////////////////////////////////////////
// MidnightMayhem_deluxe
// This entry is for 5150 servers. 5150 servers have 2 MM-dlx entries. The
// 2nd one has a space at the end of the $servermission name.
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("MidnightMayhem_deluxe ", 124, 510, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("MidnightMayhem_deluxe ", 217, 374, 0, $z0ddWPs::RTStr);
z0ddWPs::addWP("MidnightMayhem_deluxe ", 886, 491, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("MidnightMayhem_deluxe ", 798, 619, 1, $z0ddWPs::RTStr);


////////////////////////////////////////////////////////////////////////////
// Raindance
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("Raindance", 534, 133, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Raindance", 577, 138, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Raindance", 458, 263, 0, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Raindance", 532, 329, 0, $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("Raindance", 428, 819, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Raindance", 386, 844, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Raindance", 460, 675, 1, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Raindance", 460, 555, 1, $z0ddWPs::PlasmaTurStr);


////////////////////////////////////////////////////////////////////////////
// Reliquary
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Reliquary", 634, 190, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Reliquary", 811, 126, 0, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Reliquary", 553, 111, 0, $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("Reliquary", 476, 265, 0, $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("Reliquary", 631, 211, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Reliquary", 616, 196, 0, $z0ddWPs::GenStr);
//z0ddWPs::addWP("Reliquary", 705, 36,  0, $z0ddWPs::VehPadStr);
z0ddWPs::addWP("Reliquary", 391, 834, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Reliquary", 214, 898, 1, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Reliquary", 471, 912, 1, $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("Reliquary", 543, 757, 1, $z0ddWPs::PulseSenStr);
//z0ddWPs::addWP("Reliquary", 393, 813, 1, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Reliquary", 408, 825, 1, $z0ddWPs::GenStr);
//z0ddWPs::addWP("Reliquary", 319, 988, 1, $z0ddWPs::VehPadStr);


////////////////////////////////////////////////////////////////////////////
// Rollercoaster
////////////////////////////////////////////////////////////////////////////
//z0ddWPs::addWP("Rollercoaster", 595, 874, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Rollercoaster", 488, 902, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Rollercoaster", 587, 874, 0, $z0ddWPs::SolarStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("Rollercoaster", 604, 869, 0, $z0ddWPs::SolarStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("Rollercoaster", 601, 886, 0, $z0ddWPs::VehPadStr);
//z0ddWPs::addWP("Rollercoaster", 484, 126, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Rollercoaster", 382, 168, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Rollercoaster", 491, 119, 1, $z0ddWPs::SolarStr, $z0ddWPs::OneStr);
//z0ddWPs::addWP("Rollercoaster", 473, 127, 1, $z0ddWPs::SolarStr, $z0ddWPs::TwoStr);
//z0ddWPs::addWP("Rollercoaster", 492, 134, 1, $z0ddWPs::VehPadStr);


////////////////////////////////////////////////////////////////////////////
// SideWinder
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("SideWinder", 154, 459, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("SideWinder", 200, 518, 0, $z0ddWPs::NorthStr @ " " @ $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("SideWinder", 229, 350, 0, $z0ddWPs::SouthStr @ " " @ $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("SideWinder", 149, 397, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("SideWinder", 154, 375, 0, $z0ddWPs::VehPadStr);
z0ddWPs::addWP("SideWinder", 851, 628, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("SideWinder", 785, 739, 1, $z0ddWPs::NorthStr @ " " @ $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("SideWinder", 806, 569, 1, $z0ddWPs::SouthStr @ " " @ $z0ddWPs::PlasmaTurStr);
//z0ddWPs::addWP("SideWinder", 856, 691, 1, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("SideWinder", 851, 712, 1, $z0ddWPs::VehPadStr);


////////////////////////////////////////////////////////////////////////////
// Simoom
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Simoom", 121, 553, 0, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Simoom", 233, 603, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Simoom", 124, 550, 0, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Simoom", 239, 599, 0, $z0ddWPs::ELFTurStr);
z0ddWPs::addWP("Simoom", 189, 489, 0, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Simoom", 188, 467, 0, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("Simoom", 107, 639, 0, $z0ddWPs::VehPadStr);
z0ddWPs::addWP("Simoom", 902, 470, 1, $z0ddWPs::BaseStr);
z0ddWPs::addWP("Simoom", 791, 421, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Simoom", 900, 473, 1, $z0ddWPs::RTStr);
//z0ddWPs::addWP("Simoom", 786, 426, 1, $z0ddWPs::ELFTurStr);
z0ddWPs::addWP("Simoom", 836, 535, 1, $z0ddWPs::RepPackStr);
//z0ddWPs::addWP("Simoom", 837, 557, 1, $z0ddWPs::EPackStr);
//z0ddWPs::addWP("Simoom", 915, 381, 1, $z0ddWPs::VehPadStr);


////////////////////////////////////////////////////////////////////////////
// Snowblind
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Snowblind", 194, 502, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Snowblind", 445, 681, 0, $z0ddWPs::TowerStr);
z0ddWPs::addWP("Snowblind", 862, 607, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("Snowblind", 515, 418, 1, $z0ddWPs::TowerStr);


////////////////////////////////////////////////////////////////////////////
// SpinCycle
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("SpinCycle", 505, 853, 0, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("SpinCycle", 520, 834, 0, $z0ddWPs::SouthStr @ $z0ddWPs::EastStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("SpinCycle", 492, 872, 0, $z0ddWPs::NorthStr @ $z0ddWPs::WestStr @ " " @ $z0ddWPs::ELFTurStr);
z0ddWPs::addWP("SpinCycle", 508, 203, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("SpinCycle", 527, 186, 1, $z0ddWPs::SouthStr @ $z0ddWPs::EastStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("SpinCycle", 488, 218, 1, $z0ddWPs::NorthStr @ $z0ddWPs::WestStr @ " " @ $z0ddWPs::ELFTurStr);
//z0ddWPs::addWP("SpinCycle", 463, 521, 2, $z0ddWPs::SwitchStr);


////////////////////////////////////////////////////////////////////////////
// Stonehenge
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Stonehenge", 230, 244, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("Stonehenge", 814, 735, 1, $z0ddWPs::FlagStandStr);

// stonehenge_pub - added by powdahound 11/11/02
z0ddWPs::addWP("StonehengePUB", 230, 244, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("StonehengePUB", 814, 735, 1, $z0ddWPs::FlagStandStr);


////////////////////////////////////////////////////////////////////////////
// Added for the ReZurection CTF Map Pack by Kallysto
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// DeadlyValley
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("DeadlyValley", 869, 479, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("DeadlyValley", 211, 465, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("DeadlyValley", 873, 470, 0, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("DeadlyValley", 212, 456, 1, $z0ddWPs::BaseStr);

////////////////////////////////////////////////////////////////////////////
// DesertNights
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("DesertNights", 441, 772, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("DesertNights", 352, 266, 1, $z0ddWPs::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// StoneDust
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("StoneDust", 403, 498, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("StoneDust", 776, 486, 1, $z0ddWPs::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// MistyLinks
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("MistyLinks", 410, 779, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("MistyLinks", 650, 380, 1, $z0ddWPs::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Antarcticspell
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("AntarcticSpell", 399, 785, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("AntarcticSpell", 253, 256, 1, $z0ddWPs::FlagStandStr);
//z0ddWPs::addWP("AntarcticSpell", 482, 743, 0, $z0ddWPs::BaseStr);
//z0ddWPs::addWP("AntarcticSpell", 359, 235, 1, $z0ddWPs::BaseStr);

////////////////////////////////////////////////////////////////////////////
// QuickSand
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("QuickSand", 539, 780, 0, $z0ddWPs::FlagStandStr);
z0ddWPs::addWP("QuickSand", 530, 257, 1, $z0ddWPs::FlagStandStr);


////////////////////////////////////////////////////////////////////////////
// Added for the OpenCall2 Map Pack by Superslug
// Last updated 7-15-02
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// Bastard Forge
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Bastard_Forge", 377, 297, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Bastard_Forge", 606, 718, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Control
////////////////////////////////////////////////////////////////////////////
z0ddWPS::addWP("Control", 808, 750, 0, $z0ddWPS::FlagStandStr);
z0ddWPS::addWP("Control", 162, 203, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Integration
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Integration", 847, 353, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Integration", 228, 546, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Hildebrand
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Hildebrand", 488, 259, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Hildebrand", 445, 751, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Runout
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Runout", 879, 736, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Runout", 134, 289, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// StarFall
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("StarFall", 556, 251, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("StarFall", 554, 764, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Tesseract
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Tesseract", 512, 907, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Tesseract", 512, 109, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Sand_Pits
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Sand_Pits", 341, 299, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Sand_Pits", 758, 714, 1, $z0ddWPS::FlagStandStr);

////////////////////////////////////////////////////////////////////////////
// Bastard Forge Day
// Added 8-23-02
////////////////////////////////////////////////////////////////////////////
z0ddWPs::addWP("Bastard_Forge_Day", 376, 298, 0, $z0ddWPS::FlagStandStr);
z0ddWPs::addWP("Bastard_Forge_Day", 606, 718, 1, $z0ddWPS::FlagStandStr);
