//================================================================================================
// Realtime Clock Hud using Andrew's Timestamp patch.
// Timalis 2003
//
// The timestamp Code itself is Copyrighted by Andrew.
//
//================================================================================================

// Next line is editable
$realtime::pos = "300 0 100 34";

//Everything below here is geeky nerdy scripting stuff.
event::attach(eventconnected, realtime::parse);
function realtime::parse()
{
	%str = timestamp();
	
	$TimeStamp::Year = String::GetSubStr(%str, 0, 4);
	$TimeStamp::Month = String::GetSubStr(%str, 5, 2);
	$TimeStamp::Day = String::GetSubStr(%str, 8, 2);
	$timestamp::Half = "AM";
	$TimeStamp::Hour = String::GetSubStr(%str, 11, 2);
	if($timestamp::hour >= 13){
		$timestamp::hour= $timestamp::hour - 12;
		$timestamp::Half = "PM";}
	$TimeStamp::Minute = String::GetSubStr(%str, 14, 2);
	$TimeStamp::Second = String::GetSubStr(%str, 17, 2);
	$TimeStamp::Millisecond = String::GetSubStr(%str, 20, 3);
	%textline = "<f0>"@$timestamp::hour @ ":" @ $timestamp::minute @ " " @$timestamp::half;
	%textline1 = $timestamp::day @ "/" @ $timestamp::month @ "/" @ $timestamp::year;
	%textline = %textline1 @ "\n" @ %textline;
	control::setvalue("Realtime::Text", %textline);
	//Update the hud in 60 seconds.
	schedule::Add("realtime::parse();", 60);


}


$realtime::created = false;
$realtime::loaded = false;
event::Attach(eventguiopen, realtime::opengui);
function realtime::openGui(%gui)
{
	if(%gui != "playGui")
		return;
	if(!$realtime::loaded){
		addtoset(playGui, $realtime_container);
		$realtime::loaded = true;
	}
}

function realtime::closeGui(%gui)
{
	if(%gui != "playGui")
		return;
	if($realtime::loaded) {
		removefromset(playGui, $realtime_container);
	}

}

function realtime::create()
{
%x = getword($realtime::pos, 0);
%y = getword($realtime::pos, 1);
%w = getword($realtime::pos, 2);
%h = getword($realtime::pos, 3);

	if($realtime::created)
		return;
	$realtime_container = newobject("Realtime::Container", simgui::control, %x, %y, %w, %h);
	$realtime_text = newobject("RealTime::Text", fearguiformattedtext, 0,0,%w,%h);
	addtoset($realtime_container, $realtime_text);
	$realtime::Created = true;
}

realtime::Create();
event::attach(eventquit, realtime::destroy);
function realtime::destroy()
{
	deleteobject($realtime_container);
	$realtime::Created = false;
}