////////////////////////////////////////////////////////////
// File:	ReminderHUD.cs
// Version:	1.0
// Release Date: 2003-8-12
// Author:	GreyHound
// Credits:	Runar, MentalTrouser,Andrew, Timalis, many others
// The timestamp Code itself is Copyrighted by Andrew.
// Info:	Popup Hud at specified time. Dont let ur noodle cook until there is no water anymore =)
// installation:: exec the file in ur autoexec.cs 
////////////////////////////////////////////////////////////
$hight = 120;
$width = 250;
$popuptime = 10;
//how often do we want to update?
$updatetime = 50; 

//we press ctrl-r to cancel the popup (if u cant wait $popuptime secs)
$reminder::hidekey = "r";
bindCommand(keyboard0, make, control, $reminder::hidekey, TO, "ReminderHUD::toggle();");
bindCommand(keyboard0, break, alt, $reminder::hidekey, TO, "");

//Examples:
//////////////////////////////////////////////////////////////////////////
//this example reminds at 18:58 10th of August 2003 ( hour minutes day month year )
// 18 58 10 08 2003
//you can also remind on weekends(1), workdays(2) or every day(3) or on every specific day every week(4) - syntax below
// (1) - weekend
// (2) - workday
// (3) - always
// (4) - saturday, sunday, monday, tuesday, wednesday, thurday, friday
//examples:
// 19 30 always ---> 19:30 every day
// 19 30 workday  ---> 19:30 on workdays
// 19 30 weekend  ---> 19:30 on weekends
// 19 30 sunday ---> 19:30 every sunday
// 19 30 monday ---> 19:30 every monday
//etc. etc. etc. 


$reminder[1] = "17 06 17 08 2003";
$message[1] = "Pay the b33r bill";
$reminder[2] = "17 08 sunday";
$message[2] = "Get fresh b33r";
$reminder[3] = "17 10 weekend";
$message[3] = "Wohoooo its weekend!!";
$reminder[4] = "";
$message[4] = "";
$reminder[5] = "";
$message[5] = "";
$reminder[6] = "";
$message[6] = "";
$reminder[7] = "";
$message[7] = "";
$reminder[8] = "";
$message[8] = "";
$reminder[9] = "";
$message[9] = "";
$reminder[10] = "";
$message[10] = "";

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//no need to change anything below
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//script should know how many days a month has //were use normal years (feb = 28days)
$month[1] = "31";
$month[2]  = "59";
$month[3]  = "90";
$month[4]  = "120";
$month[5]  = "151";
$month[6]  = "181";
$month[7]  = "212";
$month[8]  = "243";
$month[9]  = "273";
$month[10] = "304";
$month[11] = "334";
$month[12] = "365";

//we havent posted the reminder yet
$done = "0";

//we dont have the Hud yet
$ReminderHUD::Exist = "False";

//some events
Event::Attach(eventLoadPlayGui, ReminderHUD::Create);
Event::Attach(eventUpdateTime, ReminderHUD::Update);
Event::Attach(eventExit, ReminderHUD::Destroy);

////////////////////////////////////////////////////////////



// Create HUD, if exists Update
function ReminderHUD::Create()
{
	if($ReminderHUD::Exist)
	{
		return;
	}

	// Just to make sure we delete any stale objects
	ReminderHUD::Destroy();

	// Calculate the position with the chathud
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");
	%rx = %x /2 - ($width /2);
	%ry = %y /4;
	// Make sure we don't double it!
	$ReminderHUD::Exist = "True";

	// Here's the container
	%hudContainer=newObject("ReminderHUD_Container", SimGui::Control, %rx, %ry, $width, $hight);

	//here the frame
	%hudframe = newobject("ReminderHUD_Frame", feargui::fearguimenu, 0,0, $width, $hight);

	// Here's text object
	%hudText=newObject("ReminderHUD_Text", FearGuiFormattedText, 0, 0, $width, $hight);
	// Another text object
	%hudText2=newObject("ReminderHUD_Text2", FearGuiFormattedText, 0, 17, $width, $hight-10);
	// Another text object
	%hudText3=newObject("ReminderHUD_Text3", FearGuiFormattedText, 0, 37, $width, $hight-30);
	// Another text object
	%hudText4=newObject("ReminderHUD_Text4", FearGuiFormattedText, 0, 47, $width, $hight-30);
	// Another text object
	%hudText5=newObject("ReminderHUD_Text5", FearGuiFormattedText, $width - 180, $hight-20, 70, 10);
// Another text object
	%hudText6=newObject("ReminderHUD_Text6", FearGuiFormattedText, 0, 27, $width, $hight-20);
	
	//Add Frame to container
	addToSet(%hudContainer, %hudframe);
	
	// Add text to container
	addToSet(%hudContainer, %hudText);
	addToSet(%hudContainer, %hudText2);
	addToSet(%hudContainer, %hudText3);
	addToSet(%hudContainer, %hudText4);
	addToSet(%hudContainer, %hudText5);
	addToSet(%hudContainer, %hudText5);
	addToSet(%hudContainer, %hudText6);
	
	// Add the container to PlayGui
	addToSet(PlayGui, %hudContainer);

	control::setExtent("CompassHud", 64, 40);
	
	//we dont want it visible
	Control::SetVisible("ReminderHUD_Container", "false");
}

function ReminderHUD::Update()
{
	schedule::add("ReminderHUD::Iterate();", 1);
}

function ReminderHUD::Iterate()
{
	//we need the current time
	reminder::parse();
	
	//we save them, ch = currenthour etc.
	%ch = $currenthour;
	%cm = $currentminute;
	%cd = $currentday;
	%cmo = $currentmonth;
	%cy = $currentyear;
	
	//This are the first saturday of the next years
	if (%cy == 2003)
	{
		%startamountdays = 4;
	}
	if (%cy == 2004)
	{
		%startamountdays = 3;
	}
	if (%cy == 2005)
	{
		%startamountdays = 1;
	}
	if (%cy == 2006)
	{
		%startamountdays = 7;
	}
	if (%cy == 2007)
	{
		%startamountdays = 6;
	}
	if (%cy == 2008)
	{
		%startamountdays = 5;
	}
	

	//we need all dates to check if we got an event
	for(%remindcounter = 1 ; %remindcounter < 11 ; %remindcounter++)
	{
		%h[%remindcounter] = getword($reminder[%remindcounter], 0);
		%m[%remindcounter] = getword($reminder[%remindcounter], 1);
		%d[%remindcounter] = getword($reminder[%remindcounter], 2);
		%mo[%remindcounter] = getword($reminder[%remindcounter], 3);
		%y[%remindcounter] = getword($reminder[%remindcounter], 4);
	
		//if we display on more than one single day we just tell the computer today is the day we want to post
		//for all days, quite easy
		if (%d[%remindcounter] == always)
		{
		//if we are on a day before the sirst saturday in the year we need some tweaking
		$reminderHUD::display = "Every day";
			if (%cy == 2004 && %cd <= %startamountdays){
				%difference = %difference +4; 
			}
			if (%cy == 2005 && %cd <= %startamountdays){
				%difference = %difference +6; 
			}
			if (%cy == 2007 && %cd <= %startamountdays){
				%difference = %difference +1; 
			}
			if (%cy == 2008 && %cd <= %startamountdays){
				%difference = %difference +2; 
			}
			//dumb computer needs to think today is the day
			%d[%remindcounter] = %cd;
			%mo[%remindcounter] = %cmo;
			%y[%remindcounter] = %cy;
		}
		
		//we check if its a special options
		if (%d[%remindcounter] == weekend || %d[%remindcounter] == workday || %d[%remindcounter] == saturday  || %d[%remindcounter] == sunday  || %d[%remindcounter] == monday  || %d[%remindcounter] == tuesday  || %d[%remindcounter] == wednesday  || %d[%remindcounter] == friday)
		{	
			%s = %cmo-1;
			
			//counting days
			if (%cy == 2004 || %cy == 2008)
			{
				%currentday = $month[%s] + %cd+1;
				if (%cmo == 02){
					%currentday = $month[%s] + %cd;
				}
			} else {
				%currentday = $month[%s] + %cd;
				$abc = %currentday;
			}
			
			//if january we only need the days.
			if (%cmo == 01)
			{
				%currentday = %cd;
			}
			
			$currentday = %currentday;
			//we approach currentday in weekly steps (so we keep the saturday)
			for(%i = %startamountdays+1; %i <= $currentday; %i++)
			{
				%i = %i+6;
				$i = %i;
				$samstage[$i] = $i-7;
			}
			%difference = %currentday - $samstage[$i];
			
			//if we are on a day before the sirst saturday in the year we need some tweaking
			if (%cy == 2004 && %cd <= %startamountdays){
				%difference = %difference +4; 
			}
			if (%cy == 2005 && %cd <= %startamountdays){
				%difference = %difference +6; 
			}
			if (%cy == 2007 && %cd <= %startamountdays){
				%difference = %difference +1; 
			}
			if (%cy == 2008 && %cd <= %startamountdays){
				%difference = %difference +2; 
			}
			
			//thats the var we use to check what day we have
			$debug::difference = %difference;
			cpday();
			//here we see if we have weekend or not
			if (%difference != 0 && %difference != 1 && %difference != 7) 
			{
				$status::workday = "true";
			}
			else
			{
				if (%d[%remindcounter] == weekend) 
				{
				$reminderHUD::display = "On weekends";
						%d[%remindcounter] = %cd;
						%mo[%remindcounter] = %cmo;
						%y[%remindcounter] = %cy;
				}
			}
		
		}
			//we save display var and pretent to have the correct day 
			if (%d[%remindcounter] == workday)
			{
				if($status::workday)
				{
				$reminderHUD::display = "On workdays";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
				}
			}
			
			if (%d[%remindcounter] == saturday){
				if($reminderHUD::saturday){
				$reminderHUD::display = "Every Saturday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::saturday = "false";
				}
			}
			if (%d[%remindcounter] == sunday){
				if($reminderHUD::sunday){
				$reminderHUD::display = "Every Sunday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::sunday = "false";
				}
			}
			if (%d[%remindcounter] == monday){
				if($reminderHUD::monday){
				$reminderHUD::display = "Every Monday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::monday = "false";
				}
			}
			if (%d[%remindcounter] == tuesday){
				if($reminderHUD::tuesday){
				$reminderHUD::display = "Every Tuesday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::tuesday = "false";
				}
			}
			if (%d[%remindcounter] == wednesday){
				if($reminderHUD::wednesday){
				$reminderHUD::display = "Every Wednesday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::wednesday = "false";
				}
			}
			if (%d[%remindcounter] == thursday){
				if($reminderHUD::thursday){
				$reminderHUD::display = "Every Thursday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::thursday = "false";
				}
			}
			if (%d[%remindcounter] == friday){
				if($reminderHUD::friday){
				$reminderHUD::display = "Every Friday";
					%d[%remindcounter] = %cd;
					%mo[%remindcounter] = %cmo;
					%y[%remindcounter] = %cy;
					$reminderHUD::friday = "False";
				}
			}
	//if we have a single posting we set the display var hier
	if ($reminderHUD::display != "On weekends" && $reminderHUD::display != "On workdays" && $reminderHUD::display != "Every Saturday"  && $reminderHUD::display != "Every Sunday"  && $reminderHUD::display != "Every Monday"  && $reminderHUD::display != "Every Tuesday"  && $reminderHUD::display != "Every Wednesday"  && $reminderHUD::display != "Every Thursday" && $reminderHUD::display != "Every Friday")	
		{
		$reminderHUD::display = "Only this time";
		}

	
	//we havent posted yet (avoiding continous posing the whole minute that is equal to the reminder)
		if ($done == "0")
		{
			//if time/date is equal reminder time/date
			if(%d[%remindcounter] == %cd && %m[%remindcounter] == %cm && %h[%remindcounter] == %ch && %mo[%remindcounter] == %cmo && %y[%remindcounter] == %cy)
			{
					//... we tell the HUD what to display
					Control::setValue("ReminderHUD_Text", "<JC> -=椺` <F2>Reminder<F3> `=-");
					Control::setValue("ReminderHUD_Text2", "<JC><F2>" @%h[%remindcounter]@ ":" @%m[%remindcounter]@ " "@$debug::d@", "@%y[%remindcounter]@"/"@%mo[%remindcounter]@"/"@%d[%remindcounter]);
					Control::setValue("ReminderHUD_Text6", "<JC><F2>Displayed: <f1>"@$reminderHUD::display);	
					Control::setValue("ReminderHUD_Text3", "<JC><F2>-------------------------------------");																
					Control::setValue("ReminderHUD_Text4", "<JC><F2>" @$message[%remindcounter]);
					Control::setValue("ReminderHUD_Text5", "<JC><F2><F2>  GreyHound");
					//...we make it visible
					Control::SetVisible("ReminderHUD_Container", "True");
					//...and invisible again (after 8 secs)
					schedule::Add("ReminderHUD::toggle();", $popuptime);
					//...we remember we already reminded		
					$done = "1";
			}
			
		
		} else {
		//if its 1 minute after the reminding we allow to display another reminder
			if (%d[%remindcounter] == %cd && %cm == %m[%remindcounter]+1 && %h[%remindcounter] == %ch && %mo[%remindcounter] == %cmo && %y[%remindcounter] == %cy) 
			{	
			$done = "0"; 
			}
		}
	}
	//we do that all day long (every $updatetime secs)
	Schedule::Add("ReminderHUD::Iterate();", $updatetime);
}

function ReminderHUD::toggle()
{
	if(Control::GetVisible("ReminderHUD_Container"))
	{
		// Make it not visible
		Control::SetVisible("ReminderHUD_Container", "False");
	}
	else
	{
		// Make it visible
		Control::SetVisible("ReminderHUD_Container", "True");
	}

}

//we kill the hud
function ReminderHUD::Destroy()
{
	HUD::Destroy("ReminderHUD_");
	HUD::Destroy("ReminderHUD_");
	$ReminderHUD::Exist = "False";
}


function reminder::parse()
{
//parsing data
	$str = timestamp();
	$currenthour = string::getsubstr($str, 11, 2);
	$currentminute = string::getsubstr($str, 14, 2);
	$currentyear = string::getsubstr($str, 0, 4);
	$currentmonth = string::getsubstr($str, 5, 2);
	$currentday = string::getsubstr($str, 8, 2);
	schedule::Add("timtime::parse();", 60);
	//remoteBP(2048, "<JC><F2>Predefined Setting:<F1>" @$str@ "!" , 10);

}

//copied from viking
function Viking::ScreenSize(%val)
{
	if(%val == "x")
	{
		return getWord(Control::getExtent(playGui), 0);
	}
	else
	{
		return getWord(Control::getExtent(playGui), 1);
	}
}

// This is copied from MentalTrousers web-site.
function HUD::Destroy(%hudstring)
{
	%ngs = nameToId(NamedGuiSet);
	%len = Group::objectCount(%ngs);
	for(%i = 0; %i < %len; %i++)
	{
		%obj = Group::getObject(%ngs, %i);
		%objectName=Object::getName(%obj);
  
  		if(String::findSubStr(%objectname, %hudstring) != -1 )
			deleteObject(%obj);
	}
	return;
}

function reminder::hide()
{
Control::SetVisible("ReminderHUD_Container", "False");
}

function cpday(){
if ($debug::difference == 0)
{
$debug::d = "Saturday";
$reminderHUD::saturday = "True";
}
if ($debug::difference == 1)
{
$debug::d = "Sunday";
$reminderHUD::sunday = "True";
}
if ($debug::difference == 2)
{
$debug::d = "Monday";
$reminderHUD::monday = "True";
}
if ($debug::difference == 3)
{
$debug::d = "Tuesday";
$reminderHUD::tuesday = "True";
}
if ($debug::difference == 4)
{
$debug::d = "Wednesday";
$reminderHUD::wednesday = "True";
}
if ($debug::difference == 5)
{
$debug::d = "Thursday";
$reminderHUD::thursday = "True";
}
if ($debug::difference == 6)
{
$debug::d = "Friday";
$reminderHUD::friday = "True";
}
if ($debug::difference == 7)
{
$debug::d = "Saturday";
$reminderHUD::saturday = "True";
}
}