function stack::push(%var, %item0, %item1, %item2, %item3, %item4, %item5, %item6, %item7)
{
	if ($Stack::[%var, count] == "")
		$Stack::[%var, count] = 0;

	%idx = $Stack::[%var, count];

	for (%i = 0; %item[%i] != ""; %i++)
	{
		$Stack::[%var, %idx, %i] = %item[%i];
	}

	if (%item[0] != "")
	{
		$Stack::[%var, count]++;
	}
}

function stack::pushUnique(%var, %item)
{
	if (!stack::find(%var, %item))
	{
		stack::push(%var, %item);
	}
}

function stack::pop(%var)
{
	if ($Stack::[%var, count])
	{
		%result = $Stack::[%var, $Stack::[%var, count]];
		$Stack::[%var, count]--;
	}
	else
	{
		%result = FALSE;
	}

	return %result;
}

function stack::clear(%var)
{
	deleteVariables("$Stack::" @ %var @ "*");
	$Stack::[%var, count] = 0;
	$Stack::[%var, idx] = 0;
}


function stack::reset(%var)
{
	$Stack::[%var, idx] = 0;
}

function stack::freeze(%var)
{
	stack::push(%var @ "______abcd", $Stack::[%var, idx]);
}

function stack::unfreeze(%var)
{
	if (stack::count(%var @ "______abcd") > 0)
		$Stack::[%var, idx] = stack::pop(%var @ "______abcd");
}

function stack::getnext(%var)
{
	if ($Stack::[%var, idx] == "")
		$Stack::[%var, idx] = 0;

	if ($Stack::[%var, idx] < $Stack::[%var, count])
	{
		%idx = $Stack::[%var, idx];
		for (%i = 0; $Stack::[%var, %idx, %i] != ""; %i++)
		{
			$stack::result[%i] = $Stack::[%var, %idx, %i];
		}

		$Stack::[%var, idx]++;

		%result = $Stack::[%var, %idx, 0];
		if (%result == FALSE)
			%result = "- ";
		$stack::result = TRUE;
	}
	else
	{
		%result = FALSE;
		$stack::result = FALSE;
	}


	//echo("stack:: " @ %var @ "= " @ %result);
	return %result;
}

function stack::find(%var, %search)
{
	//echo ("searching " @ %var @ " for " @ %search);

	%result = FALSE;
	%idx = 0;
	while (%idx < $Stack::[%var, count])
	{
		for (%i = 0; $Stack::[%var, %idx, %i] != ""; %i++)
		{
			if ($Stack::[%var, %idx, %i] == %search)
			{
				%result = TRUE;
				break;
			}
		}

		%idx++;
	}


	//echo("searching " @ %var @ " for " @ %search @ " = " @ %result);
	return %result;
}

function stack::count(%var)
{
	return $Stack::[%var, count];
}

function stack::exist(%var)
{
	if ($Stack::[%var, count] != "")
		return TRUE;
	else
		return FALSE;
}

function stack::test()
{
	stack::clear("test");
	stack::push("test", 1);
	stack::push("test", 2);
	stack::push("test", 3);
	
	stack::reset("test");
	echo(stack::getnext("test"));
	echo(stack::getnext("test"));
	echo(stack::getnext("test"));
	echo(stack::find("test", 1));
	echo(stack::find("test", 4));
}
