// 1 = all
// 2 = just rating

$StatHUD::Mode = "1";


Event::Attach(eventMissionChange, StatHud::Reset);
Event::Attach(eventMatchStarted, StatHud::Reset);

$StatHUD::WeaponBMP["Chaingun"] = 		"lr_chain.bmp";
$StatHUD::WeaponBMP["Disc Launcher"] =	"lr_disc.bmp";
$StatHUD::WeaponBMP["Explosives"] = 	"lr_grenade.bmp";
$StatHUD::WeaponBMP["Plasma"] =		 	"lr_plasma.bmp";
$StatHUD::WeaponBMP["Laser Rifle"] =	"lr_sniper.bmp";
$StatHUD::WeaponBMP["Mortar"] =		 	"lr_mortar.bmp";
$StatHUD::WeaponBMP["Blaster"] =		"lr_blaster.bmp";
$StatHUD::WeaponBMP["Teamkill"] =		"lr_tk.bmp";
$StatHUD::WeaponBMP["MineTeamkill"] =	"lr_tk.bmp";
$StatHUD::WeaponBMP["Vehicle"] =		"lr_vehicle.bmp";

$StatHUD::Width[1] = 60;
$StatHUD::Height[1] = 50;

$StatHUD::Width[2] = 60;
$StatHUD::Height[2] = 18;

function StatHUD::Init()
{
	// Empty frame, no Update Function
	HUD::NewFrame(StatHUD, "", 0,175, $StatHUD::Width[ $StatHUD::Mode ], $StatHUD::Height[ $StatHUD::Mode ]);

	$StatHUD::Text[x] = 23;

	// Add the sh*t
	$StatHUD::Star = Object::getName(HUD::AddObject(StatHUD, FearGuiFormattedText, 0, 0, 20, 14));
	$StatHUD::RatingObj = Object::getName(HUD::AddObject(StatHUD, FearGuiFormattedText, $StatHUD::Text[x], 0, 50, 14));

	$StatHUD::Skull = Object::getName(HUD::AddObject(StatHUD, FearGuiFormattedText, 0, 15, 20, 14));
	$StatHUD::KillDeathObj = Object::getName(HUD::AddObject(StatHUD, FearGuiFormattedText, $StatHUD::Text[x], 15, 50, 14));

	$StatHUD::Weapon = Object::getName(HUD::AddObject(StatHUD, FearGuiFormattedText, 0, 30, 20, 14));
	$StatHUD::WeaponKDObj = Object::getName(HUD::AddObject(StatHUD, FearGuiFormattedText, $StatHUD::Text[x], 30, 50, 14));

	StatHUD::Reset();
	HUD::Display(StatHUD);
}

function StatHUD::Update()
{
}

function StatHUD::setRating(%rating)
{
	Control::SetValue($StatHUD::RatingObj, "<f2>" @ floor(%rating));
}

function StatHUD::setKillDeath(%kills, %deaths)
{
	Control::SetValue($StatHUD::KillDeathObj, "<f2>" @ floor(%kills) @ "<f1>/<f2>" @ floor(%deaths));
}

function StatHUD::setKillDeathWeapon(%weapon, %kills, %deaths)
{
	$StatHUD::CurWeapon = %weapon;

	%weaponbmp = $StatHUD::WeaponBMP[%weapon];

	if (%weaponbmp == "")
		%weaponbmp = "lr_question.bmp";

	Control::SetValue($StatHUD::Weapon, "<b4,4:Stats\\" @ %weaponbmp @ ">");
	Control::SetValue($StatHUD::WeaponKDObj, "<f2>" @ floor(%kills) @ "<f1>/<f2>" @ floor(%deaths));
}


function StatHUD::Reset()
{
	Control::SetValue($StatHUD::Star, "<b4,4:Stats\\star.bmp>");
	StatHUD::SetRating(0);

	Control::SetValue($StatHUD::Skull, "<b4,4:Stats\\skull.bmp>");
	StatHUD::SetKillDeath(0, 0);

	StatHUD::SetKillDeathWeapon("", 0, 0);
}

StatHUD::Init();