exec("Stats\\tagFinder.cs");

$font = "arial";

function String::replace(%string, %search, %replace)    
{
    if(%search == %replace || String::findSubStr(%replace, %search) != -1) // prevent infinite loops
        return %string;
        
    while((%idx = String::findSubStr(%string, %search)) != -1)             
    {   
        %len = String::length(%string);
        %front = String::getSubStr(%string, 0, %idx);
        %idx += String::length(%search);
        %back = String::getSubStr(%string, %idx, %len - %idx);
        %string = %front @ %replace @ %back;
    }
    return %string; 
}

function toNum(%val)
{
	if (%val == "")
		%val = 0;
	else
		%val = "<b>" @ %val @ "</b>";

	return %val;
}

function max(%i, %j)
{
	if (%i > %j)
		return %i;
	else
		return %j;
}

function MapLogger::getscore(%name)
{
	return (($MapLogger::caps[%name] * 5) +
			($MapLogger::kills[%name]) -
			($MapLogger::suicides[%name]) - 
			($MapLogger::teamkills[%name]) -
			($MapLogger::teamminekills[%name])
		   );
}


function MapLogger::heldtimes(%team, %loc)
{
	if ($loctime::[%team, %loc, count] == "") 
	{
		$loctime::[%team, %loc, count] = 1;
		$loctime::[%team, %loc] = 0;
	}

	if ($loctime::[%team, %loc] < 0.5)
		$loctime::[%team, %loc] = 0;
		
	AddExportText("<tr><td><font face=" @ $font @ " size=2>"@ %loc @"</td><td><font face=" @ $font @ " size=2>"@ $loctime::[%team, %loc] @"</td><td><font face=" @ $font @ " size=2>"@ $loctime::[%team, %loc] / $loctime::[%team, %loc, count] @"</td></tr>");
}

function MapLogger::playerTimeLines()
{
	%totalTime = ($MapLogger::stop - $MapLogger::start);

	%htmlwidth = (100 * %totalTime) / 10;

	deleteVariables("$loctime::*");

	for (%i = 0; %i <= 1; %i++)
	{
		AddExportText("<table cellspacing=0 cellpadding=0>");
		AddExportText("<tr><td colspan=5><font face=" @ $font @ " size=2><b><center>Team " @ $FileExport::TeamTag[%i] @ " Flag</td></tr>");
		AddExportText("<tr>");

		stack::reset("flagloc" @ %i);

		%start = $MapLogger::start;
		%lastloc = "home";
		%lastrealloc = %lastloc;
		%textline = "";

		while (stack::getnext("flagloc" @ %i))
		{
			%stop = $stack::result[0];
			%loc = $stack::result[1];

			$loctime::[%i, %lastrealloc] += (%stop - %start);
			$loctime::[%i, %lastrealloc, count]++; 

			%length = ((%stop - %start) / %totalTime) * %htmlwidth;
			addExportText("<td colspan=1><img src=flag" @ %lastloc @ ".jpg height=1 width=" @ floor(%length) @ "></td>");

			%lastrealloc = %loc;
			if ((%loc != "") && (%loc != "field") && (%loc != "home"))
				%loc = "player";

			%start = %stop;
			%lastloc = %loc;
		}
		AddExportText(%textline @ "</tr>");
		AddExportText("</table>");
	}

	AddExportText("<table>");
	for (%i = -1; %i <= 1; %i++)
	{
		stack::reset("teamlist" @ %i); 
		AddExportText("<tr><td colspan=1><font face=" @ $font @ " size=2><b><center>" @ $FileExport::TeamTag[%i] @ "</td></tr>");

		while ((%name = stack::getnext("teamlist" @ %i)) != FALSE)
		{
			AddExportText("<tr><td><font face=" @ $font @ " size=1><b>" @ %name @ "</td>");

			AddExportText("<td><font face=" @ $font @ " size=1>");
			%oldstop = $MapLogger::start;
			stack::reset("starttime" @ %name); 
			stack::reset("stoptime" @ %name); 

			$MapExport::totaltime[%name,-1] = 0;
			$MapExport::totaltime[%name,0] = 0;
			$MapExport::totaltime[%name,1] = 0;

			%textline = "";
			for (%j = 0; %j < stack::count("starttime" @ %name); %j++)
			{
				stack::getnext("starttime" @ %name);
				%start = $stack::result[0];
				%team = $stack::result[1];
				%stop = stack::getnext("stoptime" @ %name);

				if (%stop == FALSE)
					%stop = getSimTime();

				$MapExport::totaltime[%name, %team] += (%stop - %start);

				//they dropped and took awhile to rejoin
				if (%start != %oldstop)
				{
					%length = ((%start - %oldstop) / %totalTime) * %htmlwidth;
					%textline = %textline @ "<img src=noteam.jpg height=6 width=" @ floor(%length) @ ">";
				}

				%length = ((%stop - %start) / %totalTime) * %htmlwidth;
				%textline = %textline @ "<img src=team" @ %team @ ".jpg height=1 width=" @ floor(%length) @ ">";

				%oldstop = %stop;
			}
			AddExportText(%textline @ "</td></tr>");
		}
	}
	AddExportText("</table>");
}

function MapLogger::ExportStats()
{
	if ($MapLogger::gamewinningcap == "")
		$MapLogger::gamewinningcap = "Nobody";

	AddExportText("<table cellspacing=0 cellpadding=0 align=center border=1>");
	AddExportText("<tr><td colspan=2><font face=" @ $font @ " size=2><b><center>Cap List</td></tr>");
	AddExportText("<tr><td><font face=" @ $font @ " size=2>"@$FileExport::TeamTag[0] @"</td><td><font face=" @ $font @ " size=2>"@ $FileExport::TeamTag[1] @"</td></tr>");

	for (%i = 0; %i < max($MapLogger::TeamScore[0], $MapLogger::TeamScore[1]); %i++)
	{
		AddExportText("<tr><td><font face=" @ $font @ " size=2>"@ $MapLogger::cap[0, %i+1] @"</td><td><font face=" @ $font @ " size=2>"@ $MapLogger::cap[1, %i+1] @"</td></tr>");
	}
	AddExportText("</table><br>");


	AddExportText("<br><Br><Br>");
	AddExportText("<table align=center border=1>");
	AddExportText("<tr><td>&nbsp;</td><td>"@ $FileExport::TeamTag[0] @"</td><td>"@ $FileExport::TeamTag[1] @"</td></tr>");
	AddExportText("<tr><td>score:</td><td>" @ toNum($MapLogger::TeamScore[0]) @ "</td><td>" @ toNum($MapLogger::TeamScore[1]) @ "</td></tr>");
	AddExportText("<tr><td>points:</td><td>" @ toNum($MapLogger::TeamPoints[0]) @ "</td><td>" @ toNum($MapLogger::TeamPoints[1]) @ "</td></tr>");
	AddExportText("<tr><td>game winning cap:</td><td colspan=2 align=center>" @ $MapLogger::gamewinningcap @ "</td></tr>");
	AddExportText("<tr><td>game length:</td><td colspan2 align=center>" @ ($MapLogger::stop - $MapLogger::start) @ "</td></tr></table>");

	AddExportText("<table cellspacing=0 cellpadding=0 border=1 align=center>");
	AddExportText("<tr><td><font face=" @ $font @ " size=2>location</td><td><font face=" @ $font @ " size=2>length</td><td><font face=" @ $font @ " size=2>average</td></tr>");
	for (%i = 0; %i <= 1; %i++)
	{
		AddExportText("<tr><td><font face=" @ $font @ " size=2>"@ $FileExport::TeamTag[%i] @"</td>");
		MapLogger::heldtimes(%i ^ 1, home);
		MapLogger::heldtimes(%i ^ 1, field);

		%teamtotal = 0;
		%teamcount = 0;
		stack::reset("teamlist" @ %i);
		while ((%name = stack::getnext("teamlist" @ %i)) != FALSE)
		{
				%teamtotal += $loctime::[%i ^ 1, %name];
				%teamcount += $loctime::[%i ^ 1, %name, count];
				MapLogger::heldtimes(%i ^ 1, %name);
		}
		AddExportText("<tr><td><font face=" @ $font @ " size=2>total:</td><td><font face=" @ $font @ " size=2>" @ %teamtotal @ "</td><td><font face=" @ $font @ " size=2>" @ %teamtotal/%teamcount @ "</td></tr>");
	}
	AddExportText("</table>");



	AddExportText("<br><table cellspacing=0 cellpadding=0 border=1 align=center>");
	AddExportText("<tr><td><font face=" @ $font @ " size=2>Name</td><td><font face=" @ $font @ " size=2>Obs Time</td><td><font face=" @ $font @ " size=2>"@ $FileExport::TeamTag[%i] @" Time</td><td><font face=" @ $font @ " size=2>"@ $FileExport::TeamTag[%i] @" Time</td>");
	for (%i = -1; %i <= 1; %i++)
	{
		AddExportText("<tr><td><font face=" @ $font @ " size=2>"@  $FileExport::TeamTag[%i]  @"</td>");

		stack::reset("teamlist" @ %i);
		while ((%name = stack::getnext("teamlist" @ %i)) != FALSE)
		{
			AddExportText("<tr><td><font face=" @ $font @ " size=2>"@ %name @"</td><td><font face=" @ $font @ " size=2>"@ $MapExport::totaltime[%name,-1] @"</td><td><font face=" @ $font @ " size=2>"@ $MapExport::totaltime[%name,0] @"</td><td><font face=" @ $font @ " size=2>"@ $MapExport::totaltime[%name,1] @"</td>");
		}
	}
	AddExportText("</table>");


	AddExportText("<br><Br><Br>");
	AddExportText("<table border=1 align=center><th align=center colspan=5><font face=" @ $font @ " size=2>Player Stats :/</th>");
	AddExportText("<tr>");
	AddExportText("<td><font face=" @ $font @ " size=2>Player</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Grabs/Pickups</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Drops</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Returns</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Cap Saves</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Caps</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Assists</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Standoff Return</td>");
	AddExportText("</tr>");

	deletevariables("$MapExport::*");
	for (%i = 0; %i <= 1; %i++)
	{
		stack::reset("teamlist" @ %i); 
		AddExportText("<tr><td colspan=7><font face=" @ $font @ " size=2><b><center>" @  $FileExport::TeamTag[%i]  @ "</td></tr>");

		while ((%name = stack::getnext("teamlist" @ %i)) != FALSE)
		{
			if ($MapLogger::grabs[%name] == "")
				$MapLogger::grabs[%name] = 0;

			if ($MapLogger::pickups[%name] == "")
				$MapLogger::pickups[%name] = 0;

			$MapExport::grabs[%i] += $MapLogger::grabs[%name];
			$MapExport::pickups[%i] += $MapLogger::pickups[%name];
			$MapExport::drops[%i] += $MapLogger::drops[%name];
			$MapExport::returns[%i] += $MapLogger::returns[%name];
			$MapExport::capSave[%i] += $MapLogger::capsave[%name];
			$MapExport::caps[%i] += $MapLogger::caps[%name];
			$MapExport::assists[%i] += $MapLogger::assists[%name];
			$MapExport::standoffreturn[%i] += $MapLogger::standoffreturn[%name];

			AddExportText("<tr>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ %name @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::grabs[%name]) @ "</td><td><font face=" @ $font @ " size=2>" @ $MapLogger::pickups[%name] @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::drops[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::returns[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::capSave[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::caps[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::assists[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::standoffReturn[%name]) @ "</td>");
			AddExportText("</tr>");
		}

		AddExportText("<tr>");
		AddExportText("<td><font face=" @ $font @ " size=2><b><u>TOTAL</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::grabs[%i]) @ "</td><td><font face=" @ $font @ " size=2>" @ $MapExport::pickups[%i] @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::drops[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::returns[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::capSave[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::caps[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::assists[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::standoffReturn[%i]) @ "</td>");
		AddExportText("</tr>");
	}
	AddExportText("</table>");

	AddExportText("<br><Br><Br>");
	AddExportText("<table border=1 align=center><th align=center colspan=5>Kill/Death Stats :/</th>");
	AddExportText("<tr>");
	AddExportText("<td><font face=" @ $font @ " size=2>Player</td colspan=2>");
	AddExportText("<td><font face=" @ $font @ " size=2>Score</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>K/D</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Chain</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Plasma</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Disc</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Explosives</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Laser</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Mortar</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Blaster</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Elf</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Vehicle</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Missile</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Crush</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Turret</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Explosion</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>Suicide</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>TK's (Mines)</td>");
	AddExportText("<td colspan=2><font face=" @ $font @ " size=2>Mine TK's</td>");
	AddExportText("<td><font face=" @ $font @ " size=2>CarrierKill</td>");
	AddExportText("</tr>");


	deletevariables("$MapExport::*");
	for (%i = 0; %i <= 1; %i++)
	{
		stack::reset("teamlist" @ %i); 
		AddExportText("<tr><td colspan=7><font face=" @ $font @ " size=2><b><center>" @  $FileExport::TeamTag[%i]  @ "</td></tr>");

		while ((%name = stack::getnext("teamlist" @ %i)) != FALSE)
		{
			if ($MapLogger::suicides[%name] == "")
				$MapLogger::suicides[%name] = 0;

			if ($MapLogger::flagsuicides[%name] == "")
				$MapLogger::flagsuicides[%name] = 0;

			$MapExport::score[%i] += MapLogger::getscore(%name);

			$MapExport::kills[%i] += $MapLogger::kills[%name];	
			$MapExport::deaths[%i] += $MapLogger::deaths[%name];

			$MapExport::kills[%i,chaingun] += $MapLogger::kills[%name, chaingun];
			$MapExport::kills[%i,plasma] += $MapLogger::kills[%name,plasma];	
			$MapExport::kills[%i,"Disc Launcher"] += $MapLogger::kills[%name,"Disc Launcher"];
			$MapExport::kills[%i,explosives] += $MapLogger::kills[%name,explosives];	
			$MapExport::kills[%i, "Laser Rifle"] += $MapLogger::kills[%name,"Laser Rifle"];
			$MapExport::kills[%i, mortar] += $MapLogger::kills[%name,mortar];
			$MapExport::kills[%i, blaster] += $MapLogger::kills[%name,blaster];
			$MapExport::kills[%i, "Elf Gun"] += $MapLogger::kills[%name, "Elf Gun"];
			$MapExport::kills[%i, vehicle] += $MapLogger::kills[%name,vehicle];

			$MapExport::deaths[%i,chaingun] += $MapLogger::deaths[%name,chaingun];
			$MapExport::deaths[%i,plasma] += $MapLogger::deaths[%name,plasma];	
			$MapExport::deaths[%i,"Disc Launcher"] += $MapLogger::deaths[%name,"Disc Launcher"];
			$MapExport::deaths[%i,explosives] += $MapLogger::deaths[%name,explosives];	
			$MapExport::deaths[%i, "Laser Rifle"] += $MapLogger::deaths[%name,"Laser Rifle"];
			$MapExport::deaths[%i, mortar] += $MapLogger::deaths[%name,mortar];
			$MapExport::deaths[%i, blaster] += $MapLogger::deaths[%name,blaster];
			$MapExport::deaths[%i, "Elf Gun"] += $MapLogger::deaths[%name, "Elf Gun"];

			$MapExport::deaths[%i, vehicle] += $MapLogger::deaths[%name,vehicle];
			$MapExport::deaths[%i, missile] += $MapLogger::deaths[%name,missile];
			$MapExport::deaths[%i,crushed] += $MapLogger::deaths[%name,crushed];
			$MapExport::deaths[%i,turret] += $MapLogger::deaths[%name,turret];
			$MapExport::deaths[%i,explosion] += $MapLogger::deaths[%name,explosion];

			$MapExport::suicides[%i] += $MapLogger::suicides[%name];
			$MapExport::teamkills[%i] += $MapLogger::teamkills[%name];
			$MapExport::teamdeaths[%i] += $MapLogger::teamdeaths[%name];
			$MapExport::teamminekills[%i] += $MapLogger::teamminekills[%name];
			$MapExport::teamminedeaths[%i] += $MapLogger::teamminedeaths[%name];

			$MapExport::carrierkills[%i] += $MapLogger::carrierkills[%name];

			AddExportText("<tr>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ %name @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ MapLogger::getscore(%name) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, chaingun]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, chaingun]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, plasma]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, plasma]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, "Disc Launcher"]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, "Disc Launcher"]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, explosives]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, explosives]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, "Laser Rifle"]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, "Laser Rifle"]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, mortar]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, mortar]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, blaster]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, blaster]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, "Elf Gun"]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, "Elf Gun"]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name, Vehicle]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, Vehicle]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, missile]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, crushed]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, turret]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Deaths[%name, explosion]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Suicides[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Teamkills[%name])     @ "</td><td><font face=" @ $font @ " size=2>"  @ toNum($MapLogger::TeamDeaths[%name])     @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::TeamMinekills[%name]) @ "</td><td><font face=" @ $font @ " size=2>"  @ toNum($MapLogger::TeamMineDeaths[%name]) @ "</td>");
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::carrierKills[%name]) @ " </td>");

			AddExportText("</tr>");
		}

		AddExportText("<tr>");
		AddExportText("<td><font face=" @ $font @ " size=2><b><u>TOTAL</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ $MapExport::score[%i] @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, chaingun]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, chaingun]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, plasma]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, plasma]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, "Disc Launcher"]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, "Disc Launcher"]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, explosives]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, explosives]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, "Laser Rifle"]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, "Laser Rifle"]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, mortar]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, mortar]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, blaster]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, blaster]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, "Elf Gun"]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, "Elf Gun"]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Kills[%i, Vehicle]) @ "</td><td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, Vehicle]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, missile]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, crushed]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, turret]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Deaths[%i, explosion]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Suicides[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::Teamkills[%i]) @ "</td><td><font face=" @ $font @ " size=2>"  @ toNum($MapExport::TeamDeaths[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::TeamMinekills[%i]) @ "</td><td><font face=" @ $font @ " size=2>"  @ toNum($MapExport::TeamMineDeaths[%i]) @ "</td>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapExport::carrierKills[%i]) @ " </td>");
		AddExportText("</tr>");
	}
	AddExportText("</table>");

	AddExportText("<table border=1 align=center><th align=center colspan=5><font face=" @ $font @ " size=2>Massive Player Matrix</th>");


	//add player name headers to the top
	AddExportText("<tr>");
	AddExportText("<td><font face=" @ $font @ " size=2>&nbsp;</td>");

	stack::reset("teamlist1");
	while ((%name[1] = stack::getnext("teamlist1")) != FALSE)
	{
		AddExportText("<td><font face=" @ $font @ " size=2>" @ %name[1] @ "</td>");
	}
	AddExportText("</tr>");

	stack::reset("teamlist0");
	while ((%name[0] = stack::getnext("teamlist0")) != FALSE)
	{
		stack::reset("teamlist1");

		AddExportText("<tr>");
		AddExportText("<td><font face=" @ $font @ " size=2>" @ %name[0] @ "</td>");
		while ((%name[1] = stack::getnext("teamlist1")) != FALSE)
		{
			AddExportText("<td><font face=" @ $font @ " size=2>" @ toNum($MapLogger::Kills[%name[0], %name[1]]) @ "/" @ toNum($MapLogger::Kills[%name[1], %name[0]]) @ "</td>");
		}

		AddExportText("</tr>");
	}
	AddExportText("</table>");

}

// Export!
function MapLogger::export()
{
	%good = client::getTeam(getManagerID());
	%bad = %good ^ 1;

	$FileExport::TeamTag[%good] =  MapLogger::getTag(%good);
	$FileExport::TeamTag[%bad] =  MapLogger::getTag(%bad);

//	%obj = newobject("FileWriterDummy", FearGuiFormattedText, 0, 0, 0, 0);
//	flushExportText();

	// Start:
//	AddExportText("<html>");
//	AddExportText("<head><title>MaTcH LoGgEr - PlAyAz VeRsIoN</title></head>");
//	AddExportText("<body bgcolor=white>");
//	AddExportText("<font face=" @ $font @ " size=1>");

	MapLogger::playerTimeLines();

//	exportObjectToScript(FileWriterDummy, "temp\\timelines.html", true);
//	deleteObject(nameToID(FileWriterDummy));
//	flushExportText();



	%obj = newobject("FileWriterDummy", FearGuiFormattedText, 0, 0, 0, 0);
	flushExportText();

	// Start:
	AddExportText("<html>");
	AddExportText("<head><title>MaTcH LoGgEr - PlAyAz VeRsIoN</title></head>");
	AddExportText("<body bgcolor=white>");
	AddExportText("<font face=" @ $font @ " size=1>");

	MapLogger::ExportStats();

	%name = string::replace(client::getname(getManagerId()), " ", "_");
	%name = string::replace(%NAME, "|", "_");
	%name = string::replace(%NAME, "<", "_");
	%name = string::replace(%NAME, ">", "_");
	%name = string::replace(%NAME, "*", "_");
	%name = string::replace(%NAME, "$", "_");
	%name = string::replace(%NAME, ":", "_");
	%name = string::replace(%NAME, "?", "_");
	%map = string::replace($matchexport::missionname, " ", "_");

	%length = $MapLogger::stop - $MapLogger::start;

	exportObjectToScript(FileWriterDummy, "temp\\" @ string::replace($Recording[$DemoOn-1], "\\", "__") @ " --" @ %length @ "-- " @ $FileExport::TeamTag[%good] @ "_vs_" @ $FileExport::TeamTag[%bad] @ "-(be-" @ $FileExport::TeamTag[0] @ ") (ds-" @ $FileExport::TeamTag[1] @ ")" @ %name @ "-" @ %map @ ".html", true);
	deleteObject(nameToID(FileWriterDummy));
	flushExportText();
}