exec("Stats\\RatingsTables.cs");

editActionMap("playMap.sae");

bindCommand(keyboard0, make, alt, "p", TO, "StatHUD::setStats(true);");
bindCommand(keyboard0, break, alt, "p", TO, "StatHUD::setStats(false);");

bindCommand(keyboard0, make, alt, "s", TO, "StatHUD::ShowPlayers();");
bindCommand(keyboard0, break, alt, "s", TO, "StatHUD::HidePlayers();");

Event::Attach(eventClientJoin, StatHUD::playerActivityTimestamp);

Event::Attach(eventMatchStarted, StatHUD::playerTimestampReset);

Event::Attach(eventKillTrak, StatHud::Kill);

Event::Attach(eventFlagTaken, StatHUD::GenericFlag);
Event::Attach(EventFlagReturned, StatHUD::GenericFlag);
Event::Attach(eventFlagCaptured, StatHUD::GenericFlag);
Event::Attach(eventFlagDropped, StatHUD::GenericFlag);

$StatHud::WeaponList[0] = "Chaingun";
$StatHud::WeaponList[1] = "Plasma";
$StatHud::WeaponList[2] = "Disc Launcher";
$StatHud::WeaponList[3] = "Explosives";
$StatHud::WeaponList[4] = "Laser Rifle";
$StatHud::WeaponList[5] = "Mortar";
$StatHud::WeaponList[6] = "Blaster";
$StatHud::WeaponList[7] = "Elf Gun";
$StatHud::WeaponList[8] = "Vehicle";

$StatHud::WeaponList[count] = 9;

// get a players rating
//

function StatHud::getRating(%name)
{
	%rating = 	($MapLogger::Kills[%name, Chaingun] 		* $StatHUD::Rating["l_chainkill"]) +
				($MapLogger::Kills[%name, "Disc Launcher"]	* $StatHUD::Rating["l_disckill"]) +
				($MapLogger::Kills[%name, Blaster] 			* $StatHUD::Rating["l_blasterkill"]) +
				($MapLogger::Kills[%name, Plasma] 			* $StatHUD::Rating["l_plasmakill"]) +
				($MapLogger::Kills[%name, Explosives] 		* $StatHUD::Rating["l_explokill"]	) +
				($MapLogger::Kills[%name, "Laser Rifle"] 	* $StatHUD::Rating["l_laserkill"]) +
				($MapLogger::Kills[%name, "Elf Gun"] 		* $StatHUD::Rating["l_elfkill"]) +
				($MapLogger::Kills[%name, Vehicle] 			* $StatHUD::Rating["l_vehickill"]) +
				($MapLogger::Kills[%name, Mortar] 			* $StatHUD::Rating["l_mortarkill"]) +
				($MapLogger::Suicides[%name] 				* $StatHUD::Rating["l_suicide"]) +
				(($MapLogger::TeamKills[%name] + 
                  $MapLogger::TeamMineKills[%name]) 		* $StatHUD::Rating["l_tk"]) +
				($MapLogger::CarrierKills[%name]			* $StatHUD::Rating["l_carrierkill"]) +
				($MapLogger::Grabs[%name] 					* $StatHUD::Rating["l_grabs"] ) +
				($MapLogger::Pickups[%name] 				* $StatHUD::Rating["l_pickups"] ) +
				($MapLogger::Drops[%name] 					* $StatHUD::Rating["l_drops"] ) +
				($MapLogger::Returns[%name] 				* $StatHUD::Rating["l_flagreturns"] ) +
				($MapLogger::standoffReturn[%name] 			* $StatHUD::Rating["l_standoff"] ) +
				($MapLogger::Assists[%name] 				* $StatHUD::Rating["l_assists"] ) +
				($MapLogger::Caps[%name] 					* $StatHUD::Rating["l_caps"] ) +
				($MapLogger::Deaths[%name, Mortar] 			* $StatHUD::Rating["l_mortardeath"] ) +
				((	$MapLogger::Deaths[%name, Chaingun] +
					$MapLogger::Deaths[%name, "Disc Launcher"] +
					$MapLogger::Deaths[%name, Blaster] +
					$MapLogger::Deaths[%name, Plasma] +
					$MapLogger::Deaths[%name, Explosives] +
					$MapLogger::Deaths[%name, "Laser Rifle"] +
					$MapLogger::Deaths[%name, "Elf Gun"] +
					$MapLogger::Deaths[%name, Vehicle]) 	* $StatHUD::Rating["l_otherdeath"] );

	return %rating;
}

// get a players kills
//
function StatHud::getKills(%name, %weapon)
{
	if (%weapon != "")
	{
		%kills = $MapLogger::Kills[%name, %weapon];
	}
	else
	{
		%kills = 0;
		for (%i = 0; %i < $StatHud::WeaponList[count]; %i++)
		{
			%kills += $MapLogger::Kills[%name, $StatHud::WeaponList[%i]];
		}
	}

	if (%kills == "")
		%kills = 0;

	return %kills;
}

// get a players deaths
//

function StatHud::getDeaths(%name, %weapon)
{
	if (%weapon != "")
	{
		%deaths = $MapLogger::Deaths[%name, %weapon];
	}
	else
	{
		%kills = 0;
		for (%i = 0; %i < $StatHud::WeaponList[count]; %i++)
		{
			%deaths += $MapLogger::Deaths[%name, $StatHud::WeaponList[%i]];
		}
	}

	if (%deaths == "")
		%deaths = 0;

	return %deaths;
}

// get the total time a player has played
//

function StatHUD::getTimePlayed(%name)
{
	Stack::freeze("starttime" @ %name);
	Stack::freeze("stoptime" @ %name);

	stack::reset("starttime" @ %name);
	stack::reset("stoptime" @ %name);


	$StatHUD::playertime[%name, -1] = 0;
	$StatHUD::playertime[%name, 0] = 0;
	$StatHUD::playertime[%name, 1] = 0;

	// Total up the time spent on each team
	for (%i = 0; %i < stack::count("starttime" @ %name); %i++)
	{
		%item = stack::getnext("starttime" @ %name);
		%start = $stack::result[0];
		%team = $stack::result[1];
		%stop = stack::getnext("stoptime" @ %name);

		if (%stop == FALSE)
			%stop = getSimTime();

		$StatHUD::playertime[%name, %team] += (%stop-%start);
	}

	%timePlayed = $StatHUD::playerTime[%name, 0] + $StatHUD::playerTime[%name, 1];

	Stack::unfreeze("starttime" @ %name);
	Stack::unfreeze("stoptime" @ %name);

	return %timePlayed;
}

// set the appropriate stat values in StatHUD
//

function StatHUD::setStats(%project)
{
	%myName = Client::getName(getManagerID());

	%weaponKills = StatHud::getKills(%myName, $StatHUD::CurWeapon);
	%weaponDeaths = StatHud::getDeaths(%myName, $StatHUD::CurWeapon);

	%Kills = StatHud::getKills(%myName);
	%Deaths = StatHud::getDeaths(%myName);

	%rating = StatHUD::getRating(%myName);

	if (%project == true)
	{
		%timePlayed = StatHUD::getTimePlayed(%myName);
		if (%timePlayed <= 0)
			%timePlayed = 1;

		%weaponKills = %weaponKills * ((25 * 60) / %timePlayed);
		%weaponDeaths = %weaponDeaths * ((25 * 60) / %timePlayed);
		%Kills = %Kills * ((25 * 60) / %timePlayed);
		%Deaths = %Deaths * ((25 * 60) / %timePlayed);
		%rating = %rating * ((25 * 60) / %timePlayed);
	}

	StatHUD::setKillDeath(%kills, %deaths);
	StatHUD::setKillDeathWeapon($StatHUD::CurWeapon, %weaponkills, %weapondeaths);

	StatHUD::setRating(%rating);
}

// our kill functions, triggers a stat update
//

function StatHud::Kill(%killer, %victim, %weapon)
{
	StatHUD::playerActivityTimestamp(%killer);
	StatHUD::playerActivityTimestamp(%victim);

	// update stat sheet
	if ($StatHUD::StatSheetVisible)
		StatHUD::ShowPlayers();

	%me = getManagerId();

	if (!((%killer == %me) || (%victim == %me)))
		return;

	%myName = Client::getName(getManagerID());

	%weaponKills = StatHud::getKills(%myName, %weapon);
	%weaponDeaths = StatHud::getDeaths(%myName, %weapon);

	%Kills = StatHud::getKills(%myName);
	%Deaths = StatHud::getDeaths(%myName);

	%rating = StatHUD::getRating(%myName);

	StatHUD::setKillDeath(%kills, %deaths);
	StatHUD::setKillDeathWeapon(%weapon, %weaponkills, %weapondeaths);

	StatHUD::setRating(%rating);
}

// our flag functions, triggers a stat update

function StatHUD::GenericFlag(%team, %client)
{
	StatHUD::playerActivityTimestamp(%client);

	// update stat sheet
	if ($StatHUD::StatSheetVisible)
		StatHUD::ShowPlayers();

	%me = getManagerId();

	if (%client != %me)
		return;

	%myName = Client::getName(getManagerID());

	%rating = StatHUD::getRating(%myName);
	StatHUD::setRating(%rating);
}

function StatHUD::playerTimestampReset()
{
	for (%i = 2049; %i < 2150; %i++)
	{
		StatHUD::playerActivityTimestamp(%i);
	}
}

function StatHUD::playerActivityTimestamp(%client)
{
	$StatHUD::PlayerTimeStamp[%client] = getSimTime();
}


// ********************************************************************************************************************
//
// INGAME STAT SHEET STUFF
//


// load all the players currently in the server

function StatHUD::LoadPlayerStats()
{
	stack::freeze("playerlist");

	$StatHUD::PlayerCount[-1] = 0;
	$StatHUD::PlayerCount[0] = 0;
	$StatHUD::PlayerCount[1] = 0;

	stack::reset("playerlist");
	while ((%name = stack::getnext("playerlist")) != FALSE)
	{
		if ((%clientid = getClientByName(%name)) != 0)
		{
			%team = Client::getTeam(getClientByName(%name));

			$StatHUD::DisplayList[ %team, $StatHUD::PlayerCount[%team] ] = %name;

			$StatHUD::PlayerList[%name, kills] = $MapLogger::Kills[%name];
			$StatHUD::PlayerList[%name, deaths] = $MapLogger::Deaths[%name];
			$StatHUD::PlayerList[%name, rating] = StatHud::getRating(%name);
			$StatHUD::PlayerList[%name, disckills] = $MapLogger::Kills[%name, "Disc Launcher"];
			$StatHUD::PlayerList[%name, discdeaths] = $MapLogger::Deaths[%name, "Disc Launcher"];
			$StatHUD::PlayerList[%name, mortarkills] = $MapLogger::Kills[%name, "Mortar"];
			$StatHUD::PlayerList[%name, mortardeaths] = $MapLogger::Deaths[%name, "Mortar"];
			$StatHUD::PlayerList[%name, chainkills] = $MapLogger::Kills[%name, "Chaingun"];
			$StatHUD::PlayerList[%name, chaindeaths] = $MapLogger::Deaths[%name, "Chaingun"];
			$StatHUD::PlayerList[%name, explokills] = $MapLogger::Kills[%name, "Explosives"];
			$StatHUD::PlayerList[%name, explodeaths] = $MapLogger::Deaths[%name, "Explosives"];
			if ($MapLogger::CarrierKills[%name])
				$StatHUD::PlayerList[%name, carrierkills] = $MapLogger::CarrierKills[%name];
			else
				$StatHUD::PlayerList[%name, carrierkills] = "0";
			$StatHUD::PlayerList[%name, touches] = $MapLogger::Grabs[%name] + $MapLogger::Pickups[%name];
			$StatHUD::PlayerList[%name, tks] = $MapLogger::TeamKills[%name] + $MapLogger::TeamMineKills[%name];

			$StatHUD::PlayerList[%name, idletime] = StatHUD::StopWatch(getSimTime() - $StatHUD::PlayerTimeStamp[%clientid]);

			//echo ("sup: " @ getSimTime() @ " : " @ $StatHUD::PlayerTimeStamp[%clientid]);

			$StatHUD::PlayerCount[%team]++;
		}
	}

	stack::unfreeze("playerlist");
}

// sort the players stats using a gay bubble sort

function StatHUD::SortPlayerStats(%column)
{
	for (%team = -1; %team < 2; %team++)
	{
		for (%i = 0; %i < $StatHUD::PlayerCount[%team]-1; %i++)
		{
			for (%j = %i+1; %j < $StatHUD::PlayerCount[%team]; %j++)
			{
				%name[i] = $StatHUD::DisplayList[ %team, %i ];
				%name[j] = $StatHUD::DisplayList[ %team, %j ];

				if ($StatHUD::PlayerList[%name[i], %column] < $StatHUD::PlayerList[%name[j], %column])
				{
					%temp = $StatHUD::DisplayList[ %team, %i ];
					$StatHUD::DisplayList[ %team, %i ] = $StatHUD::DisplayList[ %team, %j ];
					$StatHUD::DisplayList[ %team, %j ] = %temp;
				}
			}
		}
	}
}

// tab width in pixels
$StatHUD::Spacer = "\t";
$StatHUD::SpacerWidth = 15;

// column widths in terms of our spacer
$StatHUD::headerPixelSize[0] = 15 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[1] = 3 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[2] = 3 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[3] = 3 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[4] = 4 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[5] = 3 * $StatHUD::SpacerWidth;

$StatHUD::headerPixelSize[6] = 3 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[7] = 3 * $StatHUD::SpacerWidth;

$StatHUD::headerPixelSize[8] = 3 * $StatHUD::SpacerWidth;
$StatHUD::headerPixelSize[9] = 3 * $StatHUD::SpacerWidth;


// set up the a kill/death item correctly
//

function StatHUD::KillDeathLine(%kills, %deaths)
{
	if (%kills == "")
		%kills = 0;
	if (%deaths == "")
		%deaths = 0;

	return %kills @ "/" @ %deaths;
}

// tab an item apprioately for its column
//

function StatHUD::TabItem(%index, %text)
{
	%textPixels = String::Pixels(%text);
	%columnPixels = $StatHUD::headerPixelSize[%index];

	// we are assuming the text width will never surpass the column
	%pixelDifference = %columnPixels - %textPixels;
	%tabsRequired = floor((%pixelDifference / $StatHUD::SpacerWidth) + 1);

	for (%i = 0; %i < %tabsRequired; %i++)
	{
		%text = %text @ "\t";
	}

	return %text;
}

// output a line of tabed items
//

function StatHUD::TabbedList(%item0, %item1, %item2, %item3, %item4, %item5, %item6, %item7, %item8, %item9)
{
	%list = "\t\t\t\t";

	for (%i = 0; %i < 10; %i++)
	{
		%list = %list @ StatHUD::TabItem(%i, %item[%i]);
	}

	%list = %list @ "\n";

	return %list;
}


// display the player stats
//

function StatHUD::ShowPlayerStats()
{
	%topLine = StatHUD::TabbedList("Name", "Rating", "K/D", "Disc", "Mortar", "Chain", "Xplo", "CKill", "TK", "Idle") @ "\n";

	for (%team = -1; %team < 2; %team++)
	{
		for (%i = 0; %i < $StatHUD::PlayerCount[%team] ; %i++)
		{
			%name = $StatHUD::DisplayList[ %team, %i ];

			%topLine = %topLine @ 
				StatHUD::TabbedList(string::replace(%name, "<", "["),
									$StatHUD::PlayerList[%name, rating],
									StatHUD::KillDeathLine($StatHUD::PlayerList[%name, kills],$StatHUD::PlayerList[%name, deaths]),
									StatHUD::KillDeathLine($StatHUD::PlayerList[%name, disckills],$StatHUD::PlayerList[%name, discdeaths]),
									StatHUD::KillDeathLine($StatHUD::PlayerList[%name, mortarkills],$StatHUD::PlayerList[%name, mortardeaths]),
									StatHUD::KillDeathLine($StatHUD::PlayerList[%name, chainkills],$StatHUD::PlayerList[%name, chaindeaths]),
									StatHUD::KillDeathLine($StatHUD::PlayerList[%name, explokills],$StatHUD::PlayerList[%name, explodeaths]),
									$StatHUD::PlayerList[%name, carrierkills],
									$StatHUD::PlayerList[%name, tks],
									$StatHUD::PlayerList[%name, idletime]);
		}

		//divider between teams
		%topLine = %topLine @ "\n";
	}

	remoteCP(2048, %topLine, 100);
}

// show the player top level function

function StatHUD::ShowPlayers()
{
	$StatHUD::StatSheetVisible = TRUE;

	StatHUD::LoadPlayerStats();
	StatHUD::SortPlayerStats("kills");
	StatHUD::ShowPlayerStats();
}

// hide the players

function StatHUD::HidePlayers()
{
	$StatHUD::StatSheetVisible = FALSE;

	remoteCP(2048, '', 0);
}

$String::asciiString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
$String::asciipixels[127] = 8;	//	


///

function StatHUD::StopWatch(%time)
{
	if (%time < 0)
	{
		%time = 0;
	}

	%minutes = floor(%time / 60);
	%seconds = %time % 60;

	%TimeString = %minutes @ ":";

	if (%Seconds < 10)
		%TimeString = %TimeString @ "0";

	return %TimeString @ %seconds;
}
