$Const::FastForward = 1;

exec("Stats\\Stack.cs");

// Used for Demos
event::Attach(eventConnectionAccepted, MapLogger::speedUp);

	Event::Attach(eventClientMessage, MapLogger::clientMessage);
	Event::Attach(eventMatchStarted, MapLogger::Start);
	Event::Attach(eventChangeMission, MapLogger::Stop);
	Event::Attach(eventConnectionLost, MapLogger::Stop);
	Event::Attach(eventConnectionAccepted, MapLogger::Clear);

	//killtrak
	Event::Attach(eventClientMessage, KillTrak::OnClientMessage);
	Event::Attach(eventKillTrak, MapLogger::Kill);

	//player join/drop 
	Event::Attach(eventClientJoin, MapLogger::playerJoin);
	Event::Attach(eventClientDrop, MapLogger::playerDrop);
	Event::Attach(eventClientChangeTeam, MapLogger::playerChange);

	//flag events
	Event::Attach(eventFlagTaken, MapLogger::FlagTake);
	Event::Attach(EventFlagReturned, MapLogger::FlagReturn);
	Event::Attach(eventFlagCaptured, MapLogger::FlagCap);
	Event::Attach(eventFlagDropped, MapLogger::flagDropped);


// Accelerate a Demo, if we're watching one

function MapLogger::speedUp()
{
	if ($PlayingDemo)
	{
		$simgame::timescale = $Const::FastForward;
	}
}

function MapLogger::init()
{
	exec(File::FindFirst("Stats\\MapExport.cs"));
	exec(File::FindFirst("KillTrak.cs"));
	
	// We aren't tracking stats
	$MapLogger::Status = false;
}

function MapLogger::start()
{
	// Clear out the old variables
	MapLogger::clear();

	// Starting time, Start Recording
	$MapLogger::Start = getSimTime();
	$MapLogger::Status = true;

	// Empty the playerlist
	stack::clear("playerlist");

	// Initialize the teams (-1 = observers, 0 = Blood Eagle, 1 = Diamond Sword)
	initializePlayers(-1);
	initializePlayers(0);
	initializePlayers(1);

	$MapLogger::flagLoc[0] = "home";
	$MapLogger::flagLoc[1] = "home";
	$MapLogger::teamscore[0] = 0;
	$MapLogger::teamscore[1] = 0;
}

function MapLogger::Stop()
{
	if ($MapLogger::Status)
	{
		// Need a final flag event, as theyre done in pairs really
		stack::push("flagloc" @ 0, getSimTime(), "home");
		stack::push("flagloc" @ 1, getSimTime(), "home");

		// Build team lists based on player time
		MapLogger::buildTeamLists();

		// Figure out gamewinning cap
		if ($MapLogger::TeamScore[0] > $MapLogger::TeamScore[1])
		{
			%low = 1; %high = 0;
		}
		else if ($MapLogger::TeamScore[0] < $MapLogger::TeamScore[1])
		{
			%low = 0; %high = 1;
		}
		else
		{
			%skip = TRUE;
		}

		if (!%skip)
		{
			$MapLogger::gamewinningcap = $MapLogger::cap[%high, $MapLogger::TeamScore[%low] + 1];
		}
		else
		{
			$MapLogger::gamewinningcap = "Nobody";
		}

		// We're stopped
		$MapLogger::status = false;
		$MapLogger::stop = getSimTime();

		// Record stats
		MapLogger::Export();

		//back to speed
		//$simgame::timescale = 1;
	}
}

function MapLogger::buildTeamLists()
{
	//clear each team list, starting anew
	stack::clear("teamlist-1");
	stack::clear("teamlist0");
	stack::clear("teamlist1");

	// Playerlist is the list of every player who joined the server during the map duration
	stack::reset("playerlist");
	while ((%name = stack::getnext("playerlist")) != FALSE)
	{
		stack::reset("starttime" @ %name);
		stack::reset("stoptime" @ %name);

		// Time for each team (obs, be, ds) set to 0
		$MapLogger::playertime[%name, -1] = 0;
		$MapLogger::playertime[%name,  0] = 0;
		$MapLogger::playertime[%name,  1] = 0;

		// Total up the time spent on each team
		for (%i = 0; %i < stack::count("starttime" @ %name); %i++)
		{
			%item = stack::getnext("starttime" @ %name);
			%start = $stack::result[0];
			%team = $stack::result[1];
			%stop = stack::getnext("stoptime" @ %name);

			if (%stop == FALSE)
				%stop = getSimTime();

			$MapLogger::playertime[%name, %team] += (%stop-%start);
		}

		// See which team this player most likely belongs to based on time spent on the team
		if ($MapLogger::playertime[%name, 0]*50 > $MapLogger::playertime[%name, 1]*50)
			stack::push("teamlist0", %name);
		else if ($MapLogger::playertime[%name, 1]*50 > $MapLogger::playertime[%name, 0]*50)
			stack::push("teamlist1", %name);
		else
			stack::push("teamlist-1", %name);
	}
}

// Add the players from a single team to to our teamlist
function initializePlayers(%team)
{
	stack::clear("teamlist" @ %team);

	// Cheesy! we dont have a definite list, so we'll just check a LOT of the client id's for people
	// Thanks Tribes, you suck ass
	for (%i = 2048; %i < 2048+256; %i++)
	{
		// If theres a client here
		if ((%name = Client::GetName(%i)) != "")
		{
			// Get his team
			if (client::getTeam(%i) == %team)
			{
				stack::clear(%name);
				stack::clear("starttime" @ %name);
				stack::clear("stoptime" @ %name);
				stack::push("starttime" @ %name, getSimTime(), %team);

				stack::pushUnique("playerlist", %name);
			}
		}
	}
}


// Reset all the MapLogger variables
function MapLogger::reset()
{
	deleteVariables("$MapLogger::*");

	$MapLogger::start = getSimTime();
	$MapLogger::status = true;

	//reinit each team
	initializePlayers(-1);
	initializePlayers(0);
	initializePlayers(1);

	$MapLogger::flagLoc[0] = "home";
	$MapLogger::flagLoc[1] = "home";
	$MapLogger::teamscore[0] = 0;
	$MapLogger::teamscore[1] = 0;
}

function MapLogger::Clear()
{
	deleteVariables("MapLogger*");
	stack::clear("teamlist");
	stack::clear("starttime");
	stack::clear("stoptime");
	stack::clear("playerlist");
	stack::clear("flagloc");
}

function MapLogger::getTimeStamp(%start, %stop)
{
	if (%start == "")
	{
		%time = (getSimTime() - $MapLogger::Start);
	}
	else
	{
		if (%stop == "") %stop = getSimTime();
		%time = (%stop - %start);
	}
	%min = floor(%time / 60);
	%sec = floor((%time /60 - %min) * 60);
	if (%min < 10) %min = "0" @ %min;
	if (%sec < 10) %sec = "0" @ %sec;
	return %min @ ":" @ %sec;
}

// Player joined the server
function MapLogger::playerJoin(%client)
{
	%name = client::getname(%client);
	$MapLogger::playerteam[%name] = client::getteam(%client);

	stack::pushUnique("playerlist", %name);
	stack::push("starttime" @ %name, getSimTime(), client::getteam(%client));
}

// Player dropped from the server
function MapLogger::playerDrop(%client)
{
	%name = client::getname(%client);

	stack::push("stoptime" @ %name, getSimTime(), client::getteam(%client));
}

// Player changed to a team
function MapLogger::playerChange(%client, %team)
{
	%name = client::getname(%client);

	stack::push("stoptime" @ %name, getSimTime(), $MapLogger::playerteam[%name]);
	stack::push("starttime" @ %name, getSimTime(), %team);
	stack::pushUnique("playerlist", %name);

	$MapLogger::playerteam[%name] = %team;
}

// A flag was taken
function MapLogger::flagTake(%team, %name)
{
	%name = client::getname(%name);
	stack::push("flagloc" @ %team, getSimTime(), %name);

	// Grab = grabbing the flag off the stand
	// Pickup = grabbed from the field
	if (($MapLogger::flagLoc[%team] == "") || ($MapLogger::flagLoc[%team] == "home"))
	{
		$MapLogger::initialGrabTime[%team] = getSimTime();
		$MapLogger::initialGrabber[%team] = %name;
		$MapLogger::grabs[%name]++;
	}
	else
	{
		$MapLogger::pickups[%name]++;
	}

	// Only one assist per play
	stack::pushUnique("assist" @ %team, %name);

	$MapLogger::grabTime[%team] = getSimTime();
	$MapLogger::flagLoc[%team] = %name;
}

// A flag was dropped
function MapLogger::flagDropped(%team, %name)
{
	%name = client::getname(%name);
	stack::push("flagloc" @ %team, getSimTime(), "field");

	$MapLogger::dropTime[%name] = getSimTime();
	$MapLogger::teamTotalGrabTime[%team] += (getSimTime() - $MapLogger::grabTime[%team]);
	$MapLogger::flagLoc[%team] = "field";
	$MapLogger::drops[%name]++;
}

// A flag was returned
function MapLogger::flagReturn(%team, %name)
{
	%name = client::getname(%name);
	stack::push("flagloc" @ %team, getSimTime(), "home");

	$MapLogger::flagLoc[%team] = "home";

	// Trigger a return if a player returned the flag
	// Standoff Return is counted as a return after the flag was in the field for 90+ seconds
	if (%name != "")
	{
		$MapLogger::returns[%name]++;
		if ((getSimTime() - $MapLogger::initialGrabTime[%team] > 30) && ($MapLogger::flagloc[%team ^ 1] != "home"))
			$MapLogger::capSave[%name]++;

		if (getSimTime() - $MapLogger::initialGrabTime[%team] > 90)
			$MapLogger::standoffReturn[%name]++;
	}

	stack::clear("assist" @ %team);
}


// A flag was capped
function MapLogger::flagCap(%team, %name)
{
	%name = client::getname(%name);
	stack::push("flagloc" @ %team, getSimTime(), "home");

	$MapLogger::flagLoc[%team] = "home";
	$MapLogger::caps[%name]++;
	$MapLogger::conversions[$MapLogger::initialGrabber[%team]]++;

	stack::reset("assist" @ %team);

	// Add an assist for everybody who touched the flag
	while ((%assistname = stack::getNext("assist" @ %team)) != FALSE)
	{
		if (%name != %assistname)
			$MapLogger::assists[%assistname]++;

		//echo("assist for " @ %assistname @ " against team " @ %team);
	}

	stack::clear("assist" @ %team);

	$MapLogger::TeamScore[%team ^ 1] += 1;
	$MapLogger::TeamPoints[%team ^ 1] += 5;

	$MapLogger::cap[%team ^ 1, $MapLogger::TeamScore[%team ^ 1]] = %name;
	$MapLogger::cap[%team ^ 1, time] = getSimTime();
}

// A kill was made
function MapLogger::Kill(%killer, %victim, %weapon)
{
	if (%victim == 0)
		return;

	%killerID = %killer;
	%victimID = %victim;

	%killer = Client::getName(%killer);
	%victim = Client::getName(%victim);

	if (%weapon == "Suicide")
	{
		$MapLogger::teampoints[client::getteam(%killerID)]--;

		$MapLogger::Suicides[%victim]++;
		if (($MapLogger::flagloc[0] == %killer) || ($MapLogger::flagloc[1] == %killer))
			$MapLogger::FlagSuicides[%victim]++;		
	}
	else if ((%weapon == "Teamkill") || (%weapon == "MineTeamkill"))
	{
		$MapLogger::teampoints[client::getteam(%victimID)]--;

		if (%weapon == "Teamkill")
		{
			$MapLogger::TeamDeaths[%victim]++;
			$MapLogger::Teamkills[%killer]++;
		}
		else if (%weapon == "MineTeamkill")
		{
			$MapLogger::TeamMineDeaths[%victim]++;
			$MapLogger::TeamMineKills[%killer]++;
		}
	}
	else
	{
		if ((%weapon != "Turret") && (%weapon != "Missile") && (%weapon != "Crushed") && (%weapon != "Explosion"))
		{
			$MapLogger::teampoints[client::getteam(%killerID)]++;

			$MapLogger::kills[%killer, %victim]++;

			$MapLogger::Kills[%killer, %weapon]++;
			$MapLogger::Kills[%killer]++;

			$MapLogger::Deaths[%victim]++;
		}

		$MapLogger::Deaths[%victim, %weapon]++;
	}

	if ((getSimTime() - $MapLogger::dropTime[%victim] < 2) && (%killer != %victim))
	{
		if (%weapon == "Teamkill")
			$MapLogger::carrierteamkills[%killer]++;
		else
		{
			if (getSimTime() - $MapLogger::initialGrabTime[Client::GetTeam(%victimID)] > 90)
				$MapLogger::standoffCarrierKill[%killer]++;

			$MapLogger::carrierkills[%killer]++;
		}
	}
	
}

function MapLogger::clientMessage(%client, %msg)
{
		// Timer reset?
		if (String::findSubStr(%msg, "Match started") != -1)
		{
			$matchexport::missionName = $ServerMission;
			Event::Trigger(eventMatchStarted);
		}
}

MapLogger::Init();