//=============================================================
// TimeHUD 
// By: Prophet (aka Shayk-N'-Bake and Kirkesp)
//=============================================================


$TimeHUD::X 			= 0; // X-Position %
$TimeHUD::Y 			= 15;// Y-Position %
$TimeHUD::Width 	= 120;
$TimeHUD::Height 	= 30;

// ---------------------------------------------------------------------------
//
// ----------------------------- BEWARE OF CODE -------------------------------

$TimeHUD::initialized = false;

Event::Attach(eventConnected,"TimeHUD::init",initTimeHUD);

function TimeHUD::init() 
{
	$TimeHUD::check = true;
	if(!HUD::Exists(TimeHUD)) 
  	HUD::New("TimeHUD","TimeHUD::updateTimeHUD", $TimeHUD::X @"% "@ $TimeHUD::Y@"% " @ $TimeHUD::Width @ " " @ $TimeHUD::Height);
 	HUD::Display("TimeHUD");
	TimeHUD::checkTime();     
}

function TimeHUD::toggle()
{
	$TimeHUD::check = !TimeHUD::check;    
	HUD::ToggleDisplay(TimeHUD);	
}

function TimeHUD::updateTimeHUD()
{
	HUD::SetText("TimeHUD", $TimeHUD::timeText);
	HUD::Display("TimeHUD");
}

function TimeHUD::checkTime()
{
  if($phud::debugmode)
		ECHO("CHECKING TIME");
		
	parseTimeStamp();
	
	%year 				= $TimeStamp::Year;
	%month 				= $TimeStamp::Month;
	%day 					= $TimeStamp::Day;
	
	%nameDay 			= getDayOfWeek(%year, %month, %day, true);
	%nameMonth		= getNameOfMonth(%month, true);
	
	if($TimeStamp::Hour > 12)
	{
		%hour 			= $TimeStamp::Hour - 12;
		%ampm				= "PM";
	}
	else if($TimeStamp::Hour < 10 && $TimeStamp::Hour >= 1)
	{
		%hour 			= string::getSubStr($TimeStamp::Hour, 1, 1);
		%ampm				= "AM";
	}
	else if($TimeStamp::Hour < 1)
	{
		%hour 			= 12;
		%ampm				= "AM";
	}
	else
	{
		%hour 			= $TimeStamp::Hour;
		%ampm				= "AM";
	}
		
	%minute 			= $TimeStamp::Minute;
	%second 			= $TimeStamp::Second;
	%millisecond 	= $TimeStamp::Millisecond;
	
	%date = %nameMonth @ " " @ %day @ ", " @ %year;
	%time = "<f0>" @ %ampm @ " <f1>" @ %nameDay @ " <f2>" @ %hour @ ":" @ %minute;
	//%time = "<f0>" @ %ampm @ " <f1>" @ %nameDay @ " <f2>" @ %hour @ ":" @ %minute @ ":" @ %second;

  $TimeHUD::timeText = "<f2>" @ %date @ "\n" @ %time;	
  
  HUD::Update(TimeHUD); 
  Schedule::Add("TimeHUD::checkTime();", getTimeBeforeNext("minute"));
  //Schedule::Add("TimeHUD::checkTime();", 1);
}

