//=============================================================
// TimeStamp (Changed), Time-Announce && Time-Clock 
// By: Prophet (aka Shayk-N'-Bake and Kirkesp)
//=============================================================


$TimeClock::PostChat = "9"; // Key you press to say your current time in Global Chat
$TimeClock::PostBP = "0"; // Key you press to bring up your Time-Clock, with extra time information

$DayArray = "Sunday Monday Tuesday Wednesday Thursday Friday Saturday";
$DayAbbrArray = "Sun. Mon. Tue. Wed. Thu. Fri. Sat.";
$MonthArray = "January February March April May June July August September October November December";
$MonthAbbrArray = "Jan. Feb. Mar. Apr. May Jun. Jul. Aug. Sep. Oct. Nov. Dec.";
$MonthDayArray = "31 %1 31 30 31 30 31 31 30 31 30 31";

function parseTimeStamp()
{
	%str = timestamp();
	
	$TimeStamp::Year = String::GetSubStr(%str, 0, 4);
	$TimeStamp::Month = String::GetSubStr(%str, 5, 2);
	$TimeStamp::Day = String::GetSubStr(%str, 8, 2);
	
	$TimeStamp::Hour = String::GetSubStr(%str, 11, 2);
	$TimeStamp::Minute = String::GetSubStr(%str, 14, 2);
	$TimeStamp::Second = String::GetSubStr(%str, 17, 2);
	$TimeStamp::Millisecond = String::GetSubStr(%str, 20, 3);
}

function getTime()
{
	parseTimeStamp();
		
	%year 				= $TimeStamp::Year;
	%month 				= $TimeStamp::Month;
	%day 					= $TimeStamp::Day;
	
	%nameDay 			= getDayOfWeek(%year, %month, %day);
	%nameMonth		= getNameOfMonth(%month);
	
	if($TimeStamp::Hour > 12)
	{
		%hour 			= $TimeStamp::Hour - 12;
		%ampm				= "PM";
	}
	else if($TimeStamp::Hour < 10 && $TimeStamp::Hour >= 1)
	{
		%hour 			= string::getSubStr($TimeStamp::Hour, 1, 1);
		%ampm				= "AM";
	}
	else if($TimeStamp::Hour < 1)
	{
		%hour 			= 12;
		%ampm				= "AM";
	}
	else
	{
		%hour 			= $TimeStamp::Hour;
		%ampm				= "AM";
	}
	%minute 			= $TimeStamp::Minute;
	%second 			= $TimeStamp::Second;
	%millisecond 	= $TimeStamp::Millisecond;
	
	%time = %nameDay @ ", " @ %nameMonth @ " " @ %day @ ", " @ %year @ " @ " @ %hour @ ":" @ %minute @ " " @ %ampm;
		
	return %time;
}

function getTimeWithoutDate()
{
	parseTimeStamp();
		
	if($TimeStamp::Hour > 12)
	{
		%hour 			= $TimeStamp::Hour - 12;
		%ampm				= "PM";
	}
	else if($TimeStamp::Hour < 10 && $TimeStamp::Hour >= 1)
	{
		%hour 			= string::getSubStr($TimeStamp::Hour, 1, 1);
		%ampm				= "AM";
	}
	else if($TimeStamp::Hour < 1)
	{
		%hour 			= 12;
		%ampm				= "AM";
	}
	else
	{
		%hour 			= $TimeStamp::Hour;
		%ampm				= "AM";
	}
	%minute 			= $TimeStamp::Minute;
	%second 			= $TimeStamp::Second;
	%millisecond 	= $TimeStamp::Millisecond;
	
	%time = %hour @ ":" @ %minute @ " " @ %ampm;
		
	return %time;
}

function getTimeForTeamHeading()
{
	parseTimeStamp();
		
	%year 				= $TimeStamp::Year;
	%month 				= $TimeStamp::Month;
	%day 					= $TimeStamp::Day;
	
	%nameDay 			= getDayOfWeek(%year, %month, %day, true);
	%nameMonth		= getNameOfMonth(%month, true);
	
	if($TimeStamp::Hour > 12)
	{
		%hour 			= $TimeStamp::Hour - 12;
		%ampm				= "PM";
	}
	else if($TimeStamp::Hour < 10 && $TimeStamp::Hour >= 1)
	{
		%hour 			= string::getSubStr($TimeStamp::Hour, 1, 1);
		%ampm				= "AM";
	}
	else if($TimeStamp::Hour < 1)
	{
		%hour 			= 12;
		%ampm				= "AM";
	}
	else
	{
		%hour 			= $TimeStamp::Hour;
		%ampm				= "AM";
	}
	%minute 			= $TimeStamp::Minute;
	%second 			= $TimeStamp::Second;
	%millisecond 	= $TimeStamp::Millisecond;
	
	%time = %nameDay @ ", " @ %nameMonth @ " " @ %day @ ", " @ %year @ " @ " @ %hour @ ":" @ %minute @ " " @ %ampm @ " " @ $TimeZone;
		
	return %time;
}

function showTimeStamp(%abbr)
{
	if(%abbr)
		%time = getTimeForTeamHeading();
	else
		%time = getTime();
	echo(%time);
}

function getFirstDay(%year)
{
	%startYear = "2000";
	%startDay = 6;
	
	for(%i = %startYear; %i < %year; %i++)
	{
		%leapYearCheck = %i / 4;
		if(String::findSubStr(%leapYearCheck, ".") == -1)
			%nextStartDay = 2;
		else
			%nextStartDay = 1;
		
		%firstDay = %startDay + %nextStartDay;
		if(%firstDay > 6)
			%firstDay = %firstDay - 7;
		%startDay = %firstDay;
	}
	return %firstDay;
}

function getCurrentYearDays(%year, %month, %day)
{
	%leapYearCheck = %year / 4;
	if(String::findSubStr(%leapYearCheck, ".") == -1)
		%febDays = "29";
	else
		%febDays = "28";
		
	%MonthDayArray = sprintf($MonthDayArray, %febDays);
	
	%curYearDays = 0;
	for(%i = 0; %i < %month-1; %i++)
	{
		%addDays = getWord(%MonthDayArray, %i);
		%curYearDays = %curYearDays + %addDays;
	}
	return %curYearDays+%day;
}

function getDayOfWeek(%year, %month, %day, %abbr)
{
	%dayNum = getCurrentYearDays(%year, %month, %day);
	%day = getFirstDay(%year);
	for(%i = 1; %i < %dayNum; %i++)
	{
		%day = %day+1;
		if(%day > 6)
			%day = %day - 7;
	}
	if(%abbr)
		%weekDay = getWord($DayAbbrArray, %day);
	else
		%weekDay = getWord($DayArray, %day);
	return %weekDay;
}

function getNameOfMonth(%month, %abbr)
{
	if(%abbr)
		return getWord($MonthAbbrArray, %month-1);
	else
		return getWord($MonthArray, %month-1);
}

function getTimeBeforeNext(%target)
{
	parseTimeStamp();
	
	%year		= $TimeStamp::Year;
	%month	= $TimeStamp::Month;
	%day		= $TimeStamp::Day;
	%hour		= $TimeStamp::Hour;
	%minute	= $TimeStamp::Minute;
	%second	= $TimeStamp::Second;
	
	if(%target == "year")
	{
		%time = 365 - getCurrentYearDays(%year, %month, %day);
	}
	else if(%target == "month")
	{
		%leapYearCheck = %i / 4;
		if(String::findSubStr(%leapYearCheck, ".") == -1)
			%febDays = "29";
		else
			%febDays = "28";
		%MonthDayArray = sprintf($MonthDayArray, %febDays);
		
		%timeDays			= getWord(%MonthDayArray, %month) - %day;
		%timeHours		= 24 - %hour;
		%timeMinutes	= 60 - %minute;
		%timeSeconds 	= 60 - %second;
		%time	=	daysToSeconds(%timeDays);
		%time	= %time + hoursToSeconds(%timeHours);
		%time = %time + minutesToSeconds(%timeMinutes);
		%time = %time + %timeSeconds;
	}
	else if(%target == "day")
	{
		%timeHours		= 24 - %hour;
		%timeMinutes	= 60 - %minute;
		%timeSeconds 	= 60 - %second;
		%time	= hoursToSeconds(%timeHours);
		%time = %time + minutesToSeconds(%timeMinutes);
		%time = %time + %timeSeconds;
	}
	else if(%target == "hour")
	{
		%timeMinutes	= 60 - %minute;
		%timeSeconds 	= 60 - %second;
		%time = minutesToSeconds(%timeMinutes);
		%time = %time + %timeSeconds;
	}
	else if(%target == "minute")
	{
		%time 	= 60 - %second;
	}
		
	return %time;
}

function ShowMyTime(%method)
{
	if(%method == "BP")
	{
		if(!$DisplayingBPTime)
		{
			$DisplayingBPTime = true;
			parseTimeStamp();
			%year 				= $TimeStamp::Year;
			%month 				= $TimeStamp::Month;
			%day 					= $TimeStamp::Day;
			
			%nameDay 			= getDayOfWeek(%year, %month, %day);
			%nameMonth		= getNameOfMonth(%month);
			
			if($TimeStamp::Hour > 12)
			{
				%hour 			= $TimeStamp::Hour - 12;
				%ampm				= "PM";
			}
			else if($TimeStamp::Hour < 10 && $TimeStamp::Hour >= 1)
			{
				%hour 			= string::getSubStr($TimeStamp::Hour, 1, 1);
				%ampm				= "AM";
			}
			else if($TimeStamp::Hour < 1)
			{
				%hour 			= 12;
				%ampm				= "AM";
			}
			else
			{
				%hour 			= $TimeStamp::Hour;
				%ampm				= "AM";
			}
			%minute 			= $TimeStamp::Minute;
			%second 			= $TimeStamp::Second;
			%millisecond 	= $TimeStamp::Millisecond;
			
			RemoteBP(2048, "<jc><f1>Time-Clock\n" @
										 "<f2>" @ %month @ "<f0>/<f2>" @ %day @ "<f0>/<f2>" @ %year @ "\n" @
										 "<f2>" @ %nameDay @ "<f0>, <f2>" @ %nameMonth @ " " @ %day @ "\n" @
										 "<f2>" @ %hour @ "<f0>:<f2>" @ %minute @ "<f0>:<f2>" @ %second @ " " @ %ampm @ "\n" @
										 "<f0>Press your Time-Clock Key again to hide.", 0);
			Schedule("updateBPTime();", 1);
		}
		else
		{
			$DisplayingBPTime = false;
			RemoteBP(2048, "", 0);
		}
	}
	else
	{
		%time = getTimeWithoutDate();
		say(0, %time);
		return;
	}
}

function updateBPTime()
{
	if($DisplayingBPTime)
	{
		%year 				= $TimeStamp::Year;
		%month 				= $TimeStamp::Month;
		%day 					= $TimeStamp::Day;
		
		%nameDay 			= getDayOfWeek(%year, %month, %day);
		%nameMonth		= getNameOfMonth(%month);
		
		if($TimeStamp::Hour > 12)
		{
			%hour 			= $TimeStamp::Hour - 12;
			%ampm				= "PM";
		}
		else if($TimeStamp::Hour < 10 && $TimeStamp::Hour >= 1)
		{
			%hour 			= string::getSubStr($TimeStamp::Hour, 1, 1);
			%ampm				= "AM";
		}
		else if($TimeStamp::Hour < 1)
		{
			%hour 			= 12;
			%ampm				= "AM";
		}
		else
		{
			%hour 			= $TimeStamp::Hour;
			%ampm				= "AM";
		}
		%minute 			= $TimeStamp::Minute;
		%second 			= $TimeStamp::Second;
		%millisecond 	= $TimeStamp::Millisecond;
		
		parseTimeStamp();
		RemoteBP(2048, "<jc><f1>Time-Clock\n" @
									 "<f2>" @ %month @ "<f0>/<f2>" @ %day @ "<f0>/<f2>" @ %year @ "\n" @
									 "<f2>" @ %nameDay @ "<f0>, <f2>" @ %nameMonth @ " " @ %day @ "\n" @
									 "<f2>" @ %hour @ "<f0>:<f2>" @ %minute @ "<f0>:<f2>" @ %second @ " " @ %ampm @ "\n" @
									 "<f0>Press your Time-Clock Key again to hide.", 0);
		Schedule("updateBPTime();", 1);
	}
}

function myBind(%k, %m, %b)
{
	if(%m=="")
		%m = "$x='';";
	if(%b=="")
		%b = "$x='';";

	%k[0] = getword(%k, 0);
	%k[1] = getword(%k, 1);

	%keys = "\"" @ %k[0] @ "\"";
	if(%k[1] != "")
		%keys = %keys @ ", \"" @ %k[1] @ "\"";

	%dev = keyboard0;
	if(string::FindSubStr(%keys, "button") != -1)
		%dev = mouse0;

	eval("bindCommand(" @ %dev @ ", make, " @ %keys @ ", TO, \"" @ %m @ "\");");
	eval("bindCommand(" @ %dev @ ", break, " @ %keys @ ", TO, \"" @ %b @ "\");");
}

myBind($TimeClock::PostChat, "showMyTime();");
myBind($TimeClock::PostBP, "showMyTime(BP);");