// Make sure HUD.cs is included before we try to override anything
include("Presto\\event.cs");
include("Presto\\events.cs");
include("Presto\\hud.cs");

// -------------------------------------------------------------------------------------------------------
// Override several HUD.cs functions to make things transparent!
// -------------------------------------------------------------------------------------------------------
function TransHud::SetStatus(%hud, %status, %ignore) {
	Echo("Hud: ", %hud);
	if ($TransHud::EntryNum[%hud] == "") {
		echo("Adding! Entry:", $TransHud::NumEntries);
		$TransHud::Status[%hud] = %status;
		$TransHud::EntryName[$TransHud::NumEntries] = %hud;
		$TransHud::EntryStat[$TransHud::NumEntries] = %status;
		$TransHud::EntryNum[%hud] = $TransHud::NumEntries;
		$TransHud::NumEntries++;
	} else if (!%ignore) {
		%num = $TransHud::EntryNum[%hud];
		echo("Modding Entry:", %num);
		$TransHud::EntryStat[%num] = %status;
		$TransHud::Status[%hud] = %status;
	}
}

function HUD::NewFrame(%hud, %updateFunc, %x, %y, %width, %height) {

	TransHud::SetStatus(%hud, normal, true);

	if (%y == "")
		%pos = %x;
	else	%pos = %x @" "@ %y @" "@ %width @" "@ %height;

	if (HUD::Exists(%hud))
		HUD::Delete(%hud);
	HUD::SetPosition(%hud, %pos);
	HUD::SetUpdateFunc(%hud, %updateFunc);

	%pos = HUD::InterpCoords(%hud, %pos);
	%x = getWord(%pos, 0);
	%y = getWord(%pos, 1);
	%width = getWord(%pos, 2);
	%height = getWord(%pos, 3);
	if (%width == 0) {
		echo("zero width");
		return;
		}

	if ($TransHud::Status[%hud] == "trans") %objtype = "SimGui::Control";
	else %objtype = "FearGui::FearGuiMenu";

	HUD::SetGuiObject(%hud,frame, newObject("HUD::"@%hud, %objtype, %x, %y, %width, %height));

	Control::SetVisible("HUD::"@%hud, false);  // invisible by default
	HUD::SetAttached(%hud, false);
	HUD::SetGui(%hud, playGui);
	HUD::SetGuiObjectCount(%hud, 0);
	$HUD::[%hud, schedule] = "";

	// Reuse a slot when possible.
	%numHUDs = $HUD::numHUDs;
	if (%numHUDs == "")
		%numHUDs = 0;
	for (%i = 0; %i < %numHUDs; %i++)
		if ($HUD::name[%i] == %hud)
			return;
	$HUD::name[%numHUDs] = %hud;
	$HUD::numHUDs = %numHUDs + 1;
}

function HUD::Move(%hud, %x,%y,%width,%height) {
	
	if (%y == "")
		%pos = %x;
	else	%pos = %x @" "@ %y @" "@ %width @" "@ %height;

	HUD::SetPosition(%hud, %pos);
	%pos = HUD::InterpCoords(%hud, %pos);
	%x = getWord(%pos, 0);
	%y = getWord(%pos, 1);
	%width = getWord(%pos, 2);
	%height = getWord(%pos, 3);

	if (%width == 0) {
		echo("zero width");
		return;
		}

	if ($TransHud::Status[%hud] == "trans") %objtype = "SimGui::Control";
	else %objtype = "FearGui::FearGuiMenu";

	%visible = Control::GetVisible(Object::GetName(HUD::GetGuiObject(%hud, frame)));
	%newFrame = newObject("newHUD", %objtype, %x, %y, %width, %height);
	%count = HUD::GetGuiObjectCount(%hud);
	%oldFrame = HUD::GetGuiObject(%hud, frame);
	for (%i = 0; %i < %count; %i++) {
		%obj = HUD::GetGuiObject(%hud, %i);
		removeFromSet(%oldFrame, %obj);
		addToSet(%newFrame, %obj);
		}
	deleteObject(%oldFrame);
	Control::SetVisible(newHud, %visible);
	renameObject(%newFrame, "hud::"@%hud);
	HUD::SetGuiObject(%hud, frame, %newFrame);
	HUD::SetGui(%hud, HUD::GetGui(%hud));
}

// Convert all existing HUDs to transparent. Only way to make it autoload-friendly and STILL work
// because if a HUD script is loaded BEFORE the replacement, several non-transparent HUDs may be
// created.

// Here, we have a hacked up version of Hud::Move that just replaces the existing HUD's frame with a 
// Simgui::Control object, this outta do the trick!
function HUD::MakeTrans(%hud) {
	
	TransHud::SetStatus(%hud, normal, true);

	%pos = HUD::GetPosition(%hud);

	HUD::SetPosition(%hud, %pos);
	%pos = HUD::InterpCoords(%hud, %pos);
	%x = getWord(%pos, 0);
	%y = getWord(%pos, 1);
	%width = getWord(%pos, 2);
	%height = getWord(%pos, 3);

	if ($TransHud::Status[%hud] == "trans") %objtype = "SimGui::Control";
	else %objtype = "FearGui::FearGuiMenu";
	
	%visible = Control::GetVisible(Object::GetName(HUD::GetGuiObject(%hud, frame)));
	%newFrame = newObject("newHUD", %objtype, %x, %y, %width, %height);
	%count = HUD::GetGuiObjectCount(%hud);
	%oldFrame = HUD::GetGuiObject(%hud, frame);
	for (%i = 0; %i < %count; %i++) {
		%obj = HUD::GetGuiObject(%hud, %i);
		removeFromSet(%oldFrame, %obj);
		addToSet(%newFrame, %obj);
	}

	deleteObject(%oldFrame);
	Control::SetVisible(newHud, %visible);
	renameObject(%newFrame, "hud::" @ %hud);
	HUD::SetGuiObject(%hud, frame, %newFrame);
	HUD::SetGui(%hud, HUD::GetGui(%hud));
}

function TransHud::LoadSettings() {
	$TransHud::NumEntries = 0;
	include("TransHudConfig.cs");

	for (%i = 0; %i < $TransHud::NumEntries; %i++) {		
		%hud = $TransHud::EntryName[%i];
		%status = $TransHud::EntryStat[%i];
		$TransHud::Status[%hud] = %status;
		$TransHud::EntryNum[%hud] = %i;
	}

	Echo("Transhud: Loaded ", $TransHud::NumEntries, " entries");

	for (%i = 0; %i < $HUD::numHUDs; %i++) {
		Hud::MakeTrans($HUD::name[%i]);
	}
}
TransHud::LoadSettings();
////////////////////////////////////////////////
// [Meph]DooM! + VeKToR's demo crash bug
// (DooM did most of it - Vek :)

function HUD::OnGuiClose(%gui) {
	for (%i = 0; %i < $HUD::numHUDs; %i++) {
		%hud = $HUD::name[%i];
		%guiHUD = HUD::GetGui(%hud);
		if (%guiHUD == %gui && HUD::GetAttached(%hud)) {

			if ($Hud::prefs::last::[%hud] != "")
				$Hud::prefs::last::[%hud] = Hud::GetPosition(%hud);
			
			removeFromSet(%gui, HUD::GetGuiObject(%hud, frame));
			HUD::SetAttached(%hud, false);
			}
		}
	$HUD::pendingAttach[%gui] = true;
	}


Event::Attach(eventGuiClose, HUD::OnGuiClose);

// End inserted code
///////////////////////////////////////////////////


// ------------NEWOPTS-------------
function TransHud::ClickList1() {
}
function TransHud::ClickList2() {
}

function TransHud::Button1P() {
	if ((%hud = Control::GetValue("TransHud::List1")) != "") {
		TransHud::SetStatus(%hud, normal, false);
		Hud::MakeTrans(%hud);
		TransHud::OnOpen();
	}
}

function TransHud::Button2P() {
	if ((%hud = Control::GetValue("TransHud::List2")) != "") {
		TransHud::SetStatus(%hud, trans, false);
		Hud::MakeTrans(%hud);
		TransHud::OnOpen();
	}
}

function TransHud::OnOpen() {
	
	TextList::clear("TransHud::List1");
	TextList::clear("TransHud::List2");

	Control::SetText("TransHud::BLabel2", "<< Add to Transparent List");
	
	
	for (%i = 0; %i < $TransHud::NumEntries; %i++) {
		if ($TransHud::Status[$transHUD::EntryName[%i]] == "trans") TextList::addline("TransHud::List1", $transHUD::EntryName[%i]);
		else TextList::addline("TransHud::List2", $transHUD::EntryName[%i]);
	}
		
	// Our just-in-case thingy. Handle any HUDs that may have been skipped so far (!!!)
	for (%i = 0; %i < $HUD::numHUDs; %i++) {
		if ($TransHud::EntryNum[$HUD::name[%i]] == "") {
			if ($TransHud::Status[$HUD::name[%i]] == "trans") TextList::addline("TransHud::List1", $Hud::name[%i]);
			else TextList::addline("TransHud::List2", $Hud::name[%i]);
		}
	}
}

function TransHud::OnClose() {
	export("$TransHud::NumEntries", "config\\TransHudConfig.cs", false);
	export("$TransHud::EntryStat*", "config\\TransHudConfig.cs", true);
	export("$TransHud::EntryName*", "config\\TransHudConfig.cs", true);
}
event::attach(eventExit, TransHud::OnClose);

NewOpts::register("TransHUD Setup", "config\\transhud.gui", "Transhud::OnOpen();", "Transhud::OnClose();", TRUE);