//
//  HudPos 1.0
//  By Tim 'Zear' Hammock
//

function HudPos::getPosition()
{
    if($HudMover::selected == "" || $HudPos::active)
        return;
    
    if($HudMover::constraints[$HudMover::selected] > 14)
        return;
    
    $HudPos::active = TRUE;   

    EditActionMap("actionMap.sae");
    bindCommand(keyboard0, make, "escape", TO, "HudPos::onCancel();");
    
    GuiPushDialog(MainWindow, "NewOpts\\Gui\\HudPosition.gui");
    
    Control::setValue(HudPos::titleLabel, "<jc><f2>Positioning "@$HudMover::selected);
    
    %pos = HUD::GetPosition($HudMover::selected);
    $HudPos::original = %pos;
    
    TextList::clear(HudPos::relList);
    TextList::addLine(HudPos::relList, "<Screen>");

    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;

    for (%i = 0; %i < %numHUDs; %i++)
    {
	    %name = $HUD::name[%i];
	    if($HudMover::gui == HUD::GetGui(%name) && %name != $HudMover::selected)
            TextList::addLine(HudPos::relList, %name);
	}
    
    if($HudMover::constraints[$HudMover::selected] != "")
    {
        for(%i = 3; %i > -1; %i--)
        {
            %constraints = $HudMover::constraints[$HudMover::selected] >> %i;
            if((%constraints & 1) == 0)
            {
                $HudPos::currCoord = %i;
                %activepos[%i] = TRUE;
            }
            else
                %activepos[%i] = FALSE;
        }
    }
    Control::setActive(HudPos::leftButton, %activepos[0]);
    Control::setActive(HudPos::topButton, %activepos[1]);
    Control::setActive(HudPos::WidthButton, %activepos[2]);
    Control::setActive(HudPos::HeightButton, %activepos[3]);
    
    $HudPos::setupLock = FALSE;
    HudPos::setup(%pos);
}

function HudPos::setup(%pos)
{
    if($HudPos::setupLock)
        return;
        
    $HudPos::setupLock = TRUE;
    if(%pos != "")
        HUD::Move($HudMover::selected, %pos);

    %pos = HUD::GetPosition($HudMover::selected);
    Control::setText(HudPos::left, getWord(%pos, 0));
    Control::setText(HudPos::top, getWord(%pos, 1));
    Control::setText(HudPos::width, getWord(%pos, 2));
    Control::setText(HudPos::height, getWord(%pos, 3));
    
    Control::setActive(HudPos::leftLabel, ($HudPos::currCoord == 0));
    Control::setActive(HudPos::topLabel, ($HudPos::currCoord == 1));
    Control::setActive(HudPos::widthLabel, ($HudPos::currCoord == 2));
    Control::setActive(HudPos::heightLabel, ($HudPos::currCoord == 3));
    
    %type = HudMover::getType(%pos, $HudPos::currCoord);
    
    Control::setActive(HudPos::left, (%type == "custom" && $HudPos::currCoord == 0));
    Control::setActive(HudPos::top, (%type == "custom" && $HudPos::currCoord == 1));
    Control::setActive(HudPos::width, (%type == "custom" && $HudPos::currCoord == 2));
    Control::setActive(HudPos::height, (%type == "custom" && $HudPos::currCoord == 3));
    
    if(%type == "pixel")
    {
        Control::setValue(HudPos::type, "Pixel");
        Control::setVisible(HudPos::relBox, FALSE);
        Control::setActive(HudPos::relButton, FALSE);
        Control::setVisible(HudPos::edgeBox, FALSE);
        Control::setActive(HudPos::edgeButton, FALSE);
        Control::setVisible(HudPos::relativeLabel, FALSE);
        Control::setVisible(HudPos::edgeLabel, FALSE);
    }
    else if(%type == "relative")
    {
        Control::setValue(HudPos::type, "Adaptive (%)");
        Control::setVisible(HudPos::relBox, FALSE);
        Control::setActive(HudPos::relButton, FALSE);
        Control::setVisible(HudPos::edgeBox, FALSE);
        Control::setActive(HudPos::edgeButton, FALSE);
        Control::setVisible(HudPos::relativeLabel, FALSE);
        Control::setVisible(HudPos::edgeLabel, FALSE);
    }
    else if(%type == "custom")
    {
        Control::setValue(HudPos::type, "Complex");
        Control::setVisible(HudPos::relBox, FALSE);
        Control::setActive(HudPos::relButton, FALSE);
        Control::setVisible(HudPos::edgeBox, FALSE);
        Control::setActive(HudPos::edgeButton, FALSE);
        Control::setVisible(HudPos::relativeLabel, FALSE);
        Control::setVisible(HudPos::edgeLabel, FALSE);
    }
    else 
    {
        Control::setValue(HudPos::type, "Offset Relative");
        Control::setVisible(HudPos::relBox, TRUE);
        Control::setActive(HudPos::relButton, TRUE);
        Control::setVisible(HudPos::relativeLabel, TRUE);
        Control::setVisible(HudPos::edgeBox, TRUE);
        Control::setActive(HudPos::edgeButton, TRUE);
        Control::setVisible(HudPos::edgeLabel, TRUE);
        if(%type == "offsetrel")
        {
            Control::setValue(HudPos::rel, "<Screen>");
            Control::setValue(HudPos::relList, "<Screen>");

            if($HudPos::currCoord < 2)
            {
                Match::ParamString(%type,"e%");
                %edge = Match::Result(e);
                if(%edge == "50")
                    %edge = "Center";
                else if($HudPos::currCoord == 0)    // x
                {
                    if(%edge = "0%")
                        %edge = "Left";
                    else if(%edge = "100%")
                        %edge = "Right";
                }
                else                                // y
                {
                    if(%edge = "0%")
                        %edge = "Top";
                    else if(%edge = "100%")
                        %edge = "Bottom";
                }
                Control::setValue(HudPos::edge, %edge);
            }
//            else    // w or h
//            {
                Control::setVisible(HudPos::edgeBox, FALSE);
                Control::setActive(HudPos::edgeButton, FALSE);
                Control::setVisible(HudPos::edgeLabel, FALSE);
//            }
        }
        else    // %type == "hudrel"
        {
            Match::ParamString(%type,"%e(%h)");
	        %hud = Match::Result(h);
            Control::setValue(HudPos::rel, %hud);
            Control::setValue(HudPos::relList, %hud);
	        %edge = Match::Result(e);
	        if(String::ICompare(%edge, "Right") == 0)
	            %edge = "Right";
	        else if(String::ICompare(%edge, "Bottom") == 0)
	            %edge = "Bottom";
	        else if(String::ICompare(%edge, "Center") == 0)
	            %edge = "Center";
	        else if(String::ICompare(%edge, "Left") == 0)
	            %edge = "Left";
	        else if(String::ICompare(%edge, "Top") == 0)
	            %edge = "Top";
	        else if(String::ICompare(%edge, "Width") == 0)
	            %edge = "Width";
	        else if(String::ICompare(%edge, "Height") == 0)
	            %edge = "Height";
	        
            Control::setValue(HudPos::edge, %edge);
        }
    }
    $HudPos::setupLock = FALSE;
}

function HudPos::onCoord(%coord)
{
    echo(%coord);
    if($HudPos::setupLock)
        return;

    $HudPos::currCoord = %coord;
    HudPos::setup();
}

function HudPos::onDone()
{
    HUD::Move($HudMover::selected, Control::getText(HudPos::left)@" "@Control::getText(HudPos::top)@" "@Control::getText(HudPos::width)@" "@Control::getText(HudPos::height));
    HudMover::hudSelect($HudMover::selected);
    $Hud::prefs::last::[$HudMover::selected] = HUD::GetPosition($HudMover::selected);
    HudPos::close();
}

function HudPos::onCancel()
{
    HUD::Move($HudMover::selected, $HudPos::original);
    HudMover::hudSelect($HudMover::selected);
    HudPos::close();
}

function HudPos::close()
{
    EditActionMap("actionMap.sae");
    bindCommand(keyboard0, make, "escape", TO, "HudMover::quit();");
    GuiPopDialog(MainWindow, 0);
    $HudPos::active = FALSE;   
}

function HudPos::onDefault()
{
    HudPos::setup($Hud::prefs::default::[$HudMover::selected]);
}

function HudPos::onReset()
{
    HudPos::setup($Hud::prefs::last::[$HudMover::selected]);
}

function HudPos::getRelative(%pct)
{
    %cx = HUD::GetCoordValue($HudMover::selected, 0);
    %cy = HUD::GetCoordValue($HudMover::selected, 1);
    %cw = HUD::GetCoordValue($HudMover::selected, 2);
    %ch = HUD::GetCoordValue($HudMover::selected, 3);
    
    %sx = getWord(Presto::ScreenSize(), 0);
    %sy = getWord(Presto::ScreenSize(), 1);
    
    %x = floor((%cx/(%sx-%cw)*100) + 0.5);
    %y = floor((%cy/(%sy-%ch)*100) + 0.5);
    %w = floor((%cw/%sx*100) + 0.5);
    %h = floor((%ch/%sy*100) + 0.5);

    if(%pct)
        return %x@"% "@%y@"% "@%w@"% "@%h@"%";
    else
        return %x@" "@%y@" "@%w@" "@%h; // % chars omitted on purpose
}

function HudPos::pushPop(%pop)
{
    Control::setVisible(HudPos::popMask, TRUE);
    Control::setVisible(%pop, TRUE);
}

function HudPos::popPop(%list, %selection)
{
    Control::setVisible(HudPos::typePopBox, FALSE);
    Control::setVisible(HudPos::relPopBox, FALSE);
    Control::setVisible(HudPos::edgePopBox, FALSE);
    Control::setVisible(HudPos::popMask, FALSE);
    if(%list == "type")
        HudPos::onTypeSelect(%selection);
    else if(%list == "edge")
        HudPos::onEdgeSelect(%selection);
}

function HudPos::onTypeSelect(%selection)
{
    %old = Control::getValue(HudPos::type);
    if(%old == %selection)
        return;
    
    Control::setValue(HudPos::type, %selection);
    %newtype = "xxx ";

    if(%selection == "Pixel")
        %coord = HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord);
    else if(%selection == "Adaptive (%)")
        %coord = getWord(HudPos::getRelative(TRUE), $HudPos::currCoord);
    else if(%selection == "Complex")
    {
        %coord = getWord(HUD::GetPosition($HudMover::selected), $HudPos::currCoord);
        %newtype = "custom ";
    }
    else    // %selection == "Offset Relative"
    {
        %coord = HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord);
        if($HudPos::currCoord < 2)    // x or y
        {
            %screen = getWord(Presto::ScreenSize(), $HudPos::currCoord);
            if(%coord < (%screen * 0.4))  // left/top edge
                %edge = "0%";
            else if(%coord > (%screen * 0.6)) // right/bottom edge
            {
                %coord = %coord - %screen + HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord+2);
                %edge = "100%";
            }
            else    // center
            {
                %coord = %coord - (%screen / 2) + floor((HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord+2)/2)+0.5);
                %edge = "50%";
            }
            if(%coord > -1)
                %op = "+";
            else
                %op = "";
            %coord = %edge@%op@%coord;
        }
        else    // w or h
        {
            HudPos::onEdgeSelect();
            return;
        }
    }
    %pos = HUD::GetPosition($HudMover::selected);
    for(%i = 0; %i < 4; %i++)
    {
        if(%i == $HudPos::currCoord)
        {
            %newpos = %newpos@%coord@" ";
            %newtypes = %newtypes@%newtype;
        }
        else
        {
            %newpos = %newpos@getWord(%pos, %i)@" ";
            %newtypes = %newtypes@getWord($HudMover::selectedTypes, %i)@" ";
        }
    }
    $HudMover::selectedTypes = %newtypes;
    
    HudPos::setup(%newpos);
    HudMover::hudSelect($HudMover::selected, TRUE);
}

function HudPos::onRelSelect()
{
    Control::setVisible(HudPos::typePopBox, FALSE);
    Control::setVisible(HudPos::relPopBox, FALSE);
    Control::setVisible(HudPos::edgePopBox, FALSE);
    Control::setVisible(HudPos::popMask, FALSE);
    
    %old = Control::getValue(HudPos::rel);
    %selection = Control::getValue(HudPos::relList);
    if(%selection == "")
    {
        %selection = "<Screen>";
        Control::setValue(HudPos::relList, "<Screen>");
    }
    if(%old == %selection)
        return;
        
    Control::setValue(HudPos::rel, %selection);
    
    %coord = HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord);
    if(%selection == "<Screen>")
    {
        if($HudPos::currCoord < 2)    // x or y
        {
            %screen = getWord(Presto::ScreenSize(), $HudPos::currCoord);
            if(%coord < (%screen * 0.4))  // left/top edge
                %edge = "0%";
            else if(%coord > (%screen * 0.6)) // right/bottom edge
            {
                %coord = %coord - %screen + HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord+2);
                %edge = "100%";
            }
            else    // center
            {
                %coord = %coord - (%screen / 2) + floor((HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord+2)/2)+0.5);
                %edge = "50%";
            }
            if(%coord > -1)
                %op = "+";
            else
                %op = "";
            %coord = %edge@%op@%coord;
        }
        else    // w or h
        {
            %screen = getWord(Presto::ScreenSize(), $HudPos::currCoord - 2);
            %coord = floor(((%coord / %screen) * 100) + 0.5);
	        if(%coord < 1)
	            %coord = 1;
	        %coord = %coord@"%";
        }
    }
    else
    {
        HudPos::onEdgeSelect();
        return;
    }
    %pos = HUD::GetPosition($HudMover::selected);
    %newpos = %newtypes = "";
    for(%i = 0; %i < 4; %i++)
    {
        if(%i == $HudPos::currCoord)
        {
            %newpos = %newpos@%coord@" ";
            %newtypes = %newtypes@%newtype;
        }
        else
        {
            %newpos = %newpos@getWord(%pos, %i)@" ";
            %newtypes = %newtypes@getWord($HudMover::selectedTypes, %i)@" ";
        }
    }
    $HudMover::selectedTypes = %newtypes;
    
    HudPos::setup(%newpos);
    HudMover::hudSelect($HudMover::selected, TRUE);
}

function HudPos::onEdgeSelect(%selection)
{
    if(%selection != "")
        Control::setValue(HudPos::edge, %selection);
    else
    {
        if($HudPos::currCoord < 2)    // x or y
            %selection = "Center";
        else if($HudPos::currCoord == 2)    // w
            %selection = "Width";
        else    // h
            %selection = "Height";
        Control::setValue(HudPos::edge, %selection);
    }
    %newpos = "";
    %newrel = %selection@"("@Control::getValue(HudPos::rel)@")";
    for(%i = 0; %i < 4; %i++)
    {
        if(%i == $HudPos::currCoord)
            %newpos = %newpos@%newrel@" ";
        else
            %newpos = %newpos@getWord(HUD::GetPosition($HudMover::selected), %i)@" ";
    }
    %coord = HUD::GetCoordValue($HudMover::selected, $HudPos::currCoord) - HUD::InterpCoord($HudMover::selected, %newpos, $HudPos::currCoord);
    if(%coord > -1)
        %op = "+";
    else
        %op = "";
    %coord = %newrel@%op@%coord;

    %pos = HUD::GetPosition($HudMover::selected);
    %newpos = %newtypes = "";
    for(%i = 0; %i < 4; %i++)
    {
        if(%i == $HudPos::currCoord)
        {
            %newpos = %newpos@%coord@" ";
            %newtypes = %newtypes@%newtype;
        }
        else
        {
            %newpos = %newpos@getWord(%pos, %i)@" ";
            %newtypes = %newtypes@getWord($HudMover::selectedTypes, %i)@" ";
        }
    }
    $HudMover::selectedTypes = %newtypes;
    
    HudPos::setup(%newpos);
    HudMover::hudSelect($HudMover::selected, TRUE);
}
