//
//  NewPrefs 1.02
//  By Tim 'Zear' Hammock
//

//
// ----------------------------------------------------------------------------
//
//  Page 1
//
// ----------------------------------------------------------------------------
//

function NewPrefs::onInit()
{
    // $pref::PlayerFOV
    %fov = ($pref::PlayerFOV-5)/115;
    Control::setValue(NewPrefs::fovSlider, %fov);
    Control::setValue(NewPrefs::fovVal, "["@$pref::PlayerFOV@"]");
    
    // $pref::autoWaypoint
    Control::setValue(NewPrefs::autoWaypoint, $pref::autoWaypoint);

    // $pref::noEnterInvStation
    Control::setValue(NewPrefs::noEnterInvStation, $pref::noEnterInvStation);
}

function NewPrefs::validatePFOV()
{
   %fov = Control::getValue(NewPrefs::fovSlider);
   $pref::PlayerFOV = floor((%fov*115)+5.5);
   Control::setValue(NewPrefs::fovVal, "["@$pref::PlayerFOV@"]");
}

function NewPrefs::pushIntervals()
{
    GuiPushDialog(MainWindow, "NewOpts\\Gui\\NewPrefsIntervals.gui");
    Control::setText(NewPrefs::pzt, floor(($pref::PlayerZoomSpeed*1000)+0.5));
    Control::setText(NewPrefs::lt, $pref::LagTimeout);
    Control::setText(NewPrefs::cmdz, $pref::CommanderZoomTime);
}

function NewPrefs::intervalValidate()
{
    %pzt = Control::getText(NewPrefs::pzt);
    if(%pzt == "-")
    {
        %pzt = "";
        Control::setText(NewPrefs::pzt, %pzt);
    }
    %lt = Control::getText(NewPrefs::lt);
    if(%lt == "-")
    {
        %lt = "";
        Control::setText(NewPrefs::lt, %lt);
    }
    %cmdz = Control::getText(NewPrefs::cmdz);
    if(%cmdz == "-")
    {
        %cmdz = "";
        Control::setText(NewPrefs::cmdz, %cmdz);
    }
        
    if(%pzt == "" || %lt == "" || %cmdz == "" || %pzt == 0 || %lt == 0 || %cmdz == 0)
        Control::setActive(NewPrefs::dialogDone, FALSE);
    else
        Control::setActive(NewPrefs::dialogDone, TRUE);
}

function NewPrefs::closeIntervalDialog(%result)
{
    if(%result == DONE)
    {
        $pref::PlayerZoomSpeed = Control::getText(NewPrefs::pzt)/1000;
        $pref::LagTimeout = Control::getText(NewPrefs::lt);
        $pref::CommanderZoomTime = Control::getText(NewPrefs::cmdz);
    }
    GuiPopDialog(MainWindow, 0);
}

function NewPrefs::pushBadWords()
{
    GuiPushDialog(MainWindow, "NewOpts\\Gui\\Badwords.gui");
}

function NewPrefs::validateAutoWP() // also noEnterInvStation...
{
    $pref::autoWaypoint = Control::getValue(NewPrefs::autoWaypoint);
    $pref::noEnterInvStation = Control::getValue(NewPrefs::noEnterInvStation);
    remoteEval(2048, "SetCLInfo", $PCFG::SkinBase, $PCFG::RealName, $PCFG::EMail, $PCFG::Tribe, $PCFG::URL, $PCFG::Info, $pref::autoWaypoint, $pref::noEnterInvStation, $pref::messageMask);
}

function NewPrefs::onClose()
{
    export("$badwords", "config\\badwords.cs");
}

//
// ----------------------------------------------------------------------------
//
//  Page 2
//
// ----------------------------------------------------------------------------
//

function NewPrefs::onInit2()
{
    // $pref::maxConcurrentPings
    %val = ($pref::maxConcurrentPings-1)/63;
    Control::setValue(NewPrefs::maxConcurrentPings, %val);
    Control::setValue(NewPrefs::pmc, "["@$pref::maxConcurrentPings@"]");
    
    // $pref::pingRetryCount
    %val = ($pref::pingRetryCount-1)/19;
    Control::setValue(NewPrefs::pingRetryCount, %val);
    Control::setValue(NewPrefs::prl, "["@$pref::pingRetryCount@"]");
    
    // $pref::pingTimeoutTime
    %val = ($pref::pingTimeoutTime-1)/999;
    Control::setValue(NewPrefs::pingTimeoutTime, %val);
    Control::setValue(NewPrefs::ptt, "["@$pref::pingTimeoutTime@"]");
    
    // $pref::maxConcurrentRequests
    %val = ($pref::maxConcurrentRequests-1)/63;
    Control::setValue(NewPrefs::maxConcurrentRequests, %val);
    Control::setValue(NewPrefs::rmc, "["@$pref::maxConcurrentRequests@"]");
    
    // $pref::requestRetryCount
    %val = ($pref::requestRetryCount-1)/19;
    Control::setValue(NewPrefs::requestRetryCount, %val);
    Control::setValue(NewPrefs::rrl, "["@$pref::requestRetryCount@"]");
    
    // $pref::requestTimeoutTime
    %val = ($pref::requestTimeoutTime-1)/999;
    Control::setValue(NewPrefs::requestTimeoutTime, %val);
    Control::setValue(NewPrefs::rtt, "["@$pref::requestTimeoutTime@"]");
}

function NewPrefs::maxConcurrentPings()
{
   %val = Control::getValue(NewPrefs::maxConcurrentPings);
   $pref::maxConcurrentPings = floor((%val*63)+1.5);
   Control::setValue(NewPrefs::pmc, "["@$pref::maxConcurrentPings@"]");
}

function NewPrefs::pingRetryCount()
{
   %val = Control::getValue(NewPrefs::pingRetryCount);
   $pref::pingRetryCount = floor((%val*19)+1.5);
   Control::setValue(NewPrefs::prl, "["@$pref::pingRetryCount@"]");
}

function NewPrefs::pingTimeoutTime()
{
   %val = Control::getValue(NewPrefs::pingTimeoutTime);
   $pref::pingTimeoutTime = floor((%val*999)+1.5);
   Control::setValue(NewPrefs::ptt, "["@$pref::pingTimeoutTime@"]");
}

function NewPrefs::maxConcurrentRequests()
{
   %val = Control::getValue(NewPrefs::maxConcurrentRequests);
   $pref::maxConcurrentRequests = floor((%val*63)+1.5);
   Control::setValue(NewPrefs::rmc, "["@$pref::maxConcurrentRequests@"]");
}

function NewPrefs::requestRetryCount()
{
   %val = Control::getValue(NewPrefs::requestRetryCount);
   $pref::requestRetryCount = floor((%val*19)+1.5);
   Control::setValue(NewPrefs::rrl, "["@$pref::requestRetryCount@"]");
}

function NewPrefs::requestTimeoutTime()
{
   %val = Control::getValue(NewPrefs::requestTimeoutTime);
   $pref::requestTimeoutTime = floor((%val*999)+1.5);
   Control::setValue(NewPrefs::rtt, "["@$pref::requestTimeoutTime@"]");
}

function NewPrefs::onClose2()
{
    export("$NewPrefs::*", "config\\NewPrefsPrefs.cs");
}

//
// ----------------------------------------------------------------------------
//
//  Page 3
//
// ----------------------------------------------------------------------------
//

function NewPrefs::onInit3()
{
    // $NewPrefs::PlayGameMode
    FGCombo::clear(NewPrefs::playMode);
    %pmNum = 0;
    for(%i = 0; %i < 7; %i++)
    {
        FGCombo::addEntry(NewPrefs::playMode, $NewPrefs::playMode[%i], %i);
        if($NewPrefs::PlayGameMode == $NewPrefs::playMode[%i])
            %pmNum = %i;
    }
    if($NewPrefs::PlayGameMode == "" || $pref::quickstart == "false")
    {
        $NewPrefs::PlayGameMode = "Quickstart off";
        FGCombo::setSelected(NewPrefs::playMode, 0);
    }
    else
        FGCombo::setSelected(NewPrefs::playMode, %pmNum);
        
    if($NewPrefs::PlayGameMode == "Quickstart off")
        Control::setActive(NewPrefs::skipIntro, true);
    else
        Control::setActive(NewPrefs::skipIntro, false);

    // $pref::ConnectionGoodPing
    %val = ($pref::ConnectionGoodPing-1)/999;
    Control::setValue(NewPrefs::ConnectionGoodPing, %val);
    Control::setValue(NewPrefs::cgp, "["@$pref::ConnectionGoodPing@"]");
    
    // $pref::ConnectionPoorPing
    %val = ($pref::ConnectionPoorPing-1)/999;
    Control::setValue(NewPrefs::ConnectionPoorPing, %val);
    Control::setValue(NewPrefs::cpp, "["@$pref::ConnectionPoorPing@"]");
}

function NewPrefs::onPlayModeSelect()
{
    $NewPrefs::PlayGameMode = FGCombo::getSelectedText(NewPrefs::playMode);
    if($NewPrefs::PlayGameMode == "Quickstart off")
    {
        $pref::quickstart = "false";
        Control::setActive(NewPrefs::skipIntro, true);
    }
    else
    {
        $pref::quickstart = "true";
        Control::setActive(NewPrefs::skipIntro, false);
    }
}

function NewPrefs::ConnectionGoodPing()
{
   %val = Control::getValue(NewPrefs::ConnectionGoodPing);
   $pref::ConnectionGoodPing = floor((%val*999)+1.5);
   Control::setValue(NewPrefs::cgp, "["@$pref::ConnectionGoodPing@"]");
}

function NewPrefs::ConnectionPoorPing()
{
   %val = Control::getValue(NewPrefs::ConnectionPoorPing);
   $pref::ConnectionPoorPing = floor((%val*999)+1.5);
   Control::setValue(NewPrefs::cpp, "["@$pref::ConnectionPoorPing@"]");
}

function NewPrefs::onClose3()
{
    export("$NewPrefs::*", "config\\NewPrefsPrefs.cs");
}

function QuickStart()
{
    $ConnectedToServer = FALSE;
    setCursor(MainWindow, "Cur_Arrow.bmp");
    cursorOn(MainWindow);
    $QuickStart = TRUE;
    $PlayGameGui = "gui\\mainmenu.gui";
    if ($PlayingDemo)
    {
        $PlayingDemo = FALSE;
        GuiLoadContentCtrl(MainWindow, "gui\\Recordings.gui");
    }
    
    if($NewPrefs::PlayGameMode == "Quickstart off" || $NewPrefs::PlayGameMode == "")
    {        
        $NewPrefs::PlayGameMode = "Quickstart off";
        if ($PCFG::Name == "")
            GuiLoadContentCtrl(MainWindow, "gui\\PlayerSetup.gui");
        else if ($pref::PlayGameMode == "")
            GuiLoadContentCtrl(MainWindow, "gui\\Connect.gui");
        else if ($Pref::PlayGameMode == "JOIN")
            GuiLoadContentCtrl(MainWindow, "gui\\JoinGame.gui");
        else if ($pref::PlayGameMode == "TRAIN")
            GuiLoadContentCtrl(MainWindow, "gui\\training.gui");
        else
            GuiLoadContentCtrl(MainWindow, "gui\\CreateServer.gui");
    }
    else
    {
        if ($NewPrefs::PlayGameMode == "Start IRC")
            ConnectToIRCServer();
        else if ($NewPrefs::PlayGameMode == "Open options")
            GuiLoadContentCtrl(MainWindow, "gui\\Options.gui");
        else if ($PCFG::Name == "")
            GuiLoadContentCtrl(MainWindow, "gui\\PlayerSetup.gui");
        else if ($NewPrefs::PlayGameMode == "Choose game type")
            GuiLoadContentCtrl(MainWindow, "gui\\Connect.gui");
        else if ($NewPrefs::PlayGameMode == "Join server")
            GuiLoadContentCtrl(MainWindow, "gui\\JoinGame.gui");
        else if ($NewPrefs::PlayGameMode == "Start training")
            GuiLoadContentCtrl(MainWindow, "gui\\training.gui");
        else    // == "Host game"
            GuiLoadContentCtrl(MainWindow, "gui\\CreateServer.gui");
    }
    //autologin to the irc client
    IRCLogin::AutoConnect();
}

if(isFile("config\\NewPrefsPrefs.cs"))
    exec("NewPrefsPrefs.cs");

$NewPrefs::playMode[0] = "Quickstart off";
$NewPrefs::playMode[1] = "Join server";
$NewPrefs::playMode[2] = "Start training";
$NewPrefs::playMode[3] = "Host game";
$NewPrefs::playMode[4] = "Choose game type";
$NewPrefs::playMode[5] = "Start IRC";
$NewPrefs::playMode[6] = "Open options";

NewOpts::register("NewPrefs Gui", "NewOpts\\Gui\\NewPrefs3.gui", "NewPrefs::onInit3();", "NewPrefs::onClose3();", true);
NewOpts::register("NewPrefs Network", "NewOpts\\Gui\\NewPrefs2.gui", "NewPrefs::onInit2();", "NewPrefs::onClose2();", true);
NewOpts::register("NewPrefs Play", "NewOpts\\Gui\\NewPrefs1.gui", "NewPrefs::onInit();", "NewPrefs::onClose();", true);
exec("NewOpts\\NewPrefsHelp.cs");

// this should be last function!!
function NewPrefs::loaded() {return TRUE;}

