// ---------------------------------------------------------------------------
// inventory_table.cs -- Version 2.1 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\inventory_table.cs", "2.1", "Lorne Laliberte", "- May 22, 1999 - dynamic inventory table - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");


//
// Convert an item name to its equivalent $Inv:: variable name
//
function Inv::makeName(%itemname)
{
    if(%itemname == "")
        return "";

    %i = 0;
    %newstring = "$Inv::";

    while( (%char = String::getSubStr(%itemname, %i, 1)) != "" )
    {
        if(%char == " ")
            %char = "_";
        else if( "k" @ %char == "k-" )
            %char = "_";
        else if( "k" @ %char == "k+" )
            %char = "_";
        else if(%char == "=")
            %char = "_";
        else if(%char == "*")
            %char = "_";
        else if(%char == "/")
            %char = "_";

        // I'll add more if it becomes necessary :)

        %newstring = %newstring @ %char;
        %i++;
    }

    return %newstring;    
}


//
// Test whether an item exists
//
function Inv::exists(%itemname)
{
    return (getItemType(%itemname) != -1);
}

//
// Force a specific variable name onto an inventory item
//
function Inv::force(%itemvarname, %itemname)
{
    eval("$Inv::" @ %itemvarname @ "=getItemType(\""@ %itemname @ "\");");
}

//
// Set up Inventory Table variables
//
function Inv::Init(%itemname, %ammoname)
{
    %itemvarname = Inv::makename(%itemname);

    // Assign the type # for %itemname to $Inv::<%itemvarname>
    %itemtype = eval(%itemvarname @ "=getItemType(\""@ %itemname @ "\");");

    if(%itemtype != -1) // item exists on this server
    {
        // Assign the item name to our $Inv::Name array
        $Inv::Name[%itemtype] = %itemname;

        if(%ammoname != "") // %ammoname arg provided
        {
            %ammovarname = Inv::makename(%ammoname);

            // Associate this ammo name with the item (weapon)
            $Inv::Ammo[%itemtype] = %ammoname;
            $Inv::Ammo[%itemname] = %ammoname;
            
            // Assign the type # for %ammoname to $Inv::<%ammovarname>
            %ammotype = eval(%ammovarname @ "=getItemType(\""@ %ammoname @ "\");");
                
            // Assign the ammo name to our $Inv::Name array
            $Inv::Name[%ammotype] = %ammoname;
        }
        return true;
    }
    else // item has been replaced or renamed on this server
    {
        return false;
    }
}

function Inv::InitWeapon(%itemname, %ammoname)
{
    if((%type = getItemType(%itemname)) != -1)
    {
        $Inv::WeaponList[$Inv::WeaponCount++] = %type;
        
        if(%ammoname != "")
            $Inv::AmmoList[$Inv::AmmoCount++] = getItemType(%ammoname);

        return Inv::Init(%itemname, %ammoname);
    }
    return false;
}

function Inv::InitAmmo(%itemname)
{
    if((%type = getItemType(%itemname)) != -1)
    {
        $Inv::AmmoList[$Inv::AmmoCount++] = %type;
        return Inv::Init(%itemname);
    }
    return false;
}

function Inv::InitArmor(%itemname)
{
    if((%type = getItemType(%itemname)) != -1)
    {
        $Inv::ArmorList[$Inv::ArmorCount++] = %type;
        return Inv::Init(%itemname);
    }
    return false;
}

function Inv::InitPack(%itemname)
{
    if((%type = getItemType(%itemname)) != -1)
    {
        $Inv::PackList[$Inv::PackCount++] = %type;
        return Inv::Init(%itemname);
    }
    return false;
}

function Inv::InitMisc(%itemname)
{
    if((%type = getItemType(%itemname)) != -1)
    {
        $Inv::MiscList[$Inv::MiscCount++] = %type;
        return Inv::Init(%itemname);
    }
    return false;
}

function Inv::InitVehicle(%itemname)
{
    if((%type = getItemType(%itemname)) != -1)
    {
        $Inv::VehicleList[$Inv::VehicleCount++] = %type;
        return Inv::Init(%itemname);
    }
    return false;
}


//
// Set up the inventory table variables
//
function Inv::Initialize()
{
    echo("Clearing Inventory Table");
    
    deleteVariables("$Inv::*");

    echo("Initializing Inventory Table");

    //
    // Special:
    //
    Inv::InitWeapon("Weapon");
    Inv::InitAmmo("Ammo");
    Inv::InitPack("Backpack");
    
    //
    // BASE armor:
    //
    Inv::InitArmor("Light Armor");
    Inv::InitArmor("Medium Armor");
    Inv::InitArmor("Heavy Armor");

    //
    // BASE vehicles:
    //
    Inv::InitVehicle("Scout"); // on some modified servers this will point to the Scout armor? =/
    Inv::InitVehicle("LPC");
    Inv::InitVehicle("HPC");
    
    //
    // BASE weapons and ammo:
    //
    Inv::InitWeapon("Blaster");
    Inv::InitWeapon("Chaingun", "Bullet");
    Inv::InitWeapon("Disc Launcher", "Disc");
    Inv::InitWeapon("ELF gun");
    if(Inv::exists("Grenade Ammo"))
    {
        Inv::InitWeapon("Grenade Launcher", "Grenade Ammo");
    }
    else
    {
        Inv::force("Grenade_Ammo", "GrenadeAmmo");
        Inv::InitWeapon("Grenade Launcher", "GrenadeAmmo");
    }
    Inv::InitWeapon("Laser Rifle");
    if(Inv::exists("Mortar Ammo"))
    {
        Inv::InitWeapon("Mortar", "Mortar Ammo");
    }
    else
    {
        Inv::force("Mortar_Ammo", "MortarAmmo");
        Inv::InitWeapon("Mortar", "MortarAmmo");
    }
    Inv::InitWeapon("Plasma Gun", "Plasma Bolt");
    Inv::InitWeapon("Repair Gun");
    Inv::InitWeapon("Targeting Laser");

    //
    // BASE packs:
    //
    Inv::InitPack("Inventory Station");
    Inv::InitPack("Ammo Station");
    Inv::InitPack("Energy Pack");
    Inv::InitPack("Repair Pack");
    Inv::InitPack("Shield Pack");
    Inv::InitPack("Ammo Pack");
    Inv::InitPack("Sensor Jammer Pack");
    Inv::InitPack("Motion Sensor");
    Inv::InitPack("Pulse Sensor");
    Inv::InitPack("Sensor Jammer");
    Inv::InitPack("Camera");
    Inv::InitPack("Turret");

    //
    // BASE misc equipment:
    //
    Inv::InitMisc("Repair Kit");
    Inv::InitMisc("Mine");
    Inv::InitMisc("Grenade");
    Inv::InitMisc("Beacon");
    
    
    // ---------------------------------------------------------------------------
    // Now for items from the various mods
    
    //
    // MOD armor:
    //
    Inv::InitArmor("Spy");
    Inv::InitArmor("Scout"); // on base servers this will point to the Scout vehicle =/
    Inv::InitArmor("Sniper");
    Inv::InitArmor("Mercenary");
    Inv::InitArmor("Burster");
    Inv::InitArmor("Engineer");
    Inv::InitArmor("Alien");
    Inv::InitArmor("Cyborg");
    Inv::InitArmor("Dragoon");
    
    //
    // MOD vehicles:
    // 
    Inv::InitVehicle("Firestorm Bomber");
    Inv::InitVehicle("Stealth LPC");
    Inv::InitVehicle("Wraith");
    Inv::InitVehicle("Interceptor");
    Inv::InitVehicle("BomberLPC");
    Inv::InitVehicle("StealthHPC");
    
    //
    // MOD weapons and ammo:
    //
    Inv::InitWeapon("Dart Rifle", "Poison Dart");
    Inv::InitWeapon("EMP Grenade Launcher", "EMPGrenadeAmmo");
    Inv::InitWeapon("Engineer Repair-Gun");
    Inv::InitWeapon("Flame Thrower");
    Inv::InitWeapon("Gauss Gun");
    Inv::InitWeapon("Hyper Blaster");
    Inv::InitWeapon("Ion Rifle");
    Inv::InitWeapon("IX-2000 Sniper Rifle", "Rifle Ammo");
    Inv::InitWeapon("MAG Gun");
    Inv::InitWeapon("Magnum", "Magnum Bullets");
    Inv::InitWeapon("Omega Cannon");
    Inv::InitWeapon("Pyro-Torch", "Pyro Charge");
    Inv::InitWeapon("Railgun", "Railgun Bolt");
    if(Inv::exists("RocketAmmo"))
    {
        Inv::Force("Rocket_Ammo", "RocketAmmo");
        Inv::InitWeapon("Rocket Launcher", "RocketAmmo");
    }
    else
    {
        Inv::Force("Rocket_Ammo", "Rockets");
        Inv::InitWeapon("Rocket Launcher", "Rockets");
    }
    Inv::InitWeapon("Shockwave Cannon");
    Inv::InitWeapon("Sniper Rifle", "Sniper Bullet");
    Inv::InitWeapon("Stinger", "Rockets");
    Inv::InitWeapon("Thunderbolt");
    Inv::InitWeapon("Vulcan", "Vulcan Bullet");
    
    //
    // MOD packs:
    //
    Inv::InitPack("Accelerator Device");
    Inv::InitPack("Auto-Rocket Cannon");
    Inv::InitPack("Blast Wall");
    Inv::InitPack("Cloaking Device");
    Inv::InitPack("Command Laptop");
    Inv::InitPack("Cybernetic Laser");
    Inv::InitPack("Deployable Platform");
    Inv::InitPack("ELF Turret");
    Inv::InitPack("Force Field");
    Inv::InitPack("Heat Sink");
    Inv::InitPack("Hologram");
    Inv::InitPack("Ion Turret");
    Inv::InitPack("Interceptor Pack");
    Inv::InitPack("Laser Turret");
    Inv::InitPack("Large Force Field");
    Inv::InitPack("Lightning Pack");
    Inv::InitPack("Mechanical Tree");
    Inv::InitPack("Missile Turret");
    Inv::InitPack("Mortar Turret");
    Inv::InitPack("Plasma Turret");
    Inv::InitPack("Regeneration Pack");
    Inv::InitPack("Rail Turret");
    Inv::InitPack("Shock Turret");
    Inv::InitPack("Rocket Booster"); // should this be InitMisc instead?
    Inv::InitPack("Rocket Turret");
    Inv::InitPack("Sentry");
    Inv::InitPack("Small Force Field");
    Inv::InitPack("Springboard");
    Inv::InitPack("StealthHPC Pack");
    Inv::InitPack("StealthShield Pack");
    Inv::InitPack("Suicide DetPack");
    Inv::InitPack("Teleport Pad");
    Inv::InitPack("Vulcan Turret");

    //
    // MOD misc equipment:
    //

    Event::Trigger(eventInventoryTableReady);
}

Event::Attach(eventConnected, "Inv::Initialize();");
