//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | HUDSets.cs
// AUTHOR       | SixStringz  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 1.2
// RELEASE DATE | 09/25/99
// REQUIREMENTS | 
// DESCRIPTION  | 
// DESCRIPTION  | 
// DESCRIPTION  | 
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

function HUDSets::1280x1024()
{
   echo("LOADING HUD PRESET " @ $SixPref::HUDConfig @ " for 1280x1024");
   if ($SixPref::HUDConfig == 1)
   {
     $CDHUD::position = "0% bottom(scorehud)-1 120 32";  
     $phud::position = "78% 0 52 18";  
   }
   else if ($SixPref::HUDConfig == 2)
   {
     $CDHUD::position = "0% bottom(scorehud)-1 120 32";  
     $phud::position = "78% 0 52 18";  
     $dropflag::pos = "left(flagcapshud)-45 top(flagcapshud)";
   }
   else if ($SixPref::HUDConfig == 3)
   {
      $CDHUD::position = "100% bottom(hudplayers)-1 120 32";  
      $phud::position = "78% 0 52 18";  
      $dropflag::pos = "right(flagcapshud) top(flagcapshud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
   }
   else if ($SixPref::HUDConfig == 4)
   {
      $FudgePref::TinyCapHUDPos = "0% 99 40 17";
      $phud::position = "78% 0 52 18";  
      $dropflag::pos = "left(flagcapshud)-45 top(flagcapshud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
      $CrunchyPref::TeamSizeHUDPos = "0% bottom(tinykillhud) 40 18";
      $CrunchyPref::ItemHUDPos = "left(TeamSizeHUD) bottom(TeamSizeHUD)-1 40 56";
      $CDHUD::position = "0% bottom(itemhud)-1 120 32";  
      $Cowboy::PlaceX = "0%";
      $Cowboy::PlaceY = "bottom(cdhud)+20";
   }
   else if ($SixPref::HUDConfig == 5)
   {
      $phud::position = "78% 0 52 18";  
      $FlagHunterHUD::Position = "0 99 75 21";
      $CrunchyPref::ItemHUDPos = "100% 99 40 56";
      $CDHUD::position = "100% bottom(ItemHUD)-1 120 32";  
   }
   if(included("six\\options\\stopwatch.cs"))  
   {
      $SW::x = "%85";  // X coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::y = "%0";   // Y coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::width = 52;  // Width of HUD in pixels
      $SW::height = 18; // Height of HUD in pixels
   }
}

function HUDSets::1024x768()
{
   echo("LOADING HUD PRESET " @ $SixPref::HUDConfig @ " for 1024x768");
   if ($SixPref::HUDConfig == 1)
   {
     $CDHUD::position = "0% bottom(scorehud)-1 120 32";  
     $phud::position = "78% 0 52 18";  
   }
   else if ($SixPref::HUDConfig == 2)
   {
     $CDHUD::position = "0% bottom(scorehud)-1 120 32";  
     $phud::position = "78% 0 52 18";  
     $dropflag::pos = "left(flagcapshud)-45 top(flagcapshud)";
   }
   else if ($SixPref::HUDConfig == 3)
   {
      $CDHUD::position = "100% bottom(hudplayers)-1 120 32";  
      $phud::position = "78% 0 52 18";  
      $dropflag::pos = "right(flagcapshud) top(flagcapshud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
   }
   else if ($SixPref::HUDConfig == 4)
   {
      $FudgePref::TinyCapHUDPos = "0% 82 40 17";
      $phud::position = "78% 0 52 18";  
      $dropflag::pos = "left(flagcapshud)-45 top(flagcapshud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
      $CrunchyPref::TeamSizeHUDPos = "0% bottom(tinykillhud) 40 18";
      $CrunchyPref::ItemHUDPos = "left(TeamSizeHUD) bottom(TeamSizeHUD)-1 40 56";
      $CDHUD::position = "0% bottom(itemhud)-1 120 32";  
      $Cowboy::PlaceX = "0%";
      $Cowboy::PlaceY = "bottom(cdhud)+20";
   }
   else if ($SixPref::HUDConfig == 5)
   {

      $phud::position = "78% 0 52 18";  
      $FlagHunterHUD::Position = "0 82 75 21";
      $CrunchyPref::ItemHUDPos = "100% 82 40 56";
      $CDHUD::position = "100% bottom(ItemHUD)-1 120 32";  
   }
   if(included("six\\options\\stopwatch.cs"))  
   {
      $SW::x = "%85";  // X coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::y = "%0";   // Y coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::width = 52;  // Width of HUD in pixels
      $SW::height = 18; // Height of HUD in pixels
   }
}

function HUDSets::800x600()
{
   echo("LOADING HUD PRESET " @ $SixPref::HUDConfig @ " for 800x600");
   if ($SixPref::HUDConfig == 1)
   {
      $CDHUD::position = "0% bottom(scorehud) 120 32";  
      $phud::position = "77% 0 52 18";  
   }
   else if ($SixPref::HUDConfig == 2)
   {
      $CDHUD::position = "0% bottom(scorehud) 120 32";  
      $phud::position = "77% 0 52 18";  
      $dropflag::pos = "left(flagcapshud)-45 top(flagcapshud)";
   }
   else if ($SixPref::HUDConfig == 3)
   {
      $CDHUD::position = "100% bottom(hudplayers)-1 120 32";  
      $phud::position = "77% 0 52 18";  
      $dropflag::pos = "right(flagcapshud) top(flagcapshud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";

   }
   else if ($SixPref::HUDConfig == 4)
   {
      $FudgePref::TinyCapHUDPos = "0% 70 40 17";
      $phud::position = "right(tinycaphud) 70 52 18";  
      $dropflag::pos = "left(flagcapshud)-45 top(flagcapshud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
      $CrunchyPref::TeamSizeHUDPos = "0% bottom(tinykillhud) 40 18";
      $CrunchyPref::ItemHUDPos = "left(TeamSizeHUD) bottom(TeamSizeHUD)-1 40 56";
      $CDHUD::position = "0% bottom(itemhud)-1 120 32";  
      $Cowboy::PlaceX = "0%";
      $Cowboy::PlaceY = "bottom(cdhud)+20";
   }
   else if ($SixPref::HUDConfig == 5)
   {
      $phud::position = "75% 0 52 18";  
      $FlagHunterHUD::Position = "0 70 75 21";
      $CrunchyPref::ItemHUDPos = "100% 70 40 56";
      $CDHUD::position = "100% bottom(ItemHUD)-1 120 32";  
   }

   if(included("six\\options\\stopwatch.cs"))  
   {
      $SW::x = "%85";  // X coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::y = "%0";   // Y coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::width = 52;  // Width of HUD in pixels
      $SW::height = 18; // Height of HUD in pixels
   }
}

function HUDSets::640x480()
{
   echo("LOADING HUD PRESET " @ $SixPref::HUDConfig @ " for 640x480");
   if ($SixPref::HUDConfig == 1)
   {
      $CDHUD::position = "0% bottom(hudCTFEnemySmall)-1 120 32";  
      $phud::position = "100% bottom(hudplayers)-1 52 18";  
   }
   else if ($SixPref::HUDConfig == 2)
   {
      $CDHUD::position = "0% bottom(hudCTFEnemySmall)-1 120 32";  
      $phud::position = "100% bottom(hudplayers)-1 52 18";  
      $dropflag::pos = "100% bottom(pingdhud)";
   }
   else if ($SixPref::HUDConfig == 3)
   {
      $CDHUD::position = "100% bottom(hudplayers)-1 120 32";  
      $phud::position = "73 66 52 18";  
      $dropflag::pos = "73 bottom(pingdhud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
   }
   else if ($SixPref::HUDConfig == 4)
   {
      $FudgePref::TinyCapHUDPos = "0% 66 40 17";
      $phud::position = "right(tinycaphud) 66 52 18";  
      $dropflag::pos = "right(tinykillhud) bottom(pingdhud)";
      $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
      $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14";
      $CrunchyPref::TeamSizeHUDPos = "0% bottom(tinykillhud) 40 18";
      $CrunchyPref::ItemHUDPos = "left(TeamSizeHUD) bottom(TeamSizeHUD)-1 40 56";
      $CDHUD::position = "0% 171 120 32";  
      $Cowboy::PlaceX = "11%";
      $Cowboy::PlaceY = "bottom(cdhud)+20";
   }
   else if ($SixPref::HUDConfig == 5)
   {
      $FlagHunterHUD::Position = "0 66 75 21";
      $CrunchyPref::ItemHUDPos = "100% 66 40 56";
      $CDHUD::position = "100% bottom(ItemHUD)-1 120 32";  
      $phud::position = "0 bottom(FlagHunterHUD_Deaths)-1 52 18";  
   }
   if(included("six\\options\\stopwatch.cs"))  
   {
      $SW::x = "%83";  // X coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::y = "%0";   // Y coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
      $SW::width = 52;  // Width of HUD in pixels
      $SW::height = 18; // Height of HUD in pixels
   }
}

function HUDSets::InitHUDs(%size)
{
   %size = Presto::ScreenSize();
   FlagCapsHUD::CheckXY();

   if (%size == "1280 1024")
      HUDSets::1280x1024();
   else if (%size == "1024 768")
      HUDSets::1024x768();
   else if (%size == "800 600")
      HUDSets::800x600();
   else if (%size == "640 480")
      HUDSets::640x480();
   else
   {
      echo("HUDSets - Resolution " @ %size @ " is not supported by HUDSets");
      $SixVar::Res = other;
   }
   if (included("six\\pinghud.cs"))
      phud::init();
   if(included("six\\options\\stopwatch.cs"))  
      stopwatch::HUDupdate();
   if (included("six\\scorehud.cs"))
      ScoreHud::initdisply();
   if (included("six\\cdhud.cs"))
      CDHUD::SetPos();
   if (included("six\\tinycaphud.cs"))
      TinyCap::Init();
   if (included("six\\tinykillhud.cs"))
      TinyKillHUD::Init();
   if (included("six\\droptimer.cs"))
      dropflag::init();
   TeamHUD::Reset();
   if (included("six\\FlagHunterHUD.cs"))
      FlagHunterHUD::MakeHUDS();
   if (included("crunchy\\objectivehud.cs"))
   {
      HUD::Move(ObjectiveHUD, $CrunchyPref::ObjectiveHUDPos);
      ObjectiveHUD::Resize();
   }
   if (included("crunchy\\teamsizehud.cs"))
   {
      HUD::New(TeamSizeHUD, TeamSize::UpdateHUD, $CrunchyPref::TeamSizeHUDPos);
      HUD::Display(TeamSizeHUD);
   }
   if (included("crunchy\\itemhud.cs"))
   {
      HUD::New(ItemHUD, Item::UpdateHUD, $CrunchyPref::ItemHUDPos);
      HUD::Display(ItemHUD);
   }
   if (included("six\\cdhud.cs"))
      CDHUD::SetPos();
   if (included("cowboy\\cowboyhud.cs"))
      HUD::New(CowboyHUD, Cowboy::UpdateHUD, $Cowboy::PlaceX, $Cowboy::PlaceY, $Cowboy::SizeX, $Cowboy::SizeY);
}

function SnipeHud::display(%on)
{
    if (%on == toggle)
    {
       %on = !$SnipeHud::zoomState;

       if (%on == 1)
       {
          if ($SixPref::HUDConfig <= 2)
             $PrestoPref::TeamHUDPosition = "0% 100% 70% 14";
          else 
          {
             %newpos = HUD::Height(ObjectiveHUD);
             $PrestoPref::TeamHUDPosition = "0% 100% 70% 14";
             $CrunchyPref::ObjectiveHUDPos = "100%  top(SnipeHud::frame)-" @ %newpos @ " 135 14";
         }
       }
       else
       {
          if ($SixPref::HUDConfig <= 2)
             $PrestoPref::TeamHUDPosition = "0% 100% 100% 14";
          else
          {
             $PrestoPref::TeamHUDPosition = "0% 100% 100%-135 14";
             $CrunchyPref::ObjectiveHUDPos = "100% 100% 135 14"; 
          }
       }

       TeamHUD::Reset();
       HUD::Move(ObjectiveHUD, $CrunchyPref::ObjectiveHUDPos);
       ObjectiveHUD::Resize();
    }

    HUD::Display(SnipeHud::frame, %on);
    if($SnipeHud::showMag)
        HUD::Display(SnipeHud::zoomLevel, %on);
    HUD::Display(SnipeHud::crosshairs, %on);
    HUD::Display(SnipeHud::crosshairs2, %on);
    $SnipeHud::zoomState = %on;
    if (%on)
    {
        if(!$SnipeHud::passiveSense)
            SnipeHud::sensitivity(true);
        SnipeHUD::newView();
    }
    else
    {
        SnipeHud::sensitivity(false);
    }
}

HUDSets::initHUDS();