//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | ScoreHUD.cs 
// AUTHOR       | Joe Chott 
// AUTHOR EMAIL | verxion@pobox.com
// VERSION      | 0.2
// RELEASE DATE | ?
// REQUIREMENTS | 
// DESCRIPTION  | 
// DESCRIPTION  | 
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

// -----------------------
// ScoreHUD.cs version 0.2
// -----------------------

//  Written by Joe Chott (verxion@pobox.com AKA Verxion) with MUCH help from Presto,
//  who is THE MAN!  Everyone should really let him know how much
//  he helps the scripting community.

// **********************************************************************************
// These lines are where you customize the location of the hud.

$ScoreHud::position = "0% bottom(hudCTFEnemySmall)-1 120 30";



// Or use this line to put it under DynHUD (if you have that enabled)
//$ScoreHud::position = "left(hudDyn) bottom(hudDyn)-1 width(hudDyn) 30";

// **********************************************************************************

// Include files

Include("presto\\TeamTrak.cs");
Include("presto\\HUD.cs");
Include("presto\\Event.cs");

// This function deals with our initial connection to the game
// We need to assume the score is zip to zip, and we tell the
// player that we don't know for sure by putting a question mark
// after the score.  The code to "manually" sync the scores is
// not really ready for prime time yet, but I will post it when
// it is.

function ScoreHud::OnConnect() {

	// The two teams initial scores on connect.

	$ScoreHud::score[0] = 0;
	$ScoreHud::score[1] = 0;

	// Both teams scores are currently un-synced.
	
	$ScoreHud::sync[0] = "?";
	$ScoreHud::sync[1] = "?";

	// This tells the user we know NOTHING about the objective yet.

	$ScoreHud::objective = "";

	// Since we have new data, update the hud.

	HUD::Update(ScoreHud);
}

// When a new mission starts, we KNOW the score, and we know that nobody
// has the objective, so we update those variables accordingly

function ScoreHud::OnChangeMission() {
	$ScoreHud::score[0] = 0;
	$ScoreHud::score[1] = 0;
	$ScoreHud::sync[0] = "";
	$ScoreHud::sync[1] = "";
	$ScoreHud::objective = "none";

	// Since we have new data, update the hud.

	HUD::Update(ScoreHud);
}

// This just increments the score for the correct team when there is a
// flag capture.

function ScoreHud::ProcessCapture(%team) {

	// Calculate the team number that scored (incoming team is the team
	// whose flag was captured, therefore, the OTHER team gets the point.

	%scoringTeam = 1 - %team;

	// Increment their score

	$ScoreHud::score[%scoringTeam]++;

	// A nifty little blink of the new score (courtesy of Presto)

	ScoreHud::Blink(%scoringTeam, 0);
}

// Setup the appropriate fonts for the blink function coming up.

$ScoreHud::blinkFont[0] = "<f2>";
$ScoreHud::blinkFont[1] = "<f3>";

// This is the update function for the hud.  It makes sure the status of the
// objective is counted into the score, and shows the score of both teams,
// along with the status of the objective.

function ScoreHud::Update() {

	// This is going to setup our blinking score.

	%score[0] = $ScoreHud::blinkFont[$scoreHud::blink[0] == true] @ 
		($ScoreHud::score[0] + ($ScoreHud::objective == "0")) @ $ScoreHud::sync[0];
	%score[1] = $ScoreHud::blinkFont[$scoreHud::blink[1] == true] @ 
		($ScoreHud::score[1] + ($ScoreHud::objective == "1")) @ $ScoreHud::sync[1];

	// Just for readabilities sake, lets make some vars to describe the teams.

	%myTeam = Team::Friendly();
	%enemyTeam = Team::Enemy();

	// Ok, this is gonna be "Score: 0 to 0" type of format.

	HUD::AddTextLine(ScoreHUD, "<f1>Score: " @ %score[%myTeam] @
		"<f1> to " @ %score[%enemyTeam]);

	// We need to determine who has the objective.  This is done by looking at the
	// $ScoreHud::objective variable contents.  We then map those contents to the
	// %objective variable, which is ultimately placed in a line of the hud below.

	if ($ScoreHud::objective == "")
		%objective = "???";
	else if ($ScoreHud::objective == "none")
		%objective = "None";
	else if ($ScoreHud::objective == %myTeam)
		%objective = "You!";
	else if ($ScoreHud::objective == %enemyTeam)
		%objective = "Them!";
	else	%objective = "*err*";

	// Here we show the user the status of the objective.

	HUD::AddTextLine(ScoreHUD, "<f1>Objective: <f2>"@ %objective);

	// Tell the HUD handler that we don't need to be polled.

	return 0;
}

// This function is called when the objective is "messed with".  :)  We have
// to determine which team got the objective, and change the status accordingly.

function ScoreHud::ProcessObjective(%team) {

	if (%team == "Your")
		$ScoreHud::objective = Team::Friendly();
		else $ScoreHud::objective = Team::Enemy();
	ScoreHud::Blink($ScoreHud::objective,0);
}

// This function triggers events when an objective is taken,

function ScoreHud::ParseClientMessage(%client, %msg) {
	if (%client != 0) {
		return;
	}

	if (Match::String(%msg, "* team has taken an objective.")) {
		%team = Match::Result(0);
		Event::Trigger(eventObjectiveTaken, %team);
	}

	if (Match::String(%msg, "The * team has taken your objective.")) {
		%team = Match::Result(0);
		Event::Trigger(eventObjectiveTaken, %team);
	}

}

// Detects when you change teams so it can re-display correctly.

function ScoreHud::TeamChange(%client) {
	if (%client != getManagerId())
		return;

	HUD::Update(ScoreHud);
}

// This function is the brainchild of Presto.  I just changed his indention
// method to match my code.  :)  This function is recursive, and all it does
// is call itself repeatedly, 8 times, alternating the color of the score so
// it draws your eyes there.  :)

function ScoreHud::Blink(%team, %mode) {
	if (%mode == 8)
		$ScoreHud::blink[%team] = "";
	else {
		$ScoreHud::blink[%team] = !$ScoreHud::blink[%team];
		schedule("ScoreHud::Blink("@%team@", "@ (%mode + 1) @");", 0.3);
	}
	HUD::Update(ScoreHud);
}

// Instantiate our hud

function ScoreHud::initdisply()
{
   HUD::New(ScoreHud, ScoreHud::Update, $scoreHUD::position);
   HUD::Display(ScoreHud);
}

ScoreHud::initdisply();

// Setup our callbacks for events
Event::Attach(eventClientChangeTeam, ScoreHud::TeamChange);
Event::Attach(eventObjectiveTaken, ScoreHud::ProcessObjective);
Event::Attach(eventConnectionAccepted, ScoreHud::OnConnect);
Event::Attach(eventChangeMission, ScoreHud::OnChangeMission);
Event::Attach(eventFlagCaptured, ScoreHud::ProcessCapture);
Event::Attach(eventClientMessage, ScoreHud::ParseClientMessage);