// ---------------------------------------------------------------------------
// am_repair.cs -- Version 2.7 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\am_repair.cs", "2.7", "Lorne Laliberte", "- May 22, 1999 - repair messaging - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\ladder.cs");
include("writer\\flood.cs");
include("writer\\whatif.cs");


$AutoMessage::FilterItem[0] = "Scout";
$AutoMessage::FilterItem[1] = "LPC";
$AutoMessage::FilterItem[2] = "HPC";
$AutoMessage::FilterCount = 3;
$AutoMessage::FilterModeOn = true; // enable filters by default

//
// MUTING:
//
// Set this to true if you don't want to see the white "Repairing <item>" messages
$AutoMessage::Mute::RepairingItem = true;

// Set this to true if you don't want to see the white "Repairing <player>" messages
$AutoMessage::Mute::RepairingPlayer = true;

// Set this to true if you don't want to see the white "Repair stopped" messages
$AutoMessage::Mute::RepairStopped = false;

// Set this to true if you don't want to see the white "Repair done" messages
$AutoMessage::Mute::RepairDone = true;

//
// Check for "Repairing " messages
//
function AutoMessage::StartingRepairs(%msg)
{
    if( (%index = String::findSubStr(%msg, "Repairing ")) != -1)
    {
        // Set %index to next character after "Repairing "
        %index += 10;

        // What are you repairing?
        $AutoMessage::FloodItem = $AutoMessage::RepairItem = String::getSubStr(%msg, %index, 1024); // get rest of %msg from %index

        // Don't say anything if we're repairing a teammate (or an enemy lol :) -- thanks to Poker and Presto for this
		if (getClientByName($AutoMessage::RepairItem) != 0)
		{
            $AutoMessage::RepairingPlayer = true; // set a flag so we can tell them to stay put if they move away

            if($AutoMessage::Mute::RepairingPlayer)
                return truemute;

			return true;
		}

        // Set a flag to enable our Repairs Completed code
        $AutoMessage::Repairing = 1;

        // Ignore the "#1" etc in item name for purposes of comparison and flood protection
        if( (%index = String::findSubStr($AutoMessage::RepairItem, "#")) != -1)
        {
            $AutoMessage::FloodItem = String::getSubStr($AutoMessage::RepairItem, 0, %index - 1);
        }

        if(Flood::protect("repair" @ $AutoMessage::FloodItem) && Flood::protect("repairdone" @ $AutoMessage::FloodItem))
        {
            // Some people don't like hearing when I repair certain things --
            // as important as I think it is they know I'm repairing my trusty
            // scout, I try to be accomodating :)
            $AutoMessage::Filter = false;
            if($AutoMessage::FilterModeOn) 
            {
                // Should we filter (not announce repairs on) this item?
                for(%i = 0; %i < $AutoMessage::FilterCount; %i++)
                {
                    if(String::ICompare($AutoMessage::FloodItem, $AutoMessage::FilterItem[%i]) == 0)
                    {
                        $AutoMessage::Filter = true; // set flag so we won't say item's repaired when done

                        if($AutoMessage::Mute::RepairingItem)
                            return truemute;

                        return true;
                    }
                }
            }

            // Tell the team what you're repairing -- if you change the text, make
            // sure you don't use the word "repairing" at all, or you will trigger
            // this code over and over and get spam-blocked. :)
            say(1, "Repair begun on " @ $AutoMessage::RepairItem);
        }
        if($AutoMessage::Mute::RepairingItem)
            return truemute;

        return true;
    }
    return false;
}
Event::Attach(ladderClientMessage, AutoMessage::StartingRepairs);


//
// Check for messages that indicate repair was interrupted
//
function AutoMessage::RepairInvalid(%msg)
{
	if( (String::findSubStr(%msg, "is not damaged") != -1) ||
	    (String::findSubStr(%msg, "AutoRepair Off") != -1) ||
	    (String::findSubStr(%msg, "Nothing in range") != -1) )
	{
	    if($MMB::Repairing)
            MMB::StopRepair();

        return true;
    }
    else if(String::findSubStr(%msg, "Repair Stopped") != -1)
    {
        // Turn on flood protection for this item
        Flood::protect("repair" @ $AutoMessage::FloodItem, 60);

        if($AutoMessage::RepairingPlayer) // we were repairing another player
        {
            if(Flood::protect("repairplayer" @ $AutoMessage::RepairItem, 5))
            {
//                say(1, $AutoMessage::RepairItem @ ", hold position to be repaired.");
//                localMessage("wait1");
            }
            $AutoMessage::RepairingPlayer = false;
        }

	    if($MMB::Repairing)
            MMB::StopRepair();

        if($AutoMessage::Mute::RepairStopped)
            return truemute;

        return true;
    }
    return false;
}
Event::Attach(ladderClientMessage, AutoMessage::RepairInvalid);


//
// Check for completed repairs message
//
function AutoMessage::RepairDone(%msg)
{
    if($AutoMessage::Repairing)
    {
        if((String::findSubStr(%msg, "Done") != -1))
        {
            if(Flood::protect("repairdone" @ $AutoMessage::FloodItem, 60))
            {
                if(!$AutoMessage::Filter)
                {
                    // Tell the team what you've repaired:
                    say(1, $AutoMessage::RepairItem @ " has been repaired!");
                }
            }

            if($PowerWasDown)
            {
                if( (String::findSubStr($AutoMessage::RepairItem, "Generator") != -1) || 
                    (String::findSubStr($AutoMessage::RepairItem, "Solar Panel") != -1) )
                {
                    say(1, "Our Power is Back Up!"); // only visible to teammates

                    $PowerWasDown = false;
                }
            }

            // Clear flag so we don't spam with nonsense messages if someone says "Done"
            $AutoMessage::Repairing = 0;

            if($MMB::Repairing)
            {
                MMB::StopRepair();
            }
            
            if($AutoMessage::Mute::RepairDone)
                return truemute;

            return true;
        }
    }
    return false;
}
Event::Attach(ladderClientMessage, AutoMessage::RepairDone);


function AutoMessage::ToggleFilterMode()
{
    remoteBP(2048, "<L5>Repair Item Message Filter " @ wif($AutoMessage::FilterModeOn = !$AutoMessage::FilterModeOn, "ON", "OFF"), 4);
}

// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae"); 
    
    // Toggle repair message filtering on/off
    bindCommand(keyboard0, make, alt, "r", TO, "$AutoMessage::ToggleFilterMode();");
    bindCommand(keyboard0, break, alt, "r", TO, "");
}
