// ---------------------------------------------------------------------------
// am_thanks.cs -- Version 2.4 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\am_thanks.cs", "2.4", "Lorne Laliberte", "- May 22, 1999 - auto-thank when repaired - www.planetstarsiege.com/lorne/");

include("writer\\ladder.cs");
include("writer\\flood.cs");


//
// MUTING:
//
// Set this to true if you don't want to see the white "Being repaired by <player>" messages
$AutoMessage::Mute::BeingRepairedBy = false;


//
// Thank teammate (or enemy lol :) for repairing you
//
function AutoMessage::ThankYou(%msg)
{
    if((%index = String::findSubStr(%msg, "Being repaired by")) != -1)
    {
        // Set %index to next character after "Being repaired by"
        %index += 18; 
        
        // Who are you being repaired by?
        %name = String::getSubStr(%msg, %index, 1024); // get rest of %msg from %index

        // Thank player if you haven't already done so in the last 30 seconds
        if(Flood::protect("thanks" @ %name, 30))
        {
            // Be polite. :)
            schedule("say(1, \"Thanks " @ %name @ "!\");", 3); // only visible to your team
            schedule("localMessage(\"thanks\");", 3); // play local sound, only audible to those nearby
        }

        if($AutoMessage::Mute::BeingRepairedBy)
            return truemute;

        return true;
    }
    return false;
}
Event::Attach(ladderClientMessage, AutoMessage::ThankYou);
