// ---------------------------------------------------------------------------
// auto_repair_kit.cs -- Version 3.3 -- May 25, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\auto_repair_kit.cs", "3.3", "Lorne Laliberte", "- May 25, 1999 - auto-use repair kit - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\station_events.cs");
include("writer\\inventory_table.cs");
include("writer\\item_events.cs");
include("writer\\ladder.cs");
include("writer\\whatif.cs");


$useRepairKit::delay = 0.1;

//
// Toggle Auto Use Repair Kit mode on/off -- the only way I've found
// to do this client side is from onClientMessage().
// Setting $AutoUse[RepairKit] to true only works if you're serving.
//
function AutoUseRepairKitToggle()
{
    remoteBP(2048, "<L5>Auto Use Repair Kit " @ wif($AutoUseRepairKit = !$AutoUseRepairKit, "ON", "OFF"), 4);
}


//
// Taunt enemy at press of a key
//
function RepairKitTaunt()
{
    if(!$SixPref::OGLMode)      
       say(0, "Thanks for the repair kit!~wthanks");
}

//
// Automatically use repair kit when one is picked up
//
function AutoUseRepairKit(%msg)
{
    if(String::findSubStr(%msg, "You received 1 Repair Kit") != -1)
    {
        if($AutoUseRepairKit)
            newUseItem($Inv::Repair_Kit);

    	return true;
    }
    if(String::findSubStr(%msg, "You couldn't buy Repair Kit") != -1)
    	return truemute;

    return false;
}
Event::Attach(ladderClientMessage, AutoUseRepairKit);


//
// Toggle Auto Repair Kit mode off after resupplying at a station
//
Event::Attach(eventResupplyComplete, "$AutoUseRepairKit=false;");


//
// Show a message when a repair kit is used
// and but another repair kit if you used one
// while at an inventory station
//
function AutoRepairKit::onUse(%itemtype, %itemname)
{
    if(%itemtype == $Inv::Repair_Kit)
    {
        if(getItemCount("Repair Kit"))
            remoteBP(2048, "<L5>Repair Kit Used! ", 4);
    }
    return;
}
Event::Attach(eventUse, AutoRepairKit::onUse);


function useRepairKit::start()
{
    newUseItem($Inv::Repair_Kit);

    if($Station::AtInventoryStation)
    {
        buy("Repair Kit");

        if($useRepairKit::count++ > 15)
            return;

        schedule::add("useRepairKit::start();", $useRepairKit::delay, useRepairKit);
    }
}

function useRepairKit::stop()
{
    schedule::cancel(useRepairKit);
}



// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Toggle Auto Use Repair Kit mode
    bindCommand(keyboard0, make, shift, "capslock", TO, "AutoUseRepairKitToggle();");
    bindCommand(keyboard0, break, shift, "capslock", TO, "");

    // Repair Kit Taunt
    bindCommand(keyboard0, make, alt, "capslock", TO, "RepairKitTaunt();");
    bindCommand(keyboard0, break, alt, "capslock", TO, "");

    // Use repair kit -- if you're at an inventory station, you can hold this key down
    // to keep buying and using repair kits
    bindCommand(keyboard0, make, "capslock", TO, "useRepairKit::start();");
    bindCommand(keyboard0, break, "capslock", TO, "useRepairKit::stop()");
}
