// ---------------------------------------------------------------------------
// ladder.cs -- Version 1.1 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\ladder.cs", "1.1", "Lorne Laliberte", "- May 22, 1999 - ladderClientMessage event - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


// 
// Set up an "if...elseif ladder" type event trigger and attach it
// to eventClientMessage
//
function ladderClientMessage(%client, %msg)
{
    if(%client)
        return true;

    // Call any attached functions once, the first one that returns
    // true will stop the rest from being called!
    Event::TriggerUntil::SubStr(true, ladderClientMessage, %msg);

    if(Event::Returned::SubStr(ladderClientMessage, mute))
        return mute;

    return true; // eventClientMessage trigger wants true/false return
}
Event::Attach(eventClientMessage, ladderClientMessage);


//
// Set up an "if...elseif ladder" type event trigger that is triggered
// by messages from other players
//
function ladderOtherPlayerMessage(%client, %msg)
{
    if(!%client)
        return true;

    if(%client != getManagerId())
    {
        // Call any attached functions once, the first one that returns
        // true will stop the rest from being called!
        Event::TriggerUntil::SubStr(true, ladderOtherPlayerMessage, %msg);

        if(Event::Returned::SubStr(ladderOtherPlayerMessage, mute))
            return mute;
    }
    return true; // eventClientMessage trigger wants true/false return
}
Event::Attach(eventClientMessage, ladderOtherPlayerMessage);

