// ---------------------------------------------------------------------------
// weapon_switch.cs -- Version 1.2 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\weapon_switch.cs", "1.2", "Lorne Laliberte", "- May 22, 1999 - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\respawn_event.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


// Trigger an eventWeaponSwitch after respawning
Event::Attach(eventRespawned, "WeaponSwitch(-1);");


//
// Call this on an eventWeaponSwitch if the %toWeapon isn't known
//
function WeaponSwitch(%fromWeapon)
{
    $WeaponKnown = false;
    $WeaponSwitch = 0;
    WeaponSwitchLoop(%fromWeapon);
}


//
// Loop until the weapon has changed (if no change, stops looping after 10 seconds)
//
function WeaponSwitchLoop(%fromWeapon)
{
    %weapon = getMountedItem(0); // might not be correct yet!

    if(!$WeaponKnown)
    {
        if(%weapon == %fromWeapon)
        {
            $WeaponSwitch++;
            if($WeaponSwitch < 100)
                schedule("WeaponSwitchLoop(" @ %fromWeapon @ ");", 0.1);
        }
        else
        {
            $WeaponKnown = true;
            Event::Trigger(eventWeaponSwitch, %weapon, %fromWeapon);
        }
    }
}
