//
//  SenseStack 1.0
//  Written by Tim 'Zear' Hammock
//
//  Usage:
//  
//  To turn on the script specific sensitivity for your script, call
//  
//      SenseStack::request(%script, %sense);
//
//  passing in your script's name and the desired sensitivity. You may call
//  this repeatedly with the same %script parameter and it will change the
//  sensitivity accordingly. When your script no longer needs to modify the
//  mouse sensitivity, call
//
//      SenseStack::release(%script)
//
//  passing the same script name used above and the sensitivity will revert to
//  the setting requested by the script before you (or or the most recent not
//  released) or to the base sensitivity as set by the user (whichever is
//  appropriate). Repeated calls to this function after the first call will
//  have no effect.

if(NewPrefs::loaded())
{
    if($NewPrefs::baseSensitivity == "")
	    $NewPrefs::baseSensitivity = 0.003;
}
else
    $NewPrefs::baseSensitivity = Client::getMouseSensitivity("playMap.sae");

$SenseStack::StackSize = 0;

function SenseStack::request(%script, %sense)
{
    %found = SenseStack::findInStack(%script);
    if(%found > 0)
    {
        $SenseStack::Stack[%found, sense] = %sense;
        if(%found == $SenseStack::StackSize)
            SenseStack::_setSense(%sense);
    }
    else
    {
        $SenseStack::StackSize++;
        $SenseStack::Stack[$SenseStack::StackSize, script] = %script;
        $SenseStack::Stack[$SenseStack::StackSize, sense] = %sense;
        SenseStack::_setSense(%sense);
    }
}

function SenseStack::release(%script)
{
    if(%script == $SenseStack::Stack[$SenseStack::StackSize, script])
    {
        $SenseStack::StackSize--;
        while($SenseStack::Stack[$SenseStack::StackSize, sense] < 0 && $SenseStack::StackSize > 0)
        {$SenseStack::StackSize--;}
        if($SenseStack::StackSize > 0)
            SenseStack::_setSense($SenseStack::Stack[$SenseStack::StackSize, sense]);
        else
            SenseStack::_setSense($NewPrefs::baseSensitivity);
    }
    else
    {
        %found = SenseStack::findInStack(%script);
        if(%found > 0)
            $SenseStack::Stack[%found, sense] = -1;
    }
}

function SenseStack::findInStack(%script)
{
    %found = 0;
    for(%i = 0; %i < $SenseStack::StackSize; %i++)
    {
        if($SenseStack::Stack[%i+1, script] == %script)
        {
            %found = %i+1;
            %i = $SenseStack::StackSize;
        }
    }
    return %found;
}

function SenseStack::_setSense(%sensitivity)
{
    editActionMap("playMap.sae");
    
    if (String::ICompare(Control::getValue(IDCTG_OPTS_CFG_MOUSE_X_FLIP), "TRUE") == 0)
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %sensitivity);
    else
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);

    if (String::ICompare(Control::getValue(IDCTG_OPTS_CFG_MOUSE_Y_FLIP), "TRUE") == 0)
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %sensitivity);
    else
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sensitivity);
}

function SenseStack::onExit()
{
    SenseStack::_setSense($NewPrefs::baseSensitivity);
}
Event::Attach(eventExit, SenseStack::onExit);

function OptionsMovement::updateMouse()
{
    //calculate the sensitivity
    %percentage = Control::getValue(IDCTG_OPTS_CFG_MOUSE_SENSITIVE);
    %sensitivity = $minMouseSensitivity + (%percentage * ($maxMouseSensitivity - $minMouseSensitivity));
    $NewPrefs::baseSensitivity = %sensitivity;
    SenseStack::_setSense(%sensitivity);
}
