//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | flag_response.cs
// AUTHOR       | |HH|Crunchy (Jonathan Slark)  
// AUTHOR EMAIL | 
// VERSION      | 1.2
// RELEASE DATE | 
// REQUIREMENTS | 
// DESCRIPTION  | Flag events
// DESCRIPTION  | This file has been modified to support oglmode.cs
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------

// -- Automatic Flag responses -- v1.2 -----------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
//
// Sends a message to your team when you have the flag and an optional global message when you cap. The
// two messages are in the first two functions, adjust to taste.  The message that you have got the
// enemey flag is only sent out after a certain amount of time and if in that time it wasn't dropped or
// capped.  If like me you tend to miss flag messages the script can center print them for you.
//
// The cap message is chosen randomly from the list of cap messages in the header below, personalize 
// these for yourself!  Don't forget to update number of messages variable.
//
// -- Preferences --
//
// You can change the delay of announcing when you have the flag by the following line:
$CrunchyPref::FlagResponseWait = 5;
//
// To get center printed messages on important flag events set the following preference to true.
// $CrunchyPref::CenterPrintFlag = true;
//
// To adjust the length of time the center print stays on for, set this:
// $CrunchyPref::CenterPrintLen = 5;
//
// If you want to announce that you capped then set:
// $CrunchyPref::CapResponse = true;
//
// You can adjust the time delay in sending a message when you cap:
// $CrunchyPref::CapResponseWait = 2;
// This delay is to avoid the response clashing with the flag cap sound which takes about 2 seconds.
//-------------------------------------------------------------------------
// 04/03/99 Vacas_SixStringz - Added support for OGLMode and code for ATF
//-------------------------------------------------------------------------
//
// -- Header --
//

Include("presto\\Events.cs");
Include("Presto\\TeamTrak.cs");
Include("presto\\Say.cs");

Event::Attach(eventFlagTaken, Auto::FlagTaken, AutoFlagTaken);
Event::Attach(eventFlagCaptured, Auto::FlagCaptured, AutoFlagCaptured);
Event::Attach(eventFlagDropped, Auto::FlagDropped, AutoFlagDropped);

// Default preferences
if($CrunchyPref::FlagResponseWait=="")	$CrunchyPref::FlagResponseWait = 4;
if($CrunchyPref::CenterPrintFlag=="")	$CrunchyPref::CenterPrintFlag = true;
if($CrunchyPref::CenterPrintLen=="")	$CrunchyPref::CenterPrintLen = 5;
if($CrunchyPref::CapResponse=="")		$CrunchyPref::CapResponse = true;
if($CrunchyPref::CapResponseWait=="")	$CrunchyPref::CapResponseWait = 2;

$Auto::CapMsgNum = 3;	// Number of cap messages.
$Auto::CapMsg[0] = "Yeah!~wcheer1";
$Auto::CapMsg[1] = "Woohoo!!~wcheer2";
$Auto::CapMsg[2] = "All right!~wcheer3";

//
// -- Begin code --
//

// Triggered to announce you have flag
function Auto::AnnounceHave()
{
	if(!$Auto::FlagReset)
		Say::Team(flagHave, "I have the enemy flag.");
}

// Triggered to announce you have capped!
function Auto::AnnounceCap(%msg)
{
	if(%msg == "")
		%msg = floor(getRandom() * $Auto::CapMsgNum);
//FOLLOWING LINE CHECKS FOR TOURNAMENT MODE AND DISSABLES CAPMSG IF TRUE
	if(!$SixPref::OGLMode)                        
        say(0, $Auto::CapMsg[%msg]);
}

function Auto::FlagTaken(%teamNum, %client)
{
   if(%client == getManagerID())
   {
      $Auto::FlagReset = false;
      schedule("Auto::AnnounceHave();",$CrunchyPref::FlagResponseWait);
   }
   else if($CrunchyPref::CenterPrintFlag)
   {
      if(%teamNum == Team::Friendly())
      { 
         if (!$SixPref::ATFE)
            remoteBP(2048,"<jc><f0>" @ Client::getName(%client) @ " took your flag!", $CrunchyPref::CenterPrintLen==5);
      }
      else
      {
         if (!$SixPref::ATF)
            remoteBP(2048,"<jc><f1>" @ Client::getName(%client) @ " took the enemy flag!", $CrunchyPref::CenterPrintLen==5);
      }
   }
}


function Auto::FlagCaptured(%teamNum, %client)
{
	if(%client == getManagerID() && $CrunchyPref::CapResponse) // Optional cap announce
		schedule("Auto::AnnounceCap();",$CrunchyPref::CapResponseWait);

	if(%teamNum == Team::Enemy())
		$Auto::FlagReset = true; // If the enemey flag was capped, don't anounce you have it :)
}

function Auto::FlagDropped(%teamNum, %client)
{
	if(%client != getManagerID() && $CrunchyPref::CenterPrintFlag)
	{
		if(%teamNum == Team::Friendly())
			remoteBP(2048,"<jc><f0>Your flag was dropped in the field!",
				   $CrunchyPref::CenterPrintLen==5);
		else
			remoteBP(2048,"<jc><f1>The enemies flag was dropped in the field!",
				   $CrunchyPref::CenterPrintLen==5);
	}

	if(%teamNum == Team::Enemy())
		$Auto::FlagReset = true; // If the enemey flag was dropped, don't anounce you have it :)
}
