//
// StopwatchHUD - Version 0.1
//
// NOTE: This script requires either Presto Pack or Writer's Script pack to work
// This is a quick and dirty Stopwatch HUD.  It could be used to allow a team to coordinate attacks based on time.

$SW::x = "%88";  // X coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
$SW::y = "%0";   // Y coordinate of HUD: can be either percentage of current screen resolution or specific pixel coordinate
$SW::width = 52;  // Width of HUD in pixels
$SW::height = 18; // Height of HUD in pixels
$SW::zero = 10;   // Time in seconds before counter starts.
$SW::end = 60;    // Time clock will run: Use increments of 6 seconds
$SW::personal = 1; // Sets Stopwatch as a Personal or Public "0 = Personal" "1 = Public"
$SW::countdown = True; //Direction of count, True = down, False = Up
$SW::cntdown = $SW::countdown; // DO NOT CHANGE

// DO NOT TOUCH
// Used for resolution change detection

$oldfullscreen = $pref::VideoFullScreen;
$oldresolution = $pref::VideoFullScreenRes;

function SW::togglemode(){
  $SW::cntdown = $SW::countdown;	
  $SW::personal++;
  if($SW::personal >= 2){
  $SW::personal = 0;
  $SW::cntdown = false;
  }
}

// Function to create HUD
function stopwatch::HUDcreate() {
	stopwatch::evalx();
	stopwatch::evaly();
	$SW::Hud1 = newObject("SW_Frame", FearGui::FearGuiMenu, $SW::x1, $SW::y1, $SW::width, $SW::height);
	$SW::Hud2 = newObject("Stop_Watch", FearGuiFormattedText, $SW::x1 + 4, $SW::y1, $SW::width - 2, $SW::height - 2);
	addToSet(PlayGui, $SW::Hud1);
	addToSet(PlayGui, $SW::Hud2);
	Control::setValue("Stop_Watch"," 00:00");
	if($stopwatch::zero != "")
	stopwatch::update();	
}	
	
// Function to update HUD value
function stopwatch::HUDupdate() {
    Control::setValue("Stop_Watch", $stopwatch::string);
}

// Function to return the X coordinate for HUD placement  
function stopwatch::evalx() {
	if (String::getSubStr($SW::X, 0, 1) == "%"){
	%num = String::getSubStr($SW::X, 1, 4);
	%x = floor((getresolution::X()/100) * %num);
	if(%x >= (getresolution::X() - $SW::width)){
	$SW::x1 = getresolution::X() - $SW::width;
	}
	else
	$SW::x1 = %x;
	return;
	}
	else
	return;
}	

// Function to return the Y coordinate for HUD placement  
function stopwatch::evaly() {
    if (String::getSubStr($SW::y, 0, 1) == "%"){
	%num = String::getSubStr($SW::y, 1, 4);
	%y = floor((getresolution::y()/100) * %num);
	if(%y >= (getresolution::Y() - $SW::height)){
	$SW::y1 = getresolution::Y() - $SW::height;
	}
	else
	$SW::y1 = %y;
    return;
    }
    else
    return;
}    

// Function used to form the time string, and also call for the Resolution
// Change Detection. 
function stopwatch::update(%break){
   if(%break == -999)
   return;
   if($stopwatch::zero > getSimTime())	
   %time = $stopwatch::zero - getSimTime();
   else {
   if($SW::cntdown)
   %time = $stopwatch::end - getSimTime();
   else
   %time = getSimTime() - $stopwatch::zero;
   }
   if(getSimTime() >= $stopwatch::end + 1)
     return;
   %minutes = Time::getMinutes(%time);
   %seconds = Time::getSeconds(%time);
   if(%minutes < 10)
      %minutes = "0" @ %minutes;
   if(%seconds < 10)
      %seconds = "0" @ %seconds;
   $stopwatch::string = " " @ %minutes @ ":" @ %seconds @ "";
   schedule("stopwatch::update();", 1);
   ResChangeDet();
   stopwatch::HUDupdate();
 }

// Function to update the HUD with the current time
function stopwatch::HUDupdate() {
    Control::setValue("Stop_Watch", $stopwatch::string);
}
 
// Function called when PlayGui is loaded.  Creates the HUD on game start.
function stopwatch::load(%gui) {
	if(%gui == "playGui"){
	  stopwatch::HUDcreate();
	 return;
  }
}

// Function called when PlayGui is closed.  Deletes the HUD when you exit the game.
function stopwatch::close(%gui) {
	if(%gui == "playGui"){
	stopwatch::update(-999);
	deleteobject($SW::Hud1);
	deleteobject($SW::Hud2);
	}
}

// This function checks to see if the screen resolution has changed.  If it has it will 
// redraw the HUD in the correct position.
function ResChangeDet(){
	$pref::VideoFullScreen = isFullScreenMode(MainWindow);
	if(($oldfullscreen != $pref::VideoFullScreen) || ($oldresolution != $pref::VideoFullScreenRes)){
		$oldfullscreen = $pref::VideoFullScreen;
		$oldresolution = $pref::VideoFullScreenRes;
		deleteobject($SW::Hud1);
		deleteobject($SW::Hud2);
		stopwatch::HUDcreate();		
	}
}

// This function returns the X value of the current resolution.  
// There are some problems with this in Window mode but in full screen
// all resolutions (Glide, OpenGL, and software modes) should be supported
// Basically anything down to a value of 251 for X or up to 2499 for X 

function getresolution::X(){
$pref::VideoFullScreen = isFullScreenMode(MainWindow);	
 if(!$pref::VideoFullScreen) {
 %res = "640x480";
 }
else {	
 %res = $pref::VideoFullScreenRes;
}
if((String::getSubStr(%res, 0, 3)) <= 250){
   %w = String::getSubStr(%res, 0, 4);
}
else
 %w = String::getSubStr(%res, 0, 3);	
 %num = %w-1;
 return %num;
}

// This function returns the Y value of the current resolution.  
// There are some problems with this in Window mode but in full screen
// all resolutions (Glide, OpenGL, and software modes) should be supported
// Basically if the X value is supported in getresolution::X() the correct
// Y value will be returned.

function getresolution::Y(){
$pref::VideoFullScreen = isFullScreenMode(MainWindow);	
 if(!$pref::VideoFullScreen) {
 %res = "640x480";
 }
else {	
 %res = $pref::VideoFullScreenRes;
}
if((String::getSubStr(%res, 0, 3)) <= 250){
 if((String::getSubStr(%res, 5, 4)) >= 1024)	
 %w = String::getSubStr(%res, 5, 4);
 else
 %w = String::getSubStr(%res, 5, 3);
}
 else{	
 %w = String::getSubStr(%res, 4, 3);
 }
 %num = %w-1;
  return %num;
}


// Function used to start the Stopwatch when a Sync message is received

function stopwatch::OnClientMessage(%client, %msg) {
  if($SW::personal == 0){
   return;
   }	
  %firstword = getWord(%msg, 0);
  if(%firstword == "syncwatch"){
    $stopwatch::zero = getWord(%msg, 1);
    $stopwatch::end = getWord(%msg, 2);
    %zero = $stopwatch::zero - getsimtime();
    %end = $stopwatch::end - $stopwatch::zero;
    %x = String::findSubStr(%msg, ":");
    %msg2 = String::getSubStr(%msg, %x + 1 , 999999999);
//    Client::centerPrint("<jc>Stopwatch timer set for " @ (%end / 60) + 0.000001 @" minutes\nTime sync will occur in " @ %zero @ " seconds", 1);
    Client::centerPrint("<jc>" @ %msg2, 0);
    schedule("Client::centerPrint(\"\", 0);",3);
    stopwatch::update();
  return mute;  
  }
  return;	
}

// Function to send Sync message to your team
function stopwatch::sendsync(%zero1,%end1){
%zero = getsimtime() + %zero1;
%end = %zero + %end1;
schedule("say(1, \"syncwatch " @ %zero @ " " @ %end @ " \");", 3);
}

// Function to increase Sync Delay by 2 seconds
function stopwatch::zplus(%x){
	
if($SW::personal == 0){
 $stopwatch::zero = getSimTime();
 $stopwatch::end = $stopwatch::zero + 90000;
 stopwatch::update();
return;
}

   
if(%x == "plus"){	
	%k = $SW::zero;
	$SW::zero = %k + 2;
}
else {
	%k = $SW::zero;
	$SW::zero = %k - 2;
}	
Client::centerPrint("<jc>Stopwatch Sync delay set for " @ $SW::zero @" seconds", 1);
schedule("Client::centerPrint(\"\", 1);",3);
}

// Function to increase counter time
function stopwatch::eplus(%x){
	
if($SW::personal == 0){
 $stopwatch::end = getSimTime();
 return;
}

if(%x == "plus"){
	%k = $SW::end;	
	$SW::end = %k + 6;
}
else {
	%k = $SW::end;
	$SW::end = %k - 6;
}
Client::centerPrint("<jc>Stopwatch timer set for " @ ($SW::end / 60) + 0.000001 @" minutes", 1);
schedule("Client::centerPrint(\"\", 1);",3);
}

// Function to overide normal Say function.
function say(%channel, %message)
{
%flag = String::getSubStr(%message, 0, 1);
if(%flag == "!"){
  SW::preparse(%channel,%message);
 }
else {
    remoteEval(2048, say, %channel, %message);
   }
}


// Special function to Parse messages before they are sent
function SW::preparse(%channel,%message){
  if(getword(%message,0) == "!sw"){
 %msg1 = "syncwatch ";
 %delay0=getword(%message,1);
 %timer0=getword(%message,2);
 %x = String::findSubStr(%delay0, ":");
 %y = String::findSubStr(%timer0, ":");
 %delay1 = String::getSubStr(%delay0, 0, %x);
 %delay2 = String::getSubStr(%delay0, %x + 1, 2);
 %timer1 = String::getSubStr(%timer0, 0, %y);
 %timer2 = String::getSubStr(%timer0, %y + 1, 2);
 %delay = (%delay1 * 60) + %delay2; 	
 %timer = (%timer1 * 60) + %timer2;
 %msg2 = getsimtime() + %delay;
 %msg3 = %msg2 + %timer;
 %z = getword(%message,3);
 %z2 = String::findSubStr(%message, %z);
 %msg4 = String::getSubStr(%message, %z2, 999999999);
 %message2 =%msg1 @ " " @ %msg2 @ " " @ %msg3 @ " :" @ %msg4;
 remoteEval(2048, say, %channel, %message2);
  }
}

 
Event::Attach(eventGuiOpen, stopwatch::load);
Event::Attach(eventGuiClose, stopwatch::close);
Event::Attach(eventClientMessage, stopwatch::OnClientMessage);
