// ---------------------------------------------------------------------------
// am_deploy.cs -- Version 1.6 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// Inspired by DeployAnnounce.cs by |HH|Crunchy (Jonathan Slark)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\am_deploy.cs", "1.6", "Lorne Laliberte", "- May 22, 1999 - notify team when deploying items - www.planetstarsiege.com/lorne/");

include("writer\\ladder.cs");
include("writer\\flood.cs");
include("writer\\inventory_table.cs");
include("writer\\station_events.cs");

// Include Presto's Chores.cs (for the Job::Do() function) only if necessary
if( ($PrestoPref::JobMenu != "") && ($PrestoPref::JobMenu != "false") )
    include("presto\\Chores.cs");


//
// MUTING:
//
// Set this to true if you don't want to see the white "<item> deployed" messages
$AutoMessage::Mute::Deployed = true;

// Length of "flood protection" time before you announce you're carrying the same thing
$AutoMessage::DeployFloodTime = 120;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


//
// Automatically notify your teammates when you set out to deploy an item,
// unless you already set out to deploy that kind of item within the last
// 2 minutes.  Also notify your teammates whenever you deploy an item.
//
// Updates your job status for anyone using Presto's TeamHUD, even if you
// aren't using it yourself.
//
if( ($PrestoPref::JobMenu != "") && ($PrestoPref::JobMenu != "false") && included("presto\\Chores.cs") )
{
    //
    // Set up functions to work with Presto's TeamHUD
    //

    function AutoMessage::CarryingDeployable()
    {
        if(getMountedItem(1) == $Inv::Turret)
        {
			if(Flood::Protect(deploying_turret, $AutoMessage::DeployFloodTime))
                Job::Do("Deploying Turrets", "iam-depl-dtur");
        }
        else if(getMountedItem(1) == $Inv::Inventory_Station)
        {
			if(Flood::Protect(deploying_inventory, $AutoMessage::DeployFloodTime))
                Job::Do("Carrying an Inventory Station", "iam-depl-dinv");
        }
        else if(getMountedItem(1) == $Inv::Ammo_Station)
        {
			if(Flood::Protect(deploying_ammo, $AutoMessage::DeployFloodTime))
				Job::Do("Carrying an Ammo Station","iam-depl-dammo");
        }
        else if(getMountedItem(1) == $Inv::Motion_Sensor)
        {
			if(Flood::Protect(deploying_sensor, $AutoMessage::DeployFloodTime))
				Job::Do("Deploying Sensors","iam-depl-dsen");
        }
        else if(getMountedItem(1) == $Inv::Pulse_Sensor)
        {
			if(Flood::Protect(deploying_sensor, $AutoMessage::DeployFloodTime))
				Job::Do("Deploying Sensors","iam-depl-dsen");
        }
        else if(getMountedItem(1) == $Inv::Sensor_Jammer)
        {
			if(Flood::Protect(deploying_jammer, $AutoMessage::DeployFloodTime))
				Job::Do("Deploying Jammers","iam-depl-djam");
        }
        else if(getMountedItem(1) == $Inv::Camera)
        {
			if(Flood::Protect(deploying_camera, $AutoMessage::DeployFloodTime))
				Job::Do("Deploying Cameras","iam-depl-dcam");
        }
        return;
    }
    Event::Attach(eventExitStation, AutoMessage::CarryingDeployable);

    function AutoMessage::Deploy(%msg)
    {
        if(String::findSubStr(%msg, "deployed") != -1)
        {
    		// Announce job done if deploying station
    		if(String::findSubStr(%msg, "Inventory Station") != -1)
    			Job::Do("Inventory Station deployed", "fin-depl-dinv");
    		else if(String::findSubStr(%msg, "Ammo Station") != -1)
    			Job::Do("Ammo Station deployed", "fin-depl-dammo");
            else // not deploying a station
                say(1, %msg); // should we do a Job::Do(%msg, "iam-wait") here instead?

            if($AutoMessage::Mute::Deployed)
                return truemute;

            return true;
        }
        return false;
    }
    Event::Attach(ladderClientMessage, AutoMessage::Deploy);
}
else
{
    //
    // Set up functions to work without Presto's TeamHUD in the player's config
    // but still send the job info for other players who are using TeamHUD
    //

    function AutoMessage::CarryingDeployable()
    {
        if(getMountedItem(1) == $Inv::Turret)
        {
			if(Flood::Protect(deploying_turret, $AutoMessage::DeployFloodTime))
                say(1, "Deploying Turrets~job:iam-depl-dtur");
        }
        else if(getMountedItem(1) == $Inv::Inventory_Station)
        {
			if(Flood::Protect(deploying_inventory, $AutoMessage::DeployFloodTime))
                say(1, "Carrying an Inventory Station~job:iam-depl-dinv");
        }
        else if(getMountedItem(1) == $Inv::Ammo_Station)
        {
			if(Flood::Protect(deploying_ammo, $AutoMessage::DeployFloodTime))
				say(1, "Carrying an Ammo Station~job:iam-depl-dammo");
        }
        else if(getMountedItem(1) == $Inv::Motion_Sensor)
        {
			if(Flood::Protect(deploying_sensor, $AutoMessage::DeployFloodTime))
				say(1, "Deploying Sensors~job:iam-depl-dsen");
        }
        else if(getMountedItem(1) == $Inv::Pulse_Sensor)
        {
			if(Flood::Protect(deploying_sensor, $AutoMessage::DeployFloodTime))
				say(1, "Deploying Sensors~job:iam-depl-dsen");
        }
        else if(getMountedItem(1) == $Inv::Sensor_Jammer)
        {
			if(Flood::Protect(deploying_jammer, $AutoMessage::DeployFloodTime))
				say(1, "Deploying Jammers~job:iam-depl-djam");
        }
        else if(getMountedItem(1) == $Inv::Camera)
        {
			if(Flood::Protect(deploying_camera, $AutoMessage::DeployFloodTime))
				say(1, "Deploying Cameras~job:iam-depl-dcam");
        }
        return;
    }
    Event::Attach(eventExitStation, AutoMessage::CarryingDeployable);
    
    function AutoMessage::Deploy(%msg)
    {
        if(String::findSubStr(%msg, "deployed") != -1)
        {
    		// Announce job done if deploying station
    		if(String::findSubStr(%msg, "Inventory Station") != -1)
    			say(1, "Inventory Station deployed~job:fin-depl-dinv");
    		else if(String::findSubStr(%msg, "Ammo Station") != -1)
    			say(1, "Ammo Station deployed~job:fin-depl-dammo");
            else // not deploying a station
                say(1, %msg);

            if($AutoMessage::Mute::Deployed)
                return truemute;

            return true;
        }
        return false;
    }
    Event::Attach(ladderClientMessage, AutoMessage::Deploy);
}
