// ---------------------------------------------------------------------------
// ammo_check.cs -- Version 1.16 -- May 14, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// This script includes material from other scripts or is based upon an
// existing script by another author.
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\ammo_check.cs", "1.16", "Lorne Laliberte", "- May 14, 1999 - switch weapon if fired when empty - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\fire.cs");

//
// Automatically switch weapons if you try to fire without one :)
//   
function AmmoCheck::onFirePressed(%weapon)
{
    if(%weapon == -1) // no weapon in hand?  Not for long :)
    {
        // This works for all but the targeting laser and the
        // ELF gun...I could add my own handler for them but
        // is it worth it?
        nextWeapon();
    }
    return;
}
Event::Attach(eventFirePressed, AmmoCheck::onFirePressed);


//
// Automatically switch weapons if you try to fire with no ammo
//
function AmmoCheck::onNoAmmo(%weapon, %ammo)
{
    nextWeapon();
    return;
}
Event::Attach(eventNoAmmo, AmmoCheck::onNoAmmo);
