// ---------------------------------------------------------------------------
// custom_weapons.cs -- Version 3.2 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\custom_weapons.cs", "3.2", "Lorne Laliberte", "- May 22, 1999 - weapon selection keys - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\inventory_table.cs");


// Set this to true if you want to use the original Tribes config
// Note that you will have to delete Tribes\config\custom_weapons_base.cs
// (if it exists) before the original Tribes setup will be used.

// But you really should try my config, it makes accessing all the weapons
// a lot faster/easier. :)

$WeaponKey::UseOriginalTribesConfig = true;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


function WeaponKey::Init()
{
    $WeaponKey::SavefileName = "custom_weapons_";

    %i = 0;
    %prevchar = "";
    while( (%char = String::getSubStr($ServerMod, %i, 1)) != "" )
    {
        if(%prevchar != " ")
        {
            if(%char == " ")
                %char = "_";
                
            $WeaponKey::SavefileName = $WeaponKey::SavefileName @ %char;
        }
        %i++;
    }

    $WeaponKey::SavefileName = $WeaponKey::SavefileName @ ".cs";

    if(!exec($WeaponKey::SavefileName))
    {
        if($WeaponKey::UseOriginalTribesConfig)
        {
            // Set up defaults -- Original Tribes config
        
            $WeaponKey::weapon[1,0] = $Inv::Blaster;
            $WeaponKey::weapon[1,1] = "";
            $WeaponKey::weapon[1,2] = "";
            $WeaponKey::weapon[1,3] = "";
            
            $WeaponKey::weapon[2,0] = $Inv::Plasma_Gun;
            $WeaponKey::weapon[2,1] = "";
            $WeaponKey::weapon[2,2] = "";
            $WeaponKey::weapon[2,3] = "";
            
            $WeaponKey::weapon[3,0] = $Inv::Chaingun;
            $WeaponKey::weapon[3,1] = "";
            $WeaponKey::weapon[3,2] = "";
            $WeaponKey::weapon[3,3] = "";
            
            $WeaponKey::weapon[4,0] = $Inv::Disc_Launcher;
            $WeaponKey::weapon[4,1] = "";
            $WeaponKey::weapon[4,2] = "";
            $WeaponKey::weapon[4,3] = "";
            
            $WeaponKey::weapon[5,0] = $Inv::Grenade_Launcher;
            $WeaponKey::weapon[5,1] = "";
            $WeaponKey::weapon[5,2] = "";
            $WeaponKey::weapon[5,3] = "";
            
            $WeaponKey::weapon[6,0] = $Inv::Laser_Rifle;
            $WeaponKey::weapon[6,1] = "";
            $WeaponKey::weapon[6,2] = "";
            $WeaponKey::weapon[6,3] = "";
            
            $WeaponKey::weapon[7,0] = $Inv::ELF_Gun;
            $WeaponKey::weapon[7,1] = "";
            $WeaponKey::weapon[7,2] = "";
            $WeaponKey::weapon[7,3] = "";
            
            $WeaponKey::weapon[8,0] = $Inv::Mortar;
            $WeaponKey::weapon[8,1] = "";
            $WeaponKey::weapon[8,2] = "";
            $WeaponKey::weapon[8,3] = "";
            
            $WeaponKey::weapon[9,0] = $Inv::Targeting_Laser;
            $WeaponKey::weapon[9,1] = "";
            $WeaponKey::weapon[9,2] = "";
            $WeaponKey::weapon[9,3] = "";
            
            $WeaponKey::weapon[0,0] = "";
            $WeaponKey::weapon[0,1] = "";
            $WeaponKey::weapon[0,2] = "";
            $WeaponKey::weapon[0,3] = "";
        }
        else
        {
            // Set up defaults -- Writer's config :)
           
            $WeaponKey::weapon[1,0] = $Inv::Laser_Rifle;
            $WeaponKey::weapon[1,1] = $Inv::Mortar;
            $WeaponKey::weapon[1,2] = $Inv::Blaster;
            $WeaponKey::weapon[1,3] = "";
            
            $WeaponKey::weapon[2,0] = $Inv::Plasma_Gun;
            $WeaponKey::weapon[2,1] = "";
            $WeaponKey::weapon[2,2] = $Inv::Blaster;
            $WeaponKey::weapon[2,3] = "";
            
            $WeaponKey::weapon[3,0] = $Inv::Chaingun;
            $WeaponKey::weapon[3,1] = "";
            $WeaponKey::weapon[3,2] = $Inv::ELF_gun;
            $WeaponKey::weapon[3,3] = "";
            
            $WeaponKey::weapon[4,0] = $Inv::Disc_Launcher;
            $WeaponKey::weapon[4,1] = "";
            $WeaponKey::weapon[4,2] = "";
            $WeaponKey::weapon[4,3] = "";
            
            $WeaponKey::weapon[5,0] = $Inv::Grenade_Launcher;
            $WeaponKey::weapon[5,1] = "";
            $WeaponKey::weapon[5,2] = $Inv::Targeting_Laser;
            $WeaponKey::weapon[5,3] = "";
            
            $WeaponKey::weapon[6,0] = "";
            $WeaponKey::weapon[6,1] = "";
            $WeaponKey::weapon[6,2] = "";
            $WeaponKey::weapon[6,3] = "";
            
            $WeaponKey::weapon[7,0] = "";
            $WeaponKey::weapon[7,1] = "";
            $WeaponKey::weapon[7,2] = "";
            $WeaponKey::weapon[7,3] = "";
            
            $WeaponKey::weapon[8,0] = "";
            $WeaponKey::weapon[8,1] = "";
            $WeaponKey::weapon[8,2] = "";
            $WeaponKey::weapon[8,3] = "";
            
            $WeaponKey::weapon[9,0] = "";
            $WeaponKey::weapon[9,1] = "";
            $WeaponKey::weapon[9,2] = "";
            $WeaponKey::weapon[9,3] = "";
            
            $WeaponKey::weapon[0,0] = "";
            $WeaponKey::weapon[0,1] = "";
            $WeaponKey::weapon[0,2] = "";
            $WeaponKey::weapon[0,3] = "";
        }
        WeaponKey::saveSettings();
    }
}
Event::Attach(eventInventoryTableReady, "WeaponKey::Init();");


function WeaponKey::saveSettings()
{
    File::delete("config\\" @ $WeaponKey::SavefileName);
    
    export("$WeaponKey::weapon*", "config\\" @ $WeaponKey::SavefileName, false);
    echo("config\\" @ $WeaponKey::SavefileName @ " file saved!");
}


//
// Assign weapon to single or double press of given key
//
function WeaponKey::assign(%key)
{
    if($WeaponKey::double_typed[%key])
    {
        $WeaponKey::weapon[%key, 2] = getMountedItem(0);
        $WeaponKey::weapon[%key, 0] = $WeaponKey::temp[%key, 0];
    }
    else
    {
        $WeaponKey::temp[%key, 0] = $WeaponKey::weapon[%key, 0];
        $WeaponKey::weapon[%key, 0] = getMountedItem(0);
    }
	%text = "<f0><L5>Weapon Key	<f2>" @ %key @ "<f0>  -		<f1> SINGLE<f0>	PRESS						-  <f1>" @ $Inv::Name[$WeaponKey::weapon[%key, 0]]
	    @ "\n<f0><L5>Weapon Key	<f2>" @ %key @ "<f0>  -		<f1>DOUBLE<f0>	PRESS						-  <f1>" @ $Inv::Name[$WeaponKey::weapon[%key, 2]] @"<f0>";

    remoteBP(2048, %text, 5);

    WeaponKey::saveSettings();
}


//
// Assign alternate (backup) weapon for single or double press of given key
//
function WeaponKey::assignAlternate(%key)
{
    if($WeaponKey::double_typed[%key])
    {
        $WeaponKey::weapon[%key, 3] = getMountedItem(0);
        $WeaponKey::weapon[%key, 1] = $WeaponKey::temp[%key, 1];
    }
    else
    {
        $WeaponKey::temp[%key, 1] = $WeaponKey::weapon[%key, 1];
        $WeaponKey::weapon[%key, 1] = getMountedItem(0);
    }
	%text = "<f0><L5>Weapon Key	<f2>" @ %key @ "<f0>  -		<f1> SINGLE<f0>	PRESS <f0>BACKUP<f0> 		-  <f1>" @ $Inv::Name[$WeaponKey::weapon[%key, 1]]
	    @ "\n<f0><L5>Weapon Key	<f2>" @ %key @ "<f0>  -		<f1>DOUBLE<f0>	PRESS <f0>BACKUP<f0> 		-  <f1>" @ $Inv::Name[$WeaponKey::weapon[%key, 3]] @"<f0>";

    remoteBP(2048, %text, 5);

    WeaponKey::saveSettings();
}


//
// Switch to the first available of four weapons, starting
// with the first weapon on a single key press, or the third
// weapon on a double key press, in this order:
//
//      SINGLE KEYPRESS:           DOUBLE KEYPRESS
//
//  1   Single Keypress Weapon     Double Keypress Weapon
//  2   Single Keypress Backup     Double Keypress Backup
//  3   Double Keypress Weapon     Single Keypress Weapon
//  4   Double Keypress Backup     Single Keypress Backup
//
function WeaponKey::useWeapon(%key)
{
    // Interrupt a middle mouse button repair if we're doing one
    if($MMB::Repairing)
        MMB::StopRepair();

    %weapon = 0; // check for single keypress weapons by default
    if($WeaponKey::double_typed[%key])
    {
        // Check for double keypress weapons first
        %weapon = 2;
    }
    
    for(%i = 0; %i < 4; %i++)
    {
        if(%weapon > 3)
            %weapon = 0;

        if( getItemCount($Inv::Name[$WeaponKey::weapon[%key, %weapon]]) )
        {
            // We're carrying this weapon

            if(WeaponKey::AmmoCheck($WeaponKey::weapon[%key, %weapon]))
            {
                // Trigger the switch event
                if( (%currentWeapon = getMountedItem(0)) != $WeaponKey::weapon[%key, %weapon] )
                    Event::Trigger(eventWeaponSwitch, $WeaponKey::weapon[%key, %weapon], %currentWeapon);
    
                // Use the weapon
                useItem($WeaponKey::weapon[%key, %weapon]);
    
                break; // exit loop
            }
        }
        %weapon++;
    }
}

//
// Return true if weapon has any ammo left (or doesn't need any)
//
function WeaponKey::AmmoCheck(%weapon)
{
    %ammo = $Inv::Ammo[%weapon];
    return (%ammo == "") || getItemCount(%ammo);
}


//
// Call this on the key break to start the double-type timer
//
function WeaponKey::break(%key)
{
    $WeaponKey::double_typed[%key] = 1;
    schedule("$WeaponKey::double_typed[" @ %key @ "]=0;", 0.3);
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae"); 
    
    bindCommand(keyboard0, make,             "1", TO, "WeaponKey::useWeapon(1);");
    bindCommand(keyboard0, break,            "1", TO, "WeaponKey::break(1);");
    bindCommand(keyboard0, make, r_control,  "1", TO, "WeaponKey::assign(1);");
    bindCommand(keyboard0, break, r_control, "1", TO, "WeaponKey::break(1);");
    bindCommand(keyboard0, make, r_shift,    "1", TO, "WeaponKey::assignAlternate(1);");
    bindCommand(keyboard0, break, r_shift,   "1", TO, "WeaponKey::break(1);");
    
    bindCommand(keyboard0, make,             "2", TO, "WeaponKey::useWeapon(2);");
    bindCommand(keyboard0, break,            "2", TO, "WeaponKey::break(2);");
    bindCommand(keyboard0, make, r_control,  "2", TO, "WeaponKey::assign(2);");
    bindCommand(keyboard0, break, r_control, "2", TO, "WeaponKey::break(2);");
    bindCommand(keyboard0, make, r_shift,    "2", TO, "WeaponKey::assignAlternate(2);");
    bindCommand(keyboard0, break, r_shift,   "2", TO, "WeaponKey::break(2);");
    
    bindCommand(keyboard0, make,             "3", TO, "WeaponKey::useWeapon(3);");
    bindCommand(keyboard0, break,            "3", TO, "WeaponKey::break(3);");
    bindCommand(keyboard0, make, r_control,  "3", TO, "WeaponKey::assign(3);");
    bindCommand(keyboard0, break, r_control, "3", TO, "WeaponKey::break(3);");
    bindCommand(keyboard0, make, r_shift,    "3", TO, "WeaponKey::assignAlternate(3);");
    bindCommand(keyboard0, break, r_shift,   "3", TO, "WeaponKey::break(3);");
    
    bindCommand(keyboard0, make,             "4", TO, "WeaponKey::useWeapon(4);");
    bindCommand(keyboard0, break,            "4", TO, "WeaponKey::break(4);");
    bindCommand(keyboard0, make, r_control,  "4", TO, "WeaponKey::assign(4);");
    bindCommand(keyboard0, break, r_control, "4", TO, "WeaponKey::break(4);");
    bindCommand(keyboard0, make, r_shift,    "4", TO, "WeaponKey::assignAlternate(4);");
    bindCommand(keyboard0, break, r_shift,   "4", TO, "WeaponKey::break(4);");
    
    bindCommand(keyboard0, make,             "5", TO, "WeaponKey::useWeapon(5);");
    bindCommand(keyboard0, break,            "5", TO, "WeaponKey::break(5);");
    bindCommand(keyboard0, make, r_control,  "5", TO, "WeaponKey::assign(5);");
    bindCommand(keyboard0, break, r_control, "5", TO, "WeaponKey::break(5);");
    bindCommand(keyboard0, make, r_shift,    "5", TO, "WeaponKey::assignAlternate(5);");
    bindCommand(keyboard0, break, r_shift,   "5", TO, "WeaponKey::break(5);");
    
    bindCommand(keyboard0, make,             "6", TO, "WeaponKey::useWeapon(6);");
    bindCommand(keyboard0, break,            "6", TO, "WeaponKey::break(6);");
    bindCommand(keyboard0, make, r_control,  "6", TO, "WeaponKey::assign(6);");
    bindCommand(keyboard0, break, r_control, "6", TO, "WeaponKey::break(6);");
    bindCommand(keyboard0, make, r_shift,    "6", TO, "WeaponKey::assignAlternate(6);");
    bindCommand(keyboard0, break, r_shift,   "6", TO, "WeaponKey::break(6);");
    
    bindCommand(keyboard0, make,             "7", TO, "WeaponKey::useWeapon(7);");
    bindCommand(keyboard0, break,            "7", TO, "WeaponKey::break(7);");
    bindCommand(keyboard0, make, r_control,  "7", TO, "WeaponKey::assign(7);");
    bindCommand(keyboard0, break, r_control, "7", TO, "WeaponKey::break(7);");
    bindCommand(keyboard0, make, r_shift,    "7", TO, "WeaponKey::assignAlternate(7);");
    bindCommand(keyboard0, break, r_shift,   "7", TO, "WeaponKey::break(7);");
    
    bindCommand(keyboard0, make,             "8", TO, "WeaponKey::useWeapon(8);");
    bindCommand(keyboard0, break,            "8", TO, "WeaponKey::break(8);");
    bindCommand(keyboard0, make, r_control,  "8", TO, "WeaponKey::assign(8);");
    bindCommand(keyboard0, break, r_control, "8", TO, "WeaponKey::break(8);");
    bindCommand(keyboard0, make, r_shift,    "8", TO, "WeaponKey::assignAlternate(8);");
    bindCommand(keyboard0, break, r_shift,   "8", TO, "WeaponKey::break(8);");
    
    bindCommand(keyboard0, make,             "9", TO, "WeaponKey::useWeapon(9);");
    bindCommand(keyboard0, break,            "9", TO, "WeaponKey::break(9);");
    bindCommand(keyboard0, make, r_control,  "9", TO, "WeaponKey::assign(9);");
    bindCommand(keyboard0, break, r_control, "9", TO, "WeaponKey::break(9);");
    bindCommand(keyboard0, make, r_shift,    "9", TO, "WeaponKey::assignAlternate(9);");
    bindCommand(keyboard0, break, r_shift,   "9", TO, "WeaponKey::break(9);");
    
    bindCommand(keyboard0, make,             "0", TO, "WeaponKey::useWeapon(0);");
    bindCommand(keyboard0, break,            "0", TO, "WeaponKey::break(0);");
    bindCommand(keyboard0, make, r_control,  "0", TO, "WeaponKey::assign(0);");
    bindCommand(keyboard0, break, r_control, "0", TO, "WeaponKey::break(0);");
    bindCommand(keyboard0, make, r_shift,    "0", TO, "WeaponKey::assignAlternate(0);");
    bindCommand(keyboard0, break, r_shift,   "0", TO, "WeaponKey::break(0);");
}
