// ---------------------------------------------------------------------------
// jump.cs -- Version 2.2 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\jump.cs", "2.2", "Lorne Laliberte", "- May 22, 1999 - continuous jumping - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\whatif.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


//
// Hold a key to keep jump, jump, jumping, or
// tap a key to toggle jumping mode on/off
//
function Jump(%on, %taptime)
{
    if(!%taptime)
        %taptime = 0.100;

    if(%on) // Key Pressed
    {
        if(!$Jumping)
        {
            // We aren't jumping yet, so
            // start jumping now

            $Jumping = 1;
            KeepJumping();

            if($TapJumpOn)
            {
                // Set flag to initialize our keytap timer
                $WithinJumpTapTime = 1;

                // Clear flag (stop keytap timer) in %taptime seconds
                schedule("$WithinJumpTapTime=0;", %taptime);
            }
        }
    }
    else // Key Released
    {
        if(!$WithinJumpTapTime)
        {
            // Key was pressed more than %taptime seconds ago

            // Stop Jumping
            $Jumping = 0;
        }
    }
}


//
// Keep jumping while a key is held down
//
function KeepJumping()
{
    // This function will keep calling itself so we need to set or clear
    // a control flag in a separate function -- if you want this to sound
    // technical, "we need external state control." :)

    if($Jumping)
    {
        // This event is going to be called very often, so try to keep the attached
        // functions fast and efficient!

        Event::Trigger(eventJump);

        // Note that returning mute stops the jumping even if the jump key is held down!

        if(Event::Returned(eventJump, mute))
            return;

    	postAction(2048, IDACTION_MOVEUP, -0); // Jump!

    	// Call this function in 0.075 seconds to jump again
    	// so long as $Jumping hasn't been cleared
    	schedule("KeepJumping();",0.075); // interval has to be small to always land with a jump
    }
}


//
// Toggle the "continuous jumping when key is tapped" mode on/off
//
function TapJumpToggle()
{
    remoteBP(2048, "<L5>Tap Jump Mode " @ wif($TapJumpOn = !$TapJumpOn, "ON", "OFF"), 4);
}



// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Keep jumping while a key is held down or the key is tapped
    bindCommand(keyboard0, make, "space", TO, "Jump(1);");
    bindCommand(keyboard0, break, "space", TO, "Jump(0);");

    // Toggle the "continuous jumping when the key is tapped" mode on/off
    bindCommand(keyboard0, make, control, "space", TO, "TapJumpToggle();");
    bindCommand(keyboard0, break, control, "space", TO, "");
}
