// ---------------------------------------------------------------------------
// keep_moving.cs -- Version 1.3 -- May 24, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\keep_moving.cs", "1.3", "Lorne Laliberte", "- May 24, 1999 - keep moving without key held down - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\tap_action.cs");


// Automatically enable Keep Moving mode when in Pilot Mode (requires pilot_mode.cs)
$Writer::EnableKeepMovingOnPilotMode = true;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


// To use different movement keys, change these settings in keys.cs
// DO NOT CHANGE THESE, they are just the defaults!
//
// Default movement keys:
$Keys::[moveforward] = "w";
$Keys::[moveleft] = "a";
$Keys::[moveback] = "s";
$Keys::[moveright] = "d";

$KeepMoving::wasEnabled = 0; // don't want this to start out empty ("")


function KeepMoving::onPilotModeOn()
{
    if($Writer::EnableKeepMovingOnPilotMode && !$KeepMoving::alreadyInPilotMode)
    {
        $KeepMoving::wasEnabled = $KeepMoving::Enabled;
        $KeepMoving::alreadyInPilotMode = true;
        KeepMoving::Toggle(1);
    }

    return;
}
Event::Attach(eventPilotModeOn, "KeepMoving::onPilotModeOn();");


function KeepMoving::onPilotModeOff()
{
    if(!$KeepMoving::wasEnabled)
        KeepMoving::Toggle(0);

    $KeepMoving::alreadyInPilotMode = false;

    return;
}
Event::Attach(eventPilotModeOff, "KeepMoving::onPilotModeOff();");


//
// Toggle continuous movement on key tap for the 4 movement keys
//
function KeepMoving::Toggle(%on)
{

    if(%on == "")
    {
        // Toggle our flag
        $KeepMoving::Enabled = !$KeepMoving::Enabled;
    }
    else if(%on)
    {
        $KeepMoving::Enabled = true;
    }
    else
    {
        $KeepMoving::Enabled = false;
    }

    %text = "<f2>ENABLED<f0>"; // assume enabled; I just want to give %text scope outside the if blocks

    if($KeepMoving::Enabled) // we switched it on
    {
        EditActionMap("playMap.sae");

        // Tap key to keep running forward
        bindCommand(keyboard0, make, $Keys::[moveforward], TO, "tapAction(1, 0.060, IDACTION_MOVEFORWARD, IDACTION_MOVEBACK);");
        bindCommand(keyboard0, break, $Keys::[moveforward], TO, "tapAction(0, 0.060, IDACTION_MOVEFORWARD);");

        // Tap key to keep running left
        bindCommand(keyboard0, make, $Keys::[moveleft], TO, "tapAction(1, 0.060, IDACTION_MOVELEFT, IDACTION_MOVERIGHT);");
        bindCommand(keyboard0, break, $Keys::[moveleft], TO, "tapAction(0, 0.060, IDACTION_MOVELEFT);");

        // Tap key to keep running back
        bindCommand(keyboard0, make, $Keys::[moveback], TO, "tapAction(1, 0.060, IDACTION_MOVEBACK, IDACTION_MOVEFORWARD);");
        bindCommand(keyboard0, break, $Keys::[moveback], TO, "tapAction(0, 0.060, IDACTION_MOVEBACK);");

        // Tap key to keep running right
        bindCommand(keyboard0, make, $Keys::[moveright], TO, "tapAction(1, 0.060, IDACTION_MOVERIGHT, IDACTION_MOVELEFT);");
        bindCommand(keyboard0, break, $Keys::[moveright], TO, "tapAction(0, 0.060, IDACTION_MOVERIGHT);");
    }
    else // we switched it off
    {
        EditActionMap("playMap.sae");

        // Press key to run forward
        bindAction(keyboard0, make, $Keys::[moveforward], TO, IDACTION_MOVEFORWARD, 1.0);
        bindAction(keyboard0, break, $Keys::[moveforward], TO, IDACTION_MOVEFORWARD, 0.0);

        // Press key to run left
        bindAction(keyboard0, make, $Keys::[moveleft], TO, IDACTION_MOVELEFT, 1.0);
        bindAction(keyboard0, break, $Keys::[moveleft], TO, IDACTION_MOVELEFT, 0.0);

        // Press key to run back
        bindAction(keyboard0, make, $Keys::[moveback], TO, IDACTION_MOVEBACK, 1.0);
        bindAction(keyboard0, break, $Keys::[moveback], TO, IDACTION_MOVEBACK, 0.0);

        // Press key to run right
        bindAction(keyboard0, make, $Keys::[moveright], TO, IDACTION_MOVERIGHT, 1.0);
        bindAction(keyboard0, break, $Keys::[moveright], TO, IDACTION_MOVERIGHT, 0.0);

        %text = "<f2>DISABLED<f0>";
    }

	remoteBP(2048, " Keep Moving " @ %text, 4);
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Toggle continuous movement on key tap for the 4 movement keys
    bindCommand(keyboard0, make, alt, "w", TO, "KeepMoving::Toggle();");
    bindCommand(keyboard0, break, alt, "w", TO, "");

    // Press key to run forward
    bindAction(keyboard0, make, $Keys::[moveforward], TO, IDACTION_MOVEFORWARD, 1.0);
    bindAction(keyboard0, break, $Keys::[moveforward], TO, IDACTION_MOVEFORWARD, 0.0);

    // Press key to run left
    bindAction(keyboard0, make, $Keys::[moveleft], TO, IDACTION_MOVELEFT, 1.0);
    bindAction(keyboard0, break, $Keys::[moveleft], TO, IDACTION_MOVELEFT, 0.0);

    // Press key to run back
    bindAction(keyboard0, make, $Keys::[moveback], TO, IDACTION_MOVEBACK, 1.0);
    bindAction(keyboard0, break, $Keys::[moveback], TO, IDACTION_MOVEBACK, 0.0);

    // Press key to run right
    bindAction(keyboard0, make, $Keys::[moveright], TO, IDACTION_MOVERIGHT, 1.0);
    bindAction(keyboard0, break, $Keys::[moveright], TO, IDACTION_MOVERIGHT, 0.0);
}
