// ---------------------------------------------------------------------------
// smooth_zoom.cs -- Version 2.1 -- May 20, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\smooth_zoom.cs", "2.1", "Lorne Laliberte", "- May 21, 1999 - continuous zoom - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
if(include("presto\\schedule.cs") == notfound)
    include("writer\\schedule.cs");


// zoom.cs isn't needed for the smooth zooming feature itself,
// but zoom.cs and smooth_zoom.cs were designed to work well together.

//include("writer\\zoom.cs");


// Set this to your desired "normal" Field Of View setting
$pref::PlayerFov = $SmoothZoom::normal = $SmoothZoom::FOV = 90;


// This is the minimum zoom increment delay...it affects the zoom speed
// You probably don't need or want to change this! :)
$SmoothZoom::minDelay = 0.05;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


// Maximum and minimum FOV
$SmoothZoom::maxFOV = $SmoothZoom::normal;
$SmoothZoom::minFOV = 5;

// The four zoom levels
$SmoothZoom::FOV[0] = 45;
$SmoothZoom::FOV[1] = 18;
$SmoothZoom::FOV[2] = 9;
$SmoothZoom::FOV[3] = 5;


// Reset zoom whenever we join a game
Event::Attach(eventConnected, "$SmoothZoom::FOV = $SmoothZoom::FOV[1];");


function SmoothZoom::onZoomChanged(%zoom)
{
echo("");
echo("SZ::onZoomChanged(" @ %zoom @ ")");
    $SmoothZoom::FOV = $SmoothZoom::FOV[%zoom];
}
Event::Attach(eventZoomChanged, SmoothZoom::onZoomChanged);


function SmoothZoom::onZoomIn(%toZoom, %fromZoom)
{
echo("");
echo("SZ::onZoomIn(" @ %toZoom @ ", " @ %fromZoom @ ")");
echo("FOV = " @ $SmoothZoom::FOV);

    $pref::PlayerFov = $SmoothZoom::normal;

    $SmoothZoom::ZoomIsOn = $Zoom::ZoomWasOn;
    if($SmoothZoom::ZoomWasOn || $SmoothZoom::Zoomed)
    {
        postAction(2048, IDACTION_SNIPER_FOV, 1.0);
    }
    else
    {
        postAction(2048, IDACTION_SNIPER_FOV, 0.0);
    }

    $SmoothZoom::zooming = $SmoothZoom::Zoomed = false;

    if($SmoothZoom::FOV > $SmoothZoom::FOV[%fromZoom])
    {
//        $SmoothZoom::FOV = $SmoothZoom::FOV[%fromZoom];
        Event::Trigger(eventZoomChanged, %fromZoom);
        return mute;
    }
    else
    {
        $SmoothZoom::FOV = $SmoothZoom::FOV[%toZoom];
    }

echo("FOV = " @ $SmoothZoom::FOV);
    return;
}
Event::Attach(eventZoomIn, SmoothZoom::onZoomIn);


function SmoothZoom::onZoomOut(%toZoom, %fromZoom)
{
echo("");
echo("SZ::onZoomOut(" @ %toZoom @ ", " @ %fromZoom @ ")");
echo("FOV = " @ $SmoothZoom::FOV);

    $pref::PlayerFov = $SmoothZoom::normal;

    $SmoothZoom::ZoomIsOn = $Zoom::ZoomWasOn;
    if($SmoothZoom::ZoomWasOn || $SmoothZoom::Zoomed)
    {
        postAction(2048, IDACTION_SNIPER_FOV, 1.0);
    }
    else
    {
        postAction(2048, IDACTION_SNIPER_FOV, 0.0);
    }

    $SmoothZoom::zooming = $SmoothZoom::Zoomed = false;

    if($SmoothZoom::FOV < $SmoothZoom::FOV[%fromZoom])
    {
//        $SmoothZoom::FOV = $SmoothZoom::FOV[%fromZoom];
        Event::Trigger(eventZoomChanged, %fromZoom);
        return mute;
    }
    else
    {
        $SmoothZoom::FOV = $SmoothZoom::FOV[%toZoom];
    }

echo("FOV = " @ $SmoothZoom::FOV);
    return;
}
Event::Attach(eventZoomOut, SmoothZoom::onZoomOut);


//
// Adjust the zoom speed with the zoom level
//
// The adjustments were arrived at through trial and error. :)
//
function SmoothZoom::getDelay(%fov)
{
    %delay = 0.05 + ($SmoothZoom::maxFOV - $SmoothZoom::FOV) / 1000;

    if(%fov > 30)
        %delay *= 0.25;
    else if(%fov > 18)
        %delay *= 0.50;
    else
        %delay *= 0.80;

    return %delay;
}



//
// Zoom in
//
function SmoothZoom::in()
{
echo("");
echo("SZ::in()");
echo("FOV = " @ $SmoothZoom::FOV);

    if($SmoothZoom::zooming)
    {
        if($SmoothZoom::ZoomIsOn || !$SmoothZoom::Zoomed)
        {
            $SmoothZoom::ZoomIsOn = false;
            postAction(2048, IDACTION_SNIPER_FOV, 0.0);
        }
//***
        $SmoothZoom::ZoomWasOn = true;

        $SmoothZoom::Zoomed = true;

        if($SmoothZoom::FOV > $SmoothZoom::minFOV)
            $SmoothZoom::FOV--;

echo("FOV = " @ $SmoothZoom::FOV);

        %zoom = floor( (1/($SmoothZoom::FOV/90)) + 0.5 );
        
        if(%zoom != $SmoothZoom::zoom)
        {
            $SmoothZoom::zoom = %zoom;
            Event::Trigger(eventUpdateXHUD, "", "Zoom: (" @ %zoom @ "x)");
        }

        for(%i = 0; %i < 4; %i++)
        {
            if($SmoothZoom::FOV == $SmoothZoom::FOV[%i])
            {
                if(%i != $Zoom::level)
                    Zoom::set(%i);
                break;
            }
        }

        $pref::PlayerFov = $SmoothZoom::FOV;
        schedule::add("SmoothZoom::in();", SmoothZoom::getDelay($SmoothZoom::FOV), SmoothZoom);
    }
}


//
// Zoom out
//
function SmoothZoom::out()
{
echo("");
echo("SZ::out()");
echo("FOV = " @ $SmoothZoom::FOV);

    if($SmoothZoom::zooming)
    {
        if($SmoothZoom::ZoomIsOn || !$SmoothZoom::Zoomed)
        {
            $SmoothZoom::ZoomIsOn = false;
            postAction(2048, IDACTION_SNIPER_FOV, 0.0);
        }
//***
        $SmoothZoom::ZoomWasOn = true;

        $SmoothZoom::Zoomed = true;

        if($SmoothZoom::FOV < $SmoothZoom::maxFOV)
            $SmoothZoom::FOV++;

echo("FOV = " @ $SmoothZoom::FOV);

        %zoom = floor( (1/($SmoothZoom::FOV/90)) + 0.5 );

        if(%zoom != $SmoothZoom::zoom)
        {
            $SmoothZoom::zoom = %zoom;
            Event::Trigger(eventUpdateXHUD, "", "Zoom: (" @ %zoom @ "x)");
        }

        for(%i = 0; %i < 4; %i++)
        {
            if($SmoothZoom::FOV == $SmoothZoom::FOV[%i])
            {
                if(%i != $Zoom::level)
                    Zoom::set(%i);
                break;
            }
        }

        $pref::PlayerFov = $SmoothZoom::FOV;
        schedule::add("SmoothZoom::out();", SmoothZoom::getDelay($SmoothZoom::FOV), SmoothZoom);
    }
}


function SmoothZoom::onZoomOn(%zoom)
{
echo("");
echo("SZ::onZoomOn(" @ %zoom @")");
echo("FOV = " @ $SmoothZoom::FOV);
    $SmoothZoom::ZoomWasOn = $SmoothZoom::ZoomIsOn = true;
    if($SmoothZoom::FOV != $SmoothZoom::FOV[%zoom])
    {
        postAction(2048, IDACTION_SNIPER_FOV, 0.0);
        $pref::PlayerFov = $SmoothZoom::FOV;
        $SmoothZoom::ZoomIsOn = false;
    }

    $SmoothZoom::ZoomWasOn = $SmoothZoom::ZoomIsOn = true;
}
Event::Attach(eventZoomOn, SmoothZoom::onZoomOn);


function SmoothZoom::onZoomOff()
{
echo("");
echo("SZ::onZoomOff()");
echo("FOV = " @ $SmoothZoom::FOV);

    if($SmoothZoom::ZoomIsOn)
    {
        postAction(2048, IDACTION_SNIPER_FOV, 0.0);
    }

    $pref::PlayerFov = $SmoothZoom::normal;
    $SmoothZoom::ZoomWasOn = $SmoothZoom::ZoomIsOn = $SmoothZoom::Zoomed = false;
}
Event::Attach(eventZoomOff, "SmoothZoom::onZoomOff();");


//
// Zoom in while key held down
//
function SmoothZoom::inKey(%make)
{
    if(%make) // Key Pressed
    {
        // Start zooming in
        $SmoothZoom::zooming = 1;
        SmoothZoom::in();
    }
    else // Key released
    {
        // Stop zooming in
        $SmoothZoom::zooming = 0;
    }
}


//
// Zoom out while key held down
//
function SmoothZoom::outKey(%make)
{
    if(%make) // Key Pressed
    {
        // Start zooming out
        $SmoothZoom::zooming = 1;
        SmoothZoom::out();
    }
    else // Key released
    {
        // Stop zooming out
        $SmoothZoom::zooming = 0;
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Zoom in while key held down
    bindCommand(keyboard0, make, shift, "z", TO, "SmoothZoom::inKey(1);");
    bindCommand(keyboard0, break, shift, "z", TO, "SmoothZoom::inKey(0);");

    // Zoom out while key held down
    bindCommand(keyboard0, make, shift, "x", TO, "SmoothZoom::outKey(1);");
    bindCommand(keyboard0, break, shift, "x", TO, "SmoothZoom::outKey(0);");
}
