// ---------------------------------------------------------------------------
// xHUD.cs -- Version 1.1 -- May 21, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\xHUD.cs", "1.1", "Lorne Laliberte", "- May 21, 1999 - shows current zoom level - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\zoom.cs");


// Set screen coordinates for xHUD
      $xHUD::X = 55%;
      $xHUD::Y = 0;

// Set default colour to use
$xHUD::Colour = 1;

// Set text to show at four zoom levels
$xHUD::ZoomText[0] = "Zoom: 2x";
$xHUD::ZoomText[1] = "Zoom: 5x";
$xHUD::ZoomText[2] = "Zoom: 10x";
$xHUD::ZoomText[3] = "Zoom: 20x";


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


$xHUD::ColourText[0] = "<f0>";
$xHUD::ColourText[1] = "<f1>";
$xHUD::ColourText[2] = "<f2>";


function xHUD::make(%zoomtext)
{
    if(%zoomtext == "")
        %zoomtext = $xHUD::ZoomText[$xHUD::currentZoom];

    if(!$xHUD::disabled)
    {
        if($xHUD::Exists)
            xHUD::Remove();

        $xHUD = newObject("xHUD", FearGuiFormattedText, $xHUD::X - 4, $xHUD::Y + 1, 50, 16);
        addToSet(PlayGui, $xHUD);
        Control::setValue("xHUD", $xHUD::ColourText[$xHUD::Colour] @ %zoomtext);
        $xHUD::exists = true;
    }
}
Event::Attach(eventConnected, "schedule(\"xHUD::make($xHUD::ZoomText1);\", 2);");


// Reset zoom level upon joining a game
Event::Attach(eventConnected, "$xHUD::currentZoom = 1; $xHUD::currentText = $xHUD::ZoomText1;");


function xHUD::nextColour()
{
    $xHUD::Colour++;
    if($xHUD::Colour > 2)
        $xHUD::Colour = 0;

    if(!$xHUD::Exists)
        xHUD::make($xHUD::currentText);
    else
    {
        Control::setValue("xHUD", $xHUD::ColourText[$xHUD::Colour] @ $xHUD::currentText);
    }
}

function xHUD::onUpdateXHUD(%zoom, %zoomtext)
{
    if(%zoomtext != "")
    {
        if(!$xHUD::Exists)
            xHUD::make();

        $xHUD::currentText = %zoomtext;
        Control::setValue("xHUD", $xHUD::ColourText[$xHUD::Colour] @ %zoomtext);
    }
    else
    {
        if( (%zoom < 3) || (%zoom > 0) )
            $xHUD::currentZoom = %zoom;

        %zoomtext = $xHUD::currentText = $xHUD::ZoomText[$xHUD::currentZoom];

        if(!$xHUD::Exists)
            xHUD::make(%zoomtext);
        else
        {
            Control::setValue("xHUD", $xHUD::ColourText[$xHUD::Colour] @ %zoomtext);
        }
    }
}
Event::Attach(eventUpdateXHUD, xHUD::onUpdateXHUD);


function xHUD::onZoomChanged(%zoom)
{
    $xHUD::currentZoom = %zoom;

    %zoomtext = $xHUD::currentText = $xHUD::ZoomText[%zoom];

    if(!$xHUD::Exists)
        xHUD::make(%zoomtext);
    else
    {
        Control::setValue("xHUD", $xHUD::ColourText[$xHUD::Colour] @ %zoomtext);
    }
}
Event::Attach(eventZoomChanged, xHUD::onZoomChanged);


function xHUD::remove()
{
    if($xHUD::exists)
    {
        deleteObject($xHUD);
        $xHUD::exists = false;
    }
}

//
// Remove xHUD before play.gui is saved on exit -- important!
//
Event::Attach(eventExit, "xHUD::remove();");


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Cycle through available colours
    bindCommand(keyboard0, make, alt, "]", TO, "xHUD::nextColour();");
    bindCommand(keyboard0, break, alt, "]", TO, "");
}
