// ---------------------------------------------------------------------------
// zoom.cs -- Version 3.1 -- May 20, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\zoom.cs", "3.1", "Lorne Laliberte", "- May 20, 1999 - zoom functions - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\tap_action.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


// Reset zoom whenever we join a game
Event::Attach(eventConnected, "$Zoom::level = 1;");


//
// Set zoom level...based on Zear's excellent setMag function :)
//
function Zoom::set(%zoom)
{
    if( (%zoom < 0) || (%zoom > 3) )
        return;

    while (%zoom != $Zoom::level)
    {
        postAction(2048, IDACTION_INC_SNIPER_FOV, 1.0);
        $Zoom::level++;
        if($Zoom::level > 3)
            $Zoom::level = 0;
    }
    Event::Trigger(eventZoomChanged, $Zoom::level);
}


//
// Toggle zoom rollover
//
function Zoom::toggleRollover()
{
    if($Zoom::rollover)
        $Zoom::rollover = 0;
    else
        $Zoom::rollover = 1;

    remoteBP(2048, "<L5>Zoom Rollover " @ wif($Zoom::rollover, "ON", "OFF"), 4);
}


//
// Increase zoom level with option to stop at 20x
//
function Zoom::in()
{
    if( $Zoom::level < (3 + $Zoom::rollover) )
    {
        %nextZoom = wif( $Zoom::rollover && (($Zoom::level + 1) > 3), 0, $Zoom::level + 1 );

        Event::Trigger(eventZoomIn, %nextZoom, $Zoom::level);

        if(Event::Returned(eventZoomIn, mute))
            return;

        postAction(2048, IDACTION_INC_SNIPER_FOV, 1.0);

        $Zoom::level++;
        if( $Zoom::rollover && ($Zoom::level > 3) )
            $Zoom::level = 0;

        Event::Trigger(eventZoomChanged, $Zoom::level);
    }
}


//
// Decrease zoom level with option to stop at 2x
//
function Zoom::out()
{
    if( $Zoom::level > (0 - $Zoom::rollover) )
    {
        %nextZoom = wif( $Zoom::rollover && (($Zoom::level - 1) < 0), 3, $Zoom::level - 1 );

        Event::Trigger(eventZoomOut, %nextZoom, $Zoom::level);

        if(Event::Returned(eventZoomOut, mute))
            return;

        postAction(2048, IDACTION_INC_SNIPER_FOV, -1.0);

        $Zoom::level--;
        if( $Zoom::rollover && ($Zoom::level < 0) )
            $Zoom::level = 3;

        Event::Trigger(eventZoomChanged, $Zoom::level);
    }
}


//
// Turn or toggle zoom on
//
function Zoom::onTapActionDoing(%action)
{
echo(%action);
    if(%action == IDACTION_SNIPER_FOV)
    {
        Event::Trigger(eventZoomOn, $Zoom::level);
    }
}
Event::Attach(eventTapActionDoing, Zoom::onTapActionDoing);


//
// Turn zoom off
//
function Zoom::onTapActionStopping(%action)
{
    if(%action == IDACTION_SNIPER_FOV)
    {
        Event::Trigger(eventZoomOff);
    }
}
Event::Attach(eventTapActionStopping, Zoom::onTapActionStopping);


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Tap key to toggle zoom mode on
    bindCommand(keyboard0, make, "e", TO, "tapAction(1, 0.075, IDACTION_SNIPER_FOV);");
    bindCommand(keyboard0, break, "e", TO, "tapAction(0, 0.075, IDACTION_SNIPER_FOV);");

    // Set zoom levels directly
    bindCommand(keyboard0, make, shift, "1", TO, "Zoom::set(0);");
    bindCommand(keyboard0, make, shift, "2", TO, "Zoom::set(1);");
    bindCommand(keyboard0, make, shift, "3", TO, "Zoom::set(2);");
    bindCommand(keyboard0, make, shift, "4", TO, "Zoom::set(3);");

    // Toggle 2x -> 20x and 20x ->2x rollover on and off
    bindCommand(keyboard0, make, control, "z", TO, "Zoom::toggleRollover();");

    // Increase zoom
    bindCommand(keyboard0, make, "z", TO, "Zoom::in();");

    // Decrease zoom
    bindCommand(keyboard0, make, "x", TO, "Zoom::out();");
}
