// First ALARM Script
// By (RSV)MassMedia
// massmedia@bigfoot.com
// To set an alarm press ALT + M
// This REQUIRES Presto + TIMEHUD

Include("presto\\Menu.cs");
Include("presto\\Schedule.cs");
include("time.cs");
include("icqhuddata.cs");


// Change below to whatever

bindCommand(keyboard0, make, alt, "m", TO, "Menu::Display(Alarm);");  // editable

$MassAlarm::Toggle = "False";
$AMin = "";
$ATen = "";
$AHour = "";

Menu::New(Alarm, "Alarm setting");
 Menu::AddMenu(Alarm, "sSET ALARM", SetHour);
 Menu::AddChoice(Alarm, "cCLEAR ALARM", "MassAlarm::Back();");

Menu::New(SetHour, "Please Set an hour");
 Menu::AddChoice(SetHour, "11", "$AHour = \"1\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "22", "$AHour = \"2\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "33", "$AHour = \"3\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "44", "$AHour = \"4\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "55", "$AHour = \"5\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "66", "$AHour = \"6\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "77", "$AHour = \"7\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "88", "$AHour = \"8\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "99", "$AHour = \"9\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "a10", "$AHour = \"10\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "b11", "$AHour = \"11\";Menu::Display(SetTen);");
 Menu::AddChoice(SetHour, "c12", "$AHour = \"12\";Menu::Display(SetTen);");
 
Menu::New(SetTen, "Please Set a Ten-Min");
 Menu::AddChoice(SetTen, "0:00", "$ATen = \"0\";Menu::Display(SetMin);");
 Menu::AddChoice(SetTen, "1:10", "$ATen = \"1\";Menu::Display(SetMin);");
 Menu::AddChoice(SetTen, "2:20", "$ATen = \"2\";Menu::Display(SetMin);");
 Menu::AddChoice(SetTen, "3:30", "$ATen = \"3\";Menu::Display(SetMin);");
 Menu::AddChoice(SetTen, "4:40", "$ATen = \"4\";Menu::Display(SetMin);");
 Menu::AddChoice(SetTen, "5:50", "$ATen = \"5\";Menu::Display(SetMin);");

Menu::New(SetMin, "Please Set a Min");
 Menu::AddChoice(SetMin, "0:00", "$AMin = \"0\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "1:01", "$AMin = \"1\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "2:02", "$AMin = \"2\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "3:03", "$AMin = \"3\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "4:04", "$AMin = \"4\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "5:05", "$AMin = \"5\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "6:06", "$AMin = \"6\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "7:07", "$AMin = \"7\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "8:08", "$AMin = \"8\";Menu::Display(SetAP);");
 Menu::AddChoice(SetMin, "9:09", "$AMin = \"9\";Menu::Display(SetAP);");
 
Menu::New(SetAP, "AM or PM ?");
 Menu::AddChoice(SetAP, "aAM", "$AAP = \"AM\";$MassAlarm::Toggle = \"True\";MassAlarm::New();");
 Menu::AddChoice(SetAP, "pPM", "$AAP = \"PM\";$MassAlarm::Toggle = \"True\";MassAlarm::New();");

function MassAlarm::New() 
{
	if ($MassAlarm::Toggle == "True")
	{
		if (($AMin == "") || ($ATen == "") || ($AHour == ""))
		{
			RemoteCP(2048, "<f1>Please set an alarm", 3);
			return;
		}
		// if(isFile("config\\time.cs"))
		if (included("timeHUD.cs"))
		{
			%MassAlarm = $AHour @ ":" @ $ATen @ $AMin @ " " @ $AAP;
			if ($CurrentTime[12] == %MassAlarm)
			{
				// "12:47 AM" Time
				echo("ALARM");
				RemoteCP(2048, "<jc><f1>\n******ALARM <f2>" @ %MassAlarm @ " <f1>ALARM******\n\n", 5);
				MassAlarm::Back();
				
			}
		}
		if (included("ICQHUD.cs"))
		{
			%MassAlarm = $AHour @ ":" @ $ATen @ $AMin;
			%MassAlarmI = "0" @ $AHour @ ":" @ $ATen @ $AMin;
			
			%cut = String::GetSubStr($IcqHud::Time, 0, 5);
			
			if ((%cut  == %MassAlarm) || (%cut  == %MassAlarmI))
			{
				// $IcqHud::Time = "09:01:38";
				echo("ALARM");
				RemoteCP(2048, "<jc><f1>\n******ALARM <f2>" @ %MassAlarm @ " <f1>ALARM******\n\n", 5);
				MassAlarm::Back();
				
			}
		}
		Schedule::Add("MassAlarm::New();", 40);
	}
	
}

function MassAlarm::Back()
{
	Schedule::Cancel("MassAlarm::New();");
	$MassAlarm::Toggle = "False";
	$AMin = "";
	$ATen = "";
	$AHour = "";
}