// ________________________________________________
// ALEHud v1.0	-	Average Life Expectancy Hud
// ________________________________________________

// By VKTR (jimmy@home.com)

// Default position, changeable thru HUDMOVER.
$ALEHud::Position = "75% 25% 192 14";

// This defines the key that pops up the ALE readout HUD
$ALEHud::Popupkey = "control a";

// This value represents how long the pop-up will remain visible.
$ALEHud::PopupTime = 6.5;

include("presto\\hud.cs");
include("presto\\killtrak.cs");
include("presto\\inventory.cs");
include("presto\\events.cs");

include("vektor\\armor_event.cs");

if (isFile("config\\ALEHudInfo.cs"))
	include("ALEHudInfo.cs");

// Check if Writer's stuff is included, of not use te stuff in
// the VeKToR folder (didn't want to overwrite Writer's stuff :)

// For the other writer scripts
include("Writer\\version.cs");
if (!included("Writer\\version.cs")) {
	echo("ALEHud Including version file");
	include("VeKToR\\Writer\\version.cs");
}	
include("Writer\\fire.cs");
if (!included("Writer\\fire.cs")) {
	echo("ALEHud Including fire.cs file");
	include("VeKToR\\Writer\\fire.cs");
}	
include("Writer\\respawn_event.cs");
if (!included("Writer\\respawn_event.cs")) {
	echo("ALEHud Including respawn_event file");
	include("VeKToR\\Writer\\respawn_event.cs");
}	

// Gets rid of icky unusable export chars
function ALEHud::FilterString(%string) {
	%string = String::Replace(%string, " ", "_");	
	%string = String::Replace(%string, "$", "_");	
	%string = String::Replace(%string, "@", "_");	
	%string = String::Replace(%string, "%", "_");	
	%string = String::Replace(%string, "+", "_");	
	%string = String::Replace(%string, "-", "_");	
	%string = String::Replace(%string, "*", "_");	
	%string = String::Replace(%string, "/", "_");	
	%string = String::Replace(%string, "{", "_");	
	%string = String::Replace(%string, "}", "_");	
	%string = String::Replace(%string, "[", "_");	
	%string = String::Replace(%string, "]", "_");	
	%string = String::Replace(%string, "(", "_");	
	%string = String::Replace(%string, ")", "_");	
	%string = String::Replace(%string, ";", "_");	
	%string = String::Replace(%string, ",", "_");	
	%string = String::Replace(%string, ".", "_");	

	return %string;
}

function ALEHud::Update(%hud) {
	if ($ALEHud::Display) {
		if (($ALEHud::NumDeaths[$ServerMission, $ALEHud::MyName] == 0) || ($ALEHud::NumDeaths[$ServerMission, $ALEHud::MyName] == ""))
			return;

		%height = 2;		

		%avg = floor($ALEHud::Totaltime[$ServerMission, $ALEHud::MyName] / $ALEHud::NumDeaths[$ServerMission, $ALEHud::MyName]) + 1;
	
		%mins = floor(%avg / 60);
		%sec = %avg - (%mins*60);

		Hud::AddTextLine(%hud, "<f1>Avg Life Expectancy:\n<f0>Overall: <f2>" @ %mins @ "<f1>m <f0>/ <f2>" @  %sec @ "<f1>s");


		// semi-inspired by Writer's am_armor stuff
		for(%i = 1; %i <= $Inv::ArmorCount; %i++) {
			// try to keep it short - only use the 1st word!
			%armorname = getword(%totalname = $Inv::Name[$Inv::ArmorList[%i]], 0);
			%totalname = ALEHud::FilterString(%totalname);

			if (($ALEHud::NumDeaths[$ServerMission, %totalname, $ALEHud::MyName] != 0) && ($ALEHud::NumDeaths[$ServerMission, %totalname, $ALEHud::MyName] != "")) {
			
				// find average (rounded up to nearest second)
				%avg = floor($ALEHud::Totaltime[$ServerMission, %totalname, $ALEHud::MyName] / $ALEHud::NumDeaths[$ServerMission, %totalname, $ALEHud::MyName]) + 1;
	
				%mins = floor(%avg / 60);
				%sec = %avg - (%mins*60);

				Hud::AddTextLine(%hud, "<f0>" @ %armorname @ ": <f2>" @ %mins @ "<f1>m <f0>/ <f2>" @  %sec @ "<f1>s");

				%height++;
			}
		}
	
		$ALEHud::Display = false;
		%pos = getword(HUD::getposition(ALEHud),0) @ " " @ getword(HUD::getposition(ALEHud),1) @ " " @ getword(HUD::getposition(ALEHud),2);
		HUD::Move(ALEHud, %pos @ " 14*" @ %height);		
		return $ALEHud::PopupTime;
	} else {
		HUD::Display(%hud, false);
	}
}

function ALEHud::Init() {
	$ALEHud::MyName = ALEHud::FilterString($PCFG::Name);
	if (!HUD::exists("ALEHud"))
		HUD::New("ALEHud", "ALEHud::Update", $ALEHud::Position);

	HudMover::ConstrainHud(ALEHud, "size");
}

function ALEHud::ClearData() {
	deletevariables("$ALEHud::NumDeaths*");
	deletevariables("$ALEHud::TotalTime*");
}

function ALEHud::Respawn() {
	$ALEHud::RespawnTime = getsimtime();
}
event::Attach(eventRespawned, "ALEHud::Respawn");

function ALEHud::Show() {
	$ALEHud::Display = true;
	if (HUD::GetDisplayed(ALEHud))
		Hud::Update(ALEHud);
	else
		HUD::Display(ALEHud);
}

function ALEHud::Death(%killer, %victim, %weapon) {
	if (%victim != getmanagerID()) {

		return;
	}

	// for general avg
	$ALEHud::NumDeaths[$ServerMission, $ALEHud::MyName]++;
	$ALEHud::TotalTime[$ServerMission, $ALEHud::MyName] = $ALEHud::TotalTime[$ServerMission, $ALEHud::MyName] + (getsimtime() - $ALEHud::RespawnTime);

	// armor specific avg
	$ALEHud::NumDeaths[$ServerMission, $ALEHud::CurrentArmor, $ALEHud::MyName]++;
	$ALEHud::TotalTime[$ServerMission, $ALEHud::CurrentArmor, $ALEHud::MyName] = $ALEHud::TotalTime[$ServerMission, $ALEHud::CurrentArmor, $ALEHud::MyName] + (getsimtime() - $ALEHud::RespawnTime);

	// Update if hud is visible, else show + update
	ALEHud::Show();
}

function ALEHud::SetArmor(%armor, %respawn) {
	// still haven't come up with a completely "fair" way to handle time
	// already survived in old armor before changing armor types.
	// for now, I just ignore it.

	$ALEHud::CurrentArmor = ALEHud::FilterString(%armor);		
	$ALEHud::RespawnTime = getsimtime();
}

function ALEHud::export() {
	export("$ALEHud::TotalTime*", "config\\ALEHudInfo.cs", false);
	export("$ALEHud::NumDeaths*", "config\\ALEHudInfo.cs", true);
}

event::attach(eventKillTrak, ALEHud::Death);
event::attach(eventConnected, "ALEHud::Init();");
event::attach(eventArmor, ALEHud::SetArmor);

event::attach(eventExit, "ALEHud::Export();");

bindkey(play, $ALEHud::Popupkey, "ALEHud::Show();");